<?php
namespace DelishCore;

use DelishCore\PageSettings\Page_Settings;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

/**
 * Class Plugin
 *
 * Main Plugin class
 * @since 1.2.0
 */
class Delishs_Core_Plugin {

	/**
	 * Instance
	 *
	 * @since 1.2.0
	 * @access private
	 * @static
	 *
	 * @var Plugin The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.2.0
	 * @access public
	 *
	 * @return Plugin An instance of the class.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Add Category
	 */

    public function delishs_core_elementor_category($manager)
    {
        $manager->add_category(
            'delishs_core',
            array(
                'title' => esc_html__('Delish Core', 'delish-core'),
                'icon' => 'eicon-banner',
            )
        );
    }

	/**
	 * widget_scripts
	 *
	 * Load required plugin core files.
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function widget_scripts() {
		wp_register_script( 'delish-core', plugins_url( '/assets/js/hello-world.js', __FILE__ ), [ 'jquery' ], false, true );
	}

	/**
	 * Editor scripts
	 *
	 * Enqueue plugin javascripts integrations for Elementor editor.
	 *
	 * @since 1.2.1
	 * @access public
	 */
	public function editor_scripts() {
		add_filter( 'script_loader_tag', [ $this, 'editor_scripts_as_a_module' ], 10, 2 );

		wp_enqueue_script(
			'delish-core-editor',
			plugins_url( '/assets/js/editor/editor.js', __FILE__ ),
			[
				'elementor-editor',
			],
			'1.2.1',
			true
		);
	}

	/**
	 * delishs_enqueue_editor_scripts
	 */
    function delishs_enqueue_editor_scripts()
    {
        wp_enqueue_style('delish-element-addons-editor', DELISHS_CORE_ADDONS_URL . 'assets/css/editor.css', null, '1.0');
    }

	/**
	 * Force load editor script as a module
	 *
	 * @since 1.2.1
	 *
	 * @param string $tag
	 * @param string $handle
	 *
	 * @return string
	 */
	public function editor_scripts_as_a_module( $tag, $handle ) {
		if ( 'delish-core-editor' === $handle ) {
			$tag = str_replace( '<script', '<script type="module"', $tag );
		}

		return $tag;
	}

	/**
	 * Register Widgets
	 *
	 * Register new Elementor widgets.
	 *
	 * @since 1.2.0
	 * @access public
	 *
	 * @param Widgets_Manager $widgets_manager Elementor widgets manager.
	 */
	public function register_widgets( $widgets_manager ) {
		// Its is now safe to include Widgets files
		foreach($this->delishs_core_widget_list() as $widget_file_name){
			require_once( DELISHS_CORE_ELEMENTS_PATH . "/{$widget_file_name}.php" );
		}

		// WooCommerce
		if ( class_exists( 'WooCommerce' ) ) {
			foreach($this->delishs_core_widget_list_woo() as $widget_file_name){
				require_once( DELISHS_CORE_ELEMENTS_PATH . "/{$widget_file_name}.php" );
			}
		}
	}

	public function delishs_core_widget_list() {
		return [
			'heading',
			'hero',
			'hero-slider',
			'about',
			'services',
			'counter',
			'cta',
			'discount',
			'contact-form',
			'opening-time',
			'team',
			'blog-post',
			'gallery-slider',
			'testimonial-slider',
			'why-choose-us',
			'contact-info',
			'chef',
			'chef-details',
			'food-menu',
			'food-menu-two',
			'food-menu-list',
			'advanced-food-menu',
		];
	}

	// delishs_core_widget_list_woo
	public function delishs_core_widget_list_woo() {
		return [
			// 'delish-product',
			// 'delish-product-tab',
		];
	}

	/**
	 *  Plugin class constructor
	 *
	 * Register plugin action hooks and filters
	 *
	 * @since 1.2.0
	 * @access public
	 */
	public function __construct() {

		// Register widget scripts
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'widget_scripts' ] );

		// Register widgets
		add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );

		// Register editor scripts
		add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'editor_scripts' ] );

		add_action('elementor/elements/categories_registered', [$this, 'delishs_core_elementor_category']);

	    add_action('elementor/editor/after_enqueue_scripts', [$this, 'delishs_enqueue_editor_scripts'] );

	}

}

// Instantiate Plugin Class
Delishs_Core_Plugin::instance();