<?php

/**

 * Delishs Sidebar Image Gallery
 * @author     RRdevs
 * @category   Widgets
 * @package    Delishs/Widgets
 * @version    1.0.0
 * @extends    WP_Widget
 */

add_action( 'widgets_init', function () {
    register_widget( 'Delishs_sidebar_instagram_post' );
} );

class Delishs_sidebar_instagram_post extends WP_Widget {

    public function __construct() {

        parent::__construct( 'Delishs_sidebar_instagram_post', esc_html__( 'Delishs Sidebar Instagram Post', 'delishs-core' ), array(
            'description' => esc_html__( 'Show Sidebar Instagram Post Widget By Delishs', 'delishs-core' ),

        ) );

    }

    public function widget( $args, $instance ) {

        extract( $args );

        extract( $instance );

        print $before_widget;

        if ( !empty( $title ) ) {

            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;

        }

        ?>

            <div class="sidebar__widget-gallery">
                <div class="gallery-photo">
                    <?php if ( !empty( $gallery_img_1 ) ): ?>
                        <a class="popup-image" href="<?php print $gallery_img_1;?>">
                            <img src="<?php print $gallery_img_1;?>" class="img-fluid" alt="<?php print esc_html__( 'Instagram Post', 'delishs-core' );?>">
                        </a>
                    <?php endif;?>

                    <?php if ( !empty( $gallery_img_2 ) ): ?>
                        <a class="popup-image" href="<?php print $gallery_img_2;?>">
                            <img src="<?php print $gallery_img_2;?>" class="img-fluid" alt="<?php print esc_html__( 'Instagram Post', 'delishs-core' );?>">
                        </a>
                    <?php endif;?>

                    <?php if ( !empty( $gallery_img_3 ) ): ?>
                        <a class="popup-image" href="<?php print $gallery_img_3;?>">
                            <img src="<?php print $gallery_img_3;?>" class="img-fluid" alt="<?php print esc_html__( 'Instagram Post', 'delishs-core' );?>">
                        </a>
                    <?php endif;?>

                    <?php if ( !empty( $gallery_img_4 ) ): ?>
                        <a class="popup-image" href="<?php print $gallery_img_4;?>">
                            <img src="<?php print $gallery_img_4;?>" class="img-fluid" alt="<?php print esc_html__( 'Instagram Post', 'delishs-core' );?>">
                        </a>
                    <?php endif;?>

                    <?php if ( !empty( $gallery_img_5 ) ): ?>
                        <a class="popup-image" href="<?php print $gallery_img_5;?>">
                            <img src="<?php print $gallery_img_5;?>" class="img-fluid" alt="<?php print esc_html__( 'Instagram Post', 'delishs-core' );?>">
                        </a>
                    <?php endif;?>

                    <?php if ( !empty( $gallery_img_6 ) ): ?>
                        <a class="popup-image" href="<?php print $gallery_img_6;?>">
                            <img src="<?php print $gallery_img_6;?>" class="img-fluid" alt="<?php print esc_html__( 'Instagram Post', 'delishs-core' );?>">
                        </a>
                    <?php endif;?>
                </div>
            </div>

			<?php print $after_widget;?>

		<?php

    }

    /**
     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */

    public function form( $instance ) {

        $title = isset( $instance['title'] ) ? $instance['title'] : '';

        $gallery_img_1 = isset( $instance['gallery_img_1'] ) ? $instance['gallery_img_1'] : '';
        $gallery_img_2 = isset( $instance['gallery_img_2'] ) ? $instance['gallery_img_2'] : '';
        $gallery_img_3 = isset( $instance['gallery_img_3'] ) ? $instance['gallery_img_3'] : '';
        $gallery_img_4 = isset( $instance['gallery_img_4'] ) ? $instance['gallery_img_4'] : '';
        $gallery_img_5 = isset( $instance['gallery_img_5'] ) ? $instance['gallery_img_5'] : '';
        $gallery_img_6 = isset( $instance['gallery_img_6'] ) ? $instance['gallery_img_6'] : '';

        ?>

		<p>
			<label for="title"><?php esc_html_e( 'Title:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'title' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'title' ) );?>" value="<?php print esc_attr( $title );?>">
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'gallery_img_1' ) );?>" class="image_er_link" value="<?php print $gallery_img_1;?>">
			<div class="author-image-show">
				<img src="<?php print $gallery_img_1;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'gallery_img_2' ) );?>" class="image_er_link" value="<?php print $gallery_img_2;?>">
			<div class="author-image-show">
				<img src="<?php print $gallery_img_2;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'gallery_img_3' ) );?>" class="image_er_link" value="<?php print $gallery_img_3;?>">
			<div class="author-image-show">
				<img src="<?php print $gallery_img_3;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'gallery_img_4' ) );?>" class="image_er_link" value="<?php print $gallery_img_4;?>">
			<div class="author-image-show">
				<img src="<?php print $gallery_img_4;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'gallery_img_5' ) );?>" class="image_er_link" value="<?php print $gallery_img_5;?>">
			<div class="author-image-show">
				<img src="<?php print $gallery_img_5;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'gallery_img_6' ) );?>" class="image_er_link" value="<?php print $gallery_img_6;?>">
			<div class="author-image-show">
				<img src="<?php print $gallery_img_6;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<?php

    }

    public function update( $new_instance, $old_instance ) {

        $instance = array();

        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

        $instance['gallery_img_1'] = ( !empty( $new_instance['gallery_img_1'] ) ) ? strip_tags( $new_instance['gallery_img_1'] ) : '';
        $instance['gallery_img_2'] = ( !empty( $new_instance['gallery_img_2'] ) ) ? strip_tags( $new_instance['gallery_img_2'] ) : '';
        $instance['gallery_img_3'] = ( !empty( $new_instance['gallery_img_3'] ) ) ? strip_tags( $new_instance['gallery_img_3'] ) : '';
        $instance['gallery_img_4'] = ( !empty( $new_instance['gallery_img_4'] ) ) ? strip_tags( $new_instance['gallery_img_4'] ) : '';
        $instance['gallery_img_5'] = ( !empty( $new_instance['gallery_img_5'] ) ) ? strip_tags( $new_instance['gallery_img_5'] ) : '';
        $instance['gallery_img_6'] = ( !empty( $new_instance['gallery_img_6'] ) ) ? strip_tags( $new_instance['gallery_img_6'] ) : '';

        return $instance;

    }

}