<?php
/**
 * DelishsCore Sidebar Posts Image
 *
 * @author 		RRDevs
 * @category 	Widgets
 * @package 	DelishsCore/Widgets
 * @version 	1.0.0
 * @extends 	WP_Widget
*/

Class Delishs_Post_Sidebar_Widget extends WP_Widget{

	public function __construct(){
		parent::__construct('delishs-latest-posts', 'Delishs Sidebar Posts Image', array(
			'description'	=> 'Latest Blog Post Widget by Delishs'
		));
	}

	public function widget($args, $instance){
		extract($args);
		extract($instance);

	 echo $before_widget; 
		 if($instance['title']):
		 echo $before_title; ?>
<?php echo apply_filters( 'widget_title', $instance['title'] ); ?>
<?php echo $after_title; ?>
<?php endif; ?>
	<div class="sidebar-post__wrapper">
    	<?php 
		$q = new WP_Query( array(
			'post_type'     => 'post',
			'post__not_in'   => get_option( 'sticky_posts' ),
			'posts_per_page'=> ($instance['count']) ? $instance['count'] : '3',
			'order'			=> ($instance['posts_order']) ? $instance['posts_order'] : 'DESC',
			'orderby' => 'date'
		));

		if( $q->have_posts() ):
		while( $q->have_posts() ):$q->the_post();
		?>
			<div class="sidebar__widget-post">
				<?php if ( has_post_thumbnail() ): ?>
					<a href="<?php the_permalink(); ?>" class="sidebar__widget-post__thum">
						<?php the_post_thumbnail('thumbnail'); ?>
					</a>
				<?php endif; ?>
				<div class="sidebar__widget-post__content">
					<ul class="sidebar__widget-post__content-meta">
						<li>
							<a href="<?php the_permalink(); ?>">
								<i class="fa-light fa-circle-user"></i>
								<?php print esc_html( 'by', 'delishs-core' ); ?> <?php print get_the_author(); ?>
							</a>
						</li>
					</ul>
					<a href="<?php the_permalink(); ?>">
						<h5 class="sidebar__widget-post__content-title">
							<?php print wp_trim_words(get_the_title(), 5, ''); ?>
						</h5>
					</a>
				</div>
			</div>
		<?php endwhile; endif; ?>
	</div>


<?php echo $after_widget; ?>

<?php
}



	public function form($instance){
		$title = ! empty( $instance['title'] ) ? $instance['title'] : '';
		$count = ! empty( $instance['count'] ) ? $instance['count'] : esc_html__( '3', 'delishs-core' );
		$posts_order = ! empty( $instance['posts_order'] ) ? $instance['posts_order'] : esc_html__( 'DESC', 'delishs-core' );
		$choose_style = ! empty( $instance['choose_style'] ) ? $instance['choose_style'] : esc_html__( 'style_1', 'delishs-core' );
	?>
<p>
    <label for="<?php echo $this->get_field_id('title'); ?>">Title</label>
    <input type="text" name="<?php echo $this->get_field_name('title'); ?>"
        id="<?php echo $this->get_field_id('title'); ?>" value="<?php echo esc_attr( $title ); ?>" class="widefat">
</p>

<p>
    <label for="<?php echo $this->get_field_id('count'); ?>">How many posts you want to show ?</label>
    <input type="number" name="<?php echo $this->get_field_name('count'); ?>"
        id="<?php echo $this->get_field_id('count'); ?>" value="<?php echo esc_attr( $count ); ?>" class="widefat">
</p>

<p>
    <label for="<?php echo $this->get_field_id('posts_order'); ?>">Posts Order</label>
    <select name="<?php echo $this->get_field_name('posts_order'); ?>"
        id="<?php echo $this->get_field_id('posts_order'); ?>" class="widefat">
        <option value="" disabled="disabled">Select Post Order</option>
        <option value="ASC" <?php if($posts_order === 'ASC'){ echo 'selected="selected"'; } ?>>ASC</option>
        <option value="DESC" <?php if($posts_order === 'DESC'){ echo 'selected="selected"'; } ?>>DESC</option>
    </select>
</p>

<?php }


}

add_action('widgets_init', function(){
	register_widget('Delishs_Post_Sidebar_Widget');
});