<?php

/**
 * Delishs Footer Subscriber
 * @author     RRdevs
 * @category   Widgets
 * @package    Delishs/Widgets
 * @version    1.0.0
 * @extends    WP_Widget
 */

add_action( 'widgets_init', function () {
    register_widget( 'Delishs_footer_subscriber' );
} );

class Delishs_footer_subscriber extends WP_Widget {

    public function __construct() {
        parent::__construct( 'Delishs_footer_subscriber', esc_html__( 'Delishs Footer Subscriber', 'delishs-core' ), array(
            'description' => esc_html__( 'Show Footer Subscriber Widget By Delishs', 'delishs-core' ),
        ) );
    }

    public function widget( $args, $instance ) {

        extract( $args );
        extract( $instance );
        print $before_widget;
        if ( !empty( $title ) ) {
            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;
        }

        ?>


            <div class="footer-2__subscribe-content">
                <?php if ( !empty( $description ) ): ?>
                    <p class="mb-0"><?php print $description;?></p>
                <?php endif;?>

                <?php if ( !empty( $shortcode ) ): ?>
                    <?php print do_shortcode( $shortcode ); ?>
                <?php endif;?>
            </div>

			<?php print $after_widget;?>

		<?php

    }

    /**

     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */

    public function form( $instance ) {

        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $description = isset( $instance['description'] ) ? $instance['description'] : '';
        $shortcode = isset( $instance['shortcode'] ) ? $instance['shortcode'] : '';

        ?>

		<p>
			<label for="title"><?php esc_html_e( 'Title:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'title' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'title' ) );?>" value="<?php print esc_attr( $title );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Short Description:', 'delishs-core' );?></label>
			<textarea class="widefat" rows="7" cols="15" id="<?php print esc_attr( $this->get_field_id( 'description' ) );?>" value="<?php print esc_attr( $description );?>" name="<?php print esc_attr( $this->get_field_name( 'description' ) );?>"><?php print esc_attr( $description );?></textarea>
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Form Shortcode:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'shortcode' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'shortcode' ) );?>" value="<?php print esc_attr( $shortcode );?>">
		</p>

		<?php

    }

    public function update( $new_instance, $old_instance ) {

        $instance = array();
        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['description'] = ( !empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';
        $instance['shortcode'] = ( !empty( $new_instance['shortcode'] ) ) ? strip_tags( $new_instance['shortcode'] ) : '';
        
        return $instance;

    }

}