<?php

/**
 * Delishs Footer Info Widget
 * @author     RRdevs
 * @category   Widgets
 * @package    Delishs/Widgets
 * @version    1.0.0
 * @extends    WP_Widget
 */

add_action( 'widgets_init', function () {
    register_widget( 'Delishs_footer_office_time_one' );
} );

class Delishs_footer_office_time_one extends WP_Widget {

    public function __construct() {
        parent::__construct( 'Delishs_footer_office_time_one', esc_html__( 'Delishs Footer Office Time One', 'delishs-core' ), array(
            'description' => esc_html__( 'Show Footer Office Time One Widget By Delishs', 'delishs-core' ),
        ) );
    }

    public function widget( $args, $instance ) {

        extract( $args );
        extract( $instance );
        print $before_widget;
        if ( !empty( $title ) ) {
            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;
        }

        ?>

            <div class="footer__link footer__link-working">
                <ul>
                    <?php if ( !empty( $office_time_one ) ): ?>
                        <li><?php print $office_time_one; ?></li>
                    <?php endif;?>
                    <?php if ( !empty( $office_time_two ) ): ?>
                        <li><?php print $office_time_two; ?></li>
                    <?php endif;?>
                    <?php if ( !empty( $office_time_off_day ) ): ?>
                        <li><?php print $office_time_off_day; ?></li>
                    <?php endif;?>
                    <?php if ( !empty( $office_time_special_day ) ): ?>
                        <li><?php print $office_time_special_day; ?></li>
                    <?php endif;?>
                </ul>
            </div>

			<?php print $after_widget;?>

		<?php

    }

    /**

     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */

    public function form( $instance ) {

        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $office_time_one = isset( $instance['office_time_one'] ) ? $instance['office_time_one'] : '';
        $office_time_two = isset( $instance['office_time_two'] ) ? $instance['office_time_two'] : '';
        $office_time_off_day = isset( $instance['office_time_off_day'] ) ? $instance['office_time_off_day'] : '';
        $office_time_special_day = isset( $instance['office_time_special_day'] ) ? $instance['office_time_special_day'] : '';

        ?>

		<p>
			<label for="title"><?php esc_html_e( 'Title:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'title' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'title' ) );?>" value="<?php print esc_attr( $title );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Office Time One', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'office_time_one' ) );?>" value="<?php print esc_attr( $office_time_one );?>" name="<?php print esc_attr( $this->get_field_name( 'office_time_one' ) );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Office Time Two:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'office_time_two' ) );?>" value="<?php print esc_attr( $office_time_two );?>" name="<?php print esc_attr( $this->get_field_name( 'office_time_two' ) );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Day OFF:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'office_time_off_day' ) );?>" value="<?php print esc_attr( $office_time_off_day );?>" name="<?php print esc_attr( $this->get_field_name( 'office_time_off_day' ) );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Special Day:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'office_time_special_day' ) );?>" value="<?php print esc_attr( $office_time_special_day );?>" name="<?php print esc_attr( $this->get_field_name( 'office_time_special_day' ) );?>">
		</p>

		<?php

    }

    public function update( $new_instance, $old_instance ) {

        $instance = array();
        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['office_time_one'] = ( !empty( $new_instance['office_time_one'] ) ) ? strip_tags( $new_instance['office_time_one'] ) : '';
        $instance['office_time_two'] = ( !empty( $new_instance['office_time_two'] ) ) ? strip_tags( $new_instance['office_time_two'] ) : '';
        $instance['office_time_off_day'] = ( !empty( $new_instance['office_time_off_day'] ) ) ? strip_tags( $new_instance['office_time_off_day'] ) : '';
        $instance['office_time_special_day'] = ( !empty( $new_instance['office_time_special_day'] ) ) ? strip_tags( $new_instance['office_time_special_day'] ) : '';

        return $instance;

    }

}