<?php

/**
 * Delishs Footer Info Widget
 * @author     RRdevs
 * @category   Widgets
 * @package    Delishs/Widgets
 * @version    1.0.0
 * @extends    WP_Widget
 */

add_action( 'widgets_init', function () {
    register_widget( 'Delishs_footer_info_one' );
} );

class Delishs_footer_info_one extends WP_Widget {

    public function __construct() {
        parent::__construct( 'Delishs_footer_info_one', esc_html__( 'Delishs Footer Info One', 'delishs-core' ), array(
            'description' => esc_html__( 'Show Footer Info One Widget By Delishs', 'delishs-core' ),
        ) );
    }

    public function widget( $args, $instance ) {

        extract( $args );
        extract( $instance );
        print $before_widget;
        if ( !empty( $title ) ) {
            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;
        }

        ?>

			<div class="footer-2__widget footer-2__widget-item-1">
				<?php if ( !empty( $image_box_image ) ): ?>
					<div class="footer-2__logo mb-30 mb-xs-25">
						<a href="<?php print home_url();?>">
							<img class="img-fluid" src="<?php print $image_box_image;?>" alt="<?php print esc_html__( 'Logo', 'delishs-core' );?>">
						</a>
					</div>
				<?php endif;?>

				<?php if ( !empty( $description ) ): ?>
					<div class="footer-2__content mb-30 mb-xs-25">
						<p class="mb-20"><?php print $description;?></p>
					</div>
				<?php endif;?>

				<div class="footer-2__social">
					<?php if ( !empty( $facebook ) ): ?>
						<a href="<?php print esc_url( $facebook );?>"><i class="fab fa-facebook-f"></i></a>
					<?php endif;?>
					<?php if ( !empty( $twitter ) ): ?>
						<a href="<?php print esc_url( $twitter );?>">
							<svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M10.0596 6.77295L15.8879 -0.00195312H14.5068L9.44607 5.8806L5.40411 -0.00195312H0.742188L6.85442 8.89352L0.742188 15.998H2.12338L7.4676 9.78587L11.7362 15.998H16.3981L10.0593 6.77295H10.0596ZM8.16787 8.97189L7.54857 8.0861L2.62104 1.03779H4.74248L8.71905 6.726L9.33834 7.61179L14.5074 15.0056H12.386L8.16787 8.97223V8.97189Z" fill="black"/>
							</svg>
						</a>
					<?php endif;?>
					<?php if ( !empty( $instagram ) ): ?>
						<a href="<?php print esc_url( $instagram );?>"><i class="fab fa-instagram"></i></a>
					<?php endif;?>
					<?php if ( !empty( $pinterest ) ): ?>
						<a href="<?php print esc_url( $pinterest );?>"><i class="fab fa-pinterest-p"></i></a>
					<?php endif;?>
					<?php if ( !empty( $youtube ) ): ?>
						<a href="<?php print esc_url( $youtube );?>"><i class="fab fa-youtube"></i></a>
					<?php endif;?>
					<?php if ( !empty( $linkedin ) ): ?>
						<a href="<?php print esc_url( $linkedin );?>"><i class="fab fa-linkedin-in"></i></a>
					<?php endif;?>
					<?php if ( !empty( $whatsapp ) ): ?>
						<a href="<?php print esc_url( $whatsapp );?>"><i class="fab fa-whatsapp"></i></a>
					<?php endif;?>
				</div>
			</div>

			<?php if ( !empty( $office_time ) ): ?>
				<h4 class="title"><?php print $office_time_label; ?> <span><?php print $office_time; ?></span></h4>
			<?php endif;?>

			<?php print $after_widget;?>

		<?php

    }

    /**

     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */

    public function form( $instance ) {

        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $image_box_image = isset( $instance['image_box_image'] ) ? $instance['image_box_image'] : '';
        $description = isset( $instance['description'] ) ? $instance['description'] : '';
        $facebook = isset( $instance['facebook'] ) ? $instance['facebook'] : '';
        $twitter = isset( $instance['twitter'] ) ? $instance['twitter'] : '';
        $instagram = isset( $instance['instagram'] ) ? $instance['instagram'] : '';
        $pinterest = isset( $instance['pinterest'] ) ? $instance['pinterest'] : '';
        $youtube = isset( $instance['youtube'] ) ? $instance['youtube'] : '';
        $linkedin = isset( $instance['linkedin'] ) ? $instance['linkedin'] : '';
        $whatsapp = isset( $instance['whatsapp'] ) ? $instance['whatsapp'] : '';

        ?>

		<p>
			<label for="title"><?php esc_html_e( 'Title:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'title' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'title' ) );?>" value="<?php print esc_attr( $title );?>">
		</p>

		<p>
			<button type="submit" class="button button-secondary" id="author_info_image">Upload Media</button>
			<input type="hidden" name="<?php print esc_attr( $this->get_field_name( 'image_box_image' ) );?>" class="image_er_link" value="<?php print $image_box_image;?>">
			<div class="author-image-show">
				<img src="<?php print $image_box_image;?>" alt="" width="150" height="auto">
			</div>
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Short Description:', 'delishs-core' );?></label>
			<textarea class="widefat" rows="7" cols="15" id="<?php print esc_attr( $this->get_field_id( 'description' ) );?>" value="<?php print esc_attr( $description );?>" name="<?php print esc_attr( $this->get_field_name( 'description' ) );?>"><?php print esc_attr( $description );?></textarea>
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Facebook:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'facebook' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'facebook' ) );?>" value="<?php print esc_attr( $facebook );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Twitter:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'twitter' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'twitter' ) );?>" value="<?php print esc_attr( $twitter );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Instagram:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'instagram' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'instagram' ) );?>" value="<?php print esc_attr( $instagram );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Pinterest:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'pinterest' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'pinterest' ) );?>" value="<?php print esc_attr( $pinterest );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Youtube:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'youtube' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'youtube' ) );?>" value="<?php print esc_attr( $youtube );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Linkedin:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'linkedin' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'linkedin' ) );?>" value="<?php print esc_attr( $linkedin );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Whatsapp:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'whatsapp' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'whatsapp' ) );?>" value="<?php print esc_attr( $whatsapp );?>">
		</p>

		<?php

    }

    public function update( $new_instance, $old_instance ) {

        $instance = array();
        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['image_box_image'] = ( !empty( $new_instance['image_box_image'] ) ) ? strip_tags( $new_instance['image_box_image'] ) : '';
        $instance['description'] = ( !empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';
        $instance['facebook'] = ( !empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';
        $instance['twitter'] = ( !empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';
        $instance['instagram'] = ( !empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : '';
        $instance['pinterest'] = ( !empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : '';
        $instance['youtube'] = ( !empty( $new_instance['youtube'] ) ) ? strip_tags( $new_instance['youtube'] ) : '';
        $instance['linkedin'] = ( !empty( $new_instance['linkedin'] ) ) ? strip_tags( $new_instance['linkedin'] ) : '';
        $instance['whatsapp'] = ( !empty( $new_instance['whatsapp'] ) ) ? strip_tags( $new_instance['whatsapp'] ) : '';

        return $instance;

    }

}