<?php

/**
 * Delishs Footer Contact Info Widget
 * @author     RRdevs
 * @category   Widgets
 * @package    Delishs/Widgets
 * @version    1.0.0
 * @extends    WP_Widget
 */

add_action( 'widgets_init', function () {
    register_widget( 'Delishs_footer_contact_info_one' );
} );

class Delishs_footer_contact_info_one extends WP_Widget {

    public function __construct() {
        parent::__construct( 'Delishs_footer_contact_info_one', esc_html__( 'Delishs Footer Contact Info One', 'delishs-core' ), array(
            'description' => esc_html__( 'Show Footer Contact Info One Widget By Delishs', 'delishs-core' ),
        ) );
    }

    public function widget( $args, $instance ) {

        extract( $args );
        extract( $instance );
        print $before_widget;
        if ( !empty( $title ) ) {
            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;
        }

        ?>

			<div class="footer__link footer__link-touch">
				<ul>
					<?php if ( !empty( $address ) ): ?>
						<li><a href="<?php print esc_url($address_url); ?>"><?php print $address; ?></a></li>
					<?php endif;?>
					<?php if ( !empty( $phone ) ): ?>
						<li><a href="tel:<?php print esc_attr($phone_url); ?>"><?php print $phone; ?></a></li>
					<?php endif;?>
					<?php if ( !empty( $email ) ): ?>
						<li><a href="mailto:<?php print esc_attr($email); ?>"><?php print $email; ?></a></li>
					<?php endif;?>
				</ul>
			</div>

			<div class="footer__social mt-30 mt-xs-30">
				<?php if ( !empty( $facebook ) ): ?>
					<a href="<?php print esc_url( $facebook );?>"><i class="fab fa-facebook-f"></i></a>
				<?php endif;?>
				<?php if ( !empty( $twitter ) ): ?>
					<a href="<?php print esc_url( $twitter );?>">
						<svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M10.0596 6.77295L15.8879 -0.00195312H14.5068L9.44607 5.8806L5.40411 -0.00195312H0.742188L6.85442 8.89352L0.742188 15.998H2.12338L7.4676 9.78587L11.7362 15.998H16.3981L10.0593 6.77295H10.0596ZM8.16787 8.97189L7.54857 8.0861L2.62104 1.03779H4.74248L8.71905 6.726L9.33834 7.61179L14.5074 15.0056H12.386L8.16787 8.97223V8.97189Z" fill="#111111"/>
						</svg>
					</a>
				<?php endif;?>
				<?php if ( !empty( $pinterest ) ): ?>
					<a href="<?php print esc_url( $pinterest );?>"><i class="fa-brands fa-pinterest"></i></a>
				<?php endif;?>
				<?php if ( !empty( $linkedin ) ): ?>
					<a href="<?php print esc_url( $linkedin );?>"><i class="fa-brands fa-linkedin-in"></i></a>
				<?php endif;?>
				<?php if ( !empty( $instagram ) ): ?>
					<a href="<?php print esc_url( $instagram );?>"><i class="fa-brands fa-instagram"></i></a>
				<?php endif;?>
				<?php if ( !empty( $whatsapp ) ): ?>
					<a href="<?php print esc_url( $whatsapp );?>"><i class="fa-brands fa-whatsapp"></i></a>
				<?php endif;?>
				<?php if ( !empty( $youtube ) ): ?>
					<a href="<?php print esc_url( $youtube );?>"><i class="fa-brands fa-youtube"></i></a>
				<?php endif;?>
			</div>

			<?php print $after_widget;?>

		<?php

    }

    /**

     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */

    public function form( $instance ) {

        $title = isset( $instance['title'] ) ? $instance['title'] : '';
        $address = isset( $instance['address'] ) ? $instance['address'] : '';
        $address_url = isset( $instance['address_url'] ) ? $instance['address_url'] : '';
        $phone = isset( $instance['phone'] ) ? $instance['phone'] : '';
        $phone_url = isset( $instance['phone_url'] ) ? $instance['phone_url'] : '';
        $email = isset( $instance['email'] ) ? $instance['email'] : '';
        $facebook = isset( $instance['facebook'] ) ? $instance['facebook'] : '';
        $twitter = isset( $instance['twitter'] ) ? $instance['twitter'] : '';
        $instagram = isset( $instance['instagram'] ) ? $instance['instagram'] : '';
        $pinterest = isset( $instance['pinterest'] ) ? $instance['pinterest'] : '';
        $youtube = isset( $instance['youtube'] ) ? $instance['youtube'] : '';
        $linkedin = isset( $instance['linkedin'] ) ? $instance['linkedin'] : '';
        $whatsapp = isset( $instance['whatsapp'] ) ? $instance['whatsapp'] : '';

        ?>

		<p>
			<label for="title"><?php esc_html_e( 'Title:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'title' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'title' ) );?>" value="<?php print esc_attr( $title );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Address:', 'delishs-core' );?></label>
			<textarea class="widefat" rows="7" cols="15" id="<?php print esc_attr( $this->get_field_id( 'address' ) );?>" value="<?php print esc_attr( $address );?>" name="<?php print esc_attr( $this->get_field_name( 'address' ) );?>"><?php print esc_attr( $address );?></textarea>
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Address URL:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'address_url' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'address_url' ) );?>" value="<?php print esc_attr( $address_url );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Phone:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'phone' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'phone' ) );?>" value="<?php print esc_attr( $phone );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Phone URL:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'phone_url' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'phone_url' ) );?>" value="<?php print esc_attr( $phone_url );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Email Address:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'email' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'email' ) );?>" value="<?php print esc_attr( $email );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Facebook:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'facebook' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'facebook' ) );?>" value="<?php print esc_attr( $facebook );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Twitter:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'twitter' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'twitter' ) );?>" value="<?php print esc_attr( $twitter );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Instagram:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'instagram' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'instagram' ) );?>" value="<?php print esc_attr( $instagram );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Pinterest:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'pinterest' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'pinterest' ) );?>" value="<?php print esc_attr( $pinterest );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Youtube:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'youtube' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'youtube' ) );?>" value="<?php print esc_attr( $youtube );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Linkedin:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'linkedin' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'linkedin' ) );?>" value="<?php print esc_attr( $linkedin );?>">
		</p>

		<p>
			<label for="title"><?php esc_html_e( 'Whatsapp:', 'delishs-core' );?></label>
			<input type="text" class="widefat" id="<?php print esc_attr( $this->get_field_id( 'whatsapp' ) );?>"  name="<?php print esc_attr( $this->get_field_name( 'whatsapp' ) );?>" value="<?php print esc_attr( $whatsapp );?>">
		</p>

		<?php

    }

    public function update( $new_instance, $old_instance ) {

        $instance = array();
        $instance['title'] = ( !empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['address'] = ( !empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';
        $instance['address_url'] = ( !empty( $new_instance['address_url'] ) ) ? strip_tags( $new_instance['address_url'] ) : '';
        $instance['phone'] = ( !empty( $new_instance['phone'] ) ) ? strip_tags( $new_instance['phone'] ) : '';
        $instance['phone_url'] = ( !empty( $new_instance['phone_url'] ) ) ? strip_tags( $new_instance['phone_url'] ) : '';
        $instance['email'] = ( !empty( $new_instance['email'] ) ) ? strip_tags( $new_instance['email'] ) : '';
        $instance['facebook'] = ( !empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';
        $instance['twitter'] = ( !empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';
        $instance['instagram'] = ( !empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : '';
        $instance['pinterest'] = ( !empty( $new_instance['pinterest'] ) ) ? strip_tags( $new_instance['pinterest'] ) : '';
        $instance['youtube'] = ( !empty( $new_instance['youtube'] ) ) ? strip_tags( $new_instance['youtube'] ) : '';
        $instance['linkedin'] = ( !empty( $new_instance['linkedin'] ) ) ? strip_tags( $new_instance['linkedin'] ) : '';
        $instance['whatsapp'] = ( !empty( $new_instance['whatsapp'] ) ) ? strip_tags( $new_instance['whatsapp'] ) : '';

        return $instance;

    }

}