<?php
namespace DelishsCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Why_Choose_Us extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'why_choose_us';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Why Choose Us', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'delishs_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
        
        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__('Design Layout', 'delishs-core'),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'delishs-core'),
                    'layout-2' => esc_html__('Layout 2', 'delishs-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'delishs_image',
            [
                'label' => esc_html__( 'Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_title',
            [
                'label'       => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'         => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__('Subtitle', 'delishs-core'),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'BUSINESS MODEL', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'WHY DELISH YOUR PRIORITY', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Lorem ipsum dolor sit amet consectetur adipiscing elit netus sagittis aenean malesuada, velit sodales hendrerit lacus iaculis porta lobortis sollicitudin quisque dictum porttitor donec...', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_info',
            [
                'label' => esc_html__('Info List', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => esc_html__('Icon Type', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'icon' => esc_html__('Icon', 'delishs-core'),
                    'image' => esc_html__('Image', 'delishs-core'),
                ],
                'default' => 'image',
            ]
        );

        if (delishs_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'why_choose_us_icon',
                [
                    'label' => esc_html__('Icon', 'delishs-core'),
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-check',
                    'condition'   => [
                        'icon_type' => 'icon',
                    ],
                ]
            );
        } else {
            $repeater->add_control(
                'why_choose_us_selected_icon',
                [
                    'label' => esc_html__('Icon', 'delishs-core'),
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-chevrons-right',
                        'library' => 'solid',
                    ],
                    'condition'   => [
                        'icon_type' => 'icon',
                    ],
                ]
            );
        }

        $repeater->add_control(
            'why_choose_us_image_icon',
            [
                'label'     => esc_html__( 'Choose Image', 'delishs-core' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type'   => ['image'],
                ],
            ]
        );

        $repeater->add_control(
            'info_title',
            [
                'label' => esc_html__('Title', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Branding Services', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'info_description', [
                'label' => esc_html__('Description', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('01', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'delishs_info_list',
            [
                'label' => esc_html__('Info - List', 'delishs-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'info_title' => __( 'Efficiency & Management', 'delishs-core' ),
                        'info_description' => __( 'Adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'delishs-core' ),
                    ],
                    [
                        'info_title' => __( 'Effective Team Work', 'delishs-core' ),
                        'info_description' => __( 'Adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'delishs-core' ),
                    ],
                    [
                        'info_title' => __( 'Amazing Growth Flow', 'delishs-core' ),
                        'info_description' => __( 'Adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ info_title }}}',
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_info_two',
            [
                'label' => esc_html__('Info List', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => esc_html__('Icon Type', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'icon' => esc_html__('Icon', 'delishs-core'),
                    'image' => esc_html__('Image', 'delishs-core'),
                ],
                'default' => 'icon',
            ]
        );

        if (delishs_is_elementor_version('<', '2.6.0')) {
            $repeater->add_control(
                'why_choose_us_icon',
                [
                    'label' => esc_html__('Icon', 'delishs-core'),
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-check',
                    'condition'   => [
                        'icon_type' => 'icon',
                    ],
                ]
            );
        } else {
            $repeater->add_control(
                'why_choose_us_selected_icon',
                [
                    'label' => esc_html__('Icon', 'delishs-core'),
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'fas fa-chevrons-right',
                        'library' => 'solid',
                    ],
                    'condition'   => [
                        'icon_type' => 'icon',
                    ],
                ]
            );
        }

        $repeater->add_control(
            'why_choose_us_image_icon',
            [
                'label'     => esc_html__( 'Choose Image', 'delishs-core' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type'   => ['image'],
                ],
            ]
        );

        $repeater->add_control(
            'info_title',
            [
                'label' => esc_html__('Title', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Branding Services', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'info_description', [
                'label' => esc_html__('Description', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('01', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'delishs_info_list_two',
            [
                'label' => esc_html__('Info - List', 'delishs-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'info_title' => __( 'Analyzing Restaurant Customer Feedback for Enhanced Dining Experiences"', 'delishs-core' ),
                    ],
                    [
                        'info_title' => __( 'Leveraging Customer Reviews to Elevate Your Restaurants Reputation"', 'delishs-core' ),
                    ],
                    [
                        'info_title' => __( 'Decoding Online Reviews to Improve Your Restaurants Service and Menu"', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ info_title }}}',
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => __( 'Design Layout', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => __( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => __( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_inner',
            [
                'label' => esc_html__( 'Inner Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'design_layout_inner_padding',
            [
                'label' => __( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .most-reservation__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_inner_margin',
            [
                'label' => __( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .most-reservation__content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_inner_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .most-reservation__content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'design_layout_inner_border',
                'selector' => '{{WRAPPER}} .most-reservation__content::before',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // Title
        $this->add_control(
            '_heading_subheading',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
            ]
        );

        $this->add_responsive_control(
            'subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subheading_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'subheading_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading',
            ]
        );

        $this->add_responsive_control(
            'subheading_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subheading_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Title
        $this->add_control(
            '_section_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-title',
            ]
        );

        // Description
        $this->add_control(
            '_section_heading_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_description_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'section_description_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-description' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_description_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-description',
            ]
        );

        $this->end_controls_section();
    
        // TAB_STYLE
        $this->start_controls_section(
            '_style_info',
            [
                'label' => __( 'Info List', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'info_bottom_spacing',
            [
                'label'     => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .business-model__content-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .most-reservation__content-list li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'info_background',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .most-reservation__content-list li',
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_info_icon',
            [
                'label' => esc_html__( 'Icon', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'info_icon_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business-model__content-item-icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .most-reservation__content-list li i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'info_icon_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business-model__content-item-icon' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            '_heading_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'info_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .business-model__content-item-text h6' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'info_title_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business-model__content-item-text h6' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .most-reservation__content-list li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_title_typography',
                'selector' => '{{WRAPPER}} .business-model__content-item-text h6, .most-reservation__content-list li',
            ]
        );

        $this->add_control(
            '_heading_description',
            [
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'info_description_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .business-model__content-item-text p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_description_typography',
                'selector' => '{{WRAPPER}} .business-model__content-item-text p',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( !empty($settings['delishs_image']['url']) ) {
            $delishs_image = !empty($settings['delishs_image']['id']) ? wp_get_attachment_image_url( $settings['delishs_image']['id'], 'full' ) : $settings['delishs_image']['url'];
            $delishs_image_alt = get_post_meta($settings["delishs_image"]["id"], "_wp_attachment_image_alt", true);
        }

        $this->add_render_attribute('_section_subheading_args', 'class', 'delishs-el-section-subheading sub-heading wow fade-in-bottom');
        $this->add_render_attribute('_section_subheading_args', 'data-wow-delay', '400ms');
        $this->add_render_attribute('_section_title_args', 'class', 'delishs-el-section-title section-title wow fade-in-bottom');
        $this->add_render_attribute('_section_title_args', 'data-wow-delay', '600ms');

		?>

        <?php if ( $settings['design_style']  == 'layout-1' ): ?>

            <section class="delishs-el-section business-model section-space">
                <div class="container">
                    <div class="row g-24">
                        <div class="col-xl-6">
                            <div class="business-model__content">
                                <div class="section__title-wrapper text-start">
                                    <?php if(!empty($settings['section_subheading'])): ?>
                                        <span class="delishs-el-section-subheading section__subtitle justify-content-start mb-15 wow clip-a-z">
                                            <?php echo rrdevs_kses($settings['section_subheading']); ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['section_title' ]) ) : ?>
                                        <h2 class="delishs-el-section-title section__title mb-20 section__subtitle-line-height title-animation">
                                            <?php echo rrdevs_kses($settings['section_title']); ?>
                                        </h2>
                                    <?php endif; ?>
                                    <?php if( !empty($settings['section_description']) ): ?>
                                        <p class="delishs-el-section-description mb-0">
                                            <?php echo rrdevs_kses($settings['section_description']); ?>
                                        </p>
                                    <?php endif; ?>
                                </div>

                                <div class="business-model__content-wrapper mt-35">
                                    <?php foreach ($settings['delishs_info_list'] as $key => $item) : 
                                        
                                        if ( !empty($item['why_choose_us_image_icon']['url']) ) {
                                            $why_choose_us_image_icon = !empty($item['why_choose_us_image_icon']['id']) ? wp_get_attachment_image_url( $item['why_choose_us_image_icon']['id'], 'full') : $item['why_choose_us_image_icon']['url'];
                                            $why_choose_us_image_icon_alt = get_post_meta($item["why_choose_us_image_icon"]["id"], "_wp_attachment_image_alt", true);
                                        }
                                    
                                    ?>
                                    <div class="business-model__content-item">
                                        <?php if ( 'icon' === $item['icon_type'] ): ?>
                                            <div class="business-model__content-item-icon">
                                                <?php delishs_render_icon($item, 'why_choose_us_icon', 'why_choose_us_selected_icon'); ?>
                                            </div>

                                        <?php elseif ( 'image' === $item['icon_type'] ): ?>
                                            <div class="business-model__content-item-icon">
                                                <img src="<?php echo esc_url( $why_choose_us_image_icon ); ?>" alt="<?php echo esc_attr( $why_choose_us_image_icon_alt ); ?>">
                                            </div>
                                        <?php endif;?>
                                        <div class="business-model__content-item-text">
                                            <?php if (!empty($item['info_title'])) : ?>
                                                <h6><?php print delishs_kses($item['info_title' ]); ?></h6>
                                            <?php endif; ?>
                                            <?php if (!empty($item['info_description'])): ?>
                                                <p class="mb-0"><?php print delishs_kses($item['info_description' ]); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="business-model__media text-center text-xl-end wow clip-a-z">
                                <img src="<?php print esc_url($delishs_image); ?>" alt="<?php print esc_attr($delishs_image_alt); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-2' ): ?>

            <section class="delishs-el-section most-reservation section-space most-reservation__bottom-up theme-bg-secondary" data-background="<?php print get_template_directory_uri(); ?>/assets/imgs/most-reservation/most-reservation.png">
                <div class="container">
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="most-reservation__content wow clip-a-z">
                                <div class="section__title-wrapper text-start mb-15">
                                    <?php if(!empty($settings['section_subheading'])): ?>
                                        <span class="delishs-el-section-subheading section__subtitle justify-content-start mb-15 mb-xs-5 wow clip-a-z">
                                            <?php echo rrdevs_kses($settings['section_subheading']); ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['section_title' ]) ) : ?>
                                        <h2 class="delishs-el-section-title section__title section__title-line-height-50 mb-0 title-animation">
                                            <?php echo rrdevs_kses($settings['section_title']); ?>
                                        </h2>
                                    <?php endif; ?>
                                </div>
                                <?php if( !empty($settings['section_description']) ) : ?>
                                    <p class="delishs-el-section-description mb-35">
                                        <?php echo rrdevs_kses($settings['section_description']); ?>
                                    </p>
                                <?php endif; ?>

                                <ul class="most-reservation__content-list">
                                    <?php foreach ($settings['delishs_info_list_two'] as $key => $item) : 
                                            
                                        if ( !empty($item['why_choose_us_image_icon']['url']) ) {
                                            $why_choose_us_image_icon = !empty($item['why_choose_us_image_icon']['id']) ? wp_get_attachment_image_url( $item['why_choose_us_image_icon']['id'], 'full') : $item['why_choose_us_image_icon']['url'];
                                            $why_choose_us_image_icon_alt = get_post_meta($item["why_choose_us_image_icon"]["id"], "_wp_attachment_image_alt", true);
                                        }
                                    
                                    ?>
                                    <li>
                                        <?php if ( 'icon' === $item['icon_type'] ): ?>
                                            <?php delishs_render_icon($item, 'why_choose_us_icon', 'why_choose_us_selected_icon'); ?>
                                        <?php elseif ( 'image' === $item['icon_type'] ): ?>
                                            <img src="<?php echo esc_url( $why_choose_us_image_icon ); ?>" alt="<?php echo esc_attr( $why_choose_us_image_icon_alt ); ?>">
                                        <?php endif;?>
                                        <?php if (!empty($item['info_title'])) : ?>
                                            <?php print delishs_kses($item['info_title' ]); ?>
                                        <?php endif; ?>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif;
	}

}

$widgets_manager->register( new Delishs_Why_Choose_Us() );