<?php
namespace DelishsCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Testimonial_Slider extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'delishs_testimonial_slider';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Testimonial Slider', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'delishs_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__( 'Design Layout', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__( 'Style', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__( 'Layout 1', 'delishs-core' ),
                    'layout-2'  => esc_html__( 'Layout 2', 'delishs-core' ),
                    'layout-3'  => esc_html__( 'Layout 3', 'delishs-core' ),
                ],
            ]
        );

        $this->add_control(
            'testimonial_image',
            [
                'label' => esc_html__( 'Testimonial Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_title',
            [
                'label'       => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'         => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__('Subtitle', 'delishs-core'),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Our Testimonial Say', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'What Clients Say Digital Services', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title_shape',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'delishs-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'delishs-core' ),
                'label_off' => esc_html__( 'Hide', 'delishs-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Testimonial List
        $this->start_controls_section(
            '_content_testimonial_list',
            [
                'label' => esc_html__( 'Testimonial List', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            
        $repeater = new Repeater();

        $repeater->add_control(
            'testimonial_author_image',
            [
                'label' => esc_html__( 'Testimonial Background Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'testimonial_name', [
                'label' => esc_html__( 'Name', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Karon Metara' , 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'testimonial_position', [
                'label' => esc_html__( 'Position', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Founder' , 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'testimonial_description',
            [
                'label' => esc_html__( 'Content', 'delishs-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__( 'We are privileged to work with hundreds future what They Say About businesses, including many of the world’s for best this tobe software, and this softewer brands.', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'testimonial_list',
            [
                'label' => esc_html__( 'Testimonial List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' =>  $repeater->get_controls(),
                'default' => [
                    [
                        'testimonial_name' => esc_html__( 'Karon Metara', 'delishs-core' ),
                        'testimonial_position' => esc_html__( 'Founder', 'delishs-core' ),
                        'testimonial_description' => esc_html__( 'We are privileged to work with hundreds future what They Say About businesses, including many of the world’s for best this tobe software, and this softewer brands.', 'delishs-core' ),
                    ],
                    [
                        'testimonial_name' => esc_html__( 'David Willey', 'delishs-core' ),
                        'testimonial_position' => esc_html__( 'Founder', 'delishs-core' ),
                        'testimonial_description' => esc_html__( 'We are privileged to work with hundreds future what They Say About businesses, including many of the world’s for best this tobe software, and this softewer brands.', 'delishs-core' ),
                    ],
                    [
                        'testimonial_name' => esc_html__( 'Henry John', 'delishs-core' ),
                        'testimonial_position' => esc_html__( 'Founder', 'delishs-core' ),
                        'testimonial_description' => esc_html__( 'We are privileged to work with hundreds future what They Say About businesses, including many of the world’s for best this tobe software, and this softewer brands.', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ testimonial_name }}}',
            ]
        );

        $this->end_controls_section();

        // TAB_STYLE
		$this->start_controls_section(
			'_style_design_layout',
			[
				'label' => esc_html__( 'Design Layout', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => esc_html__( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_subheading',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
            ]
        );

        $this->add_responsive_control(
            'subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subheading_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'subheading_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading',
            ]
        );

        $this->add_responsive_control(
            'subheading_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Title
        $this->add_control(
            '_section_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-title',
            ]
        );

        $this->add_control(
            '_heading_style_section_layout',
            [
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_layout_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .section__title-wrapper' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'delishs_testimonial_list_style',
			[
				'label' => esc_html__( 'Testimonial List', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            '_heading_name',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Name', 'delishs-core' ),
            ]
        );

        $this->add_responsive_control(
            'name_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item__author-text h5' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .client-feedback__item-content__author h6' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item__author-text h5' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .client-feedback__item-content__author .text h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .client-testimonial__item__author-text h5, .client-feedback__item-content__author .text h6',
            ]
        );

        // Position 
        $this->add_control(
            '_heading_position',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Position', 'delishs-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'position_spacing',
            [
                'label' => esc_html__( 'Top Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item__author-text span' => 'margin-top: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .client-feedback__item-content__author .text span' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item__author-text span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .client-feedback__item-content__author .text span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'position_typography',
                'selector' => '{{WRAPPER}} .client-testimonial__item__author-text span, .client-feedback__item-content__author .text span',
            ]
        );

        // Description
        $this->add_control(
            '_content_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'description_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .client-feedback__item-content p' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .client-feedback__item-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .client-testimonial__item p, .client-feedback__item-content p',
            ]
        );

        // Layout
        $this->add_control(
            '_content_testimonial_list_layout',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'separator' => 'before',
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2' ],
                ],
            ]
        );

        $this->add_control(
            'testimonial_list_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-testimonial__item' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .client-feedback__item' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-3' ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_list_layout_border',
                'selector' => '{{WRAPPER}} .client-testimonial__item:before',
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $this->add_control(
            'testimonial_list_layout_border_color_two',
            [
                'label' => esc_html__( 'Border Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .client-feedback__item-content::before' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-3' ],
                ],
            ]
        );

		$this->end_controls_section();
        
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( !empty($settings['testimonial_image']['url']) ) {
            $delishs_testimonial_image = !empty($settings['testimonial_image']['id']) ? wp_get_attachment_image_url( $settings['testimonial_image']['id'], 'full') : $settings['testimonial_image']['url'];
            $delishs_testimonial_image_alt = get_post_meta($settings["testimonial_image"]["id"], "_wp_attachment_image_alt", true);
        }

		?>

        <?php if ( $settings['design_style']  == 'layout-1' ) : ?>

            <section class="delishs-el-section client-testimonial section-space__top overflow-hidden">
                <div class="container">
                    <div class="client-testimonial__bg leftRight" data-background="<?php print esc_url($delishs_testimonial_image); ?>"></div>
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="section__title-wrapper text-center mb-70 mb-sm-50 mb-xs-40">
                                <?php if ( !empty ($settings['section_subheading']) ) : ?>
                                    <span class="delishs-el-section-subheading section__subtitle justify-content-center mb-10 mb-xs-5 wow clip-a-z">
                                        <?php print rrdevs_kses($settings['section_subheading']); ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( !empty ($settings['section_title']) ) : ?>
                                    <h2 class="delishs-el-section-title section__title mb-10 mb-xs-5 title-animation">
                                        <?php print rrdevs_kses($settings['section_title']); ?>
                                    </h2>
                                <?php endif; ?>
                                <?php if ( !empty ($settings['section_title_shape']) ) : ?>
                                    <div class="dot-shpae wow clip-a-z">
                                        <img class="img-fluid" src="<?php print get_template_directory_uri(); ?>/assets/imgs/section-title/dot-shape.svg" alt="<?php print esc_attr( 'Dot shape', 'delishs-core' ); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="row g-24">
                        <div class="col-12">
                            <div class="swiper client-testimonial__slider">
                                <div class="swiper-wrapper">
                                    <?php foreach ($settings['testimonial_list'] as $index => $item) : 
                                        if ( !empty($item['testimonial_author_image']['url']) ) {
                                            $delishs_testimonial_author_image = !empty($item['testimonial_author_image']['id']) ? wp_get_attachment_image_url( $item['testimonial_author_image']['id']) : $item['testimonial_author_image']['url'];
                                            $delishs_testimonial_author_image_alt = get_post_meta($item["testimonial_author_image"]["id"], "_wp_attachment_image_alt", true);
                                        }
                                    ?>
                                    <div class="swiper-slide">
                                        <div class="client-testimonial__item">
                                            <?php if ( !empty($item['testimonial_description']) ) : ?>
                                                <p class="mb-30"><?php echo rrdevs_kses($item['testimonial_description']); ?></p>
                                            <?php endif; ?>
                                            
                                            <div class="client-testimonial__item__author d-flex align-items-center justify-content-between">
                                                <div class="client-testimonial__item__author-media">
                                                    <img src="<?php print esc_url($delishs_testimonial_author_image); ?>" class="img-fluid" alt="<?php print esc_attr($delishs_testimonial_author_image_alt); ?>">
                                                </div>

                                                <div class="client-testimonial__item__author-text">
                                                    <h5><?php echo rrdevs_kses($item['testimonial_name']); ?></h5>
                                                    <?php if ( !empty ($item['testimonial_position']) ) : ?>
                                                        <span>
                                                            <?php echo rrdevs_kses($item['testimonial_position']); ?>
                                                        </span>
                                                    <?php endif; ?>
                                                </div>

                                                <div class="client-testimonial__item__author-icon">
                                                    <img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-testimonial/quite.png" class="img-fluid" alt="quote icon">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-2' ) : ?>

            <section class="delishs-el-section client-feedback client-feedback__bg section-space section-bg-3" data-background="<?php print esc_url($delishs_testimonial_image); ?>">
                <div class="container">
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="section__title-wrapper text-center mb-70 mb-sm-50 mb-xs-40">
                                <?php if ( !empty ($settings['section_subheading']) ) : ?>
                                    <span class="delishs-el-section-subheading section__subtitle justify-content-center mb-10 mb-xs-5 wow clip-a-z">
                                        <?php print rrdevs_kses($settings['section_subheading']); ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( !empty ($settings['section_title']) ) : ?>
                                    <h2 class="delishs-el-section-title section__title mb-10 mb-xs-5 title-animation">
                                        <?php print rrdevs_kses($settings['section_title']); ?>
                                    </h2>
                                <?php endif; ?>
                                <?php if ( !empty ($settings['section_title_shape']) ) : ?>
                                    <div class="dot-shpae wow clip-a-z">
                                        <img class="img-fluid" src="<?php print get_template_directory_uri(); ?>/assets/imgs/section-title/dot-shape.svg" alt="<?php print esc_attr( 'Dot shape', 'delishs-core' ); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="swiper client-feedback__slider">
                        <div class="swiper-wrapper">
                            <?php foreach ($settings['testimonial_list'] as $index => $item) : 
                                if ( !empty($item['testimonial_author_image']['url']) ) {
                                    $delishs_testimonial_author_image = !empty($item['testimonial_author_image']['id']) ? wp_get_attachment_image_url( $item['testimonial_author_image']['id']) : $item['testimonial_author_image']['url'];
                                    $delishs_testimonial_author_image_alt = get_post_meta($item["testimonial_author_image"]["id"], "_wp_attachment_image_alt", true);
                                }
                            ?>
                            <div class="swiper-slide">
                                <div class="client-feedback__item">
                                    <div class="client-feedback__item-media d-flex flex-column">
                                        <img src="<?php print esc_url($delishs_testimonial_author_image); ?>" class="img-fluid" alt="<?php print esc_attr($delishs_testimonial_author_image_alt); ?>">
                                        <ul class="client-feedback__item-rating mt-xl-auto">
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                        </ul>
                                    </div>
                                    <div class="client-feedback__item-content">
                                        <?php if ( !empty($item['testimonial_description']) ) : ?>
                                            <p><?php echo rrdevs_kses($item['testimonial_description']); ?></p>
                                        <?php endif; ?>

                                        <div class="client-feedback__item-content__author d-flex justify-content-between align-items-center">
                                            <div class="text">
                                                <h6 class="text-uppercase"><?php echo rrdevs_kses($item['testimonial_name']); ?></h6>
                                                <?php if ( !empty ($item['testimonial_position']) ) : ?>
                                                    <span>
                                                        <?php echo rrdevs_kses($item['testimonial_position']); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/quite.png" class="img-fluid" alt="quite icon">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-3' ) : ?>

            <section class="delishs-el-section customer-feedback customer-feedback__bg section-space theme-bg-secondary" data-background="<?php print esc_url($delishs_testimonial_image); ?>">
                <div class="container">
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="section__title-wrapper text-center mb-70 mb-sm-50 mb-xs-40">
                                <?php if ( !empty ($settings['section_subheading']) ) : ?>
                                    <span class="delishs-el-section-subheading section__subtitle justify-content-center mb-10 mb-xs-5 wow clip-a-z">
                                        <?php print rrdevs_kses($settings['section_subheading']); ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( !empty ($settings['section_title']) ) : ?>
                                    <h2 class="delishs-el-section-title section__title section__title-white mb-10 mb-xs-5 title-animation">
                                        <?php print rrdevs_kses($settings['section_title']); ?>
                                    </h2>
                                <?php endif; ?>
                                <?php if ( !empty ($settings['section_title_shape']) ) : ?>
                                    <div class="dot-shpae wow clip-a-z">
                                        <img class="img-fluid" src="<?php print get_template_directory_uri(); ?>/assets/imgs/section-title/dot-shape.svg" alt="<?php print esc_attr( 'Dot shape', 'delishs-core' ); ?>">
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <div class="swiper client-feedback__slider">
                        <div class="swiper-wrapper">
                            <?php foreach ($settings['testimonial_list'] as $index => $item) : 
                                if ( !empty($item['testimonial_author_image']['url']) ) {
                                    $delishs_testimonial_author_image = !empty($item['testimonial_author_image']['id']) ? wp_get_attachment_image_url( $item['testimonial_author_image']['id']) : $item['testimonial_author_image']['url'];
                                    $delishs_testimonial_author_image_alt = get_post_meta($item["testimonial_author_image"]["id"], "_wp_attachment_image_alt", true);
                                }
                            ?>
                            <div class="swiper-slide">
                                <div class="client-feedback__item client-feedback__item-customer">
                                    <div class="client-feedback__item-media d-flex flex-column">
                                        <img src="<?php print esc_url($delishs_testimonial_author_image); ?>" class="img-fluid" alt="<?php print esc_attr($delishs_testimonial_author_image_alt); ?>">
                                        <ul class="client-feedback__item-rating mt-xl-auto">
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                            <li><img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/start.svg" class="img-fluid" alt="not found"></li>
                                        </ul>
                                    </div>
                                    <div class="client-feedback__item-content">
                                        <?php if ( !empty($item['testimonial_description']) ) : ?>
                                            <p><?php echo rrdevs_kses($item['testimonial_description']); ?></p>
                                        <?php endif; ?>

                                        <div class="client-feedback__item-content__author d-flex justify-content-between align-items-center">
                                            <div class="text">
                                                <h6 class="text-uppercase"><?php echo rrdevs_kses($item['testimonial_name']); ?></h6>
                                                <?php if ( !empty ($item['testimonial_position']) ) : ?>
                                                    <span>
                                                        <?php echo rrdevs_kses($item['testimonial_position']); ?>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            <img src="<?php print get_template_directory_uri(); ?>/assets/imgs/client-feedback/quite.png" class="img-fluid" alt="quite icon">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif; ?>

    <?php 
        }
    }

$widgets_manager->register( new Delishs_Testimonial_Slider() );