<?php
namespace DelishCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Runok_Team_Details extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'team_details';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team Details', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'runok_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected static function get_profile_names()
    {
        return [
            '500px' => esc_html__('500px', 'delishs-core'),
            'apple' => esc_html__('Apple', 'delishs-core'),
            'behance' => esc_html__('Behance', 'delishs-core'),
            'bitbucket' => esc_html__('BitBucket', 'delishs-core'),
            'codepen' => esc_html__('CodePen', 'delishs-core'),
            'delicious' => esc_html__('Delicious', 'delishs-core'),
            'deviantart' => esc_html__('DeviantArt', 'delishs-core'),
            'digg' => esc_html__('Digg', 'delishs-core'),
            'dribbble' => esc_html__('Dribbble', 'delishs-core'),
            'email' => esc_html__('Email', 'delishs-core'),
            'facebook' => esc_html__('Facebook', 'delishs-core'),
            'flickr' => esc_html__('Flicker', 'delishs-core'),
            'foursquare' => esc_html__('FourSquare', 'delishs-core'),
            'github' => esc_html__('Github', 'delishs-core'),
            'houzz' => esc_html__('Houzz', 'delishs-core'),
            'instagram' => esc_html__('Instagram', 'delishs-core'),
            'jsfiddle' => esc_html__('JS Fiddle', 'delishs-core'),
            'linkedin' => esc_html__('LinkedIn', 'delishs-core'),
            'medium' => esc_html__('Medium', 'delishs-core'),
            'pinterest' => esc_html__('Pinterest', 'delishs-core'),
            'product-hunt' => esc_html__('Product Hunt', 'delishs-core'),
            'reddit' => esc_html__('Reddit', 'delishs-core'),
            'slideshare' => esc_html__('Slide Share', 'delishs-core'),
            'snapchat' => esc_html__('Snapchat', 'delishs-core'),
            'soundcloud' => esc_html__('SoundCloud', 'delishs-core'),
            'spotify' => esc_html__('Spotify', 'delishs-core'),
            'stack-overflow' => esc_html__('StackOverflow', 'delishs-core'),
            'tripadvisor' => esc_html__('TripAdvisor', 'delishs-core'),
            'tumblr' => esc_html__('Tumblr', 'delishs-core'),
            'twitch' => esc_html__('Twitch', 'delishs-core'),
            'twitter' => esc_html__('Twitter', 'delishs-core'),
            'vimeo' => esc_html__('Vimeo', 'delishs-core'),
            'vk' => esc_html__('VK', 'delishs-core'),
            'website' => esc_html__('Website', 'delishs-core'),
            'whatsapp' => esc_html__('WhatsApp', 'delishs-core'),
            'wordpress' => esc_html__('WordPress', 'delishs-core'),
            'xing' => esc_html__('Xing', 'delishs-core'),
            'yelp' => esc_html__('Yelp', 'delishs-core'),
            'youtube' => esc_html__('YouTube', 'delishs-core'),
        ];
    }


	protected function register_controls() {

        $this->start_controls_section(
            'runok_section_title',
            [
                'label' => esc_html__('Title & Content', 'delishs-core'),
            ]
        );

        $this->add_control(
            'runok_image',
            [
                'label' => esc_html__( 'Choose Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );     

        $this->add_control(
            'name',
            [
                'label' => esc_html__('Name', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Richard John', 'delishs-core'),
                'label_block' => true,
            ]
        );       

        $this->add_control(
            'designation',
            [
                'label' => esc_html__('Name', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Richard John', 'delishs-core'),
                'label_block' => true,
            ]
        );       

        $this->add_control(
            'description',
            [
                'label' => esc_html__('About', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __('Sem consequat mauris conubia inceptos nostra rutrum morbi sagittis pulvinar, commodo curabitur maecenas fermentum magna tempus nisi ullamcorper, ante auctor magnis pretium eu lectus euismod platea. Congue sociosqu nostra est urna pellentesque placerat euismod bibendum.', 'delishs-core'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_info',
            [
                'label' => esc_html__( 'Info',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'experience_label',
            [
                'label' => esc_html__('Experience Label', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Experience', 'delishs-core'),
            ]
        );

        $this->add_control(
            'experience',
            [
                'label' => esc_html__('Experience', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('More Than 10 Years', 'delishs-core'),
            ]
        );

        $this->add_control(
            'email_label',
            [
                'label' => esc_html__('Email Label', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Email', 'delishs-core'),
            ]
        );

        $this->add_control(
            'email',
            [
                'label' => esc_html__('Email Address', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('info@agency.com', 'delishs-core'),
            ]
        );

        $this->add_control(
            'phone_label',
            [
                'label' => esc_html__('Phone Label', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Phone', 'delishs-core'),
            ]
        );

        $this->add_control(
            'phone',
            [
                'label' => esc_html__('Phone', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+(256) 58621-69581', 'delishs-core'),
            ]
        );

        $this->add_control(
            'phone_number',
            [
                'label' => esc_html__('Phone Number', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+2565862169581', 'delishs-core'),
            ]
        );

        $this->add_control(
            'fax_label',
            [
                'label' => esc_html__('Fax Label', 'delishs-core'),
                'description' => runok_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Fax', 'delishs-core'),
            ]
        );

        $this->add_control(
            'fax',
            [
                'label' => esc_html__('Fax', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('+2568145632', 'delishs-core'),
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_button',
            [
                'label' => esc_html__( 'Button', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Contact Me', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Button link', 'delishs-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'delishs-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'button_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_page_link',
            [
                'label' => esc_html__( 'Select Button Page', 'delishs-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => runok_get_all_pages(),
                'condition' => [
                    'button_link_type' => '2',
                ]
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
			'_style_design_layout',
			[
				'label' => esc_html__( 'Design Layout', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .author-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'_style_title',
			[
				'label' => esc_html__( 'Title & Content', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            '_heading_name',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Name', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .author-wrap .author-content .name',
            ]
        );

        $this->add_control(
            '_heading_designation',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Designation', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'designation_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .name span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'designation_typography',
                'selector' => '{{WRAPPER}} .author-wrap .author-content .name span',
            ]
        );

        $this->add_control(
            '_heading_about',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'About', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'about_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'about_typography',
                'selector' => '{{WRAPPER}} .author-wrap .author-content p',
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            '_style_info',
            [
                'label' => esc_html__( 'Info',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            '_heading_info_icon',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Icon', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'info_icon_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'info_icon_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            '_heading_info_label',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Label', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'info_label_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .content h4 span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_label_typography',
                'selector' => '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .content h4 span',
            ]
        );

        $this->add_control(
            '_heading_info_text',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Info Text', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->start_controls_tabs( 'info_text_tabs' );
        
        $this->start_controls_tab(
            'info_text_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'info_text_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .content h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'info_text_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'info_text_color_hover',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .content h4 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_text_typography',
                'selector' => '{{WRAPPER}} .author-wrap .author-content .author-items .author-item .content h4',
            ]
        );

        $this->add_control(
            '_style_info_layout',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'info_layout_border_color',
            [
                'label' => esc_html__( 'Border', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:not(:last-of-type)' => 'border-bottom-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:nth-child(2)' => 'border-bottom-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:nth-child(1)' => 'border-bottom-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:nth-child(1)' => 'border-right-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:nth-child(3)' => 'border-bottom-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:nth-child(3)' => 'border-right-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items .author-item:nth-child(4)' => 'border-bottom-color: {{VALUE}}',
                    '{{WRAPPER}} .author-wrap .author-content .author-items' => 'border-top-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_button',
            [
                'label' => esc_html__( 'Button', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->start_controls_tabs( 'tabs_style_button' );
        
        $this->start_controls_tab(
            'button_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button'    => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'label'    => esc_html__( 'Border', 'delishs-core' ),
                'name'     => 'button_border',
                'selector' => '{{WRAPPER}} .delishs-el-button',
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .delishs-el-button',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button:after, .delishs-el-button:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'label'    => esc_html__( 'Border', 'delishs-core' ),
                'name'     => 'button_border_hover',
                'selector' => '{{WRAPPER}} .delishs-el-button:hover',
            ]
        );
        
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow_hover',
                'selector' => '{{WRAPPER}} .delishs-el-button:hover',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();
        
        $this->add_control(
            'button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'delishs-core' ),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button' => 'border-radius: {{SIZE}}px;',
                    '{{WRAPPER}} .delishs-el-button:before' => 'border-radius: {{SIZE}}px;',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'delishs-core' ),
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .delishs-el-button',
            ]
        );
        
        $this->add_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'delishs-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'delishs-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

            if ( !empty($settings['runok_image']['url']) ) {
                $runok_image = !empty($settings['runok_image']['id']) ? wp_get_attachment_image_url( $settings['runok_image']['id'], 'full' ) : $settings['runok_image']['url'];
                $runok_image_alt = get_post_meta($settings["runok_image"]["id"], "_wp_attachment_image_alt", true);
            }

            if ( !empty($settings['runok_signature_image']['url']) ) {
                $runok_signature_image = !empty($settings['runok_signature_image']['id']) ? wp_get_attachment_image_url( $settings['runok_signature_image']['id'], 'full' ) : $settings['runok_signature_image']['url'];
                $runok_signature_image_alt = get_post_meta($settings["runok_signature_image"]["id"], "_wp_attachment_image_alt", true);
            }

            if ('2' == $settings['button_link_type']) {
                $this->add_render_attribute('delishs-button-arg', 'href', get_permalink($settings['button_page_link']));
                $this->add_render_attribute('delishs-button-arg', 'target', '_self');
                $this->add_render_attribute('delishs-button-arg', 'rel', 'nofollow');
                $this->add_render_attribute('delishs-button-arg', 'class', 'delishs-el-button rr-primary-btn');
            } else {
                if ( ! empty( $settings['button_link']['url'] ) ) {
                    $this->add_link_attributes( 'delishs-button-arg', $settings['button_link'] );
                    $this->add_render_attribute('delishs-button-arg', 'class', 'delishs-el-button rr-primary-btn');
                }
            }

		?>
            <section class="team-author">
                <div class="container">
                    <div class="row author-wrap align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <?php if ( !empty ( $settings['runok_image']['url'] ) ) : ?>  
                                <div class="author-img">
                                    <img src="<?php echo esc_url($runok_image); ?>" alt="<?php echo esc_attr($runok_image_alt); ?>" />
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-lg-6 col-md-12">
                            <div class="author-content">
                                <?php if ( !empty($settings['name' ]) ) : ?>
                                    <h2 class="name">
                                        <?php print rrdevs_kses($settings['name' ]); ?> <span><?php print rrdevs_kses($settings['designation' ]); ?></span>
                                    </h2>
                                <?php endif; ?>
                                <?php if ( !empty($settings['description']) ) : ?>
                                    <p><?php print rrdevs_kses($settings['description']); ?></p>
                                <?php endif; ?>
                                <div class="author-items">
                                    <?php if ( !empty($settings['experience']) ) : ?>
                                        <div class="author-item">
                                            <div class="icon"><i class="fa-solid fa-user"></i></div>
                                            <div class="content">
                                                <h4>
                                                    <span><?php print rrdevs_kses( $settings['experience_label'] ); ?></span>
                                                    <?php print rrdevs_kses( $settings['experience'] ); ?>
                                                </h4>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['experience']) ) : ?>
                                        <div class="author-item">
                                            <div class="icon"><i class="fa-sharp fa-solid fa-envelope"></i></div>
                                            <div class="content">
                                                <h4>
                                                    <span><?php print rrdevs_kses( $settings['email_label'] ); ?></span>
                                                    <a href="mailto:<?php print esc_attr( $settings['email'] ); ?>"><?php print esc_html( $settings['email'] ); ?></a>
                                                </h4>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['phone']) ) : ?>
                                        <div class="author-item">
                                            <div class="icon"><i class="fa-sharp fa-solid fa-phone"></i></div>
                                            <div class="content">
                                                <h4>
                                                    <span><?php print rrdevs_kses( $settings['phone_label'] ); ?></span>
                                                    <a href="tel:<?php print esc_attr( $settings['phone_number'] ); ?>">
                                                        <?php print esc_html( $settings['phone'] ); ?>
                                                    </a>
                                                </h4>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['fax']) ) : ?>
                                        <div class="author-item">
                                            <div class="icon"><i class="fa-sharp fa-solid fa-fax"></i></div>
                                            <div class="content">
                                                <h4><span><?php print rrdevs_kses( $settings['fax_label'] ); ?></span>
                                                    <a href="fax:<?php print esc_attr( $settings['fax'] ); ?>">
                                                        <?php print esc_html( $settings['fax'] ); ?>
                                                    </a>
                                                </h4>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if ( !empty ( $settings['button_text'] ) ) : ?>
                                <a <?php echo $this->get_render_attribute_string( 'delishs-button-arg' ); ?>>
                                    <?php print esc_html($settings['button_text']); ?>
                                </a>
                                <?php endif; ?>   
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php
	}

}

$widgets_manager->register( new Runok_Team_Details() );