<?php
namespace DelishsCore\Widgets;

use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Widget_Base;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Opening_Time extends Widget_Base {

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'delishs_opening_time';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Opening Time', 'delishs-core' );
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'delishs-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['delishs_core'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return ['delishs-core'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function register_controls() {

        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__( 'Design Layout', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'   => esc_html__( 'Select Layout', 'delishs-core' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__( 'Layout 1', 'delishs-core' ),
                    'layout-2' => esc_html__( 'Layout 2', 'delishs-core' ),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'section_background_image',
            [
                'label'     => esc_html__( 'Background Image', 'delishs-core' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'section_background_image_two',
            [
                'label'     => esc_html__( 'Background Image Two', 'delishs-core' ),
                'type'      => Controls_Manager::MEDIA,
                'default'   => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_title',
            [
                'label'       => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'         => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'section_subheading',
            [
                'label'       => esc_html__( 'Subtitle', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'MAKE RESERVATION', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label'       => esc_html__( 'Title', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'OPENING TIME', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_title_shape',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'delishs-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'delishs-core' ),
                'label_off' => esc_html__( 'Hide', 'delishs-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_info',
            [
                'label' => esc_html__( 'Info', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            '_heading_content_shift_one',
            [
                'label' => esc_html__( 'Shift One', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'opening_time_title_one',
            [
                'label'       => esc_html__( 'Title', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Monday To Friday', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'opening_time_start_one',
            [
                'label'       => esc_html__( 'Start', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '10:00', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'opening_time_end_one',
            [
                'label'       => esc_html__( 'End', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '12:00', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            '_heading_content_shift_two',
            [
                'label' => esc_html__( 'Shift Two', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'opening_time_title_two',
            [
                'label'       => esc_html__( 'Title', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'Friday To Sunday', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'opening_time_start_two',
            [
                'label'       => esc_html__( 'Start', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '10:00', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'opening_time_end_two',
            [
                'label'       => esc_html__( 'End', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '12:00', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_phone',
            [
                'label' => esc_html__( 'Phone',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'phone_icon_type',
            [
                'label' => esc_html__( 'Image Type', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'icon',
                'options' => [
                    'icon' => esc_html__( 'Icon', 'delishs-core' ),
                    'image' => esc_html__( 'Image', 'delishs-core' ),
                ],
            ]
        );
        
        $this->add_control(
            'phone_image_icon',
            [
                'label' => esc_html__( 'Upload Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'condition' => [
                    'phone_icon_type' => 'image',
                ],
            ]
        );
        
        $this->add_control(
            'phone_icon',
            [
                'label' => esc_html__( 'Icon', 'delishs-core' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'label_block' => true,
                'default' => [
                    'value' => 'fas fa-phone',
                    'library' => 'solid',
                ],
                'condition' => [
                    'phone_icon_type' => 'icon',
                ],
            ]
        );
        
        $this->add_control(
            'opening_time_phone',
            [
                'label'       => esc_html__( 'Phone', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '+256 1489 362', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'opening_time_phone_url',
            [
                'label'       => esc_html__( 'Phone URL', 'delishs-core' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( '+2561489362', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_open_hours',
            [
                'label' => esc_html__( 'Opening Hours',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );
        
        $this->add_control(
            'open_hours_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Opening Hours', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();
        
        $repeater->add_control(
            'open_hours_text',
            [
                'label' => esc_html__( 'Text', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'open_hours_list',
            [
                'label' => esc_html__( ' List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'open_hours_text' => __( 'Lunch: 12Pm – 3Pm', 'delishs-core' ),
                    ],
                    [
                        'open_hours_text' => __( 'Diner: 7Pm – 2Am (Last Order At 11:30Pm)', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ open_hours_text }}}',
            ]
        );
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            '_content_visit_our_restaurant',
            [
                'label' => esc_html__( 'Visit Our Restaurant',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );
        
        $this->add_control(
            'visit_our_restaurant_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Visit Our Restaurant', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'visit_our_restaurant_select',
            [
                'label' => esc_html__( 'Select Option', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'address' => esc_html__( 'Address', 'delishs-core' ),
                    'phone' => esc_html__( 'Phone', 'delishs-core' ),
                    'mail' => esc_html__( 'Mail', 'delishs-core' ),
                    'text' => esc_html__( 'Text', 'delishs-core' ),
                ],
                'default' => 'text',
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_address',
            [
                'label' => esc_html__( 'Address', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'address',
                ],
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_address_url',
            [
                'label' => esc_html__( 'Address URL', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'address',
                ],
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_phone',
            [
                'label' => esc_html__( 'Phone', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'phone',
                ],
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_phone_url',
            [
                'label' => esc_html__( 'Phone URL', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'phone',
                ],
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_mail',
            [
                'label' => esc_html__( 'Mail', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'mail',
                ],
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_mail_url',
            [
                'label' => esc_html__( 'Mail', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'mail',
                ],
            ]
        );
        
        $repeater->add_control(
            'visit_our_restaurant_text',
            [
                'label' => esc_html__( 'Text', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Eight avenue 487, NY,', 'delishs-core' ),
                'label_block' => true,
                'condition' => [
                    'visit_our_restaurant_select' => 'text',
                ],
            ]
        );
        
        $this->add_control(
            'visit_our_restaurant_list',
            [
                'label' => esc_html__( ' List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'visit_our_restaurant_address' => __( 'Eight avenue 487, NY,', 'delishs-core' ),
                        'visit_our_restaurant_address_url' => __( 'https://maps.app.goo.gl/1N77c8d8zieLRaot7', 'delishs-core' ),
                    ],
                    [
                        'visit_our_restaurant_phone' => __( 'T. +12 344 0567899', 'delishs-core' ),
                        'visit_our_restaurant_phone_url' => __( '+123440567899', 'delishs-core' ),
                    ],
                    [
                        'visit_our_restaurant_mail' => __( 'M. fidalgo@example.com', 'delishs-core' ),
                        'visit_our_restaurant_mail_url' => __( 'fidalgo@example.com', 'delishs-core' ),
                    ],
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => __( 'Design Layout', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'design_layout_margin',
            [
                'label'      => esc_html__( 'Margin', 'delishs-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_padding',
            [
                'label'      => esc_html__( 'Padding', 'delishs-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_image_border',
            [
                'label' => esc_html__( 'Image Border', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .book-a-table-3-bottom__media-thumb-1 .thumb-2::before' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_section_title',
            [
                'label'     => esc_html__( 'Title', 'delishs-core' ),
                'type'      => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label'      => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label'     => __( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'section_title_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-title',
            ]
        );

        $this->add_control(
            '_heading_style_section_title_layout',
            [
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_title_layout_spacing',
            [
                'label'      => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .section__title-wrapper' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
                'type'  => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_subheading_spacing',
            [
                'label'      => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'section_subheading_color',
            [
                'label'     => __( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'section_subheading_background',
            [
                'label'     => __( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'section_subheading_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_phone',
            [
                'label' => esc_html__( 'Phone',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->start_controls_tabs( 'phone_tabs' );
        
        $this->start_controls_tab(
            'phone_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'phone_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content a' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'phone_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'phone_border',
                'selector' => '{{WRAPPER}} .opening-time__content a',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'phone_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'phone_color_hover',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'phone_background_hover',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'phone_border_hover',
                'selector' => '{{WRAPPER}} .opening-time__content a:hover',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'phone_typography',
                'selector' => '{{WRAPPER}} .opening-time__content a',
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_info_list',
            [
                'label' => esc_html__( 'Info List',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            '_heading_style_info_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'info_title_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .book-a-table-3-bottom__item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->add_control(
            'info_title_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content-table tr th' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .book-a-table-3-bottom__item h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_title_typography',
                'selector' => '{{WRAPPER}} .opening-time__content-table tr th, .book-a-table-3-bottom__item h6',
            ]
        );

        $this->add_control(
            '_heading_style_info_list',
            [
                'label' => esc_html__( 'List', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'info_list_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .book-a-table-3-bottom__item ul li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->add_control(
            'info_list_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content-table tr td' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .book-a-table-3-bottom__item ul li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'info_list_color_hover',
            [
                'label' => esc_html__( 'Color (Hover)', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .book-a-table-3-bottom__item ul li a:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'info_list_typography',
                'selector' => '{{WRAPPER}} .opening-time__content-table tr td, .book-a-table-3-bottom__item ul li',
            ]
        );

        $this->add_control(
            '_heading_style_info_list_layout',
            [
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'info_list_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .book-a-table-3-bottom__item' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .opening-time__content .table>:not(caption)>*>*' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'info_list_border_color',
            [
                'label' => esc_html__( 'Border Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .opening-time__content-table tr' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .book-a-table-3-bottom__item' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_section();

    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( !empty($settings['section_background_image']['url']) ) {
            $section_background_image = !empty($settings['section_background_image']['id']) ? wp_get_attachment_image_url( $settings['section_background_image']['id'], 'full') : $settings['section_background_image']['url'];
            $section_background_image_alt = get_post_meta($settings["section_background_image"]["id"], "_wp_attachment_image_alt", true);
        }

        if ( !empty($settings['section_background_image_two']['url']) ) {
            $section_background_image_two = !empty($settings['section_background_image_two']['id']) ? wp_get_attachment_image_url( $settings['section_background_image_two']['id'], 'full') : $settings['section_background_image_two']['url'];
            $section_background_image_two_alt = get_post_meta($settings["section_background_image_two"]["id"], "_wp_attachment_image_alt", true);
        }

        ?>

        <?php if ( $settings['design_style'] == 'layout-1' ) : ?>

                <section class="delishs-el-section opening-time opening-time__bottom opening-time__background opening-time__space section-bg-3" data-background="<?php print esc_url($section_background_image); ?>">
                    <div class="container">
                        <div class="row g-24">
                            <div class="col-12">
                                <div class="opening-time__content wow clip-a-z text-center">
                                    <div class="section__title-wrapper text-center mb-40 mb-xs-30">
                                        <?php if ( !empty( $settings['section_subheading'] ) ): ?>
                                            <span class="delishs-el-section-subheading section__subtitle justify-content-center mb-10 mb-xs-5 wow clip-a-z">
                                                <?php echo rrdevs_kses( $settings['section_subheading'] ); ?>
                                            </span>
                                        <?php endif;?>
                                        <?php if ( !empty( $settings['section_title'] ) ): ?>
                                            <h2 class="delishs-el-section-title section__title mb-10 mb-xs-5 title-animation">
                                                <?php echo rrdevs_kses( $settings['section_title'] ); ?>
                                            </h2>
                                        <?php endif;?>
                                        <?php if ( !empty( $settings['section_title_shape'] ) ): ?>
                                            <div class="dot-shpae wow clip-a-z">
                                                <img class="img-fluid" src="<?php print get_template_directory_uri();?>/assets/imgs/section-title/dot-shape.svg" alt="not found">
                                            </div>
                                        <?php endif;?>
                                    </div>

                                    <table class="opening-time__content-table table table-bordered mb-40">
                                        <thead>
                                        <tr>
                                            <th scope="col"><?php echo rrdevs_kses( $settings['opening_time_title_one'] ); ?></th>
                                            <th scope="col"><?php echo rrdevs_kses( $settings['opening_time_title_two'] ); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><?php echo rrdevs_kses( $settings['opening_time_start_one'] ); ?></td>
                                            <td><?php echo rrdevs_kses( $settings['opening_time_end_one'] ); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo rrdevs_kses( $settings['opening_time_start_two'] ); ?></td>
                                            <td><?php echo rrdevs_kses( $settings['opening_time_end_two'] ); ?></td>
                                        </tr>
                                        </tbody>
                                    </table>

                                    <a href="tel:<?php print esc_attr($settings['opening_time_phone_url']); ?>">
                                        <?php if ( $settings['phone_icon_type']  == 'image' ): ?>
                                            <img class="img-fluid" src="<?php echo $settings['phone_image_icon']['url']; ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($settings['phone_image_icon']['url']), '_wp_attachment_image_alt', true); ?>">
                                        <?php elseif ( $settings['phone_icon_type']  == 'icon' ): ?>
                                            <?php delishs_render_icon($settings, 'phone_icon' ); ?>
                                        <?php endif; ?>
                                        <?php print esc_html($settings['opening_time_phone']); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

        <?php elseif ( $settings['design_style'] == 'layout-2' ): ?>

            <section class="delishs-el-section book-a-table-3-bottom section-space overflow-hidden">
                <div class="container">
                    <div class="row g-24 align-items-center">
                        <div class="col-md-6">
                            <div class="book-a-table-3-bottom__media">
                                <div class="book-a-table-3-bottom__media-thumb-1">
                                    <img src="<?php print esc_url($section_background_image_two); ?>" class="img-fluid" alt="<?php print esc_attr($section_background_image_two_alt); ?>">
                                    <div class="thumb-2">
                                        <img src="<?php print esc_url($section_background_image); ?>" class="img-fluid" alt="<?php print esc_attr($section_background_image_alt); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="book-a-table-3-bottom-wrapper">
                                <div class="book-a-table-3-bottom__item">
                                    <h6 class="text-uppercase mb-15"><?php print rrdevs_kses($settings['open_hours_title']); ?></h6>
                                    <ul>
                                        <?php foreach ($settings['open_hours_list'] as $item) : ?>
                                            <li><?php print rrdevs_kses($item['open_hours_text']); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                                <div class="book-a-table-3-bottom__item">
                                    <h6 class="text-uppercase mb-15"><?php print rrdevs_kses($settings['visit_our_restaurant_title']); ?></h6>
                                    <ul>
                                            
                                        <li><a href="https://maps.app.goo.gl/1N77c8d8zieLRaot7">Eight avenue 487, NY,</a></li>
                                        <li><a href="tel:123440567899">T. +12 344 0567899</a></li>
                                        <li><a href="mailto:fidalgo@example.com">M. fidalgo@example.com</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif;?>

        <?php
    }
}

$widgets_manager->register( new Delishs_Opening_Time() );