<?php
namespace DelishsCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Hero_Slider extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'delishs_hero_slider';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Hero Slider', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'delishs_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'delishs-core'),
                'type' => Controls_Manager::HIDDEN,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'delishs-core'),
                    'layout-2' => esc_html__('Layout 2', 'delishs-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'title_one',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Transforming', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'title_two',
            [
                'label' => esc_html__( 'Title Two', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Visions into', 'delishs-core' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'title_three',
            [
                'label' => esc_html__( 'Title Three', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Digital Reality', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_hero_slider',
            [
                'label' => esc_html__( 'Slider',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $repeater = new Repeater();

        $repeater->add_control(
            'hero_image',
            [
                'label' => esc_html__( 'Hero Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $repeater->add_control(
            'hero_title_one',
            [
                'label' => esc_html__( 'Title One', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_title_two',
            [
                'label' => esc_html__( 'Title Two', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_title_three',
            [
                'label' => esc_html__( 'Title Three', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_button_text',
            [
                'label' => esc_html__( 'Button Text', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Button Text', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_button_link',
            [
                'label' => esc_html__( 'Button link', 'delishs-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'delishs-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'hero_button_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_button_page_link',
            [
                'label' => esc_html__( 'Select Button Page', 'delishs-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => delishs_get_all_pages(),
                'condition' => [
                    'hero_button_link_type' => '2',
                ]
            ]
        );
        
        $repeater->add_control(
            'hero_secondary_button_text',
            [
                'label' => esc_html__( 'Button Text', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Button Text', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_secondary_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_secondary_button_link',
            [
                'label' => esc_html__( 'Button link', 'delishs-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'delishs-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'hero_secondary_button_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'hero_secondary_button_page_link',
            [
                'label' => esc_html__( 'Select Button Page', 'delishs-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => delishs_get_all_pages(),
                'condition' => [
                    'hero_secondary_button_link_type' => '2',
                ]
            ]
        );
        
        $this->add_control(
            'hero_slider_list',
            [
                'label' => esc_html__( 'Slider List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'hero_title_one' => __( 'The Great', 'delishs-core' ),
                        'hero_title_two' => __( 'Flavored Food', 'delishs-core' ),
                        'hero_title_three' => __( 'Part Of Us', 'delishs-core' ),
                    ],
                    [
                        'hero_title_one' => __( 'The Great', 'delishs-core' ),
                        'hero_title_two' => __( 'Flavored Food', 'delishs-core' ),
                        'hero_title_three' => __( 'Part Of Us', 'delishs-core' ),
                    ],
                    [
                        'hero_title_one' => __( 'The Great', 'delishs-core' ),
                        'hero_title_two' => __( 'Flavored Food', 'delishs-core' ),
                        'hero_title_three' => __( 'Part Of Us', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ hero_title_one }}}',
            ]
        );
        
        $repeater = new Repeater();

        $repeater->add_control(
            'hero_small_image',
            [
                'label' => esc_html__( 'Navigation Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $this->add_control(
            'hero_slider_list_two',
            [
                'label' => esc_html__( 'Thumbnail List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'hero_small_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'hero_small_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'hero_small_image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                ],
            ]
        );
        
        $this->end_controls_section();

		$this->start_controls_section(
            '_style_design_layout',
            [
                'label' => esc_html__( 'Design Layout', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-section' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .hero-section-2' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .hero-section-3' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .hero-section-4' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'design_layout_image_background',
            [
                'label' => esc_html__( 'Image Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-section-3 .hero-round-img:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_subheading',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
            ]
        );

        $this->add_responsive_control(
            'subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'subheading_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'subheading_background_before',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading:before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading',
                
            ]
        );

        $this->add_responsive_control(
            'subheading_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'subheading_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        // Title
        $this->add_control(
            '_heading_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => __( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-heading' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_highlight_background_one',
            [
                'label' => __( 'Highlight One', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-content .section-title span:after' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $this->add_control(
            'title_highlight_background_two',
            [
                'label' => __( 'Highlight Two', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hero-content .section-title span:before' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-1' ],
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-heading',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
			'delishs_button_style',
			[
				'label' => __( 'Button', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs( 'tabs_button_style' );

        $this->start_controls_tab(
            'button_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .delishs-el-button:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'delishs-core' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-button' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'delishs-core' ),
                'name'     => 'button_typography',
                'selector' => '{{WRAPPER}} .delishs-el-button',
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'delishs-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'delishs-core' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .delishs-el-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    
        $this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<?php if ( $settings['design_style']  == 'layout-1' ) : ?>

            <section class="banner overflow-hidden">
                <div class="swiper banner__slider">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['hero_slider_list'] as $key => $item) : 

                            if ( !empty($item['hero_image']['url']) ) {
                                $hero_image = !empty($item['hero_image']['id']) ? wp_get_attachment_image_url( $item['hero_image']['id'], 'full') : $item['hero_image']['url'];
                                $hero_image_alt = get_post_meta($item["hero_image"]["id"], "_wp_attachment_image_alt", true);
                            }
                                        
                            if ('2' == $item['hero_button_link_type']) {
                                $link = get_permalink($item['hero_button_page_link']);
                                $target = '_self';
                                $rel = 'nofollow';
                            } else {
                                $link = !empty($item['hero_button_link']['url']) ? $item['hero_button_link']['url'] : '';
                                $target = !empty($item['hero_button_link']['is_external']) ? '_blank' : '';
                                $rel = !empty($item['hero_button_link']['nofollow']) ? 'nofollow' : '';
                            }
                                        
                            if ('2' == $item['hero_secondary_button_link_type']) {
                                $link_secondary = get_permalink($item['hero_secondary_button_page_link']);
                                $target_secondary = '_self';
                                $rel_secondary = 'nofollow';
                            } else {
                                $link_secondary = !empty($item['hero_secondary_button_link']['url']) ? $item['hero_secondary_button_link']['url'] : '';
                                $target_secondary = !empty($item['hero_secondary_button_link']['is_external']) ? '_blank' : '';
                                $rel_secondary = !empty($item['hero_secondary_button_link']['nofollow']) ? 'nofollow' : '';
                            }

                        ?>
                        <div class="swiper-slide">
                            <div class="banner__item banner__item-overlay">
                                <div class="banner__item-bg" data-background="<?php print esc_url($hero_image); ?>"></div>
                                <div class="container">
                                    <div class="row g-24">
                                        <div class="col-12">
                                            <div class="banner__item-content text-center">
                                                <h1 class="banner__item-title mb-45">
                                                    <?php if ( !empty( $item['hero_title_one'] ) ) : ?>
                                                        <span><?php print rrdevs_kses($item['hero_title_one']); ?></span>
                                                    <?php endif; ?>
                                                    <?php print rrdevs_kses($item['hero_title_two']); ?>
                                                    <?php if ( !empty( $item['hero_title_three'] ) ) : ?>
                                                        <span class="bar">
                                                            <span><?php print rrdevs_kses($item['hero_title_three']); ?></span>
                                                        </span>
                                                    <?php endif; ?>
                                                </h1>

                                                <div class="banner__item-content-link">
                                                    <?php if ( !empty( $item['hero_button_text'] ) ) : ?>
                                                        <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                                            <?php print rrdevs_kses($item['hero_button_text']); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                    
                                                    <?php if ( !empty( $item['hero_secondary_button_text'] ) ) : ?>
                                                        <a target="<?php echo esc_attr($target_secondary); ?>" rel="<?php echo esc_attr($rel_secondary); ?>" href="<?php echo esc_url($link_secondary); ?>">
                                                            <?php print rrdevs_kses($item['hero_secondary_button_text']); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="swiper banner__thumbnail">
                        <div class="swiper-wrapper">
                            <?php foreach ($settings['hero_slider_list_two'] as $key => $item) : 

                                if ( !empty($item['hero_small_image']['url']) ) {
                                    $hero_small_image = !empty($item['hero_small_image']['id']) ? wp_get_attachment_image_url( $item['hero_small_image']['id'], 'full') : $item['hero_small_image']['url'];
                                    $hero_small_image_alt = get_post_meta($item["hero_small_image"]["id"], "_wp_attachment_image_alt", true);
                                }

                            ?>
                            <div class="swiper-slide">
                                <div class="banner__thumbnail-item">
                                    <img src="<?php print esc_url($hero_small_image); ?>" alt="<?php print esc_attr($hero_small_image_alt); ?>">
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </section>
        
        <?php elseif ( $settings['design_style']  == 'layout-2' ): ?>

        <?php endif; ?>

		<?php
	}
}

$widgets_manager->register( new Delishs_Hero_Slider() );