<?php
namespace DelishsCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Counter extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'delishs_counter';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Counter', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'delishs_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_fun_fact',
            [
                'label' => esc_html__('Fun Fact', 'delishs-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__( 'Select Layout', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__( 'Layout 1', 'delishs-core' ),
                    'layout-2' => esc_html__( 'Layout 2', 'delishs-core' ),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'section_background_image',
            [
                'label' => esc_html__( 'Choose Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'fun_fact_number',
            [
                'label' => esc_html__( 'Number', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'fun_fact_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        
        $this->add_control(
            'counter_list',
            [
                'label' => esc_html__( ' List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'fun_fact_number' => __( '15', 'delishs-core' ),
                        'fun_fact_title' => __( 'New <br> Cool Projects', 'delishs-core' ),
                    ],
                    [
                        'fun_fact_number' => __( '15', 'delishs-core' ),
                        'fun_fact_title' => __( 'Total <br> Awards Win', 'delishs-core' ),
                    ],
                    [
                        'fun_fact_number' => __( '20', 'delishs-core' ),
                        'fun_fact_title' => __( 'Unique <br> Food Specialities', 'delishs-core' ),
                    ],
                    [
                        'fun_fact_number' => __( '69', 'delishs-core' ),
                        'fun_fact_title' => __( 'Hard <br> Team Members', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ fun_fact_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => esc_html__( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience__background:after' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .experience-2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'design_layout_border',
                'selector' => '{{WRAPPER}} .experience__bottom-up .experience__item-wrapper',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_bottom_spacing',
            [
                'label' => esc_html__( 'Inner Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .experience__bottom-up .experience__item-wrapper' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_fun_fact',
            [
                'label' => esc_html__( 'Fun Fact', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '_heading_fun_fact_number',
            [
                'label' => esc_html__( 'Number', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'fun_fact_number_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience__item p span.odometer' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .experience-2__item p span.odometer' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'fun_fact_number_typography',
                'selector' => '{{WRAPPER}} .experience__item p span.odometer, .experience-2__item p span.odometer',
            ]
        );

        $this->add_control(
            '_heading_fun_fact_text',
            [
                'label' => esc_html__( 'Text', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'fun_fact_text_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .experience__item p' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .experience-2__item p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'fun_fact_text_typography',
                'selector' => '{{WRAPPER}} .experience__item p, .experience-2__item p',
            ]
        );

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        
        if ( !empty($settings['section_background_image']['url']) ) {
            $section_background_image = !empty($settings['section_background_image']['id']) ? wp_get_attachment_image_url( $settings['section_background_image']['id'], 'full') : $settings['section_background_image']['url'];
            $section_background_image_alt = get_post_meta($settings["section_background_image"]["id"], "_wp_attachment_image_alt", true);
        }

		?>

        <?php if ( $settings['design_style']  == 'layout-1' ): ?>
        
            <div class="delishs-el-section experience experience__background experience__space experience__bottom-up overflow-hidden" data-background="<?php print esc_url($section_background_image); ?>">
                <div class="container">
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="experience__item-wrapper">
                                <?php foreach( $settings['counter_list'] as $key => $item): ?>
                                    <div class="experience__item">
                                        <p>
                                            <span class="odometer" data-count="<?php print esc_attr($item['fun_fact_number']); ?>"><?php print esc_html( '0', 'delishs-core' ); ?></span>
                                            <span><?php print rrdevs_kses($item['fun_fact_title']); ?></span>
                                        </p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        <?php elseif ( $settings['design_style']  == 'layout-2' ): ?>
        
            <div class="delishs-el-section experience-2 experience-2__space theme-bg-primary">
                <div class="container">
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="experience-2__item-wrapper">
                                <?php foreach( $settings['counter_list'] as $key => $item): ?>
                                    <div class="experience-2__item">
                                        <p>
                                            <span class="odometer" data-count="<?php print esc_attr($item['fun_fact_number']); ?>">
                                                <?php print esc_html( '0', 'delishs-core' ); ?>
                                            </span>
                                            <span><?php print rrdevs_kses($item['fun_fact_title']); ?></span>
                                        </p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        
        <?php endif; ?>

		<?php
	}
}

$widgets_manager->register( new Delishs_Counter() );