<?php
namespace DelishsCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Delish Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Contact_Form extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'delishs_contact_form';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Contact Form', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'delishs_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}


    public function get_delishs_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $delishs_cfa         = array();
        $delishs_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $delishs_forms       = get_posts( $delishs_cf_args );
        $delishs_cfa         = ['0' => esc_html__( 'Select Form', 'delishs-core' ) ];
        if( $delishs_forms ){
            foreach ( $delishs_forms as $delishs_form ){
                $delishs_cfa[$delishs_form->ID] = $delishs_form->post_title;
            }
        }else{
            $delishs_cfa[ esc_html__( 'No contact form found', 'delishs-core' ) ] = 0;
        }
        return $delishs_cfa;
    }


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        // layout Panel
        $this->start_controls_section(
            '_content_design_style',
            [
                'label' => esc_html__('Design Layout', 'delishs-core'),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'delishs-core'),
                    'layout-2' => esc_html__('Layout 2', 'delishs-core'),
                    'layout-3' => esc_html__('Layout 3', 'delishs-core'),
                    'layout-4' => esc_html__('Layout 4', 'delishs-core'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->add_control(
            'shape_switch',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'delishs-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'delishs-core' ),
                'label_off' => esc_html__( 'Hide', 'delishs-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

		$this->add_control(
            'form_image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Background Image One', 'delishs-core' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Book A Table', 'delishs-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Make Reservation', 'delishs-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            'section_description',
            [
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Book A Open Table For Your Happy Time Spent', 'delishs-core' ),
                'label_block' => true,
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            'section_title_shape',
            [
                'label' => esc_html__( 'Shape ON/OFF', 'delishs-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'delishs-core' ),
                'label_off' => esc_html__( 'Hide', 'delishs-core' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'delishs_contact',
            [
                'label' => esc_html__('Contact Form', 'delishs-core'),
            ]
        );

        $this->add_control(
            'delishs_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'delishs-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_delishs_contact_form(),
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'_style_design_layout',
			[
				'label' => __( 'Design Layout', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => __( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => __( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => __( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_design_layout_inner',
            [
                'label' => esc_html__( 'Inner Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_inner_margin',
            [
                'label' => __( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .book-a-table__content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .contact-us-message-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_inner_padding',
            [
                'label' => __( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .book-a-table__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .contact-us-message-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            'design_layout_inner_background',
            [
                'label' => __( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .book-a-table__content' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message-wrapper' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => [ 'layout-1', 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            '_heading_style_section_title',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Title', 'delishs-core' ),
            ]
        );

        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_control(
            'section_title_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-title',
            ]
        );

        $this->add_control(
            '_heading_style_section_subheading',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
                'separator' => 'before',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'section_subheading_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'section_subheading_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_subheading_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_section_description',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Description', 'delishs-core' ),
                'separator' => 'before',
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );
        
        $this->add_responsive_control(
            'section_description_spacing',
            [
                'label' => __( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-description' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );
        
        $this->add_control(
            'section_description_color',
            [
                'label' => __( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-description' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_description_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-description',
                'condition' => [
                    'design_style' => [ 'layout-2', 'layout-4' ],
                ],
            ]
        );

        $this->add_control(
            '_heading_style_section_layout',
            [
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_layout_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-shape' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'delishs_contact_style',
			[
				'label' => __( 'Contact Form', 'delishs-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'input_bottom_spacing',
            [
                'label'     => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .contact-us-message__form-input-select' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		// Input
        $this->add_control(
            '_content_input',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Input', 'delishs-core' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'input_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'delishs-core' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .contact-us-message__form-input textarea' => 'border-radius: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .contact-us-message__form-input-select select' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( '_form_input_tabs' );
        
        $this->start_controls_tab(
            'form_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'input_color',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input input::placeholder' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea::placeholder' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'input_background',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'input_border_color',
            [
                'label'     => esc_html__( 'Border', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'form_focus_tab',
            [
                'label' => esc_html__( 'Focus', 'delishs-core' ),
            ]
        );

        $this->add_control(
            'input_color_focus',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input:focus' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea:focus' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'input_background_focus',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input:focus' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea:focus' => 'background-color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
            'input_border_color_focus',
            [
                'label'     => esc_html__( 'Border', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form-input input:focus' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .contact-us-message__form-input textarea:focus' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

		// Button
        $this->add_control(
            '_content_button',
            [
                'type' => Controls_Manager::HEADING,
                'label' => __( 'Button', 'delishs-core' ),
                'separator' => 'before'
            ]
        );

        $this->start_controls_tabs( '_tabs_button' );
        
        $this->start_controls_tab(
            'button_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form .rr-btn-solid .btn-wrap .text-one' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form .rr-btn-solid' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'delishs-core' ),
            ]
        );

		$this->add_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form .rr-btn-solid .btn-wrap .text-two' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background_hover',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form .rr-btn-solid:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'button_border_radius',
            [
                'label'     => esc_html__( 'Border Radius', 'delishs-core' ),
                'type'      => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .contact-us-message__form .rr-btn-solid' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( !empty($settings['form_image']['url']) ) {
            $form_image = !empty($settings['form_image']['id']) ? wp_get_attachment_image_url( $settings['form_image']['id'], 'full') : $settings['form_image']['url'];
            $form_image_alt = get_post_meta($settings["form_image"]["id"], "_wp_attachment_image_alt", true);
        }

		?>

		<?php if ( $settings['design_style']  == 'layout-1' ): ?>

            <section class="delishs-el-section book-a-table section-space__top overflow-hidden">
                <div class="container">
                    <?php if ( !empty( $settings['shape_switch'] ) ) : ?>
                        <div class="book-a-table__bg upDown" data-background="<?php print get_template_directory_uri(); ?>/assets/imgs/book-a-table/bg.png"></div>
                    <?php endif; ?>
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="book-a-table__content section-bg-2 d-flex flex-column flex-xl-row justify-content-between align-items-center" data-background="<?php print get_template_directory_uri(); ?>/assets/imgs/book-a-table/book-a-table__bg.png">
                                <div class="book-a-table__content-left">
                                    <div class="section__title-wrapper text-center">
                                        <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                            <span class="delishs-el-section-subheading section__subtitle justify-content-center mb-10 mb-xs-5 wow clip-a-z">
                                                <?php print rrdevs_kses($settings['section_subheading']); ?>
                                            </span>
                                        <?php endif; ?>
                                        <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                            <h2 class="delishs-el-section-title section__title mb-10 mb-xs-5 title-animation">
                                                <?php print rrdevs_kses($settings['section_title']); ?>
                                            </h2>
                                        <?php endif; ?>
                                        <?php if ( !empty( $settings['section_title_shape'] ) ) : ?>
                                            <div class="delishs-el-section-shape dot-shpae wow clip-a-z">
                                                <img class="img-fluid" src="<?php print get_template_directory_uri(); ?>/assets/imgs/section-title/dot-shape.svg" alt="not found">
                                            </div>
                                        <?php endif; ?>

                                        <?php if( !empty($settings['delishs_select_contact_form']) ) : ?> 
                                            <?php echo do_shortcode( '[contact-form-7  id="'.$settings['delishs_select_contact_form'].'"]' ); ?> 
                                        
                                        <?php else : ?>
                                            <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'delishs-core' ). '</p></div>'; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="book-a-table__content-right">
                                    <div class="book-a-table__content-media wow clip-a-z">
                                        <img class="img-fluid" src="<?php print esc_url($form_image); ?>" alt="<?php print esc_attr($form_image_alt); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

		<?php elseif ( $settings['design_style']  == 'layout-2' ): ?>

            <section class="delishs-el-section book-a-table-2 section-space theme-bg-secondary">
                <div class="container">
                    <div class="row g-24 align-items-center">
                        <div class="col-lg-4">
                            <div class="book-a-table-2__content">
                                <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                    <h4 class="delishs-el-section-title book-a-table-2__content-title color-white text-uppercase">
                                        <?php print rrdevs_kses($settings['section_title']); ?>
                                    </h4>
                                <?php endif; ?>
                                <?php if ( !empty( $settings['section_description'] ) ) : ?>
                                    <p class="delishs-el-section-description mb-0 color-white">
                                        <?php print rrdevs_kses($settings['section_description']); ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <?php if( !empty($settings['delishs_select_contact_form']) ) : ?> 
                                <?php echo do_shortcode( '[contact-form-7  id="'.$settings['delishs_select_contact_form'].'"]' ); ?>
                            <?php else : ?>
                                <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'delishs-core' ). '</p></div>'; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-3' ) : ?>

            <div class="delishs-el-section book-a-table-3 section-space theme-bg-secondary" data-background="<?php print get_template_directory_uri(); ?>/assets/imgs/book-a-table-3/shape.png">
                <div class="container">
                    <div class="row g-24">
                        <?php if( !empty($settings['delishs_select_contact_form']) ) : ?> 
                            <?php echo do_shortcode( '[contact-form-7  id="'.$settings['delishs_select_contact_form'].'"]' ); ?> 
                        <?php else : ?>
                            <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'delishs-core' ). '</p></div>'; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

        <?php elseif ( $settings['design_style']  == 'layout-4' ) : ?>

            <section class="delishs-el-section contact-us-message section-space">
                <div class="container">
                    <div class="contact-us-message-wrapper section-bg-2 wow clip-a-z">
                        <div class="row g-24">
                            <div class="col-12">
                                <div class="section__title-wrapper text-center mb-35">
                                    <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                        <h3 class="delishs-el-section-title text-uppercase fw-bold mb-1">
                                            <?php print rrdevs_kses($settings['section_title']); ?>
                                        </h3>
                                    <?php endif; ?>
                                    <?php if ( !empty( $settings['section_description'] ) ) : ?>
                                        <p class="delishs-el-section-description">
                                            <?php print rrdevs_kses($settings['section_description']); ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="row g-24 justify-content-center">
                            <div class="col-12">
                                <?php if( !empty($settings['delishs_select_contact_form']) ) : ?> 
                                    <?php echo do_shortcode( '[contact-form-7  id="'.$settings['delishs_select_contact_form'].'"]' ); ?>
                                <?php else : ?>
                                    <?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'delishs-core' ). '</p></div>'; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php endif; ?>

        <?php 
	}
}

$widgets_manager->register( new Delishs_Contact_Form() );