<?php
namespace DelishsCore\Widgets;

use \Elementor\Widget_Base;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Css_Filter;
use \Elementor\Repeater;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Box_Shadow;
use OptiBoomCore\Elementor\Controls\Group_Control_OptiBoomBGGradient;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * OptiBoom Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Delishs_Advanced_Food_Menu extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'delishs_advanced_food_menu';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Advanced Food Menu', 'delishs-core' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'delishs-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'delishs_core' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'delishs-core' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        $this->start_controls_section(
            '_content_design_layout',
            [
                'label' => esc_html__( 'Design Layout',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => esc_html__('Select Layout', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'delishs-core'),
                    'layout-2' => esc_html__('Layout 2', 'delishs-core'),
                ],
                'default' => 'layout-1',
            ]
        );
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            '_content_title',
            [
                'label' => esc_html__( 'Title & Content',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->add_control(
            'section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Food Menu', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'section_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Our Delicious Foods', 'delishs-core' ),
                'label_block' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_food_menu',
            [
                'label' => esc_html__( 'Food Menu',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->add_control(
            'section_image',
            [
                'label' => esc_html__( 'Choose Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $repeater = new Repeater();
        
        $repeater->add_control(
            'food_menu_name',
            [
                'label' => esc_html__( 'Food Name', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'food_menu_description',
            [
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'currency',
            [
                'label' => __('Currency', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options' => [
                    '' => __('None', 'delishs-core'),
                    'baht' => '&#3647; ' . _x('Baht', 'Currency Symbol', 'delishs-core'),
                    'bdt' => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'delishs-core'),
                    'dollar' => '&#36; ' . _x('Dollar', 'Currency Symbol', 'delishs-core'),
                    'euro' => '&#128; ' . _x('Euro', 'Currency Symbol', 'delishs-core'),
                    'franc' => '&#8355; ' . _x('Franc', 'Currency Symbol', 'delishs-core'),
                    'guilder' => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'delishs-core'),
                    'krona' => 'kr ' . _x('Krona', 'Currency Symbol', 'delishs-core'),
                    'lira' => '&#8356; ' . _x('Lira', 'Currency Symbol', 'delishs-core'),
                    'peseta' => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'delishs-core'),
                    'peso' => '&#8369; ' . _x('Peso', 'Currency Symbol', 'delishs-core'),
                    'pound' => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'delishs-core'),
                    'real' => 'R$ ' . _x('Real', 'Currency Symbol', 'delishs-core'),
                    'ruble' => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'delishs-core'),
                    'rupee' => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'delishs-core'),
                    'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'delishs-core'),
                    'shekel' => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'delishs-core'),
                    'won' => '&#8361; ' . _x('Won', 'Currency Symbol', 'delishs-core'),
                    'yen' => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'delishs-core'),
                    'custom' => __('Custom', 'delishs-core'),
                ],
                'default' => 'dollar',
            ]
        );

        $repeater->add_control(
            'currency_custom',
            [
                'label' => __('Custom Symbol', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'currency' => 'custom',
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'food_menu_price',
            [
                'label' => esc_html__( 'Price', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        
        $repeater->add_control(
            'food_menu_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'food_menu_button_link',
            [
                'label' => esc_html__( 'Button link', 'delishs-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'delishs-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'food_menu_button_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'food_menu_button_page_link',
            [
                'label' => esc_html__( 'Select Button Page', 'delishs-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => delishs_get_all_pages(),
                'condition' => [
                    'food_menu_button_link_type' => '2',
                ]
            ]
        );
        
        $this->add_control(
            'food_menu_list',
            [
                'label' => esc_html__( 'Food List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'food_menu_name' => __( 'Mushroom Arancini', 'delishs-core' ),
                        'food_menu_description' => __( 'Ricotta, goat cheese, beetroot and dateline.', 'delishs-core' ),
                        'food_menu_price' => __( '16.00', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Butternut Squash Soup', 'delishs-core' ),
                        'food_menu_description' => __( 'Ricotta, goat cheese, beetroot and dateline.', 'delishs-core' ),
                        'food_menu_price' => __( '25.00', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Braised Short Ribs', 'delishs-core' ),
                        'food_menu_description' => __( 'Ricotta, goat cheese, beetroot and dateline.', 'delishs-core' ),
                        'food_menu_price' => __( '11.00', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Braised Long Ribs', 'delishs-core' ),
                        'food_menu_description' => __( 'Ricotta, goat cheese, beetroot and dateline.', 'delishs-core' ),
                        'food_menu_price' => __( '14.00', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Mushroom Arancini', 'delishs-core' ),
                        'food_menu_description' => __( 'Ricotta, goat cheese, beetroot and dateline.', 'delishs-core' ),
                        'food_menu_price' => __( '19.00', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ food_menu_name }}}',
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_content_food_two',
            [
                'label' => esc_html__( 'Food Menu',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );
        
        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Title', 'seoq-core'),
                'default' => __('Tab Title', 'seoq-core'),
                'placeholder' => __('Type Tab Title', 'seoq-core'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'active_tab',
            [
                'label' => __('Is Active Tab?', 'seoq-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'seoq-core'),
                'label_off' => __('No', 'seoq-core'),
                'return_value' => 'yes',
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $repeater->add_control(
            'template',
            [
                'label' => __('Section Template', 'seoq-core'),
                'placeholder' => __('Select a section template for as tab content', 'seoq-core'),
  
                'type' => Controls_Manager::SELECT2,
                'options' => get_elementor_templates()
            ]
        );

        $this->add_control(
            'tabs',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{title}}',
                'default' => [
                    [
                        'title' => 'Tab 1',
                    ],
                    [
                        'title' => 'Tab 2',
                    ]
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'delishs_filter',
            [
                'label' => esc_html__('Food Masonry List', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'all_food',
            [
                'label' => esc_html__('Title', 'delishs-core'),
                'description' => delishs_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('all food', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'delishs_filter_tags', [
                'label' => esc_html__('Tag Name', 'delishs-core'),
                'description' => esc_html__('Please added only one tag using small letter.', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('exterior', 'delishs-core'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'delishs_filter_list',
            [
                'label' => esc_html__('Tag - List', 'delishs-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'delishs_filter_tags' => esc_html__('breakfast', 'delishs-core'),
                    ],
                    [
                        'delishs_filter_tags' => esc_html__('lunch', 'delishs-core'),
                    ],
                    [
                        'delishs_filter_tags' => esc_html__('dinner', 'delishs-core'),
                    ],
                ],
                'title_field' => '{{{ delishs_filter_tags }}}',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'delishs_info_tags',
            [
                'label' => esc_html__('Tags', 'optiboom-core'),
                'description' => esc_html__('Please write tags using small letter. For Multiple tags use space. Example: exterior view', 'optiboom-core'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'food_menu_image',
            [
                'label' => esc_html__( 'Choose Image', 'delishs-core' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        
        $repeater->add_control(
            'food_menu_name',
            [
                'label' => esc_html__( 'Food Name', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'currency',
            [
                'label' => __('Currency', 'delishs-core'),
                'type' => Controls_Manager::SELECT,
                'label_block' => false,
                'options' => [
                    '' => __('None', 'delishs-core'),
                    'baht' => '&#3647; ' . _x('Baht', 'Currency Symbol', 'delishs-core'),
                    'bdt' => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'delishs-core'),
                    'dollar' => '&#36; ' . _x('Dollar', 'Currency Symbol', 'delishs-core'),
                    'euro' => '&#128; ' . _x('Euro', 'Currency Symbol', 'delishs-core'),
                    'franc' => '&#8355; ' . _x('Franc', 'Currency Symbol', 'delishs-core'),
                    'guilder' => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'delishs-core'),
                    'krona' => 'kr ' . _x('Krona', 'Currency Symbol', 'delishs-core'),
                    'lira' => '&#8356; ' . _x('Lira', 'Currency Symbol', 'delishs-core'),
                    'peseta' => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'delishs-core'),
                    'peso' => '&#8369; ' . _x('Peso', 'Currency Symbol', 'delishs-core'),
                    'pound' => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'delishs-core'),
                    'real' => 'R$ ' . _x('Real', 'Currency Symbol', 'delishs-core'),
                    'ruble' => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'delishs-core'),
                    'rupee' => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'delishs-core'),
                    'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'delishs-core'),
                    'shekel' => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'delishs-core'),
                    'won' => '&#8361; ' . _x('Won', 'Currency Symbol', 'delishs-core'),
                    'yen' => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'delishs-core'),
                    'custom' => __('Custom', 'delishs-core'),
                ],
                'default' => 'dollar',
            ]
        );

        $repeater->add_control(
            'currency_custom',
            [
                'label' => __('Custom Symbol', 'delishs-core'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'currency' => 'custom',
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'food_menu_price',
            [
                'label' => esc_html__( 'Price', 'delishs-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'food_rating',
            [
                'label' => esc_html__( 'Rating', 'delishs-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => .5,
                'default' => 5,
            ]
        );
        
        $repeater->add_control(
            'food_menu_button_link_type',
            [
                'label' => esc_html__( 'Button Link Type', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => 'Custom Link',
                    '2' => 'Internal Page',
                ],
                'default' => '1',
                'label_block' => true,
            ]
        );
        
        $repeater->add_control(
            'food_menu_button_link',
            [
                'label' => esc_html__( 'Button link', 'delishs-core' ),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => esc_html__('https://your-link.com', 'delishs-core'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'condition' => [
                    'food_menu_button_link_type' => '1',
                ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'food_menu_button_page_link',
            [
                'label' => esc_html__( 'Select Button Page', 'delishs-core' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'options' => delishs_get_all_pages(),
                'condition' => [
                    'food_menu_button_link_type' => '2',
                ]
            ]
        );

        $this->add_control(
            'food_menu_list_two',
            [
                'label' => esc_html__( 'Food List', 'delishs-core' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'food_menu_name' => __( 'Mushroom Arancini', 'delishs-core' ),
                        'food_menu_price' => __( '16.00', 'delishs-core' ),
                        'delishs_info_tags' => __( 'breakfast', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Butternut Squash Soup', 'delishs-core' ),
                        'food_menu_price' => __( '25.00', 'delishs-core' ),
                        'delishs_info_tags' => __( 'lunch', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Braised Short Ribs', 'delishs-core' ),
                        'food_menu_price' => __( '11.00', 'delishs-core' ),
                        'delishs_info_tags' => __( 'dinner', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Braised Long Ribs', 'delishs-core' ),
                        'food_menu_price' => __( '14.00', 'delishs-core' ),
                        'delishs_info_tags' => __( 'breakfast', 'delishs-core' ),
                    ],
                    [
                        'food_menu_name' => __( 'Mushroom Arancini', 'delishs-core' ),
                        'food_menu_price' => __( '19.00', 'delishs-core' ),
                        'delishs_info_tags' => __( 'lunch', 'delishs-core' ),
                    ],
                ],
                'title_field' => '{{{ food_menu_name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_content_column',
            [
                'label' => esc_html__( 'Column',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->add_control(
            'column_desktop',
            [
                'label' => esc_html__( 'Columns for Desktop', 'delishs-core' ),
                'description' => esc_html__( 'Screen width equal to or greater than 1200px', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'delishs-core' ),
                    6 => esc_html__( '2 Columns', 'delishs-core' ),
                    4 => esc_html__( '3 Columns', 'delishs-core' ),
                    3 => esc_html__( '4 Columns', 'delishs-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'delishs-core' ),
                    2 => esc_html__( '6 Columns', 'delishs-core' ),
                    1 => esc_html__( '12 Columns', 'delishs-core' ),
                ],
                'separator' => 'before',
                'default' => 4,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'column_laptop',
            [
                'label' => esc_html__( 'Columns for Large', 'delishs-core' ),
                'description' => esc_html__( 'Screen width equal to or greater than 992px', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'delishs-core' ),
                    6 => esc_html__( '2 Columns', 'delishs-core' ),
                    4 => esc_html__( '3 Columns', 'delishs-core' ),
                    3 => esc_html__( '4 Columns', 'delishs-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'delishs-core' ),
                    2 => esc_html__( '6 Columns', 'delishs-core' ),
                    1 => esc_html__( '12 Columns', 'delishs-core' ),
                ],
                'separator' => 'before',
                'default' => 4,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'column_tablet',
            [
                'label' => esc_html__( 'Columns for Tablet', 'delishs-core' ),
                'description' => esc_html__( 'Screen width equal to or greater than 768px', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'delishs-core' ),
                    6 => esc_html__( '2 Columns', 'delishs-core' ),
                    4 => esc_html__( '3 Columns', 'delishs-core' ),
                    3 => esc_html__( '4 Columns', 'delishs-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'delishs-core' ),
                    2 => esc_html__( '6 Columns', 'delishs-core' ),
                    1 => esc_html__( '12 Columns', 'delishs-core' ),
                ],
                'separator' => 'before',
                'default' => 6,
                'style_transfer' => true,
            ]
        );

        $this->add_control(
            'column_mobile',
            [
                'label' => esc_html__( 'Columns for Mobile', 'delishs-core' ),
                'description' => esc_html__( 'Screen width less than 767px', 'delishs-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    12 => esc_html__( '1 Columns', 'delishs-core' ),
                    6 => esc_html__( '2 Columns', 'delishs-core' ),
                    4 => esc_html__( '3 Columns', 'delishs-core' ),
                    3 => esc_html__( '4 Columns', 'delishs-core' ),
                    5 => esc_html__( '5 Columns (For Carousel Item)', 'delishs-core' ),
                    2 => esc_html__( '6 Columns', 'delishs-core' ),
                    1 => esc_html__( '12 Columns', 'delishs-core' ),
                ],
                'separator' => 'before',
                'default' => 12,
                'style_transfer' => true,
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            '_style_design_layout',
            [
                'label' => __( 'Design Layout', 'delishs-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'design_layout_margin',
            [
                'label' => __( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_padding',
            [
                'label' => __( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'design_layout_background',
            [
                'label' => __( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_design_layout_inner',
            [
                'label' => esc_html__( 'Inner', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_inner_margin',
            [
                'label' => __( 'Margin', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .food-menu__item-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'design_layout_inner_padding',
            [
                'label' => __( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .food-menu__item-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'design_layout_inner_background',
            [
                'label' => __( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__item-wrapper' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_title',
            [
                'label' => esc_html__( 'Title & Content',  'delishs-core'  ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->add_control(
            '_heading_style_section_subheading',
            [
                'label' => esc_html__( 'Subheading', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_responsive_control(
            'section_subheading_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'section_subheading_color',
            [
                'label' => __( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'section_subheading_background',
            [
                'label' => __( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subheading_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-subheading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_subheading_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-subheading',
            ]
        );

        $this->add_control(
            '_heading_style_section_title',
            [
                'label' => esc_html__( 'Title', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_responsive_control(
            'section_title_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'section_title_color',
            [
                'label' => __( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'section_title_typography',
                'selector' => '{{WRAPPER}} .delishs-el-section-title',
            ]
        );

        $this->add_control(
            '_heading_style_section_title_layout',
            [
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'section_title_layout_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .delishs-el-section-title-layout' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
    
        $this->start_controls_section(
            '_style_masonry_filter',
            [
                'label' => __( 'Filter Menu', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'filter_border_color',
            [
                'label' => esc_html__( 'Border Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu-tab__nav-tabs' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-2',
                ],
            ]
        );

        $this->start_controls_tabs( '_tabs_masonry_filter' );
        
        $this->start_controls_tab(
            'masonry_filter_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'masonry_filter_color',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__tab button' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu-tab__nav-tabs .nav-link' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_background',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__tab button' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_border',
            [
                'label'     => esc_html__( 'Border', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__tab button' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'masonry_filter_active_tab',
            [
                'label' => esc_html__( 'Active', 'delishs-core' ),
            ]
        );
        
        $this->add_control(
            'masonry_filter_color_active',
            [
                'label'     => esc_html__( 'Color', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__tab button.active' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu-tab__nav-tabs .nav-link.active' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_background_active',
            [
                'label'     => esc_html__( 'Background', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__tab button.active' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'masonry_filter_border_active',
            [
                'label'     => esc_html__( 'Border', 'delishs-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__tab button.active' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu-tab__nav-tabs .nav-link.active:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            '_style_food_menu',
            [
                'label' => esc_html__( 'Food Menu', 'delishs-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_food_name',
            [
                'label' => esc_html__( 'Name', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_responsive_control(
            'food_name_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li .text h6' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .food-menu__item-text h6' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'food_name_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li .text h6' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu__item-text h6' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'food_name_color_hover',
            [
                'label' => esc_html__( 'Color (Hover)', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li .text h6 a:hover' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu__item-text h6 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'food_name_typography',
                'selector' => '{{WRAPPER}} .food-menu__price-nav__list li .text h6, .food-menu__item-text h6',
            ]
        );

        $this->add_control(
            '_heading_style_food_price',
            [
                'label' => esc_html__( 'Price', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'food_price_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li .price' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu__item-text .price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'food_price_typography',
                'selector' => '{{WRAPPER}} .food-menu__price-nav__list li .price, .food-menu__item-text .price',
            ]
        );

        $this->add_control(
            '_heading_style_food_description',
            [
                'label' => esc_html__( 'Description', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'food_description_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li .text p' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'food_description_color',
            [
                'label' => esc_html__( 'Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li .text p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'food_description_typography',
                'selector' => '{{WRAPPER}} .food-menu__price-nav__list li .text p',
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            '_heading_style_food_layout',
            [
                'label' => esc_html__( 'Layout', 'delishs-core' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'food_layout_padding',
            [
                'label' => esc_html__( 'Padding', 'delishs-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .food-menu__item-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'food_layout_bottom_spacing',
            [
                'label' => esc_html__( 'Bottom Spacing', 'delishs-core' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'design_style' => 'layout-1',
                ],
            ]
        );

        $this->add_control(
            'food_layout_border_color',
            [
                'label' => esc_html__( 'Border Color', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list li:not(:last-child)' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu__item-text' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu__item' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'food_layout_background',
            [
                'label' => esc_html__( 'Background', 'delishs-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .food-menu__price-nav__list' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .food-menu__item-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

	}

    private static function get_currency_symbol($symbol_name)
    {
        $symbols = [
            'baht' => '&#3647;',
            'bdt' => '&#2547;',
            'dollar' => '&#36;',
            'euro' => '&#128;',
            'franc' => '&#8355;',
            'guilder' => '&fnof;',
            'indian_rupee' => '&#8377;',
            'pound' => '&#163;',
            'peso' => '&#8369;',
            'peseta' => '&#8359',
            'lira' => '&#8356;',
            'ruble' => '&#8381;',
            'shekel' => '&#8362;',
            'rupee' => '&#8360;',
            'real' => 'R$',
            'krona' => 'kr',
            'won' => '&#8361;',
            'yen' => '&#165;',
        ];

        return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
    }

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

        if ( !empty($settings['section_image']['url']) ) {
            $section_image = !empty($settings['section_image']['id']) ? wp_get_attachment_image_url( $settings['section_image']['id'], 'full') : $settings['section_image']['url'];
            $section_image_alt = get_post_meta($settings["section_image"]["id"], "_wp_attachment_image_alt", true);
        }

		?>

        <?php if ( $settings['design_style']  == 'layout-1' ): ?>

            <section class="delishs-el-section food-menu section-space">
                <div class="container">
                    <div class="delishs-el-section-title-layout row g-24 mb-55 mb-sm-50 mb-xs-40 align-items-lg-end align-items-center">
                        <div class="col-xl-6">
                            <div class="section__title-wrapper text-center text-xl-start">
                                <?php if ( !empty( $settings['section_subheading'] ) ) : ?>
                                    <span class="delishs-el-section-subheading section__subtitle justify-content-start mb-10 mb-xs-5 wow clip-a-z">
                                        <?php print rrdevs_kses($settings['section_subheading']); ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( !empty( $settings['section_title'] ) ) : ?>
                                    <h2 class="delishs-el-section-title section__title mb-0 title-animation">
                                        <?php print rrdevs_kses($settings['section_title']); ?>
                                    </h2>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-xl-6">
                            <div class="d-flex justify-content-xl-end mt-xs-10 mt-sm-10 mt-md-10 mt-lg-10 justify-content-center">
                                <div class="food-menu__tab masonary-menu">
                                    <button data-filter="*" class="active"><?php print esc_html($settings['all_food']); ?></button>
                                    <?php foreach ($settings['delishs_filter_list'] as $key => $item) : ?>
                                        <button data-filter=".<?php print esc_attr($item['delishs_filter_tags']); ?>">
                                            <?php print esc_html($item['delishs_filter_tags']); ?>
                                        </button>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-24 flex-row flex-xl-row-reverse">
                        <div class="col-xl-8">
                            <div class="food-menu__item-wrapper">
                                <div class="row g-10 grid">
                                    <?php foreach ($settings['food_menu_list_two'] as $key => $item) : 
                        
                                        if ( !empty($item['food_menu_image']['url']) ) {
                                            $food_menu_image = !empty($item['food_menu_image']['id']) ? wp_get_attachment_image_url( $item['food_menu_image']['id'], 'full') : $item['food_menu_image']['url'];
                                            $food_menu_image_alt = get_post_meta($item["food_menu_image"]["id"], "_wp_attachment_image_alt", true);
                                        }

                                        if ($item['currency'] === 'custom') {
                                            $currency = $item['currency_custom'];
                                        } else {
                                            $currency = self::get_currency_symbol($item['currency']);
                                        }

                                        if ('2' == $item['food_menu_button_link_type']) {
                                            $link = get_permalink($item['food_menu_button_page_link']);
                                            $target = '_self';
                                            $rel = 'nofollow';
                                        } else {
                                            $link = !empty($item['food_menu_button_link']['url']) ? $item['food_menu_button_link']['url'] : '';
                                            $target = !empty($item['food_menu_button_link']['is_external']) ? '_blank' : '';
                                            $rel = !empty($item['food_menu_button_link']['nofollow']) ? 'nofollow' : '';
                                        }
                                        
                                    ?>
                                    <div class="col-xl-<?php print esc_attr($settings['column_desktop']); ?> col-lg-<?php print esc_attr($settings['column_laptop']); ?> col-md-<?php print esc_attr($settings['column_tablet']); ?> col-sm-<?php print esc_attr($settings['column_mobile']); ?> <?php print esc_attr($item['delishs_info_tags']); ?> grid-item">
                                        <div class="food-menu__item">
                                            <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>" class="food-menu__item-media">
                                                <img src="<?php print esc_url($food_menu_image); ?>" class="img-fluid" alt="<?php print esc_attr($food_menu_image_alt); ?>">
                                            </a>

                                            <div class="food-menu__item-text">
                                                <ul class="rating">
                                                    <?php 
                                                    $food_rating = $item['food_rating'];

                                                    // Calculate full stars, half stars, and empty stars
                                                    $full_stars = floor($food_rating);
                                                    $half_star = ($food_rating - $full_stars >= 0.5) ? 1 : 0;
                                                    $empty_stars = 5 - ($full_stars + $half_star);
                                                    for ($i = 1; $i <= $full_stars; $i++): ?>
                                                        <li><i class="fa-solid fa-star"></i></li>
                                                    <?php endfor; ?>

                                                    <?php if ($half_star): ?>
                                                        <li><i class="fa-solid fa-star-half-stroke"></i></li>
                                                    <?php endif; ?>

                                                    <?php for ($i = 1; $i <= $empty_stars; $i++): ?>
                                                        <li><i class="fa-regular fa-star"></i></li>
                                                    <?php endfor; ?>
                                                </ul>
                                                <h6>
                                                    <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                                        <?php print rrdevs_kses($item['food_menu_name']); ?>
                                                    </a>
                                                </h6>
                                                <span class="price">
                                                    <?php echo esc_attr($currency); ?><?php print rrdevs_kses($item['food_menu_price']); ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-4">
                            <div class="food-menu__price-nav">
                                <div class="food-menu__price-nav__media">
                                    <img src="<?php print esc_url($section_image); ?>" class="img-fluid" alt="<?php print esc_attr($section_image_alt); ?>">
                                </div>

                                <ul class="food-menu__price-nav__list">
                                    <?php foreach ($settings['food_menu_list'] as $item) :

                                        if ($item['currency'] === 'custom') {
                                            $currency = $item['currency_custom'];
                                        } else {
                                            $currency = self::get_currency_symbol($item['currency']);
                                        }

                                        if ('2' == $item['food_menu_button_link_type']) {
                                            $link = get_permalink($item['food_menu_button_page_link']);
                                            $target = '_self';
                                            $rel = 'nofollow';
                                        } else {
                                            $link = !empty($item['food_menu_button_link']['url']) ? $item['food_menu_button_link']['url'] : '';
                                            $target = !empty($item['food_menu_button_link']['is_external']) ? '_blank' : '';
                                            $rel = !empty($item['food_menu_button_link']['nofollow']) ? 'nofollow' : '';
                                        }
                                                        
                                    ?>
                                    <li>
                                        <div class="text">
                                            <h6>
                                                <a target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" href="<?php echo esc_url($link); ?>">
                                                    <?php print rrdevs_kses($item['food_menu_name']); ?>
                                                </a>
                                            </h6>
                                            <p class="mb-0"><?php print rrdevs_kses($item['food_menu_description']); ?></p>
                                        </div>
                                        <span class="price">
                                            <?php echo esc_attr($currency); ?><?php print rrdevs_kses($item['food_menu_price']); ?>
                                        </span>
                                    </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        <?php elseif ( $settings['design_style']  == 'layout-2' ): ?>

            <section class="delishs-el-section food-menu-tab overflow-hidden section-bg-3 section-space">
                <div class="container">
                    <div class="food-menu-tab__shape">
                        <img class="shape-1 rightLeft" src="<?php print get_template_directory_uri(); ?>/assets/imgs/food-menu-tab/shape-1.png" alt="not found">
                        <img class="shape-2 leftRight" src="<?php print get_template_directory_uri(); ?>/assets/imgs/food-menu-tab/shape-3.png" alt="not found">
                        <img class="shape-3 zooming1" src="<?php print get_template_directory_uri(); ?>/assets/imgs/food-menu-tab/shape-2.png" alt="not found">
                        <img class="shape-4 upDown" src="<?php print get_template_directory_uri(); ?>/assets/imgs/food-menu-tab/shape-4.png" alt="not found">
                    </div>
                    <div class="row g-24">
                        <div class="col-12">
                            <div class="food-menu-tab__nav-tabs">
                                <nav class="nav" id="nav-tab" role="tablist">
                                    <?php foreach ($settings['tabs'] as $key => $tab):
                                        $active = ($key == 0) ? 'active' : '';
                                    ?>
                                    <button class="nav-link <?php echo esc_attr($active); ?>" id="all-tab-<?php echo esc_attr($key); ?>" data-bs-toggle="tab" data-bs-target="#all-food-<?php echo esc_attr($key); ?>" type="button" role="tab" aria-controls="all-food-<?php echo esc_attr($key); ?>" aria-selected="true">
                                        <?php echo rrdevs_kses($tab['title']); ?>
                                    </button>
                                    <?php endforeach; ?>
                                </nav>
                            </div>
                        </div>
                    </div>
                    <div class="tab-content" id="nav-tabContent">
                        <?php foreach ($settings['tabs'] as $key => $tab):
                            $active = ($key == 0) ? 'show active' : '';
                        ?>
                        <div class="tab-pane fade <?php echo esc_attr($active); ?>" id="all-food-<?php echo esc_attr($key); ?>" role="tabpanel" aria-labelledby="all-tab-<?php echo esc_attr($key); ?>">
                            <?php echo \Elementor\Plugin::instance()->frontend->get_builder_content($tab['template'], true); ?>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

        <?php endif;
	}

}

$widgets_manager->register( new Delishs_Advanced_Food_Menu() );