<?php 
class DelishsServicesPost 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'template_include', array( $this, 'services_template_include' ) );
	}
	
	public function services_template_include( $template ) {
		if ( is_singular( 'delishs-services' ) ) {
			return $this->get_template( 'single-delishs-services.php');
		}
		return $template;
	}
	
	public function get_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} 
		else {
			$file = DELISHS_CORE_ADDONS_DIR . '/include/template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}
	
	
	public function register_custom_post_type() {
		$youlink_services_slug = get_theme_mod( 'youlink_services_slug', __( 'delishs-services', 'delishs-core' ) );
		$labels = array(
			'name'                  => esc_html_x( 'Services', 'Post Type General Name', 'delishs-core' ),
			'singular_name'         => esc_html_x( 'Service', 'Post Type Singular Name', 'delishs-core' ),
			'menu_name'             => esc_html__( 'Services', 'delishs-core' ),
			'name_admin_bar'        => esc_html__( 'Services', 'delishs-core' ),
			'archives'              => esc_html__( 'Item Archives', 'delishs-core' ),
			'parent_item_colon'     => esc_html__( 'Parent Item:', 'delishs-core' ),
			'all_items'             => esc_html__( 'All Items', 'delishs-core' ),
			'add_new_item'          => esc_html__( 'Add New Service', 'delishs-core' ),
			'add_new'               => esc_html__( 'Add New', 'delishs-core' ),
			'new_item'              => esc_html__( 'New Item', 'delishs-core' ),
			'edit_item'             => esc_html__( 'Edit Item', 'delishs-core' ),
			'update_item'           => esc_html__( 'Update Item', 'delishs-core' ),
			'view_item'             => esc_html__( 'View Item', 'delishs-core' ),
			'search_items'          => esc_html__( 'Search Item', 'delishs-core' ),
			'not_found'             => esc_html__( 'Not found', 'delishs-core' ),
			'not_found_in_trash'    => esc_html__( 'Not found in Trash', 'delishs-core' ),
			'featured_image'        => esc_html__( 'Featured Image', 'delishs-core' ),
			'set_featured_image'    => esc_html__( 'Set featured image', 'delishs-core' ),
			'remove_featured_image' => esc_html__( 'Remove featured image', 'delishs-core' ),
			'use_featured_image'    => esc_html__( 'Use as featured image', 'delishs-core' ),
			'inserbt_into_item'     => esc_html__( 'Insert into item', 'delishs-core' ),
			'uploaded_to_this_item' => esc_html__( 'Uploaded to this item', 'delishs-core' ),
			'items_list'            => esc_html__( 'Items list', 'delishs-core' ),
			'items_list_navigation' => esc_html__( 'Items list navigation', 'delishs-core' ),
			'filter_items_list'     => esc_html__( 'Filter items list', 'delishs-core' ),
		);

		$args   = array(
			'label'                 => esc_html__( 'Service', 'delishs-core' ),
			'labels'                => $labels,
			'supports'              => ['title', 'editor', 'thumbnail', 'elementor'],
			'hierarchical'          => false,
			'public'                => true,
			'show_ui'               => true,
			'show_in_menu'          => true,
			'menu_position'         => 5,
			'menu_icon'   			=> 'dashicons-clipboard',
			'show_in_admin_bar'     => true,
			'show_in_nav_menus'     => true,
			'can_export'            => true,
			'has_archive'           => true,		
			'exclude_from_search'   => false,
			'publicly_queryable'    => true,
			'capability_type'       => 'page',
			'rewrite' => array(
				'slug' => $youlink_services_slug,
				'with_front' => false
			),
		);

		register_post_type( 'delishs-services', $args );
	}
	
	public function create_cat() {
		$labels = array(
			'name'                       => esc_html_x( 'Service Categories', 'Taxonomy General Name', 'delishs-core' ),
			'singular_name'              => esc_html_x( 'Service Categories', 'Taxonomy Singular Name', 'delishs-core' ),
			'menu_name'                  => esc_html__( 'Service Categories', 'delishs-core' ),
			'all_items'                  => esc_html__( 'All Service Category', 'delishs-core' ),
			'parent_item'                => esc_html__( 'Parent Item', 'delishs-core' ),
			'parent_item_colon'          => esc_html__( 'Parent Item:', 'delishs-core' ),
			'new_item_name'              => esc_html__( 'New Service Category Name', 'delishs-core' ),
			'add_new_item'               => esc_html__( 'Add New Service Category', 'delishs-core' ),
			'edit_item'                  => esc_html__( 'Edit Service Category', 'delishs-core' ),
			'update_item'                => esc_html__( 'Update Service Category', 'delishs-core' ),
			'view_item'                  => esc_html__( 'View Service Category', 'delishs-core' ),
			'separate_items_with_commas' => esc_html__( 'Separate items with commas', 'delishs-core' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove items', 'delishs-core' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used', 'delishs-core' ),
			'popular_items'              => esc_html__( 'Popular Service Category', 'delishs-core' ),
			'search_items'               => esc_html__( 'Search Service Category', 'delishs-core' ),
			'not_found'                  => esc_html__( 'Not Found', 'delishs-core' ),
			'no_terms'                   => esc_html__( 'No Service Category', 'delishs-core' ),
			'items_list'                 => esc_html__( 'Service Category list', 'delishs-core' ),
			'items_list_navigation'      => esc_html__( 'Service Category list navigation', 'delishs-core' ),
		);

		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);

		register_taxonomy('services-cat','delishs-services', $args );
	}

}

new DelishsServicesPost();