<?php 
class DelishsFooterPost 
{

	private $type = 'delishs-footer';
    private $slug;
    private $name;
    private $plural_name;

	public function __construct() {
		$this->name = __('Footer', 'delishs-core');
        $this->slug = 'delishs-footer';
        $this->plural_name = __('Footer', 'delishs-core');

		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_filter( 'single_template', array( $this, 'get_custom_pt_single_template' ) );
		
	}
	
	
	public function register_custom_post_type() {
		$labels = array(
			'name' => $this->name,
            'singular_name' => $this->name,
            'add_new' => sprintf( __('Add New Template', 'delishs-core'), $this->name ),
            'add_new_item' => sprintf( __('Add New %s', 'delishs-core'), $this->name ),
            'edit_item' => sprintf( __('Edit %s', 'delishs-core'), $this->name ),
            'new_item' => sprintf( __('New %s', 'delishs-core'), $this->name ),
            'all_items' => sprintf( __('All Templates', 'delishs-core'), $this->plural_name ),
            'view_item' => sprintf( __('View %s', 'delishs-core'), $this->name ),
            'search_items' => sprintf( __('Search %s', 'delishs-core'), $this->name ),
            'not_found' => sprintf( __('No %s found' , 'delishs-core'), strtolower($this->name) ),
            'not_found_in_trash' => sprintf( __('No %s found in Trash', 'delishs-core'), strtolower($this->name) ),
            'parent_item_colon' => '',
            'menu_name' => $this->name,
		);

		$args   = array(
			'labels' => $labels,
            'public' => true,
            'exclude_from_search' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'rewrite' => [ 'slug' => $this->slug ],
            'menu_position' => 10,
            'supports' => ['title', 'editor', 'thumbnail', 'page-attributes','elementor'],
            'menu_icon' => 'dashicons-admin-page'
		);

		register_post_type( $this->type, $args );

        $cpt_support = get_option('elementor_cpt_support');
        if (!$cpt_support) {
            $cpt_support = ['page', 'post','delishs-footer', 'delishs-footer', 'elementor_disable_color_schemes']; //create array of our default supported post types
            update_option('elementor_cpt_support', $cpt_support); //write it to the database
        }
	}

	public function wrapper_footer_open()
    {
        global $post;

        if ($post->post_type == $this->type) {}
    }

    public function wrapper_footer_close()
    {
        global $post;

        if ($post->post_type == $this->type) { }
    }


	public function get_custom_pt_single_template($single_template)
    {
        global $post;

        if ($post->post_type == $this->type) {

            if (defined('ELEMENTOR_PATH')) {
                $elementor_template = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

                if ( file_exists( $elementor_template ) ) {
                    add_action( 'elementor/page_templates/canvas/before_content', [$this, 'wrapper_footer_open']);
                    add_action( 'elementor/page_templates/canvas/after_content', [$this, 'wrapper_footer_close']);
                    return $elementor_template;
                }
            }

            if (file_exists(get_template_directory().'/single-footer.php')) return $single_template;

            $single_template = plugin_dir_path( dirname( __FILE__ ) ) . 'include/template/single-footer.php';
        }
        return $single_template;
    }
}

new DelishsFooterPost();