<?php
/**
 * Template for displaying course Material Includes assets
 *
 * @package Tutor\Templates
 * @subpackage Single\Course
 * @author Themeum <support@themeum.com>
 * @link https://themeum.com
 * @since 1.0.0
 */

do_action( 'tutor_course/single/before/material_includes' );

$materials = tutor_course_material_includes();

if ( empty( $materials ) ) {
	return;
}

if ( is_array( $materials ) && count( $materials ) ) {
	?>
	<div class="tutor-course-details-widget">
		<h5 class="tutor-course-details-widget-title tutor-mb-16">
			<?php esc_html_e( 'Material Includes', 'eduvalt' ); ?>
		</h5>
		<ul class="tutor-course-details-widget-list">
			<?php foreach ( $materials as $material ) : ?>
				<li class="tutor-d-flex tutor-mb-12">
					<span><?php echo esc_html( $material ); ?></span>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
	<?php
}

do_action( 'tutor_course/single/after/material_includes' );

?>
