<?php
/**
 * Single Event Template
 * A single event. This displays the event title, description, meta, and
 * optionally, the Google map for the event.
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/single-event.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$events_label_singular = tribe_get_event_label_singular();
$events_label_plural   = tribe_get_event_label_plural();

$event_id = Tribe__Events__Main::postIdHelper( get_the_ID() );

/**
 * Allows filtering of the event ID.
 *
 * @since 6.0.1
 *
 * @param int $event_id
 */
$event_id = apply_filters( 'tec_events_single_event_id', $event_id );

/**
 * Allows filtering of the single event template title classes.
 *
 * @since 5.8.0
 *
 * @param array  $title_classes List of classes to create the class string from.
 * @param string $event_id The ID of the displayed event.
 */
$title_classes = apply_filters( 'tribe_events_single_event_title_classes', [ 'tribe-events-single-event-title' ], $event_id );
$title_classes = implode( ' ', tribe_get_classes( $title_classes ) );

/**
 * Allows filtering of the single event template title before HTML.
 *
 * @since 5.8.0
 *
 * @param string $before HTML string to display before the title text.
 * @param string $event_id The ID of the displayed event.
 */
$before = apply_filters( 'tribe_events_single_event_title_html_before', '<h1 class="' . $title_classes . '">', $event_id );

/**
 * Allows filtering of the single event template title after HTML.
 *
 * @since 5.8.0
 *
 * @param string $after HTML string to display after the title text.
 * @param string $event_id The ID of the displayed event.
 */
$after = apply_filters( 'tribe_events_single_event_title_html_after', '</h1>', $event_id );

/**
 * Allows filtering of the single event template title HTML.
 *
 * @since 5.8.0
 *
 * @param string $after HTML string to display. Return an empty string to not display the title.
 * @param string $event_id The ID of the displayed event.
 */
$title = apply_filters( 'tribe_events_single_event_title_html', the_title( $before, $after, false ), $event_id );
$cost  = tribe_get_formatted_cost( $event_id );

$event_venue = tribe_get_venue();
$event_start_time = tribe_get_start_date(null, false, 'h:i A');
$event_end_time = tribe_get_end_date(null, false, 'h:i A');
$event_phone = tribe_get_phone();

?>

<div id="tribe-events-content" class="tribe-events-single">
	<div class="event-details-area">
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-73">
					<div class="event-details-content">
						<!-- Notices -->
						<?php tribe_the_notices() ?>

						<h2 class="title"><?php echo get_the_title(); ?></h2>
						<div class="event-meta">
			                <ul class="list-wrap">
			                    <?php if( !empty( $event_venue ) ){ ?>
			                    	<li><i class="flaticon-pin-1"></i><?php echo esc_html( $event_venue ); ?></li>
			                    <?php } ?>
			                    <li><i class="flaticon-calendar-date"></i><?php echo tribe_get_start_date(null, false, 'M d, Y'); ?></li>
			                    <li><i class="flaticon-timer"></i><?php echo $event_start_time; ?> - <?php echo $event_end_time; ?></li>
			                    <?php if( !empty( $event_phone ) ){ ?> 
			                    	<li><i class="flaticon-phone"></i><?php echo esc_html( $event_phone ); ?></li>
			                    <?php } ?>
			                </ul>
			            </div>

						<!-- Event header -->
						<div id="tribe-events-header" <?php tribe_events_the_header_attributes() ?>>
							<!-- Navigation -->
							<nav class="tribe-events-nav-pagination" aria-label="<?php printf( esc_html__( '%s Navigation', 'eduvalt' ), $events_label_singular ); ?>">
								<ul class="tribe-events-sub-nav">
									<li class="tribe-events-nav-previous"><?php tribe_the_prev_event_link( '<span>&laquo;</span> %title%' ) ?></li>
									<li class="tribe-events-nav-next"><?php tribe_the_next_event_link( '%title% <span>&raquo;</span>' ) ?></li>
								</ul>
								<!-- .tribe-events-sub-nav -->
							</nav>
						</div>
						<!-- #tribe-events-header -->

						<?php while ( have_posts() ) :  the_post(); ?>
							<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
								<!-- Event featured image, but exclude link -->
								<?php echo tribe_event_featured_image( $event_id, 'full', false ); ?>

								<!-- Event content -->
								<?php do_action( 'tribe_events_single_event_before_the_content' ) ?>
								<div class="tribe-events-single-event-description tribe-events-content">
									<?php the_content(); ?>
								</div>
								

								<?php
									echo '<div class="tribe-events-meta-group tribe-events-meta-group-gmap">';
									tribe_get_template_part( 'modules/meta/map' );
									echo '</div>';
								?>



								<!-- .tribe-events-single-event-description -->
								<?php do_action( 'tribe_events_single_event_after_the_content' ) ?>


								<!-- Event meta -->
								<?php do_action( 'tribe_events_single_event_before_the_meta' ) ?>
								<?php tribe_get_template_part( 'modules/meta' ); ?>
								<?php do_action( 'tribe_events_single_event_after_the_meta' ) ?>
							</div> <!-- #post-x -->
							<?php if ( get_post_type() == Tribe__Events__Main::POSTTYPE && tribe_get_option( 'showComments', false ) ) comments_template() ?>
						<?php endwhile; ?>

						<!-- Event footer -->
						<div id="tribe-events-footer">
							<!-- Navigation -->
							<nav class="tribe-events-nav-pagination" aria-label="<?php printf( esc_html__( '%s Navigation', 'eduvalt' ), $events_label_singular ); ?>">
								<ul class="tribe-events-sub-nav">
									<li class="tribe-events-nav-previous"><?php tribe_the_prev_event_link( '<span>&laquo;</span> %title%' ) ?></li>
									<li class="tribe-events-nav-next"><?php tribe_the_next_event_link( '%title% <span>&raquo;</span>' ) ?></li>
								</ul>
								<!-- .tribe-events-sub-nav -->
							</nav>
						</div>
						<!-- #tribe-events-footer -->
					</div>
				</div>
				<div class="col-27">
					<div class="event__sidebar">
						<div class="event-widget">
							<?php
								// Include details meta if appropriate
								tribe_get_template_part( 'modules/meta/details' );
							?>
						</div>

						<div class="event-widget">
							<?php
								// Include vanue meta if appropriate
								tribe_get_template_part( 'modules/meta/venue' );
							
							?>
						</div>

						<div class="event-widget">
							<?php
								// Include organizer meta if appropriate
								if ( tribe_has_organizer() ) {
									tribe_get_template_part( 'modules/meta/organizer' );
								}
							?>
						</div>


						<?php if (is_active_sidebar('event-sidebar')) : ?>
							<div class="event-widget">
								<?php dynamic_sidebar('event-sidebar'); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</div><!-- #tribe-events-content -->
