<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eduvalt
 */

$categories = get_the_terms($post->ID, 'category');
$eduvalt_blog_date = get_theme_mod('eduvalt_blog_date', true);
$eduvalt_blog_comments = get_theme_mod('eduvalt_blog_comments', true);
$eduvalt_blog_author = get_theme_mod('eduvalt_blog_author', true);
$eduvalt_blog_cat = get_theme_mod('eduvalt_blog_cat', false);

?>


<ul class="list-wrap blog__post-meta d-flex flex-wrap align-items-center p-0">

    <?php if (!empty($eduvalt_blog_cat)) : ?>
        <?php $categories = get_the_category();
        if (!empty($categories)) {
            echo '<li class="tag"><a href="' . esc_url(get_category_link($categories[0]->term_id)) . '">' . esc_html($categories[0]->name) . '</a></li>';
        }
        ?>
    <?php endif; ?>

    <?php if (!empty($eduvalt_blog_author)) : ?>
        <li><i class="flaticon-account"></i><a href="<?php print esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php print get_the_author(); ?></a></li>
    <?php endif; ?>

    <?php if (!empty($eduvalt_blog_date)) : ?>
        <li><i class="flaticon-calendar-date"></i> <?php the_time(get_option('date_format')); ?></li>
    <?php endif; ?>

    <?php if (!empty($eduvalt_blog_comments)) : ?>
        <li><i class="flaticon-help"></i> <a href="<?php comments_link(); ?>"><?php comments_number(); ?></a></li>
    <?php endif; ?>

</ul>