<?php

/**
 * Template part for displaying post btn
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package eduvalt
 */

$eduvalt_blog_btn = get_theme_mod('eduvalt_blog_btn', __('Continue Reading', 'eduvalt'));
$eduvalt_blog_btn_switch = get_theme_mod('eduvalt_blog_btn_switch', true);

$randID = wp_rand();
?>

<?php if (!empty($eduvalt_blog_btn_switch)) : ?>
    <div class="tg-button-wrap">
        <a href="<?php the_permalink(); ?>" class="btn tg-svg"><span class="text"><?php print esc_html($eduvalt_blog_btn); ?></span> <span class="svg-icon" id="blog-btn<?php echo esc_attr($randID); ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
    </div>
<?php endif; ?>