<?php
/**
 * Template for displaying primary course meta data such as: Instructor, Categories, Reviews (addons)...
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

use LearnPress\TemplateHooks\Instructor\SingleInstructorTemplate;

defined( 'ABSPATH' ) or die;

$course = learn_press_get_course();
if ( ! $course ) {
	return;
}

$instructor = $course->get_instructor();
if ( ! $instructor ) {
	return;
}

?>

<div class="courses__breadcrumb-content">
	<span class="category">
		<?php
			if ( ! get_the_terms( get_the_ID(), 'course_category' ) ) {
				esc_html_e( 'Uncategorized', 'eduvalt' );
			} else {
				echo get_the_term_list( get_the_ID(), 'course_category', '', '<span>|</span>' );
			}
		?>
	</span>
	<h3 class="title"><?php the_title(); ?></h3>
	<p><?php the_excerpt(); ?></p>
	<ul class="courses__item-meta list-wrap">
	    <li>
	        <div class="author">
	        	<div class="tutor-avatar">
	        		<div class="tutor-ratio tutor-ratio-1x1">
	        			<?php echo wp_kses_post( $instructor->get_profile_picture() ); ?>
	        		</div>
	        	</div>
				<?php
					echo wp_kses_post(
						sprintf(
							'<a href="%s">%s</a>',
							$instructor->get_url_instructor(),
							SingleInstructorTemplate::instance()->html_display_name( $instructor )
						)
					);
				?>
	        </div>
	    </li>
	    <li><i class="flaticon-file"></i>
	        <?php
	            $lessons = $course->get_items('lp_lesson', false) ? count($course->get_items('lp_lesson', false)) : 0;
	            $lessons_text = ('1' == $lessons) ? esc_html__(' Lesson', 'eduvalt') : esc_html__(' Lessons', 'eduvalt');
	            echo esc_attr( $lessons ) . $lessons_text;
	        ?>
	    </li>
	    <li><i class="flaticon-timer"></i> <?php echo learn_press_get_post_translated_duration( get_the_ID(), esc_html__( 'Lifetime', 'eduvalt' ) ); ?></li>
	    <li><i class="flaticon-user-1"></i>
	        <?php
	            $students = (int)learn_press_get_course()->count_students();
	            $students_text = ('1' == $students) ? esc_html__(' Student', 'eduvalt') : esc_html__(' Students', 'eduvalt');
	            echo esc_attr( $students );
	         ?>
	    </li>
	    <li>
			<?php if( class_exists('LP_Addon_Course_Review_Preload') ) {
				//plugin is activated
				$ratings     = learn_press_get_course_rate_total( get_the_ID() );
				?>
                <div class="rating">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <span class="rating-count">(<?php echo esc_html( $ratings ); ?>)</span>
                </div>
            <?php } ?>
	    </li>
	</ul>
</div>