<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course = \LP_Global::course();
$course_id           = get_the_ID();
$duration = get_post_meta( $course_id, '_lp_duration', true );
$user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0;
$lessons  = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0;


?>
<div class="col-lg-4">
	<div class="courses__item-two shine__animate-item">
		<div class="courses__item-two-thumb">
			<a href="<?php the_permalink(); ?>" class="shine__animate-link">
				<?php the_post_thumbnail( ); ?>
			</a>
			<div class="author">
				<?php echo wp_kses_post ($course->get_instructor()->get_profile_picture() ); ?>
			</div>
		</div>
		<div class="courses__item-two-content">
			<?php
			$terms = wp_get_post_terms( $course_id, 'course_category');
        	foreach ($terms as $term) {
        		$term_link = get_term_link( $term );
        		?>
            	<a href="<?php echo $term_link; ?>" class="courses__item-tag" style="background-color: #F7EEFA; color: #BC18E4;"><?php echo esc_html( $term->name ); ?></a>
			<?php } ?>
			<h5 class="title">
				<a href="<?php the_permalink(); ?>" class="course-permalink"><?php the_title(); ?></a>	
			</h5>

			<ul class="courses__item-meta list-wrap">
			    <li><i class="flaticon-file"></i> <?php echo $lessons; ?></li>
				<?php 
					if ( $variation = (int)$duration ) :
						preg_match('/\d (\w*)/', $duration, $match);
						if (isset($match[1])) {
							switch ($match[1]) {
								case 'minute': $s = _n( 'Minute', 'Minutes', $variation, 'eduvalt' ); break;
								case 'hour': $s = _n( 'Hour', 'Hours', $variation, 'eduvalt' ); break;
								case 'day': $s = _n( 'Day', 'Days', $variation, 'eduvalt' ); break;
								case 'week': $s = _n( 'Week', 'Weeks', $variation, 'eduvalt' ); break;
							}
							$duration = sprintf( '%d %s', $variation, $s);
						}
					endif;
				?>
			    <li><i class="flaticon-timer"></i><?php printf('%s', $duration); ?></li>
			    <li><i class="flaticon-user-1"></i><?php echo $user_count; ?></li>
			</ul>

			<div class="courses__item-bottom">
                <div class="course__price">
                    <h3 class="price">
						<?php
							if ( $price = $course->get_price_html() ) :
								if ( $course->get_origin_price() != $course->get_price() ) :
						            echo '<del>', esc_html( $course->get_origin_price_html() ), '</del>';
								endif;
						        echo '<span class="price">', esc_html($price), '</span>';
							endif;
						?>
                    </h3>
                </div>
				<?php if( class_exists('LP_Addon_Course_Review_Preload') ) {
					//plugin is activated
					$ratings     = learn_press_get_course_rate_total( $course_id );
					?>
                    <div class="courses__item-rating">
                        <i class="fas fa-star"></i>
                        <span class="rating-count">(<?php echo esc_html( $ratings ); ?>)</span>
                    </div>
                <?php } ?>
            </div>
		</div>

		<?php

		/**
		 * LP Hook
		 *
		 * @since 3.0.0
		 *
		 * @see LP_Template_Course::courses_loop_item_meta()
		 * @see LP_Template_Course::courses_loop_item_info_begin()
		 * @see LP_Template_Course::clearfix()
		 * @see LP_Template_Course::courses_loop_item_price()
		 * @see LP_Template_Course::courses_loop_item_info_end()
		 */
		//do_action( 'learn-press/after-courses-loop-item' );

		?>
	</div>
</div>
