<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package eduvalt
 */


/**
 *
 * Eduvalt Header
 */

function eduvalt_check_header() {
    $eduvalt_header_style = function_exists( 'get_field' ) ? get_field( 'header_style' ) : NULL;
    $eduvalt_default_header_style = get_theme_mod( 'choose_default_header', 'header-style-1' );

    if ( $eduvalt_header_style == 'header-style-1' && empty($_GET['s']) ) {
        get_template_part( 'template-parts/header/header-1' );
    }
    elseif ( $eduvalt_header_style == 'header-style-2' && empty($_GET['s']) ) {
        get_template_part( 'template-parts/header/header-2' );
    }
    elseif ( $eduvalt_header_style == 'header-style-3' && empty($_GET['s']) ) {
        get_template_part( 'template-parts/header/header-3' );
    }
    else {
        /** Default Header Style **/
        if ( $eduvalt_default_header_style == 'header-style-2' ) {
            get_template_part( 'template-parts/header/header-2' );
        }
        elseif ( $eduvalt_default_header_style == 'header-style-3' ) {
            get_template_part( 'template-parts/header/header-3' );
        }
        else {
            get_template_part( 'template-parts/header/header-1' );
        }
    }

}
add_action( 'eduvalt_header_style', 'eduvalt_check_header', 10 );


/**
 * [eduvalt_header_lang description]
 * @return [type] [description]
 */
function eduvalt_header_lang_default() {
    $eduvalt_header_lang = get_theme_mod( 'eduvalt_header_lang', false );
    if ( $eduvalt_header_lang ): ?>

    <ul>
        <li><a href="javascript:void(0)" class="lang__btn"><?php print esc_html__( 'English', 'eduvalt' );?> <i class="fa-light fa-angle-down"></i></a>
        <?php do_action( 'eduvalt_language' );?>
        </li>
    </ul>

    <?php endif;?>
<?php
}

/**
 * [eduvalt_language_list description]
 * @return [type] [description]
 */
function _eduvalt_language( $mar ) {
    return $mar;
}
function eduvalt_language_list() {

    $mar = '';
    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=id&order=desc' );
    if ( !empty( $languages ) ) {
        $mar = '<ul class="lang-list">';
        foreach ( $languages as $lan ) {
            $active = $lan['active'] == 1 ? 'active' : '';
            $mar .= '<li class="' . $active . '"><a href="' . $lan['url'] . '">' . $lan['translated_name'] . '</a></li>';
        }
        $mar .= '</ul>';
    } else {
        //remove this code when send themeforest reviewer team
        $mar .= '<ul class="lang-list">';
        $mar .= '<li><a href="#">' . esc_html__( 'IND', 'eduvalt' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'SPA', 'eduvalt' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'GRE', 'eduvalt' ) . '</a></li>';
        $mar .= '<li><a href="#">' . esc_html__( 'CIN', 'eduvalt' ) . '</a></li>';
        $mar .= ' </ul>';
    }
    print _eduvalt_language( $mar );
}
add_action( 'eduvalt_language', 'eduvalt_language_list' );


// Header Logo
function eduvalt_header_logo() { ?>
      <?php
        $eduvalt_logo_on = function_exists( 'get_field' ) ? get_field( 'is_enable_sec_logo' ) : NULL;
        $eduvalt_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
        $eduvalt_logo_black = get_template_directory_uri() . '/assets/img/logo/secondary_logo.png';

        $eduvalt_site_logo = get_theme_mod( 'logo', $eduvalt_logo );
        $eduvalt_secondary_logo = get_theme_mod( 'secondary_logo', $eduvalt_logo_black );
      ?>

      <?php if ( !empty( $eduvalt_logo_on ) ) : ?>
         <a class="secondary-logo" href="<?php print esc_url( home_url( '/' ) );?>">
             <img src="<?php print esc_url( $eduvalt_secondary_logo );?>" style="max-width: <?php echo get_theme_mod( 'logo_size_adjust', '150px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'eduvalt' );?>" />
         </a>
      <?php else : ?>
         <a class="main-logo" href="<?php print esc_url( home_url( '/' ) );?>">
             <img src="<?php print esc_url( $eduvalt_site_logo );?>" style="max-width: <?php echo get_theme_mod( 'logo_size_adjust', '150px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'eduvalt' );?>" />
         </a>
      <?php endif; ?>
   <?php
}

// Header Sticky Logo
function eduvalt_header_sticky_logo() {?>
    <?php
        $eduvalt_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
        $eduvalt_site_logo = get_theme_mod( 'logo', $eduvalt_logo );
    ?>
      <a class="sticky-logo" href="<?php print esc_url( home_url( '/' ) );?>">
          <img src="<?php print esc_url( $eduvalt_site_logo );?>" style="max-width: <?php echo get_theme_mod( 'logo_size_adjust', '150px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'eduvalt' );?>" />
      </a>
    <?php
}

// Mobile Menu Logo
function eduvalt_mobile_logo() {

    $mobile_menu_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
    $mobile_logo = get_theme_mod('mobile_logo', $mobile_menu_logo);

    ?>

    <a class="main-logo" href="<?php print esc_url( home_url( '/' ) ); ?>">
        <img src="<?php print esc_url( $mobile_logo ); ?>" height="auto" width="<?php echo get_theme_mod( 'logo_size_adjust', '150px' ); ?>" alt="<?php print esc_attr__( 'Logo', 'eduvalt' );?>" />
    </a>

<?php }


/**
 * [eduvalt_header_social description]
 * @return [type] [description]
 */
function eduvalt_header_social() {
    $eduvalt_header_social_title = get_theme_mod('eduvalt_header_social_title', __('Follow Us On :', 'eduvalt'));
    $eduvalt_header_fb_url       = get_theme_mod('eduvalt_header_fb_url', '#');
    $eduvalt_header_insta_url    = get_theme_mod('eduvalt_header_insta_url', '#');
    $eduvalt_header_twitter_url  = get_theme_mod('eduvalt_header_twitter_url', '#');
    $eduvalt_header_whatsapp_url = get_theme_mod('eduvalt_header_whatsapp_url', '#');
    $eduvalt_header_linkedin_url = get_theme_mod('eduvalt_header_linkedin_url', '#');
    $eduvalt_header_youtube_url  = get_theme_mod('eduvalt_header_youtube_url', '#');
    $eduvalt_header_tiktok_url   = get_theme_mod('eduvalt_header_tiktok_url', '');
    $eduvalt_header_dribbb_url   = get_theme_mod('eduvalt_header_dribbb_url', '');
    $eduvalt_header_behance_url  = get_theme_mod('eduvalt_header_behance_url', '');
?>
    <ul class="tg-header__top-social list-wrap">
        <?php if (!empty($eduvalt_header_social_title)) : ?>
            <li><?php echo esc_html($eduvalt_header_social_title); ?></li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_fb_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_fb_url); ?>" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_insta_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_insta_url); ?>" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_twitter_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_twitter_url); ?>" aria-label="Twitter"><i class="fab fa-twitter"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_whatsapp_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_whatsapp_url); ?>" aria-label="Whatsapp"><i class="fab fa-whatsapp"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_linkedin_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_linkedin_url); ?>" aria-label="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_youtube_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_youtube_url); ?>" aria-label="Youtube"><i class="fab fa-youtube"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_tiktok_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_tiktok_url); ?>" aria-label="Tiktok"><i class="fab fa-tiktok"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_dribbb_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_dribbb_url); ?>" aria-label="Dribbble"><i class="fab fa-dribbble"></i></a>
            </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_header_behance_url)) : ?>
            <li>
                <a href="<?php echo esc_url($eduvalt_header_behance_url); ?>" aria-label="Behance"><i class="fab fa-behance"></i></a>
            </li>
        <?php endif; ?>

    </ul>

<?php
}



/**
 * [eduvalt_mobile_social_profiles description]
 * @return [type] [description]
 */
function eduvalt_mobile_social_profiles() {
    $eduvalt_mobile_fb_url           = get_theme_mod('eduvalt_mobile_fb_url', '#');
    $eduvalt_mobile_twitter_url      = get_theme_mod('eduvalt_mobile_twitter_url', '#');
    $eduvalt_mobile_instagram_url    = get_theme_mod('eduvalt_mobile_instagram_url', '#');
    $eduvalt_mobile_linkedin_url     = get_theme_mod('eduvalt_mobile_linkedin_url', '#');
    $eduvalt_mobile_telegram_url      = get_theme_mod('eduvalt_mobile_telegram_url', '#');
    ?>

    <ul class="clearfix">
        <?php if (!empty($eduvalt_mobile_fb_url)): ?>
        <li class="facebook">
            <a href="<?php print esc_url($eduvalt_mobile_fb_url); ?>" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_mobile_twitter_url)): ?>
        <li class="twitter">
            <a href="<?php print esc_url($eduvalt_mobile_twitter_url); ?>" aria-label="Twitter"><i class="fab fa-twitter"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_mobile_instagram_url)): ?>
        <li class="instagram">
            <a href="<?php print esc_url($eduvalt_mobile_instagram_url); ?>" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_mobile_linkedin_url)): ?>
        <li class="linkedin">
            <a href="<?php print esc_url($eduvalt_mobile_linkedin_url); ?>" aria-label="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
        </li>
        <?php endif; ?>

        <?php if (!empty($eduvalt_mobile_telegram_url)): ?>
        <li class="telegram">
            <a href="<?php print esc_url($eduvalt_mobile_telegram_url); ?>" aria-label="Telegram"><i class="fab fa-telegram-plane"></i></a>
        </li>
        <?php endif; ?>
    </ul>

<?php
}


/**
 * [eduvalt_header_menu description]
 * @return [type] [description]
 */
function eduvalt_header_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => 'Eduvalt_Navwalker_Class::fallback',
            'walker'         => new Eduvalt_Navwalker_Class,
        ] );
    ?>
    <?php
}


/**
 * [eduvalt_hamburger_menu description]
 * @return [type] [description]
 */
function eduvalt_hamburger_menu() {
    ?>
    <?php
        wp_nav_menu( [
            'theme_location' => 'hamburger-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => 'Eduvalt_Navwalker_Class::fallback',
            'walker'         => new Eduvalt_Navwalker_Class,
        ] );
    ?>
    <?php
}

/**
 * [eduvalt_header_menu description]
 * @return [type] [description]
 */
function eduvalt_mobile_menu() { ?>
    <?php
        $eduvalt_menu = wp_nav_menu( [
            'theme_location' => 'main-menu',
            'menu_class'     => 'navigation',
            'container'      => '',
            'fallback_cb'    => false,
            'echo'           => false,
        ] );

    $eduvalt_menu = str_replace( "menu-item-has-children", "menu-item-has-children has-children", $eduvalt_menu );
        echo wp_kses_post( $eduvalt_menu );
    ?>
    <?php
}


/**
 * [eduvalt_footer_menu description]
 * @return [type] [description]
 */
function eduvalt_footer_menu() {
    wp_nav_menu( [
        'theme_location' => 'footer-menu',
        'menu_class'     => 'navigation',
        'container'      => '',
        'fallback_cb'    => 'Eduvalt_Navwalker_Class::fallback',
        'walker'         => new Eduvalt_Navwalker_Class,
    ] );
}


/**
 * [eduvalt_categories_menu description]
 * @return [type] [description]
 */
function eduvalt_categories_menu() {
    wp_nav_menu( [
        'theme_location' => 'categories-menu',
        'menu_class'     => 'dropdown-menu',
        'container'      => '',
        'fallback_cb'    => 'Eduvalt_Navwalker_Class::fallback',
        'walker'         => new Eduvalt_Navwalker_Class,
    ] );
}

/**
 *
 * eduvalt footer
 */
add_action( 'eduvalt_footer_style', 'eduvalt_check_footer', 10 );

function eduvalt_check_footer() {

    $footer_show = 1;
    $is_footer = function_exists( 'get_field' ) ? get_field( 'is_it_invisible_footer') : '';
    if( !empty($_GET['s']) ) {
      $is_footer = null;
    }

    if ( empty( $is_footer ) && $footer_show == 1 ) {
        $eduvalt_footer_style = function_exists( 'get_field' ) ? get_field( 'footer_style' ) : NULL;
        $eduvalt_default_footer_style = get_theme_mod( 'choose_default_footer', 'footer-style-1' );

        get_template_part( 'template-parts/footer/footer-1' );

    }
}


// eduvalt_copyright_text
function eduvalt_copyright_text() {
   print get_theme_mod( 'eduvalt_copyright', wp_kses_post('Copyright © 2025 eduvalt. All rights reserved.', 'eduvalt' ) );
}


/**
 *
 * pagination
 */
if ( !function_exists( 'eduvalt_pagination' ) ) {

    function _eduvalt_pagi_callback( $pagination ) {
        return $pagination;
    }

    //page navegation
    function eduvalt_pagination( $prev, $next, $pages, $args ) {
        global $wp_query, $wp_rewrite;
        $menu = '';
        $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

        if ( $pages == '' ) {
            global $wp_query;
            $pages = $wp_query->max_num_pages;

            if ( !$pages ) {
                $pages = 1;
            }

        }

        $pagination = [
            'base'      => add_query_arg( 'paged', '%#%' ),
            'format'    => '',
            'total'     => $pages,
            'current'   => $current,
            'prev_text' => $prev,
            'next_text' => $next,
            'type'      => 'array',
        ];

        //rewrite permalinks
        if ( $wp_rewrite->using_permalinks() ) {
            $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
        }

        if ( !empty( $wp_query->query_vars['s'] ) ) {
            $pagination['add_args'] = ['s' => get_query_var( 's' )];
        }

        $pagi = '';
        if ( paginate_links( $pagination ) != '' ) {
            $paginations = paginate_links( $pagination );
            $pagi .= '<ul class="pagination">';
            foreach ( $paginations as $key => $pg ) {
                $pagi .= '<li class="page-item">' . $pg . '</li>';
            }
            $pagi .= '</ul>';
        }

        print _eduvalt_pagi_callback( $pagi );
    }
}


// LearnPress Categories
function eduvalt_course_select() {

    $children_cats = array();
    $categories = get_terms(array(
        'taxonomy'         => 'course-category',
        'hide_empty'    => true,
        'depth' => 1,
        'parent'        => 0
    ));

    ?>


    <label for="course-cat" class="s-classs"><?php echo esc_html__('Categories', 'eduvalt'); ?></label>
    <select class="form-select" id="course-cat" style="width: 150px" name="course-category">
        <option selected disabled><?php echo esc_html__('Categories', 'eduvalt'); ?></option>
        <?php if (!empty($categories)) :

            foreach ($categories as $term) :
                $child_terms = get_term_children($term->slug, 'course-category');

            if (!empty($child_terms)) {
                foreach ($child_terms as $child_term_id) {
                    $child_term = get_term_by('id', $child_term_id, 'course-category');
                    $children_cats[] = $child_term;
                }
            }
        ?>
            <option value="<?php echo esc_html($term->slug); ?>"><?php echo esc_html($term->name); ?></option>
        <?php wp_reset_query(); endforeach; endif; ?>
        <input type="hidden" value="tutor" name="post_type">
    </select>
<?php

}


// theme color
function eduvalt_custom_color() {

    // Primary Color
    $color_code = get_theme_mod( 'eduvalt_color_option', '#1363DF' );
    wp_enqueue_style( 'eduvalt-custom', EDUVALT_THEME_CSS_DIR . 'eduvalt-custom.css', [] );
    if ( $color_code != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-theme-primary: " . $color_code . "}";
        $custom_css .= "html:root { --unit-primary-color: " . $color_code . "}";
        wp_add_inline_style( 'eduvalt-custom', $custom_css );
    }

    // Secondary Color
    $color_code2 = get_theme_mod( 'eduvalt_color_option2', '#082A5E' );
    wp_enqueue_style( 'eduvalt-custom', EDUVALT_THEME_CSS_DIR . 'eduvalt-custom.css', [] );
    if ( $color_code2 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-theme-secondary: " . $color_code2 . "}";
        $custom_css .= "html:root { --unit-secondary-color: " . $color_code2 . "}";
        wp_add_inline_style( 'eduvalt-custom', $custom_css );
    }

    // Yellow Color
    $color_code3 = get_theme_mod( 'eduvalt_color_option3', '#FAB123' );
    wp_enqueue_style( 'eduvalt-custom', EDUVALT_THEME_CSS_DIR . 'eduvalt-custom.css', [] );
    if ( $color_code3 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-common-color-yellow: " . $color_code3 . "}";
        wp_add_inline_style( 'eduvalt-custom', $custom_css );
    }

    // Gray Color
    $color_code4 = get_theme_mod( 'eduvalt_color_option4', '#E7EFFC' );
    wp_enqueue_style( 'eduvalt-custom', EDUVALT_THEME_CSS_DIR . 'eduvalt-custom.css', [] );
    if ( $color_code4 != '' ) {
        $custom_css = '';
        $custom_css .= "html:root { --tg-common-color-gray: " . $color_code4 . "}";
        wp_add_inline_style( 'eduvalt-custom', $custom_css );
    }

}
add_action( 'wp_enqueue_scripts', 'eduvalt_custom_color' );



// eduvalt_kses_intermediate
function eduvalt_kses_intermediate( $string = '' ) {
    return wp_kses( $string, eduvalt_get_allowed_html_tags( 'intermediate' ) );
}

function eduvalt_get_allowed_html_tags( $level = 'basic' ) {
    $allowed_html = [
        'b'      => [],
        'i'      => [],
        'u'      => [],
        'em'     => [],
        'br'     => [],
        'abbr'   => [
            'title' => [],
        ],
        'span'   => [
            'class' => [],
        ],
        'strong' => [],
        'a'      => [
            'href'  => [],
            'title' => [],
            'class' => [],
            'id'    => [],
        ],
    ];

    if ($level === 'intermediate') {
        $allowed_html['a'] = [
            'href' => [],
            'title' => [],
            'class' => [],
            'id' => [],
        ];
        $allowed_html['div'] = [
            'class' => [],
            'id' => [],
        ];
        $allowed_html['img'] = [
            'src' => [],
            'class' => [],
            'alt' => [],
        ];
        $allowed_html['del'] = [
            'class' => [],
        ];
        $allowed_html['ins'] = [
            'class' => [],
        ];
        $allowed_html['bdi'] = [
            'class' => [],
        ];
        $allowed_html['i'] = [
            'class' => [],
            'data-rating-value' => [],
        ];
    }

    return $allowed_html;
}



// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function eduvalt_kses($raw){

   $allowed_tags = array(
      'a'      => array(
         'class'   => array(),
         'href'    => array(),
         'rel'  => array(),
         'title'   => array(),
         'target' => array(),
      ),
      'abbr'   => array(
         'title' => array(),
      ),
      'b'    => array(),
      'blockquote'   => array(
         'cite' => array(),
      ),
      'cite'   => array(
         'title' => array(),
      ),
      'code'  => array(),
      'del'   => array(
         'datetime'   => array(),
         'title'      => array(),
      ),
      'dd'     => array(),
      'div'    => array(
         'class'   => array(),
         'title'   => array(),
         'style'   => array(),
      ),
      'dl'   => array(),
      'dt'   => array(),
      'em'   => array(),
      'h1'   => array(),
      'h2'   => array(),
      'h3'   => array(),
      'h4'   => array(),
      'h5'   => array(),
      'h6'   => array(),
      'i'    => array(
        'class' => array(),
      ),
      'img'   => array(
         'alt'  => array(),
         'class'   => array(),
         'height' => array(),
         'src'  => array(),
         'width'   => array(),
      ),
      'li'   => array(
         'class' => array(),
      ),
      'ol'   => array(
         'class' => array(),
      ),
      'p'    => array(
         'class' => array(),
      ),
      'q'    => array(
         'cite'    => array(),
         'title'   => array(),
      ),
      'span'  => array(
         'class'   => array(),
         'title'   => array(),
         'style'   => array(),
      ),
      'iframe'   => array(
         'width'        => array(),
         'height'       => array(),
         'scrolling'    => array(),
         'frameborder'  => array(),
         'allow'        => array(),
         'src'          => array(),
      ),
      'strike'  => array(),
      'br'      => array(),
      'strong'    => array(),
      'data-wow-duration'   => array(),
      'data-wow-delay'   => array(),
      'data-wallpaper-options'  => array(),
      'data-stellar-background-ratio'   => array(),
      'ul'   => array(
         'class' => array(),
      ),
      'svg' => array(
           'class' => true,
           'aria-hidden' => true,
           'aria-labelledby' => true,
           'role' => true,
           'xmlns' => true,
           'width' => true,
           'height' => true,
           'viewbox' => true, // <= Must be lower case!
       ),
       'g'     => array( 'fill' => true ),
       'title' => array( 'title' => true ),
       'path'  => array( 'd' => true, 'fill' => true,  ),
      );

   if (function_exists('wp_kses')) { // WP is here
      $allowed = wp_kses($raw, $allowed_tags);
   } else {
      $allowed = $raw;
   }

   return $allowed;
}