<?php
/**
 * Tutor LMS Custom Functions
 */

if( !function_exists('tutor_count_total_lesson_time') ){
    function tutor_count_total_lesson_time( $topic_contents ){
        $times = array();
        if( $topic_contents->have_posts() ){
            $hours = 0;
            $mins  = 0;
            $secs  = 0;
            while( $topic_contents->have_posts() ){
                $topic_contents->the_post();
                $video      = tutor_utils()->get_video_info();
                $play_time  = $video ? $video->playtime : false;
                $times_arr  = $play_time? explode(":", $play_time) : array();

                if( !empty($times_arr) && count($times_arr) == 3 ){
                    $hours += intval($times_arr[0]);
                    $mins  += intval($times_arr[1]);
                    $secs  += intval($times_arr[2]);
                }if( !empty($times_arr) && count($times_arr) == 2 ){
                    $mins  += intval($times_arr[0]);
                    $secs  += intval($times_arr[1]);
                }if( !empty($times_arr) && count($times_arr) == 1 ){
                    $secs  += intval($times_arr[0]);
                }
            }

            if($mins > 60){
                $divide_mins = number_format($mins / 60, 2);
                $min = fmod((float) $divide_mins, 1);
                $hours += 1;
                $mins = floor(($min * 60));
            }

            if($secs > 60){
                $divide_secs = number_format($secs / 60, 2);
                $sec = fmod((float) $divide_secs, 1);
                $mins += 1;
                $secs = floor(($sec * 60));
            }

            $times['hour'] = $hours;
            $times['min']  = $mins;
            $times['sec']  = $secs;

            $time_output = '';
            if( $times['hour'] > 0 ){
                $time_output = sprintf('%sh %smin %ssec', $times['hour'], $times['min'], $times['sec']);
            }elseif(intval($times['hour']) == 0 && intval($times['min']) > 0){
                $time_output = sprintf('%smin %s', $times['min'], (intval($times['sec']) > 0)? "{$times['sec']}sec" : '');
            }else{
                $time_output = sprintf('%ssec', $times['sec']);
            }
            if( isset($time_output) && !empty($times) && ($times['hour'] != 0 || $times['min'] != 0 || $times['sec'] != 0) ){
                return $time_output;
            }
        }
    }
}


if( !function_exists('tutor_show_lesson_time_format') ){
    function tutor_show_lesson_time_format( $play_time ){
        $times_arr_2 = $play_time? explode(":", $play_time) : array();
        $duration = '';

        if( !empty($times_arr_2) && count($times_arr_2) == 3 ){
            if(intval($times_arr_2[0]) > 0){
                if(intval($times_arr_2[1]) > 0 && intval($times_arr_2[2]) > 0){
                    $duration = intval($times_arr_2[0])."hr ".intval($times_arr_2[1])."min {$times_arr_2[2]}sec";
                }else{
                    $duration = intval($times_arr_2[0])."hr";
                }
            }elseif(intval($times_arr_2[0]) == 0 && intval($times_arr_2[1]) > 0){
                $duration = intval($times_arr_2[1])."min";
                if(intval($times_arr_2[2]) > 0){
                    $duration .= " $times_arr_2[2]sec";
                }
            }else{
                $duration = "{$times_arr_2[2]} sec";
            }
        }else if(!empty($times_arr_2) && count($times_arr_2) == 2){
            if(intval($times_arr_2[0]) > 0){
                if(intval($times_arr_2[1]) > 0){
                    $duration = intval($times_arr_2[0])."min {$times_arr_2[1]}sec";
                }else{
                    $duration = intval($times_arr_2[0])."min";
                }
            }else{
                $duration = "{$times_arr_2[1]} sec";
            }
        }
        return $duration;
    }
}

// custom tutor lms utils object
if( !function_exists('olc_tutor_utils') ){
    function olc_tutor_utils(){
        if( !isset($GLOBALS['olc_tutor_object']) ){
            $GLOBALS['olc_tutor_object'] = new OLC_Tutor_Utils();
        }

        return $GLOBALS['olc_tutor_object'];
    }
}

if( !function_exists('tutor_course_topics') ){
    function tutor_course_topics(){
        tutor_load_template( 'single.course.course-topics' );
    }
}

if( !function_exists('tutor_course_info_custom') ){
    function tutor_course_info_custom(){
        tutor_course_content();
	    tutor_course_benefits_html();
    }
}