<?php

/**
 * eduvalt_scripts description
 * @return [type] [description]
 */
function eduvalt_scripts() {


    /**
     * ALL CSS FILES
    */
    wp_enqueue_style( 'eduvalt-fonts', eduvalt_fonts_url(), array(), '1.0.0' );
    if( is_rtl() ){
        wp_enqueue_style( 'bootstrap-rtl', EDUVALT_THEME_CSS_DIR.'bootstrap.rtl.min.css', array() );
    }else{
        wp_enqueue_style( 'bootstrap', EDUVALT_THEME_CSS_DIR.'bootstrap.min.css', array() );
    }
    wp_enqueue_style( 'eduvalt-animate', EDUVALT_THEME_CSS_DIR . 'animate.min.css', [] );
    wp_enqueue_style( 'magnific-popup', EDUVALT_THEME_CSS_DIR . 'magnific-popup.css', [] );
    wp_enqueue_style( 'font-awesome-free', EDUVALT_THEME_CSS_DIR . 'fontawesome-all.min.css', [] );
    wp_enqueue_style( 'flaticon-eduvalt', EDUVALT_THEME_CSS_DIR . 'flaticon-eduvalt.css', [] );
    wp_enqueue_style( 'default-icons', EDUVALT_THEME_CSS_DIR . 'default-icons.css', [] );
    // wp_enqueue_style( 'select2', EDUVALT_THEME_CSS_DIR . 'select2.min.css', [] );
    wp_enqueue_style( 'odometer', EDUVALT_THEME_CSS_DIR . 'odometer.css', [] );
    wp_enqueue_style( 'slick', EDUVALT_THEME_CSS_DIR . 'slick.css', [] );
    wp_enqueue_style( 'aos', EDUVALT_THEME_CSS_DIR . 'aos.css', [] );
    wp_enqueue_style( 'eduvalt-spacing', EDUVALT_THEME_CSS_DIR . 'spacing.css', [] );
    wp_enqueue_style( 'tg-cursor', EDUVALT_THEME_CSS_DIR . 'tg-cursor.css', [] );
    wp_enqueue_style( 'eduvalt-core', EDUVALT_THEME_CSS_DIR . 'eduvalt-core.css', [] );
    wp_enqueue_style( 'eduvalt-unit', EDUVALT_THEME_CSS_DIR . 'eduvalt-unit.css', [] );
    wp_enqueue_style( 'eduvalt-woo', EDUVALT_THEME_CSS_DIR . 'eduvalt-woo.css', [] );
    wp_enqueue_style( 'eduvalt-style', get_stylesheet_uri() );


    // ALL JS FILES
    wp_enqueue_script( 'bootstrap-bundle', EDUVALT_THEME_JS_DIR . 'bootstrap.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'isotope', EDUVALT_THEME_JS_DIR . 'isotope.pkgd.min.js', [ 'imagesloaded' ], '', true );
    wp_enqueue_script( 'magnific-popup', EDUVALT_THEME_JS_DIR . 'jquery.magnific-popup.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'odometer', EDUVALT_THEME_JS_DIR . 'jquery.odometer.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'appear', EDUVALT_THEME_JS_DIR . 'jquery.appear.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'tween-max', EDUVALT_THEME_JS_DIR . 'tween-max.min.js', [ 'jquery' ], '', true );
    // wp_enqueue_script( 'eduvalt-select2', EDUVALT_THEME_JS_DIR . 'select2.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'slick', EDUVALT_THEME_JS_DIR . 'slick.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'slick-animation', EDUVALT_THEME_JS_DIR . 'slick-animation.min.js', [ 'jquery' ], '', true );
    $eduvalt_cursor_mode = get_theme_mod('eduvalt_cursor_mode', false);
    if (!empty($eduvalt_cursor_mode)) {
        wp_enqueue_script( 'tg-cursor', EDUVALT_THEME_JS_DIR . 'tg-cursor.min.js', [ 'jquery' ], '', true );
    };
    wp_enqueue_script( 'vivus', EDUVALT_THEME_JS_DIR . 'vivus.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'wow', EDUVALT_THEME_JS_DIR . 'wow.min.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'aos', EDUVALT_THEME_JS_DIR . 'aos.js', [ 'jquery' ], '', true );
    wp_enqueue_script( 'eduvalt-main', EDUVALT_THEME_JS_DIR . 'main.js', [ 'jquery' ], false, true );

    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
}
add_action( 'wp_enqueue_scripts', 'eduvalt_scripts' );

/*
Register Fonts
*/
function eduvalt_fonts_url() {
    $font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
    */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'eduvalt' ) ) {
        $font_url = add_query_arg( array(
            'family' => 'Hind:wght@400,500,600,700|Lexend+Deca:wght@400,500,600,700,800',
            'display' => 'swap',
        ), '//fonts.googleapis.com/css' );
    }

    return $font_url;
}