<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package eduvalt
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <?php if (is_singular() && pings_open(get_queried_object())) : ?>
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <?php wp_body_open(); ?>


    <?php
        $eduvalt_preloader = get_theme_mod('eduvalt_preloader', false);
        $eduvalt_backtotop = get_theme_mod('eduvalt_backtotop', false);
    ?>


    <?php if (!empty($eduvalt_preloader)) : ?>
        <!-- Preloader -->
        <div id="preloader">
            <div class="spinner">
                <div class="rect1"></div>
                <div class="rect2"></div>
                <div class="rect3"></div>
                <div class="rect4"></div>
                <div class="rect5"></div>
            </div>
        </div>
        <!-- Preloader-end -->
    <?php endif; ?>

    <?php if (!empty($eduvalt_backtotop)) : ?>
        <!-- Scroll-top -->
        <button class="scroll__top scroll-to-target" data-target="html" aria-label="Scroll to top">
            <i class="tg-flaticon-arrowhead-up"></i>
        </button>
        <!-- Scroll-top-end-->
    <?php endif; ?>

    <?php do_action('eduvalt_header_style'); ?>

    <!-- main-area -->
    <main class="main-area fix">

        <?php do_action('eduvalt_before_main_content'); ?>