<?php

/**
 * The interface for the float column.
 *
 * @since 3.0.0
 *
 * @package \TEC\Common\StellarWP\Schema\Columns
 */
declare (strict_types=1);
namespace TEC\Common\StellarWP\Schema\Columns;

use TEC\Common\StellarWP\Schema\Columns\Contracts\Column;
use TEC\Common\StellarWP\Schema\Columns\Contracts\Lengthable;
use TEC\Common\StellarWP\Schema\Columns\Contracts\Signable;
use TEC\Common\StellarWP\Schema\Columns\Contracts\Precisionable;
use TEC\Common\StellarWP\Schema\Columns\Contracts\Uniquable;
use TEC\Common\StellarWP\Schema\Columns\PHP_Types;
use TEC\Common\StellarWP\Schema\Columns\Column_Types;
/**
 * Class Float_Column
 *
 * @since 3.0.0
 *
 * @package \TEC\Common\StellarWP\Schema\Columns
 */
class Float_Column extends Column implements Lengthable, Signable, Precisionable, Uniquable
{
    /**
     * The length of the column.
     *
     * @var int
     */
    private int $length = 20;
    /**
     * The precision of the column.
     *
     * @var int
     */
    private int $precision = 2;
    /**
     * Whether the column is signed.
     *
     * @var bool
     */
    private bool $signed = true;
    /**
     * The default value of the column.
     *
     * @var float
     */
    protected $default = null;
    /**
     * The type of the column.
     *
     * @var string
     */
    protected string $type = Column_Types::DECIMAL;
    /**
     * The PHP type of the column.
     *
     * @var string
     */
    protected string $php_type = PHP_Types::FLOAT;
    /**
     * Get the precision of the column.
     *
     * @return int The precision of the column.
     */
    public function get_precision(): int
    {
        return $this->precision;
    }
    /**
     * Get the signed of the column.
     *
     * @return bool Whether the column is signed.
     */
    public function get_signed(): bool
    {
        return $this->signed;
    }
    /**
     * Get the length of the column.
     *
     * @return int The length of the column.
     */
    public function get_length(): int
    {
        return $this->length;
    }
    /**
     * Set the precision of the column.
     *
     * @param int $precision The precision of the column.
     *
     * @return self
     */
    public function set_precision(int $precision): self
    {
        $this->precision = $precision;
        return $this;
    }
    /**
     * Set the signed of the column.
     *
     * @param bool $signed Whether the column is signed.
     *
     * @return self
     */
    public function set_signed(bool $signed): self
    {
        $this->signed = $signed;
        return $this;
    }
    /**
     * Set the length of the column.
     *
     * @param int $length The length of the column.
     *
     * @return self
     */
    public function set_length(int $length): self
    {
        $this->length = $length;
        return $this;
    }
    /**
     * Get the supported column types.
     *
     * @return string[] The supported column types.
     */
    protected function get_supported_column_types(): array
    {
        return Column_Types::SUPPORTED_FLOAT;
    }
    /**
     * Get the supported PHP types.
     *
     * @return string[] The supported PHP types.
     */
    protected function get_supported_php_types(): array
    {
        return [PHP_Types::FLOAT];
    }
}