<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Working_Process extends Widget_Base {
	// widgets unique ID
	public function get_name() {
		return 'working-process';
	}

	// widgets title
	public function get_title() {
		return 'Working Process';
	}

	// widgets Icon
	public function get_icon() {
		return 'eicon-info-box';
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Working Process', 'eduvalt' ),   //section name for controler view
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
            'working_process_icons', [
                'label' => __( 'Icon', 'eduvalt' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
            ]
        );

		$repeater->add_control(
			'working_process_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Title', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'working_process_subtitle',
			[
				'label' => esc_html__( 'Sub Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Sub Title', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'working_process_desc',
			[
				'label' => esc_html__( 'Description', 'eduvalt' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __( 'Description', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'working_process_active',
			[
				'label' => __( 'Active Item', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
			    'default' => 'no',
			    'options' => [
			     	'no'   => __( 'No', 'eduvalt' ),
			     	'yes'   => __( 'Yes', 'eduvalt' ),
			    ],
			    'label_block' => true,
			]
		);

		$repeater->add_control(
			'working_process_anim',
			[
				'label' => __( 'Select Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
			]
		);

		$repeater->add_control(
			'working_process_anim_delay',
			[
				'label' => __( 'Animation Delay', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'working_process_list',
			[
				'label' => __( 'Repeater List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'working_process_title'  => __( 'Title One', 'eduvalt' ),
						'working_process_subtitle'  => __( 'Sub Title One', 'eduvalt' ),
					],
					[
						'working_process_title'  => __( 'Title Two', 'eduvalt' ),
						'working_process_subtitle'  => __( 'Sub Title Two', 'eduvalt' ),
					],
					[
						'working_process_title'  => __( 'Title Three', 'eduvalt' ),
						'working_process_subtitle'  => __( 'Sub Title Three', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ working_process_title }}}',
			]
		);
 
        $this->add_control(
            'work_bg_shape',
            [
                'label' => esc_html__( 'Work Process Image', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


		$this->end_controls_section();
		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Item Styling
		========================================*/
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'eduvalt' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title text color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .features-item-two .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .features-item-two .title',
			]
		);

		$this->add_responsive_control(
			'content_color',
			[
				'label' => __( 'Content Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#999999',
				'selectors' => [
					'{{WRAPPER}} .features-item-two p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Content Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .features-item-two p',
			]
		);
	}
	//end of control box 

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
            <div class="work-process-wrap wow fadeInRight" data-wow-delay=".2s">
                <div class="work-process-list">
                    <ul class="nav nav-tabs list-wrap" id="myTab" role="tablist">
		            	<?php
		            	$active = 'active';
		            	$area_selected = 'true';
		            	$flag = 1;
		            	foreach ( $settings['working_process_list'] as $key => $value ) {
		            		$title = strtolower( $value['working_process_title'] );
		            		if ( $flag > 1 ) {
		            			$active = '';
		            			$area_selected = 'false';
		            		}
		            		$flag++;
		            	?>
		                	<li class="nav-item" role="presentation">
		                    	<button class="nav-link <?php echo esc_attr( $active ); ?>" id="<?php echo esc_attr( $title ); ?>-tab" data-toggle="tab" href="#<?php echo esc_attr( $title ); ?>" role="tab" aria-controls="<?php echo esc_attr( $title ); ?>" aria-selected="<?php echo esc_attr( $area_selected ); ?>">
	                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 177.4 197.4">
	                                    <path d="M0,58.4v79.9c0,6.5,3.5,12.6,9.2,15.8l70.5,40.2c5.6,3.2,12.4,3.2,18,0l70.5-40.2c5.7-3.2,9.2-9.3,9.2-15.8V58.4 c0-6.5-3.5-12.6-9.2-15.8L97.7,2.4c-5.6-3.2-12.4-3.2-18,0L9.2,42.5C3.5,45.8,0,51.8,0,58.4z">
	                                    </path>
	                                </svg>
	                                <span class="icon">
	                                    <i class="<?php echo $value['working_process_icons']; ?>"></i>
	                                </span>
		                    	</button>
		                	</li>
		            	<?php } ?>
                    </ul>

                    <div class="tab-content" id="myTabContent">
		            	<?php
		            	$flag = 1;
		            	$active_class = 'show active';
		            	foreach ( $settings['working_process_list'] as $key => $value ) { 
		            		$title = strtolower( $value['working_process_title'] );
		            		if ( $flag > 1 ) {
		            			$active_class = '';
		            		}
		            		$flag++;
		            	?>
	                    <div class="tab-pane fade <?php echo esc_attr( $active_class ); ?>" id="<?php echo esc_attr( $title ); ?>" role="tabpanel" aria-labelledby="<?php echo esc_attr( $title ); ?>-tab">
                            <div class="circle-content-wrap">
                                <h2 class="title"><span><?php echo esc_html( $value['working_process_title'] ); ?></span><?php echo esc_html( $value['working_process_subtitle'] ); ?></h2>
                                <p><?php echo esc_html( $value['working_process_desc'] ); ?></p>
                            </div>
	                    </div>
		            	<?php } ?>
                    </div>
                </div>
            </div>

		<?php
	}
}