<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Video_Area_Section extends Widget_Base {

	public function get_name() {
		return 'video-area-section';
	}

	// title to show on eduvalt
	public function get_title() {
		return 'Video Area Section';
	}

	public function get_icon() {
		return 'fal fa-play-circle'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Video Area Section', 'eduvalt' ),   //section name for controler view
			]
		);

        // Title 
        $this->add_control(
            'style3_section_title1',
            [
                'label' => esc_html__( 'Title First', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Online Learning Courses Designed For Real Life', 'eduvalt' ),
            ]
        );

        $this->add_control(
            'style3_sec_sub_title',
            [
                'label' => esc_html__( 'Sub Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Unique online courses', 'eduvalt' ),
            ]
        );

        $this->add_control(
            'style3_sec_description',
            [
                'label' => esc_html__( 'Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Borem ipsum dolor sit amet, consectetur adipiscing eliawe awUt elit ellus, luctus nec ullamcorper mattisBorem ipsum dolor awes atnse awctetur.', 'eduvalt' ),
            ]
        );

        $this->add_control(
            'section_about_btn1_text',
            [
                'label' => esc_html__( 'Button One Text', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'See All Categories', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_btn1_link',
            [
                'label' => __( 'Link', 'eduvalt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'video_bg_thumb',
            [
                'label' => esc_html__( 'Video Image', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_bg_icon',
            [
                'label' => esc_html__( 'Video Icon Image', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


		$this->end_controls_section();

		$this->start_controls_section(
			'section_students',
			[
				'label' => esc_html__( 'All Studens', 'eduvalt' ),
			]
		);

        $this->add_control(
            'student_title',
            [
                'label' => esc_html__( 'Student Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '36k+', 'eduvalt' ),
            ]
        );

        $this->add_control(
            'student_sub_title',
            [
                'label' => esc_html__( 'Student Sub', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Enrolled Students', 'eduvalt' ),
            ]
        );

        $this->add_control(
            'video_student_icon_1',
            [
                'label' => esc_html__( 'Video Student One', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_student_icon_2',
            [
                'label' => esc_html__( 'Video Student Two', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_student_icon_3',
            [
                'label' => esc_html__( 'Video Student Three', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_student_icon_4',
            [
                'label' => esc_html__( 'Video Student Four', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_student_icon_5',
            [
                'label' => esc_html__( 'Video Student Five', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_student_icon_6',
            [
                'label' => esc_html__( 'Video Student Six', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


		$this->end_controls_section();




        $this->start_controls_section(
            'section_icons',
            [
                'label' => esc_html__( 'All Icons', 'eduvalt' ),
            ]
        );

        $this->add_control(
            'video_shape_icon_1',
            [
                'label' => esc_html__( 'Video Shape One', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_shape_icon_2',
            [
                'label' => esc_html__( 'Video Shape Two', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_shape_icon_3',
            [
                'label' => esc_html__( 'Video Shape Three', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_shape_icon_4',
            [
                'label' => esc_html__( 'Video Shape Four', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'video_shape_icon_5',
            [
                'label' => esc_html__( 'Video Shape Five', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->end_controls_section();






		// $this->start_controls_section(
		// 	'section_image_overlay',
		// 	[
		// 		'label' => esc_html__( 'Image Overlay', 'eduvalt' ),
		// 	]
		// );
		// $this->add_control(
		// 	'video_link',
		// 	[
		// 		'label' => esc_html__( 'Video link', 'eduvalt' ),
		// 		'type' => Controls_Manager::TEXT,
		// 		'label_block' => true,
		// 		'placeholder' => esc_html__( 'Enter your URL', 'eduvalt' ) . ' (YouTube)',
		// 		'default' => 'https://www.youtube.com/watch?v=XHOmBV4js_E',
		// 	]
		// );
		// $this->add_control(
		// 	'video_icon',
		// 	[
		// 		'label' => esc_html__( 'Video icon', 'eduvalt' ),
		// 		'type' => Controls_Manager::ICON,
		// 		'label_block' => true,
		// 		'default' => 'fas fa-play',
		// 	]
		// );
		// $this->add_control(
		// 	'image_overlay',
		// 	[
		// 		'label' => esc_html__( 'Choose Image', 'eduvalt' ),
		// 		'type' => Controls_Manager::MEDIA,
		// 		'default' => [
		// 			'url' => Utils::get_placeholder_image_src(),
		// 		],
		// 	]
		// );

		// $this->end_controls_section();

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Section Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_responsive_control(
            'video_area_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .skill-content .section-title.title-style-four h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_area_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .skill-content .section-title.title-style-four span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_area_content_color',
            [
                'label' => __( 'Content Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .skill-content p' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'section_style_margin',
            [
                'label' => esc_html__('Section Margin', 'eduvalt'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [
                    'top' => 75,
                    'right' => 0,
                    'bottom' => 80,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

        /* = Progress Bar Styling
        ========================================*/
        $this->start_controls_section(
            'section_progress_bar_style',
            [
                'label' => esc_html__( 'Progress Bar Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'video_area_progress_bg_color',
            [
                'label' => __( 'Default Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .progress-item .progress' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_area_progress_bgac_color',
            [
                'label' => __( 'Active Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .progress-item .progress-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_area_progress_content_color',
            [
                'label' => __( 'Content Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .progress-item .title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .skill-area .progress-item .progress-bar span' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

        /* = Progress Video Styling
        ========================================*/
        $this->start_controls_section(
            'section_progress_video_style',
            [
                'label' => esc_html__( 'Video Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'progress_video_bg_color',
            [
                'label' => __( 'Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .video-bg .play-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'progress_video_icon_color',
            [
                'label' => __( 'Icon Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-area .video-bg .play-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

	}
	//end of control box 

	//to show on the fontend
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

            <div class="container tg-motion-effects">
                <div class="row align-items-center">
                    <div class="col-xl-7 col-lg-7">
                        <div class="online__image-wrap">
                            <?php if (!empty($settings['video_bg_thumb']['url'])): ?>
                                <div class="main-img">
                                    <img src="<?php echo $settings['video_bg_thumb']['url']; ?>" alt="img">
                                </div>
                            <?php endif; ?>
                            <div class="enrolled__students position-absolute">
                                <p><span><?php echo $settings['student_title']; ?></span> <?php echo $settings['student_sub_title']; ?></p>
                                <ul class="list-wrap">
                                    <?php if (!empty($settings['video_student_icon_1']['url'])): ?>
                                        <li><img src="<?php echo $settings['video_student_icon_1']['url']; ?>" alt="img"></li>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['video_student_icon_2']['url'])): ?>
                                        <li><img src="<?php echo $settings['video_student_icon_2']['url']; ?>" alt="img"></li>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['video_student_icon_3']['url'])): ?>
                                        <li><img src="<?php echo $settings['video_student_icon_3']['url']; ?>" alt="img"></li>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['video_student_icon_4']['url'])): ?>
                                        <li><img src="<?php echo $settings['video_student_icon_4']['url']; ?>" alt="img"></li>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['video_student_icon_5']['url'])): ?>
                                        <li><img src="<?php echo $settings['video_student_icon_5']['url']; ?>" alt="img"></li>
                                    <?php endif; ?>
                                    <?php if (!empty($settings['video_student_icon_6']['url'])): ?>
                                        <li><img src="<?php echo $settings['video_student_icon_6']['url']; ?>" alt="img"></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                            <?php if (!empty($settings['video_bg_icon']['url'])): ?>
                                <img src="<?php echo $settings['video_bg_icon']['url']; ?>" alt="img" class="icons position-absolute">
                            <?php endif; ?>
                            <?php if (!empty($settings['video_shape_icon_1']['url'])): ?>
                                <img src="<?php echo $settings['video_shape_icon_1']['url']; ?>" alt="shape" class="left-shape position-absolute tg-motion-effects3">
                            <?php endif; ?>
                            <?php if (!empty($settings['video_shape_icon_2']['url'])): ?>
                                <img src="<?php echo $settings['video_shape_icon_2']['url']; ?>" alt="shape" class="top-shape position-absolute tg-motion-effects4">
                            <?php endif; ?>
                            <?php if (!empty($settings['video_shape_icon_3']['url'])): ?>
                                <img src="<?php echo $settings['video_shape_icon_3']['url']; ?>" alt="shape" class="svg-shape position-absolute tg-motion-effects6">
                            <?php endif; ?>
                            <?php if (!empty($settings['video_shape_icon_4']['url'])): ?>
                                <img src="<?php echo $settings['video_shape_icon_4']['url']; ?>" alt="shape" class="bottom-shape position-absolute tg-motion-effects3">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-5">
                        <div class="online__content">
                            <div class="section__title">
                                <span class="sub-title"><?php echo $settings['style3_sec_sub_title']; ?></span>
                                <h2 class="title"><?php echo $settings['style3_section_title1']; ?></h2>
                            </div>
                            <p><?php echo $settings['style3_sec_description']; ?></p>
                            <div class="tg-button-wrap">
                                <a href="<?php echo esc_url( $settings['section_about_btn1_link']['url'] ); ?>" class="btn tg-svg"><span class="text"><?php echo esc_html( $settings['section_about_btn1_text'] ); ?></span> <span class="svg-icon" id="online-btn" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
                            </div>
                            <?php if (!empty($settings['video_shape_icon_5']['url'])): ?>
                                <img src="<?php echo $settings['video_shape_icon_5']['url']; ?>" alt="shape" class="right-shape position-absolute tg-motion-effects5">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

		<?php
	}
}