<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Tutor_Course_Categoreis extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-tutor-course-categories';
	}

	public function get_title() {
		return 'Tutor Course Categories';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-quote-left';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}
   
   public function get_script_depends() {
		return [ 'eduvalt-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Tutor Course Categories', 'eduvalt' ),   //section name for controler view
			]
		);
        $this->add_control(
            'section_about_title',
            [
                'label' => esc_html__( 'Section Title First', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Our', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_middle',
            [
                'label' => esc_html__( 'Section Title Middle', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Featured', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_last',
            [
                'label' => esc_html__( 'Section Title Last', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Courses', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_sub_title',
            [
                'label' => esc_html__( 'Section Sub Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Unique online courses.', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_main_description',
            [
                'label' => esc_html__( 'Section Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Borem ipsum dolor sit amet, consectetur adipiscing eliawe awut elit ellus, luctus nec ullamcorper mattisBorem ipsum dolor awes atnse awctetur.', 'eduvalt'),
                'label_block' => true,
            ]
        );

		$this->add_control(
			  'case_grid_styles',
			  [
			     'label'   => __( 'Categories Style', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'style1',
			     'options' => [
					'style1' => __( 'Categories Style 1', 'eduvalt' ),
					'style2' => __( 'Categories Style 2', 'eduvalt' ),
					'style3' => __( 'Categories Style 3', 'eduvalt' ),
			     ],
			  ]
		);
		$this->add_control(
			'categories_portfolio',
			[
				'label' => __( 'Select Categories', 'eduvalt' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => eduvalt_get_terms_dropdown_array([
					'taxonomy' => 'course-category',
					'hide_empty' => true
				]),
				'label_block' => true,
			]
		);
		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Categories', 'eduvalt' ),
				'description' => esc_html__( 'Give -1 for all post', 'eduvalt' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
			]
		);
		$this->add_control(
			'grid_columns',
			[
			    'label'       => __( 'Case Grid columns', 'eduvalt' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'eduvalt' ),
			     	'4'   => __( '3', 'eduvalt' ),
			     	'3'   => __( '4', 'eduvalt' ),
			    ],
			]
		);
		$this->add_control(
			'orderby',
			[
				'label' => __( 'Order by', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);
		$this->add_control(
			'order',
			[
				'label' => __( 'Order', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'eduvalt' ),
					'DESC' => __( 'Descending', 'eduvalt' ),
				],
			]
		);


        $this->add_control(
            'cat_bg_shape',
            [
                'label' => esc_html__( 'Shape Image 1', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'cat_bg_shape2',
            [
                'label' => esc_html__( 'Shape Image 2', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'cat_bg_shape3',
            [
                'label' => esc_html__( 'Shape Image 3', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'cat_bg_shape4',
            [
                'label' => esc_html__( 'Shape Image 4', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_style',
			[
				'label' => esc_html__( 'Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'casegrid_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .projects-area-three .project-content-three .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);
		$this->add_control(
			'casegrid_title_hover_color',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .projects-area-three .project-content-three .title a:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .projects-area-three .project-content-three .title',
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);


		$this->add_control(
			'casegrid_items2_color',
			[
				'label' => __( 'Item Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two::before' => 'background: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->add_control(
			'casegrid_title2_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two .project-content-two .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);
		$this->add_control(
			'casegrid_title2_hover_color',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two .project-content-two .title a:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title2_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .project-item-two .project-content-two .title',
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);



		$this->end_controls_section();

		$this->start_controls_section(
			'casegrid_sub_title_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'casegrid_sub_title_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .projects-area-three .project-content-three span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .projects-area-three .project-content-three span',
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);
		$this->add_control(
			'casegrid_sub_title2_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two .project-content-two span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title2_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .project-item-two .project-content-two span',
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();


		if ( function_exists('tutor')) {

		if( !empty( $settings['categories_portfolio'] ) ){
			$category = !empty( $settings['categories_portfolio'] ) ? $settings['categories_portfolio'] : 'All';
	    	$args = array(
				'post_type'      => 'courses',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['orderby'],
	            'tax_query'     => array(
	                array(
	                    'taxonomy'  => 'course-category',
	                    'field'     => 'id', 
	                    'terms'     => $category
	                )
	            )
	    	);
		}else{
	    	$args = array(
				'post_type'      => 'courses',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['orderby'],
	    	);
		}

		$e_uniqid     = uniqid();
		$randID = wp_rand();

		$grid_query= null;		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : ?>
			<?php if( 'style3' == $settings['case_grid_styles'] ){ ?>
                <div class="row justify-content-center row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xl-4">
	                <?php 
	                	$categories = get_terms( array(
	                        'taxonomy' => 'course-category',
	                        'hide_empty' => false,
	                        'number' => $settings['post_number'],
	                    ) );

                        foreach($categories as $category) {
                        	$category_id = $category->term_id;
                        	$category_slug = $category->slug;
							$thumbnail_id = absint( get_term_meta( $category->term_id, 'thumbnail_id', true ) );

							if ( $thumbnail_id ) {
								$image = wp_get_attachment_image_src( $thumbnail_id, 'full' );
							}

						    $query = new \WP_Query(array(
						        'post_type' => 'courses',
						        'post_status' => 'publish',
						        'tax_query' => array(
						            array(
						                'taxonomy' => 'course-category',
						                'field' => 'term_id',
						                'terms' => $category_id,
						            ),
						        ),
						    ));

						    $post_count = $query->found_posts;
						?>
	                    <div class="col">
	                        <div class="categories__item-three">
	                            <a href="<?php echo get_term_link($category_slug, 'course-category'); ?>">
	                                <div class="thumb">
	                                    <img src="<?php echo esc_url( $image[0] ); ?>" alt="<?php echo esc_attr( $category->name ); ?>">
	                                </div>
	                                <div class="info">
	                                    <div class="list"><span class="courses"><?php echo $post_count; ?> <?php echo esc_html( 'Courses', 'eduvalt' ); ?></span></div>
	                                    <div class="list"><span class="name"><?php echo $category->name; ?></span></div>
	                                </div>
	                            </a>
	                        </div>
	                    </div>
                    <?php } ?> 
                </div>
			<?php }elseif( 'style2' == $settings['case_grid_styles'] ){ ?>
                <div class="row justify-content-center row-cols-1 row-cols-sm-2 row-cols-md-3">
				<?php
					$categories = get_terms(array(
					    'taxonomy' => 'course-category',
					    'hide_empty' => false,
					    'number' => $settings['post_number'],
					));

					foreach ($categories as $category) {
					    $category_id = $category->term_id;
					    $category_name = $category->name;
					    $category_slug = $category->slug;

					    $query = new \WP_Query(array(
					        'post_type' => 'courses',
					        'post_status' => 'publish',
					        'tax_query' => array(
					            array(
					                'taxonomy' => 'course-category',
					                'field' => 'term_id',
					                'terms' => $category_id,
					            ),
					        ),
					    ));

					    $post_count = $query->found_posts;
					    ?>

					    <div class="col">
					        <div class="categories__item-two tg-svg">
					            <a href="<?php echo get_term_link($category_slug, 'course-category'); ?>">
					                <div class="icon">
					                    <span class="svg-icon" id="cat_svg1" data-svg-icon="assets/img/icons/categories_icon.svg"></span>
					                    <i class="flaticon-graphic-design"></i>
					                </div>
					                <div class="info">
					                    <span class="name"><?php echo $category_name; ?></span>
					                    <span class="courses"><?php echo $post_count; ?> <?php echo esc_html( 'Courses', 'eduvalt' ); ?></span>
					                </div>
					            </a>
					        </div>
					    </div>
				<?php } ?>
                </div>
			<?php } else{ ?>
		        <section class="categories-area section-py-130">
		            <div class="container">
		                <div class="row align-items-center justify-content-center">
		                    <div class="col-xl-5 col-lg-8 col-md-10">
		                        <div class="categories__title-wrap text-center text-xl-start">
		                            <div class="section__title">
		                                <span class="sub-title"><?php echo esc_html( $settings['section_sub_title'] ); ?></span>
		                                <h2 class="title tg-svg"><?php echo esc_html( $settings['section_about_title'] ); ?> <span class="position-relative"><span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo esc_html( $settings['section_about_title_middle'] ); ?></span></h2>
		                            </div>
		                            <p><?php echo esc_html( $settings['section_main_description'] ); ?></p>
		                            <div class="tg-button-wrap justify-content-center justify-content-xl-start">
		                                <a href="courses.html" class="btn btn-border tg-svg"><span class="text">All Categories</span> <span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="assets/img/icons/btn-arrow.svg"></span></a>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="col-xl-7 col-lg-9">
		                        <div class="categories__wrap">
		                            <img src="<?php echo $settings['cat_bg_shape3']['url']; ?>" alt="shape" data-aos="fade-right">
		                            <img src="<?php echo $settings['cat_bg_shape4']['url']; ?>" alt="shape" data-aos="fade-left">

								    <div class="row justify-content-center row-cols-2 row-cols-md-3">
								        <?php
								        $categories = get_terms(array(
								            'taxonomy' => 'course-category',
								            'hide_empty' => false,
								            'number' => $settings['post_number'],
								        ));

								        $count = 0;
								        foreach ($categories as $category) {
								            $category_id = $category->term_id;
								            $category_name = $category->name;
								            $category_slug = $category->slug;

								            $query = new \WP_Query(array(
								                'post_type' => 'courses',
								                'post_status' => 'publish',
								                'tax_query' => array(
								                    array(
								                        'taxonomy' => 'course-category',
								                        'field' => 'term_id',
								                        'terms' => $category_id,
								                    ),
								                ),
								            ));

								            $post_count = $query->found_posts;
								            $count++;
								            $div_class = ($count <= 2) ? 'col-6' : 'col-12';
								        ?>
								        <div class="<?php echo $div_class; ?>">
								            <div class="categories__item">
								                <a href="courses.html">
								                    <i class="flaticon-graphic-design"></i>
								                    <span class="name"><?php echo $category_name; ?></span>
								                    <span class="courses"><?php echo $post_count; ?> <?php echo esc_html( 'Courses', 'eduvalt' ); ?></span>
								                </a>
								            </div>
								        </div>
								        <?php
								            if ($count == 2) {
								                echo '</div><div class="row justify-content-center row-cols-2 row-cols-sm-3">';
								            }
								        ?>
								        <?php } ?>
								    </div>
		                        </div>
		                    </div>
		                </div>
		            </div>
		            <div class="categories__shapes">
		                <div class="categories__shapes-item rotateme"><img src="<?php echo $settings['cat_bg_shape']['url']; ?>" alt="Cta Shape"></div>
		                <div class="categories__shapes-item" data-aos="fade-up"><img src="<?php echo $settings['cat_bg_shape2']['url']; ?>" alt="Shape"></div>
		            </div>
		        </section>
			<?php } ?>
		<?php endif;

		}
	}
}