<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Testimonial extends Widget_Base {

	public function get_name() {
		return 'section_testimonial';
	}

	public function get_title() {
		return 'Testimonial Section';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//section name for controler view
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Testimonial Section', 'eduvalt' ),
			]
		);


		// Title 
		$this->add_control(
			'style3_section_title1',
			[
				'label' => esc_html__( 'Title First', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'What Our ', 'eduvalt' ),
			]
		);
		// Title 
		$this->add_control(
			'style3_section_title2',
			[
				'label' => esc_html__( 'Title Middle', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Students', 'eduvalt' ),
			]
		);
		// Title 
		$this->add_control(
			'style3_section_title3',
			[
				'label' => esc_html__( 'Title Last', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Say About Us', 'eduvalt' ),
			]
		);


		$this->add_control(
			  'testimonial_styles',
			  [
			     'label'   => __( 'Testimonial Style', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'style1',
			     'options' => [
					'style1' => __( 'Grid Style 1', 'eduvalt' ),
					'style2' => __( 'Grid Style 2', 'eduvalt' ),
			     ],
			  ]
		);



		$repeater = new Repeater();

		$repeater->add_control(
			'testimonial_item_desc',
			[
				'label' => esc_html__( 'Description', 'eduvalt' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __( '', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'testimonial_item_name',
			[
				'label' => esc_html__( 'Name', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'testimonial_item_designation',
			[
				'label' => esc_html__( 'Designation', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '', 'eduvalt' ),
			]
		);
		$repeater->add_control(
			'testimonial_item_thumb',
			[
				'label' => esc_html__( 'Image', 'eduvalt' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'testimonial_list',
			[
				'label' => __( 'Testimonial List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'testimonial_item_name'  => __( 'Title One', 'eduvalt' ),
					],
					[
						'testimonial_item_name'  => __( 'Title Two', 'eduvalt' ),
					],
					[
						'testimonial_item_name'  => __( 'Title Three', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ testimonial_item_name }}}',
			]
		);
		
		$this->end_controls_section();

		//section name for controler view
		$this->start_controls_section(
			'section_images_content',
			[
				'label' => esc_html__( 'Testimonial Images', 'eduvalt' ),
			]
		);

        $this->add_control(
            'testimonial_shape_1',
            [
                'label' => esc_html__( 'Shape One', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'testimonial_shape_2',
            [
                'label' => esc_html__( 'Shape Two', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'testimonial_shape_3',
            [
                'label' => esc_html__( 'Shape Three', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

		$this->end_controls_section();



		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'full_imgstyle',
			[
				'label' => esc_html__( 'Testimonial Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'slide_item_bg_color',
			[
				'label' => __( 'Item Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-item-two' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'slide_item_text_color',
			[
				'label' => __( 'Item Content Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-item-two .testimonial-content p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'slide_item_name_color',
			[
				'label' => __( 'Item Name Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-item-two .avatar-content .title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'slide_item_designation_color',
			[
				'label' => __( 'Item Designation Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-item-two .avatar-content span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'slide_item_icons_color',
			[
				'label' => __( 'Item Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-item-two .testimonial-icon' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 
		$settings = $this->get_settings_for_display();
		$eduvalt_rtl_check = is_rtl() ?  'true' : 'false';
		$e_uniqid     = uniqid();

		?>

	    <?php if ( $settings['testimonial_styles'] == 'style2' ) { ?>
			<script type="text/javascript">
			    jQuery(document).ready(function(){
					jQuery('.testimonial-active').slick({
						dots: false,
						infinite: true,
						speed: 600,
						autoplay: false,
						arrows: true,
						rtl: <?php echo $eduvalt_rtl_check; ?>,
						slidesToShow: 1,
						slidesToScroll: 1,
					    prevArrow: '<button type="button" class="slick-prev" aria-label="Previous testimonial"><i class="flaticon-chevron"></i></button>',
					    nextArrow: '<button type="button" class="slick-next" aria-label="Next testimonial"><i class="flaticon-chevron"></i></button>',
						responsive: [
							{
								breakpoint: 1200,
								settings: {
									slidesToShow: 1,
									slidesToScroll: 1,
									infinite: true,
								}
							},
							{
								breakpoint: 992,
								settings: {
									slidesToShow: 1,
									slidesToScroll: 1
								}
							},
							{
								breakpoint: 767,
								settings: {
									slidesToShow: 1,
									slidesToScroll: 1,
									arrows: false,
								}
							},
							{
								breakpoint: 575,
								settings: {
									slidesToShow: 1,
									slidesToScroll: 1,
									arrows: false,
								}
							},
						]
					});
			    });
			</script>

	        <?php if ( $settings['testimonial_list'] ) { ?>
	            <div class="testimonial-active">
	            	<?php foreach ( $settings['testimonial_list'] as $key => $value ) { ?>
	                    <div class="testimonial__item">
	                        <div class="testimonial__quote">
	                            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/icons/quote02.png" alt="icon">
	                        </div>
	                        <div class="testimonial__rating">
	                            <i class="fas fa-star"></i>
	                            <i class="fas fa-star"></i>
	                            <i class="fas fa-star"></i>
	                            <i class="fas fa-star"></i>
	                            <i class="fas fa-star"></i>
	                        </div>
	                        <p><?php echo esc_html( $value['testimonial_item_desc'] ); ?></p>
	                        <div class="testimonial__avatar">
	                            <h4 class="name"><?php echo esc_html( $value['testimonial_item_name'] ); ?></h4>
	                            <span class="designation"><?php echo esc_html( $value['testimonial_item_designation'] ); ?></span>
	                        </div>
	                    </div>
	                <?php } ?>
	            </div>
	    	<?php } ?>
    	<?php }else{ ?>
			<script type="text/javascript">
			    jQuery(document).ready(function(){
					 jQuery('.testimonial__content-active-<?php echo $e_uniqid; ?>').slick({
					    slidesToShow: 1,
					    slidesToScroll: 1,
					    arrows: true,
					    rtl: <?php echo $eduvalt_rtl_check; ?>,
					    dots: false,
					    asNavFor: '.testimonial__image-active-<?php echo $e_uniqid; ?>',
					    prevArrow: '<button type="button" class="slick-prev" aria-label="Previous testimonial"><i class="flaticon-chevron"></i></button>',
					    nextArrow: '<button type="button" class="slick-next" aria-label="Next testimonial"><i class="flaticon-chevron"></i></button>',
					    appendArrows: '.testimonial__content-nav',
					});
					jQuery('.testimonial__image-active-<?php echo $e_uniqid; ?>').slick({
					    slidesToShow: 1,
					    slidesToScroll: 1,
					    asNavFor: '.testimonial__content-active-<?php echo $e_uniqid; ?>',
					    dots: false,
					    arrows: false,
					    rtl: <?php echo $eduvalt_rtl_check; ?>,
					    fade: true,
					    focusOnSelect: true
					});
			    });
			</script>
	        <?php if ( $settings['testimonial_list'] ) { ?>
	        	<section class="testimonial-area testimonial-bg">
	                <div class="row align-items-xl-center">
	                    <div class="col-lg-5 col-md-7 col-sm-9">
	                        <div class="testimonial__image-wrapper position-relative">
	                            <div class="testimonial__image-active-<?php echo $e_uniqid; ?>">
	                            	<?php foreach ( $settings['testimonial_list'] as $key => $value ) { ?>
	                            		<?php if (!empty($value['testimonial_item_thumb']['url'])): ?>
			                                <div class="testimonial__image-item">
			                                    <img src="<?php echo esc_attr( $value['testimonial_item_thumb']['url'] ); ?>" alt="img">
			                                </div>
	                                	<?php endif; ?>
	                                <?php } ?>
	                            </div>
	                            <div class="testimonial__shapes">
	                            	<?php if (!empty($settings['testimonial_shape_1']['url'])): ?>
	                                	<img src="<?php echo $settings['testimonial_shape_1']['url']; ?>" alt="shape" data-aos="fade-up-left" data-aos-delay="300">
	                                <?php endif; ?>
	                            	<?php if (!empty($settings['testimonial_shape_2']['url'])): ?>
	                                <img src="<?php echo $settings['testimonial_shape_2']['url']; ?>" alt="shape" data-aos="fade-up-right" data-aos-delay="300">
	                                <?php endif; ?>
	                            	<?php if (!empty($settings['testimonial_shape_3']['url'])): ?>
	                                <img src="<?php echo $settings['testimonial_shape_3']['url']; ?>" alt="shape" class="rotateme">
	                                <?php endif; ?>
	                            </div>
	                        </div>
	                    </div>
	                    <div class="col-lg-7">
	                        <div class="testimonial__content-wrapper">
	                            <div class="section__title white-title mb-40">
	                                <h2 class="title tg-svg"><?php echo $settings['style3_section_title1']; ?><span class="position-relative"><span class="svg-icon" id="svg-<?php echo $e_uniqid; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo $settings['style3_section_title2']; ?></span><br><?php echo $settings['style3_section_title3']; ?></h2>
	                            </div>
	                            <div class="testimonial__content-active-<?php echo $e_uniqid; ?>">
	                            	<?php foreach ( $settings['testimonial_list'] as $key => $value ) { ?>
		                                <div class="testimonial__content-item">
		                                    <div class="testimonial__content-icon">
		                                        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/icons/quote.png" alt="img">
		                                    </div>
		                                    <p>“ <?php echo esc_html( $value['testimonial_item_desc'] ); ?> ”</p>
		                                    <div class="testimonial__content-avatar">
		                                        <h5 class="name"><?php echo esc_html( $value['testimonial_item_name'] ); ?></h5>
		                                        <span class="designation"><?php echo esc_html( $value['testimonial_item_designation'] ); ?></span>
		                                    </div>
		                                </div>
	                            	<?php } ?>
	                            </div>
	                            <div class="testimonial__content-nav"></div>
	                        </div>
	                    </div>
	                </div>
	        	</section>
	    	<?php } ?>
    	<?php } ?>
	<?php 
	}
}