<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Promotion extends Widget_Base {
	// widgets unique ID
	public function get_name() {
		return 'section-promotion';
	}

	// widgets title
	public function get_title() {
		return 'Promotion Ads';
	}

	// widgets Icon
	public function get_icon() {
		return 'eicon-info-box';
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Promotion Ads', 'eduvalt' ),   //section name for controler view
			]
		);
		$this->add_control(
			'ads_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Best Instructors From Around The World', 'eduvalt' ),
			]
		);
		$this->add_control(
			'ads_button_title',
			[
				'label' => esc_html__( 'Button Text', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Register Now', 'eduvalt' ),
			]
		);
		$this->add_control(
			'ads_link',
			[
				'label' => __( 'Button Link', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);
        $this->add_control(
            'ads_bg_image',
            [
                'label' => esc_html__( 'Background Image', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

		$this->end_controls_section();
		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Item Styling
		========================================*/
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'eduvalt' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title text color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .quick__action-content .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .quick__action-content .title',
			]
		);

		$this->add_responsive_control(
			'content_color',
			[
				'label' => __( 'Content Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#999999',
				'selectors' => [
					'{{WRAPPER}} .features-item-two p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Content Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .features-item-two p',
			]
		);
	}
	//end of control box 

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
        $target1 = $settings['ads_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow1 = $settings['ads_link']['nofollow'] ? ' rel="nofollow"' : '';
        $randID = wp_rand();
		?>

        <div class="quick__action-item" style="background-image:url(<?php echo $settings['ads_bg_image']['url']; ?>)">
            <div class="quick__action-content">
                <h4 class="title"><?php echo esc_html( $settings['ads_title'] ); ?></h4>
                <div class="tg-button-wrap">
                    <a href="<?php echo $settings['ads_link']['url']; ?>" <?php echo $target1; ?> <?php echo $nofollow1; ?> class="btn white-btn tg-svg"><span class="text"><?php echo esc_html( $settings['ads_button_title'] ); ?></span> <span class="svg-icon" id="reg-btn-<?php echo esc_attr( $randID );?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
                </div>
            </div>
        </div>
		<?php
	}
}