<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Fun_Facts extends Widget_Base {
	// widgets unique ID
	public function get_name() {
		return 'fun-facts';
	}

	// widgets title
	public function get_title() {
		return 'Fun Facts';
	}

	// widgets Icon
	public function get_icon() {
		return 'eicon-info-box';
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Fun Facts', 'eduvalt' ),   //section name for controler view
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
            'fun_facts_icons', [
                'label' => __( 'Upload Images', 'eduvalt' ),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );

		$repeater->add_control(
			'fun_facts_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Title', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'fun_facts_subtitle',
			[
				'label' => esc_html__( 'Number', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '12', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'fun_facts_views',
			[
				'label' => esc_html__( 'Total Views', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'k', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'fun_facts_bgcolor',
			[
				'label' => esc_html__( 'Item Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'label_block' => true,
			]
		);

		$this->add_control(
			'fun_facts_list',
			[
				'label' => __( 'Repeater List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'fun_facts_title'  => __( 'Experience Tutors', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '12', 'eduvalt' ),
						'fun_facts_views'  => __( 'k+', 'eduvalt' ),
					],
					[
						'fun_facts_title'  => __( 'Enrolled Students', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '15', 'eduvalt' ),
						'fun_facts_views'  => __( 'M+', 'eduvalt' ),
					],
					[
						'fun_facts_title'  => __( 'Qualified Courses', 'eduvalt' ),
						'fun_facts_subtitle'  => __( '10', 'eduvalt' ),
						'fun_facts_views'  => __( 'k+', 'eduvalt' ),
					],
				],
				'title_field' => '{{{ fun_facts_title }}}',
			]
		);
 
        $this->add_control(
            'work_bg_shape',
            [
                'label' => esc_html__( 'Facts Shape', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


		$this->end_controls_section();
		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Item Styling
		========================================*/
		$this->add_control(
			'title_heading',
			[
				'label' => __( 'Title Style', 'eduvalt' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'title_color',
			[
				'label' => __( 'Title text color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .fact__content .count' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .fact__content .count',
			]
		);

		$this->add_responsive_control(
			'content_color',
			[
				'label' => __( 'Content Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .fact__content p' => 'color: {{VALUE}};',
				],
			]
		);
	}
	//end of control box 

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<?php if ( $settings['fun_facts_list'] ) : ?>
	        <section class="fact-area position-relative">
	            <div class="container">
	                <div class="row justify-content-center">
	                	<?php foreach ( $settings['fun_facts_list'] as $value ) { ?>
		                    <div class="col-lg-4 col-sm-6">
		                        <div class="fact__item text-center" style="background-color: <?php echo $value['fun_facts_bgcolor']; ?>;">
		                            <div class="fact__content">
		                                <h3 class="count"><span class="odometer" data-count="<?php echo $value['fun_facts_subtitle']; ?>"></span><?php echo $value['fun_facts_views']; ?></h3>
		                                <p><?php echo $value['fun_facts_title']; ?></p>
		                            </div>
		                            <?php if (!empty($value['fun_facts_icons']['url'])): ?>
			                            <div class="fact__img">
			                                <img src="<?php echo esc_attr( $value['fun_facts_icons']['url'] ); ?>" alt="img">
			                            </div>
		                        	<?php endif; ?>
		                        </div>
		                    </div>
	                	<?php } ?>
	                </div>
	            </div>
	            <?php if (!empty($settings['work_bg_shape']['url'])): ?>
		            <div class="fact__shapes">
		                <div class="categories__shapes-item rotateme">
		                    <img src="<?php echo $settings['work_bg_shape']['url'];?>" alt="shape">
		                </div>
		            </div>
	        	<?php endif; ?>
	        </section>
    	<?php endif; ?>
		<?php
	}
}