<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Slider_Banner_Three extends Widget_Base {

    public function get_name() {
        return 'slider-banner-three';
    }

    public function get_title() {
        return 'Banner Two';   // title to show on eduvalt
    }

    public function get_icon() {
        return 'fal fa-address-card'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
    }

    public function get_categories() {
        return [ 'eduvalt-elements' ];    // category of the widget
    }

    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/

    protected function register_controls() {
        
        //start of a control box
        $this->start_controls_section(
            'section_banner_content',
            [
                'label' => esc_html__( 'Banner Content', 'eduvalt' ),   //section name for controler view
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__( 'Title First', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Explore Your', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_title_middle',
            [
                'label' => esc_html__( 'Title Middle', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Skills', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_title_last',
            [
                'label' => esc_html__( 'Title Last', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'With Varieties of Courses', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn1_text',
            [
                'label' => esc_html__( 'Link Text', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'You can access 7,900+ different courses', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn1_link',
            [
                'label' => __( 'Link', 'eduvalt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'banner_background_img',
            [
                'label' => esc_html__( 'Banner Background Image', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();
        //End of a control box

        //start of a control box
        $this->start_controls_section(
            'section_banner_images',
            [
                'label' => esc_html__( 'Banner Images', 'eduvalt' ),   //section name for controler view
            ]
        );
        $this->add_control(
            'banner_main_img',
            [
                'label' => esc_html__( 'Main Image 1', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_main_img1',
            [
                'label' => esc_html__( 'Banner Image 2', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_main_img2',
            [
                'label' => esc_html__( 'Banner Image 3', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_main_img3',
            [
                'label' => esc_html__( 'Banner Shape 1', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_main_img4',
            [
                'label' => esc_html__( 'Banner Shape 2', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_main_img5',
            [
                'label' => esc_html__( 'Banner Shape 3', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'banner_main_img6',
            [
                'label' => esc_html__( 'Banner Shape 4', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();
        //End of a control box

        $this->start_controls_section(
            'banner_title_style',
            [
                'label' => esc_html__( 'Title Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .banner__content-two .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'banner_title_typography',
                'label' => __( 'Title Typography', 'eduvalt' ),
                'selector' => '{{WRAPPER}} .banner__content-two .title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'banner_sub_title_style',
            [
                'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .banner__search-form p a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'banner_sub_title_typography',
                'label' => __( 'Sub Title Typography', 'eduvalt' ),
                'selector' => '{{WRAPPER}} .banner__search-form p a',
            ]
        );

        $this->end_controls_section();

    }
    //end of control box 

    //to show on the fontend
    protected function render() {
        $settings = $this->get_settings_for_display();
        $target1 = $settings['banner_btn1_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow1 = $settings['banner_btn1_link']['nofollow'] ? ' rel="nofollow"' : '';
        $randID = wp_rand();

        ?>
        <section class="banner-area-two banner-bg-two" style="background-image:url(<?php echo $settings['banner_background_img']['url']; ?>)">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="banner__content-two">
                            <?php if (!empty($settings['banner_main_img4']['url'])): ?>
                                <img src="<?php echo $settings['banner_main_img4']['url']; ?>" alt="shape" class="shape" data-aos="zoom-in-right" data-aos-delay="1200">
                            <?php endif; ?>
                            <h3 class="title tg-svg"><?php echo esc_html( $settings['banner_title'] ); ?> <span class="position-relative"><span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo esc_html( $settings['banner_title_middle'] ); ?></span> <?php echo esc_html( $settings['banner_title_last'] ); ?></h3>
                            <div class="banner__search-form">
                                <form action="<?php echo home_url('/'); ?>">
                                    <input type="text" value="<?php echo get_search_query() ?>" name="s" id="s" class="search-course-input" placeholder="<?php echo esc_attr__('Search For Course . . .', 'eduvalt'); ?>" />
                                    <input type="hidden" name="post_type" value="courses">
                                    <button aria-label="Search"><i class="flaticon-searching fa-flip-horizontal"></i></button>
                                </form>
                                <p><a href="<?php echo $settings['banner_btn1_link']['url']; ?>" <?php echo $target1; ?> <?php echo $nofollow1; ?>><?php echo esc_html( $settings['banner_btn1_text'] ); ?></a></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="banner__images-two">
                            <?php if (!empty($settings['banner_main_img5']['url'])): ?>
                                <img src="<?php echo $settings['banner_main_img5']['url']; ?>" alt="shape" class="shape" data-aos="zoom-in-down" data-aos-delay="800">
                            <?php endif; ?>
                            <?php if (!empty($settings['banner_main_img6']['url'])): ?>
                                <img src="<?php echo $settings['banner_main_img6']['url']; ?>" alt="shape" class="shape" data-aos="zoom-in-left" data-aos-delay="1200">
                            <?php endif; ?>
                            <div class="banner__images-grid">
                                <?php if (!empty($settings['banner_main_img']['url'])): ?>
                                    <div class="banner__images-col" data-aos="fade-up" data-aos-delay="200">
                                        <img src="<?php echo $settings['banner_main_img']['url']; ?>" alt="img">
                                    </div>
                                <?php endif; ?>
                                <div class="banner__images-col">
                                    <?php if (!empty($settings['banner_main_img1']['url'])): ?>
                                        <img src="<?php echo $settings['banner_main_img1']['url']; ?>" alt="img" data-aos="fade-left" data-aos-delay="300">
                                    <?php endif; ?>
                                    <?php if (!empty($settings['banner_main_img2']['url'])): ?>
                                        <img src="<?php echo $settings['banner_main_img2']['url']; ?>" alt="img" data-aos="fade-left" data-aos-delay="400">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($settings['banner_main_img3']['url'])): ?>
                <img src="<?php echo $settings['banner_main_img3']['url']; ?>" alt="shape" class="banner__two-shape alltuchtopdown">
            <?php endif; ?>
        </section>
    <?php
    }
}