<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Slider_Banner extends Widget_Base {

    public function get_name() {
        return 'slider-banner';
    }

    public function get_title() {
        return 'Banner One';   // title to show on eduvalt
    }

    public function get_icon() {
        return 'fal fa-address-card'; // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
    }

    public function get_categories() {
        return [ 'eduvalt-elements' ];    // category of the widget
    }

    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/

    protected function register_controls() {
        
        //start of a control box
        $this->start_controls_section(
            'section_banner_content',
            [
                'label' => esc_html__( 'Banner Content', 'eduvalt' ),   //section name for controler view
            ]
        );

        $this->add_control(
            'banner_bg_img',
            [
                'label' => esc_html__( 'Banner Background', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_bg_shape',
            [
                'label' => esc_html__( 'Banner Image', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'hide_yellow_underline',
            [
                'label' => __( 'Hide Yellow Underline', 'eduvalt' ),
                'type'  => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', 'eduvalt' ),
                'label_off' => __( 'Hide', 'eduvalt' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'banner_title',
            [
                'label' => esc_html__( 'Banner Title First', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Learn', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_title_middle',
            [
                'label' => esc_html__( 'Banner Title Middle', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Skills', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_title_last',
            [
                'label' => esc_html__( 'Banner Title Last', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'From Our Top Instructors', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_sub_title',
            [
                'label' => esc_html__( 'Banner Sub Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '100% Satisfaction Guarantee', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_description',
            [
                'label' => esc_html__( 'Banner Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Borem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattisBorem ipsum dolor sit amet consectetur adipiscing area we followelit.', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'total_students',
            [
                'label' => esc_html__( 'Total Students', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Total Students', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'total_students_number',
            [
                'label' => esc_html__( 'Total Students Number', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '15k', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'total_graduation',
            [
                'label' => esc_html__( 'Complete Graduation', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Complete Graduation', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'total_graduation_number',
            [
                'label' => esc_html__( 'Complete Graduation Number', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '34k', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn1_text',
            [
                'label' => esc_html__( 'Button One Text', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Explore Courses', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn1_link',
            [
                'label' => __( 'Link', 'eduvalt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'banner_btn2_text',
            [
                'label' => esc_html__( 'Button Two Text', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Have any Question?', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn2_number',
            [
                'label' => esc_html__( 'Button Two Number', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '993-00-67777', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'banner_btn2_link',
            [
                'label' => __( 'Link', 'eduvalt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'banner_bg_shape_01',
            [
                'label' => esc_html__( 'Sape Image One', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_bg_shape_02',
            [
                'label' => esc_html__( 'Sape Image Two', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_bg_shape_03',
            [
                'label' => esc_html__( 'Sape Image Three', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_bg_shape_04',
            [
                'label' => esc_html__( 'Sape Image Four', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'banner_bg_shape_05',
            [
                'label' => esc_html__( 'Sape Image Five', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->end_controls_section();
        //End of a control box

        $this->start_controls_section(
            'banner_title_style',
            [
                'label' => esc_html__( 'Title Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_title_color',
            [
                'label' => __( 'Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .banner__content h3.title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'banner_title_typography',
                'label' => __( 'Title Typography', 'eduvalt' ),
                'selector' => '{{WRAPPER}} .banner__content h3.title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'banner_sub_title_style',
            [
                'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .banner-area .banner-content span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'banner_sub_title_typography',
                'label'    => __( 'Sub Title Typography', 'eduvalt' ),
                'selector' => '{{WRAPPER}} .banner-area .banner-content span',
            ]
        );

        $this->end_controls_section();

        // Contact
        $this->start_controls_section(
            'banner_content_style',
            [
                'label' => esc_html__( 'Content Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'banner_content_color',
            [
                'label' => __( 'Content Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .banner__content p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Total Students
        $this->start_controls_section(
            'students_icon_style',
            [
                'label' => esc_html__( 'Total Students', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'total_sudents_bg_color',
            [
                'label' => __( 'Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#12bb6a',
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item .icon' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total_sudents_icon_color',
            [
                'label' => __( 'Icon Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item .icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total_sudents_number_color',
            [
                'label' => __( 'Total Student Number Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item .info .count' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'total_sudents_text_color',
            [
                'label' => __( 'Total Student Text Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item .info span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Graduation Style
        $this->start_controls_section(
            'graduation_icon_style',
            [
                'label' => esc_html__( 'Graduation Students', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'total_graduation_bg_color',
            [
                'label' => __( 'Background Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8121fb',
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item.two .icon' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total_graduation_icon_color',
            [
                'label' => __( 'Icon Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item.two .icon.new' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'total_graduation_number_color',
            [
                'label' => __( 'Graduation Number Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item.two .info .count' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'total_graduation_text_color',
            [
                'label' => __( 'Graduation Text Color', 'eduvalt' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .banner__fact-item.two .info span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


    }
    //end of control box 

    //to show on the fontend
    protected function render() {
        $settings = $this->get_settings_for_display();

        $target1 = $settings['banner_btn1_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow1 = $settings['banner_btn1_link']['nofollow'] ? ' rel="nofollow"' : '';

        $target2 = $settings['banner_btn2_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow2 = $settings['banner_btn2_link']['nofollow'] ? ' rel="nofollow"' : '';

        $randID = wp_rand();
        
    ?>
    <section class="banner-area banner-bg" style="background-image:url(<?php echo $settings['banner_bg_img']['url']; ?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="banner__content">
                        <?php if( !empty( $settings['banner_bg_shape_01']['url'] ) ): ?>
                            <img src="<?php echo $settings['banner_bg_shape_01']['url']; ?>" alt="shape" class="shape alltuchtopdown">
                        <?php endif; ?>
                        <?php if( !empty( $settings['banner_bg_shape_02']['url'] ) ): ?>
                            <img src="<?php echo $settings['banner_bg_shape_02']['url']; ?>" alt="shape" class="shape">
                        <?php endif; ?>
                        <span class="sub-title" data-aos="fade-right" data-aos-delay="200"><?php echo esc_html( $settings['banner_sub_title'] ); ?></span>
                        <h3 class="title tg-svg" data-aos="fade-right" data-aos-delay="400"><?php echo esc_html( $settings['banner_title'] ); ?> 
                        <span class="position-relative"><?php if( 'yes' == $settings[ 'hide_yellow_underline' ] ) { ?><span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php } ?><?php echo esc_html( $settings['banner_title_middle'] ); ?></span> <?php echo esc_html( $settings['banner_title_last'] ); ?></h3>
                        <p data-aos="fade-right" data-aos-delay="600"><?php echo esc_html( $settings['banner_description'] ); ?></p>
                        <div class="banner__btn-wrap" data-aos="fade-right" data-aos-delay="800">
                            <div class="tg-button-wrap">
                                <a href="<?php echo esc_url( $settings['banner_btn1_link']['url'] ); ?>" class="btn tg-svg"><span class="text"><?php echo esc_html( $settings['banner_btn1_text'] ); ?></span> <span class="svg-icon" id="svg-1<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
                            </div>
                            <?php if( !empty( $settings['banner_btn2_text'] ) ) : ?>
                                <div class="banner__phone">
                                    <i class="flaticon-phone-call"></i>
                                    <div class="number-info">
                                        <span><?php echo esc_html( $settings['banner_btn2_text'] ); ?></span>
                                        <span class="number"><a href="tel:<?php echo esc_attr( str_replace(" ","",( $settings['banner_btn2_number'] )) ); ?>"><?php echo esc_attr( str_replace(" ","",( $settings['banner_btn2_number'] )) ); ?></a></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="banner__images">
                        <?php if (!empty($settings['banner_bg_shape']['url'])): ?>
                            <img src="<?php echo $settings['banner_bg_shape']['url']; ?>" alt="img" class="main-img">
                        <?php endif; ?>
                        <?php if( !empty( $settings['banner_bg_shape_03']['url'] ) ): ?>
                            <img src="<?php echo $settings['banner_bg_shape_03']['url']; ?>" alt="shape" class="shape" data-aos="fade-down-right" data-aos-delay="1200">
                        <?php endif; ?>
                        <?php if( !empty( $settings['banner_bg_shape_04']['url'] ) ): ?>
                            <img src="<?php echo $settings['banner_bg_shape_04']['url']; ?>" alt="shape" class="shape" data-aos="fade-right" data-aos-delay="1200">
                        <?php endif; ?>
                        <?php if( !empty( $settings['banner_bg_shape_05']['url'] ) ): ?>
                            <img src="<?php echo $settings['banner_bg_shape_05']['url']; ?>" alt="shape" class="shape" data-aos="fade-down-left" data-aos-delay="1200">
                        <?php endif; ?>
                        <div class="banner__fact">
                            <div class="banner__fact-item">
                                <div class="icon">
                                    <i class="flaticon-group"></i>
                                </div>
                                <div class="info">
                                    <span><?php echo esc_html( $settings['total_students'] ); ?></span>
                                    <h4 class="count"><?php echo esc_html( $settings['total_students_number'] ); ?></h4>
                                </div>
                            </div>
                            <div class="banner__fact-item two">
                                <div class="icon new">
                                    <i class="flaticon-graduation-cap"></i>
                                </div>
                                <div class="info">
                                    <span><?php echo esc_html( $settings['total_graduation'] ); ?></span>
                                    <h4 class="count"><?php echo esc_html( $settings['total_graduation_number'] ); ?></h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    }
}