<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_About_Two extends Widget_Base {

	public function get_name() {
		return 'section_about_two';
	}

	public function get_title() {
		return 'About Section Two';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//section name for controler view
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'About Section Two', 'eduvalt' ),
			]
		);
		$this->add_control(
			'section_about_title',
			[
				'label' => esc_html__( 'Section Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
			]
		);
		$this->add_control(
			'section_about_sub_title',
			[
				'label' => esc_html__( 'Section Sub Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '',
			]
		);
		$this->add_control(
			'section_about_description',
			[
				'label' => esc_html__( 'Section Description', 'eduvalt' ),
				'type'  => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => '',
			]
		);



		$repeater = new Repeater();
        $repeater->add_control(
            'checkbox_item_title', [
                'label' => __( 'Checkbox Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Checkbox Description' , 'eduvalt' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'checkbox_item_sub_icon', [
                'label' => __( 'Checkbox Icon', 'eduvalt' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fas fa-check-square',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'section_about_checkbox_items',
            [
                'label' => __( 'Add Checkbox List', 'eduvalt' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

		$this->add_control(
			'anim_counter_title',
			[
				'label' => esc_html__( 'Counter Number', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '32',
			]
		);
		$this->add_control(
			'anim_countersub_title',
			[
				'label' => esc_html__( 'Counter Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'years Of Experience',
			]
		);
		$this->add_control(
			'section_button_url',
			[
				'label' => esc_html__( 'Button Link', 'eduvalt' ),
				'type'  => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_button_text',
			[
				'label' => esc_html__( 'Button Text', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'anim_one_img',
			[
				'label' => esc_html__( 'Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'img_one_animation',
			[
				'label' => __( 'Image One Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);
		$this->add_control(
			'img_one_animation_delay',
			[
				'label' => __( 'Image One Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'full_imgstyle',
			[
				'label' => esc_html__( 'Item Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'item_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .section-title.title-style-three h2.title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'sub_title_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .section-title.title-style-three .sub-title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'sub_title_bg_color',
			[
				'label' => __( 'Sub Title Bg Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .section-title.title-style-three .sub-title' => 'background: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		// Content Color
		$this->start_controls_section(
			'full_content_style',
			[
				'label' => esc_html__( 'Item Content Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'item_content_color',
			[
				'label' => __( 'Content Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .about-content p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'item_checklist_color',
			[
				'label' => __( 'Check List Bg Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .about-content .about-list .list-wrap li i' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'item_checklist_text_color',
			[
				'label' => __( 'Check List Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-area .about-content .about-list .list-wrap li' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		// Experience Color
		$this->start_controls_section(
			'experience_content_style',
			[
				'label' => esc_html__( 'Experience Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_experience_bg_color',
			[
				'label' => __( 'Experience Bg Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-img-wrap .year-experience svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_experience_text_color',
			[
				'label' => __( 'Experience Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-img-wrap .year-experience .content .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		// Button Color
		$this->start_controls_section(
			'button_content_style',
			[
				'label' => esc_html__( 'Button Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_button_bg_color',
			[
				'label' => __( 'Button Bg Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-content a.btn.btn-two' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_button_text_color',
			[
				'label' => __( 'Button Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-content a.btn.btn-two' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_button_line_color',
			[
				'label' => __( 'Button Line Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-content a.btn.btn-two span::before' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_button_hover_bg_color',
			[
				'label' => __( 'Button Hover Bg Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-content a.btn.btn-two:after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_button_hover_text_color',
			[
				'label' => __( 'Button Hover Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-content a.btn.btn-two:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_button_hover_line_color',
			[
				'label' => __( 'Button Hover Line Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-content a.btn.btn-two:hover span::after' => 'background: {{VALUE}};',
				],
			]
		);


		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 

		$settings = $this->get_settings_for_display();

		// one image animation
		if (!empty( $settings['img_one_animation'] )) {
			$img_one_anim = 'data-wow-delay="'.esc_attr( $settings['img_one_animation_delay'] ).'"';
		} else {
			$img_one_anim = '';	
		}

		if ( ! empty( $settings['img_one_animation'] ) ) {
			$this->add_render_attribute( 'img-one', 'class', 'wow ' . $settings['img_one_animation'] );
		}
		?>

            <section class="about-area fix">
                <div class="container">
                    <div class="row align-items-center justify-content-center">
                        <div class="col-lg-6 col-md-10 col-sm-10">
                            <div class="about-img-wrap">
                            	<?php if( !empty ( $settings['anim_one_img']['url'] ) ) : ?>
	                                <div class="about-img wow fadeInLeft" data-wow-delay=".2s">
	                                    <img src="<?php echo esc_attr( $settings['anim_one_img']['url'] );?>">
	                                </div>
                                <?php endif; ?>
                                <div class="year-experience wow fadeInUp" data-wow-delay=".3s">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="213.875" height="237.31" viewBox="0 0 213.875 237.31">
                                        <path d="M927.407,1398.64l-78.017-44.91a28.989,28.989,0,0,0-28.915,0l-78.017,44.91A28.818,28.818,0,0,0,728,1423.61v89.83a28.8,28.8,0,0,0,14.458,24.96l78.017,44.92a28.989,28.989,0,0,0,28.915,0l78.017-44.92a28.8,28.8,0,0,0,14.457-24.96v-89.83A28.819,28.819,0,0,0,927.407,1398.64Z"
                                            transform="translate(-728 -1349.88)" />
                                    </svg>
                                    <div class="content">
                                        <h2 class="title"><?php echo esc_html( $settings['anim_counter_title'] ); ?> <span><?php echo esc_html( $settings['anim_countersub_title'] ); ?></span></h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="about-content wow fadeInRight" data-wow-delay=".2s">
                                <div class="section-title title-style-three mb-20 tg-heading-subheading animation-style2">
                                    <span class="sub-title"><?php echo esc_html( $settings['section_about_sub_title'] ); ?></span>
                                    <h2 class="title tg-element-title"><?php echo esc_html( $settings['section_about_title'] ); ?></h2>
                                </div>
                                <p><?php echo esc_html( $settings['section_about_description'] ); ?></p>
                                <?php if ( $settings['section_about_checkbox_items'] ) : ?>
	                                <div class="about-list">
	                                    <ul class="list-wrap">
	                                    	<?php foreach ( $settings['section_about_checkbox_items'] as $key => $value ) : ?>
	                                       		<li><i class="<?php echo esc_attr( $value['checkbox_item_sub_icon'] );?>"></i><?php echo esc_attr( $value['checkbox_item_title'] );?></li>
	                                    	<?php endforeach; ?>
	                                    </ul>
	                                </div>
                            	<?php endif; ?>
                            	<?php if( !empty( $settings['section_button_url']['url'] ) ): ?>
                                	<a href="<?php echo $settings['section_button_url']['url']; ?>" class="btn btn-two"><span><?php echo $settings['section_button_text']; ?></span></a>
                            	<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

	<?php 
	}
}