<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Animate_About_Image_Two extends Widget_Base {

	public function get_name() {
		return 'animated_about_image_two';
	}

	public function get_title() {
		return 'About Animate Two';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//section name for controler view
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Animate Image Two', 'eduvalt' ),
			]
		);

		$this->add_control(
			'anim_one_img',
			[
				'label' => esc_html__( 'Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_two_img',
			[
				'label' => esc_html__( 'Image Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_three_img',
			[
				'label' => esc_html__( 'Image Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img',
			[
				'label' => esc_html__( 'Image Shape', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img_two',
			[
				'label' => esc_html__( 'Image Shape Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img_three',
			[
				'label' => esc_html__( 'Image Shape Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'full_imgstyle',
			[
				'label' => esc_html__( 'Counter style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'delay',
			[
				'label' => __( 'Counter Delay (milliseconds)', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '10', 'eduvalt' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'time',
			[
				'label' => __( 'Counter Animation Time', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '2000', 'eduvalt' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'img_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .expertise-img-wrap .exp-content' => 'background: {{VALUE}};',
					'{{WRAPPER}} .expertise-img-wrap .exp-box' => 'border:10px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'img_text_color',
			[
				'label' => __( 'Test Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .expertise-img-wrap .exp-content h2, .expertise-img-wrap .exp-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .expertise-img-wrap .exp-content .icon i:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 
		$settings = $this->get_settings_for_display();
		$randID = wp_rand();
		?>

        <div class="about__images-wrap">
        	<?php if( !empty ( $settings['anim_one_img']['url'] ) ) : ?>
	            <div class="column">
	                <img src="<?php echo esc_url( $settings['anim_one_img']['url'] );?>" alt="img">
	            </div>
        	<?php endif; ?>
            <div class="column">
            	<?php if( !empty ( $settings['anim_two_img']['url'] ) ) : ?>
                	<img src="<?php echo esc_url( $settings['anim_two_img']['url'] );?>" alt="img">
                <?php endif; ?>
                <?php if( !empty ( $settings['anim_three_img']['url'] ) ) : ?>
                	<img src="<?php echo esc_url( $settings['anim_three_img']['url'] );?>" alt="img">
                <?php endif; ?>
            </div>
            <div class="about__shapes">
            	<?php if( !empty ( $settings['anim_shape_img']['url'] ) ) : ?>
                	<img src="<?php echo esc_url( $settings['anim_shape_img']['url'] );?>" alt="img" class="about-shape-01" data-aos="fade-down-left">
                <?php endif; ?>
                <?php if( !empty ( $settings['anim_shape_img_two']['url'] ) ) : ?>
                	<img src="<?php echo esc_url( $settings['anim_shape_img_two']['url'] );?>" alt="img" class="about-shape-02" data-aos="fade-up-right">
                <?php endif; ?>
                <?php if( !empty ( $settings['anim_shape_img_three']['url'] ) ) : ?>
                	<img src="<?php echo esc_url( $settings['anim_shape_img_three']['url'] );?>" alt="img" class="about-shape-03 rotateme">
                <?php endif; ?>
            </div>
        </div>
	<?php
	}
}