<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * A Font Icon select box.
 *
 * @property array $icons   A list of font-icon classes. [ 'class-name' => 'nicename', ... ]
 *                          Default Font Awesome icons. @see Control_Icon::get_icons().
 * @property array $include list of classes to include form the $icons property
 * @property array $exclude list of classes to exclude form the $icons property
 *
 * @since 1.0.0
 */
class Eduvalt_Icon_Controler extends Elementor\Base_Data_Control {

	public function get_type() {
		return 'icon';
	}

	/**
	 * Get icons list
	 *
	 * @return array
	*/

	public static function get_icons() {

		$icons = array(
			'ficon flaticon-support'              => 'Flaticon Support',
			'ficon flaticon-file'                 => 'FlatIcon File',
			'ficon flaticon-graduation-cap'       => 'FlatIcon Graduation Cap',
			'ficon flaticon-video-player'         => 'FlatIcon Video Player',
			'ficon flaticon-pin-1'                => 'FlatIcon Pin',
			'ficon flaticon-phone-call'           => 'FlatIcon Call',
			'ficon flaticon-email'                => 'FlatIcon Email',
			'ficon flaticon-graphic-design'       => 'FlatIcon Graphic Design',
			'ficon flaticon-email-marketing'      => 'FlatIcon Email marketing',
			'ficon flaticon-bars'                 => 'FlatIcon Bars',
			'ficon flaticon-edit'                 => 'FlatIcon Edit',
			'ficon flaticon-programming-language' => 'FlatIcon language',
			'ficon flaticon-atom'                 => 'FlatIcon Atom',
			'ficon flaticon-pin'                  => 'FlatIcon Pin',
			'ficon flaticon-phone-call'           => 'FlatIcon Phone Call',
			'ficon flaticon-camera'               => 'FlatIcon Camera',
			'ficon flaticon-webinar'              => 'FlatIcon Webinar',
			'ficon flaticon-graduates'            => 'FlatIcon Graduates',
			'ficon flaticon-countries'            => 'FlatIcon Countries',
			'ficon flaticon-trophy'               => 'Flaticon trophy',
			'ficon flaticon-travel-insurance'  => 'FlatIcon travel insurance',
			'ficon flaticon-keyword-research'  => 'FlatIcon keyword research',
			'ficon flaticon-design'            => 'FlatIcon design',
			'ficon flaticon-strategies'        => 'FlatIcon strategies',
			'ficon flaticon-technical-support' => 'FlatIcon technical-support',
			'ficon flaticon-seo'               => 'FlatIcon SEO',
			'ficon flaticon-analysis-1'        => 'FlatIcon analysis 1',
			'ficon flaticon-optimization'      => 'FlatIcon optimization',
			'ficon flaticon-social-media'      => 'Customer social-media',
			'ficon flaticon-strategy'          => 'FlatIcon strategy',
			'ficon flaticon-graphic-design'    => 'FlatIcon graphic Design',
			'ficon flaticon-development'       => 'FlatIcon development',
			'ficon flaticon-shopping-bag'      => 'Flaticon Shopping Bag',
			'ficon flaticon-search-1'          => 'FlatIcon search 1',
			'ficon flaticon-link'              => 'FlatIcon link',
			'ficon flaticon-www'               => 'FlatIcon WWW',
			'ficon flaticon-online-learning'   => 'FlatIcon Online learning',
			'ficon flaticon-promotion'         => 'Flaticon promotion',
			'ficon flaticon-playlist'          => 'Flaticon playlist',
			'ficon flaticon-client'            => 'Flaticon client',
			'ficon flaticon-support'           => 'Flaticon Support',
			'ficon flaticon-shopping-online'   => 'Flaticon shopping Online',
			'ficon flaticon-global'            => 'Flaticon global',
			'ficon flaticon-computer'          => 'Flaticon computer',
			'ficon flaticon-mechanism'         => 'Flaticon mechanism',
			'ficon flaticon-recovery'          => 'Flaticon recovery',
			'ficon flaticon-archive'           => 'Flaticon Archive',
			'far fa-burn' 		=> 'burn',
			'fal fa-burn' 		=> 'burn',
			'fas fa-bullseye' => 'bullseye',
			'far fa-bullseye' => 'bullseye',
			'fal fa-bullseye' => 'bullseye',
			'fas fa-bullhorn' => 'bullhorn',
			'far fa-bullhorn' => 'bullhorn',
			'fal fa-bullhorn' => 'bullhorn',
			'fas fa-building' => 'building',
			'far fa-building' => 'building',
			'fal fa-building' => 'building',
			'fas fa-bug' => 'bug',
			'far fa-bug' => 'bug',
			'fal fa-bug' => 'bug',
			'fab fa-btc' => 'btc',
			'fas fa-browser' => 'browser',
			'far fa-browser' => 'browser',
			'fal fa-browser' => 'browser',
			'fas fa-briefcase-medical' => 'briefcase-medical',
			'far fa-briefcase-medical' => 'briefcase-medical',
			'fal fa-briefcase-medical' => 'briefcase-medical',
			'fas fa-briefcase' => 'briefcase',
			'far fa-briefcase' => 'briefcase',
			'fal fa-briefcase' => 'briefcase',
			'fas fa-braille' => 'braille',
			'far fa-braille' => 'braille',
			'fal fa-braille' => 'braille',
			'fas fa-boxing-glove' => 'boxing-glove',
			'far fa-boxing-glove' => 'boxing-glove',
			'fal fa-boxing-glove' => 'boxing-glove',
			'fas fa-boxes-alt' => 'boxes-alt',
			'far fa-boxes-alt' => 'boxes-alt',
			'fal fa-boxes-alt' => 'boxes-alt',
			'fas fa-boxes' => 'boxes',
			'far fa-boxes' => 'boxes',
			'fal fa-boxes' => 'boxes',
			'fas fa-box-usd' => 'box-usd',
			'far fa-box-usd' => 'box-usd',
			'fal fa-box-usd' => 'box-usd',
			'fas fa-box-up' => 'box-up',
			'far fa-box-up' => 'box-up',
			'fal fa-box-up' => 'box-up',
			'fas fa-box-open' => 'box-open',
			'far fa-box-open' => 'box-open',
			'fal fa-box-open' => 'box-open',
			'fas fa-box-heart' => 'box-heart',
			'far fa-box-heart' => 'box-heart',
			'fal fa-box-heart' => 'box-heart',
			'fas fa-box-full' => 'box-full',
			'far fa-box-full' => 'box-full',
			'fal fa-box-full' => 'box-full',
			'fas fa-box-fragile' => 'box-fragile',
			'far fa-box-fragile' => 'box-fragile',
			'fal fa-box-fragile' => 'box-fragile',
			'fas fa-box-check' => 'box-check',
			'far fa-box-check' => 'box-check',
			'fal fa-box-check' => 'box-check',
			'fas fa-box-alt' => 'box-alt',
			'far fa-box-alt' => 'box-alt',
			'fal fa-box-alt' => 'box-alt',
			'fas fa-box' => 'box',
			'far fa-box' => 'box',
			'fal fa-box' => 'box',
			'fas fa-bowling-pins' => 'bowling-pins',
			'far fa-bowling-pins' => 'bowling-pins',
			'fal fa-bowling-pins' => 'bowling-pins',
			'fas fa-bowling-ball' => 'bowling-ball',
			'far fa-bowling-ball' => 'bowling-ball',
			'fal fa-bowling-ball' => 'bowling-ball',
			'fas fa-bookmark' => 'bookmark',
			'far fa-bookmark' => 'bookmark',
			'fal fa-bookmark' => 'bookmark',
			'fas fa-book-heart' => 'book-heart',
			'far fa-book-heart' => 'book-heart',
			'fal fa-book-heart' => 'book-heart',
			'fas fa-book' => 'book',
			'far fa-book' => 'book',
			'fal fa-book' => 'book',
			'fas fa-bomb' => 'bomb',
			'far fa-bomb' => 'bomb',
			'fal fa-bomb' => 'bomb',
			'fas fa-bolt' => 'bolt',
			'far fa-bolt' => 'bolt',
			'fal fa-bolt' => 'bolt',
			'fas fa-bold' => 'bold',
			'far fa-bold' => 'bold',
			'fal fa-bold' => 'bold',
			'fab fa-bluetooth-b' => 'bluetooth-b',
			'fab fa-bluetooth' => 'bluetooth',
			'fab fa-blogger-b' => 'blogger-b',
			'fab fa-blogger' => 'blogger',
			'fas fa-blind' => 'blind',
			'far fa-blind' => 'blind',
			'fal fa-blind' => 'blind',
			'fas fa-blanket' => 'blanket',
			'far fa-blanket' => 'blanket',
			'fal fa-blanket' => 'blanket',
			'fab fa-blackberry' => 'blackberry',
			'fab fa-black-tie' => 'black-tie',
			'fab fa-bity' => 'bity',
			'fab fa-bitcoin' => 'bitcoin',
			'fab fa-bitbucket' => 'bitbucket',
			'fas fa-birthday-cake' => 'birthday-cake',
			'far fa-birthday-cake' => 'birthday-cake',
			'fal fa-birthday-cake' => 'birthday-cake',
			'fas fa-binoculars' => 'binoculars',
			'far fa-binoculars' => 'binoculars',
			'fal fa-binoculars' => 'binoculars',
			'fab fa-bimobject' => 'bimobject',
			'fas fa-bicycle' => 'bicycle',
			'far fa-bicycle' => 'bicycle',
			'fal fa-bicycle' => 'bicycle',
			'fas fa-bell-slash' => 'bell-slash',
			'far fa-bell-slash' => 'bell-slash',
			'fal fa-bell-slash' => 'bell-slash',
			'fas fa-bell' => 'bell',
			'far fa-bell' => 'bell',
			'fal fa-bell' => 'bell',
			'fab fa-behance-square' => 'behance-square',
			'fab fa-behance' => 'behance',
			'fas fa-beer' => 'beer',
			'far fa-beer' => 'beer',
			'fal fa-beer' => 'beer',
			'fas fa-bed' => 'bed',
			'far fa-bed' => 'bed',
			'fal fa-bed' => 'bed',
			'fas fa-battery-three-quarters' => 'battery-three-quarters',
			'far fa-battery-three-quarters' => 'battery-three-quarters',
			'fal fa-battery-three-quarters' => 'battery-three-quarters',
			'fas fa-battery-slash' => 'battery-slash',
			'far fa-battery-slash' => 'battery-slash',
			'fal fa-battery-slash' => 'battery-slash',
			'fas fa-battery-quarter' => 'battery-quarter',
			'far fa-battery-quarter' => 'battery-quarter',
			'fal fa-battery-quarter' => 'battery-quarter',
			'fas fa-battery-half' => 'battery-half',
			'far fa-battery-half' => 'battery-half',
			'fal fa-battery-half' => 'battery-half',
			'fas fa-battery-full' => 'battery-full',
			'far fa-battery-full' => 'battery-full',
			'fal fa-battery-full' => 'battery-full',
			'fas fa-battery-empty' => 'battery-empty',
			'far fa-battery-empty' => 'battery-empty',
			'fal fa-battery-empty' => 'battery-empty',
			'fas fa-battery-bolt' => 'battery-bolt',
			'far fa-battery-bolt' => 'battery-bolt',
			'fal fa-battery-bolt' => 'battery-bolt',
			'fas fa-bath' => 'bath',
			'far fa-bath' => 'bath',
			'fal fa-bath' => 'bath',
			'fas fa-basketball-hoop' => 'basketball-hoop',
			'far fa-basketball-hoop' => 'basketball-hoop',
			'fal fa-basketball-hoop' => 'basketball-hoop',
			'fas fa-basketball-ball' => 'basketball-ball',
			'far fa-basketball-ball' => 'basketball-ball',
			'fal fa-basketball-ball' => 'basketball-ball',
			'fas fa-baseball-ball' => 'baseball-ball',
			'far fa-baseball-ball' => 'baseball-ball',
			'fal fa-baseball-ball' => 'baseball-ball',
			'fas fa-baseball' => 'baseball',
			'far fa-baseball' => 'baseball',
			'fal fa-baseball' => 'baseball',
			'fas fa-bars' => 'bars',
			'far fa-bars' => 'bars',
			'fal fa-bars' => 'bars',
			'fas fa-barcode-scan' => 'barcode-scan',
			'far fa-barcode-scan' => 'barcode-scan',
			'fal fa-barcode-scan' => 'barcode-scan',
			'fas fa-barcode-read' => 'barcode-read',
			'far fa-barcode-read' => 'barcode-read',
			'fal fa-barcode-read' => 'barcode-read',
			'fas fa-barcode-alt' => 'barcode-alt',
			'far fa-barcode-alt' => 'barcode-alt',
			'fal fa-barcode-alt' => 'barcode-alt',
			'fas fa-barcode' => 'barcode',
			'far fa-barcode' => 'barcode',
			'fal fa-barcode' => 'barcode',
			'fab fa-bandcamp' => 'bandcamp',
			'fas fa-band-aid' => 'band-aid',
			'far fa-band-aid' => 'band-aid',
			'fal fa-band-aid' => 'band-aid',
			'fas fa-ban' => 'ban',
			'far fa-ban' => 'ban',
			'fal fa-ban' => 'ban',
			'fas fa-balance-scale' => 'balance-scale',
			'far fa-balance-scale' => 'balance-scale',
			'fal fa-balance-scale' => 'balance-scale',
			'fas fa-badge-check' => 'badge-check',
			'far fa-badge-check' => 'badge-check',
			'fal fa-badge-check' => 'badge-check',
			'fas fa-badge' => 'badge',
			'far fa-badge' => 'badge',
			'fal fa-badge' => 'badge',
			'fas fa-backward' => 'backward',
			'far fa-backward' => 'backward',
			'fal fa-backward' => 'backward',
			'fas fa-user-slash' => 'user-slash',
			'far fa-user-slash' => 'user-slash',
			'fal fa-user-slash' => 'user-slash',
			'fas fa-user-shield' => 'user-shield',
			'far fa-user-shield' => 'user-shield',
			'fal fa-user-shield' => 'user-shield',
			'fas fa-user-secret' => 'user-secret',
			'far fa-user-secret' => 'user-secret',
			'fal fa-user-secret' => 'user-secret',
			'fas fa-user-plus' => 'user-plus',
			'far fa-user-plus' => 'user-plus',
			'fal fa-user-plus' => 'user-plus',
			'fas fa-user-ninja' => 'user-ninja',
			'far fa-user-ninja' => 'user-ninja',
			'fal fa-user-ninja' => 'user-ninja',
			'fas fa-user-minus' => 'user-minus',
			'far fa-user-minus' => 'user-minus',
			'fal fa-user-minus' => 'user-minus',
			'fas fa-user' => 'user',
			'far fa-user' => 'user',
			'fal fa-user' => 'user',
			'fas fa-user-md' => 'user-md',
			'far fa-user-md' => 'user-md',
			'fal fa-user-md' => 'user-md',
			'fas fa-user-lock' => 'user-lock',
			'far fa-user-lock' => 'user-lock',
			'fal fa-user-lock' => 'user-lock',
			'fas fa-user-graduate' => 'user-graduate',
			'far fa-user-graduate' => 'user-graduate',
			'fal fa-user-graduate' => 'user-graduate',
			'fas fa-user-friends' => 'user-friends',
			'far fa-user-friends' => 'user-friends',
			'fal fa-user-friends' => 'user-friends',
			'fas fa-user-edit' => 'user-edit',
			'far fa-user-edit' => 'user-edit',
			'fal fa-user-edit' => 'user-edit',
			'fas fa-user-cog' => 'user-cog',
			'far fa-user-cog' => 'user-cog',
			'fal fa-user-cog' => 'user-cog',
			'fas fa-user-clock' => 'user-clock',
			'far fa-user-clock' => 'user-clock',
			'fal fa-user-clock' => 'user-clock',
			'fas fa-user-circle' => 'user-circle',
			'far fa-user-circle' => 'user-circle',
			'fal fa-user-circle' => 'user-circle',
			'fas fa-user-check' => 'user-check',
			'far fa-user-check' => 'user-check',
			'fal fa-user-check' => 'user-check',
			'fas fa-user-astronaut' => 'user-astronaut',
			'far fa-user-astronaut' => 'user-astronaut',
			'fal fa-user-astronaut' => 'user-astronaut',
			'fas fa-user-alt-slash' => 'user-alt-slash',
			'far fa-user-alt-slash' => 'user-alt-slash',
			'fal fa-user-alt-slash' => 'user-alt-slash',
			'fas fa-user-alt' => 'user-alt',
			'far fa-user-alt' => 'user-alt',
			'fal fa-user-alt' => 'user-alt',
			'fas fa-user' => 'user',
			'far fa-user' => 'user',
			'fal fa-user' => 'user',
			'fas fa-users' => 'users',
			'far fa-users' => 'users',
			'fal fa-users' => 'users',
			'fas fa-usd-square' => 'usd-square',
			'far fa-usd-square' => 'usd-square',
			'fal fa-usd-square' => 'usd-square',
			'fas fa-usd-circle' => 'usd-circle',
			'far fa-usd-circle' => 'usd-circle',
			'fal fa-usd-circle' => 'usd-circle',
			'fab fa-usb' => 'usb',
			'fas fa-upload' => 'upload',
			'far fa-upload' => 'upload',
			'fal fa-upload' => 'upload',
			'fab fa-untappd' => 'untappd',
			'fas fa-unlock-alt' => 'unlock-alt',
			'far fa-unlock-alt' => 'unlock-alt',
			'fal fa-unlock-alt' => 'unlock-alt',
			'fas fa-unlock' => 'unlock',
			'far fa-unlock' => 'unlock',
			'fal fa-unlock' => 'unlock',
			'fas fa-unlink' => 'unlink',
			'far fa-unlink' => 'unlink',
			'fal fa-unlink' => 'unlink',
			'fas fa-university' => 'university',
			'far fa-university' => 'university',
			'fal fa-university' => 'university',
			'fas fa-universal-access' => 'universal-access',
			'far fa-universal-access' => 'universal-access',
			'fal fa-universal-access' => 'universal-access',
			'fab fa-uniregistry' => 'uniregistry',
			'fas fa-undo-alt' => 'undo-alt',
			'far fa-undo-alt' => 'undo-alt',
			'fal fa-undo-alt' => 'undo-alt',
			'fas fa-undo' => 'undo',
			'far fa-undo' => 'undo',
			'fal fa-undo' => 'undo',
			'fas fa-underline' => 'underline',
			'far fa-underline' => 'underline',
			'fal fa-underline' => 'underline',
			'fas fa-umbrella' => 'umbrella',
			'far fa-umbrella' => 'umbrella',
			'fal fa-umbrella' => 'umbrella',
			'fab fa-uikit' => 'uikit',
			'fab fa-uber' => 'uber',
			'fab fa-typo3' => 'typo3',
			'fab fa-twitter-square' => 'twitter-square',
			'fab fa-twitter' => 'twitter',
			'fab fa-twitch' => 'twitch',
			'fas fa-tv-retro' => 'tv-retro',
			'far fa-tv-retro' => 'tv-retro',
			'fal fa-tv-retro' => 'tv-retro',
			'fas fa-tv' => 'tv',
			'far fa-tv' => 'tv',
			'fal fa-tv' => 'tv',
			'fab fa-tumblr-square' => 'tumblr-square',
			'fab fa-tumblr' => 'tumblr',
			'fas fa-truck-ramp' => 'truck-ramp',
			'far fa-truck-ramp' => 'truck-ramp',
			'fal fa-truck-ramp' => 'truck-ramp',
			'fas fa-truck-moving' => 'truck-moving',
			'far fa-truck-moving' => 'truck-moving',
			'fal fa-truck-moving' => 'truck-moving',
			'fas fa-truck-loading' => 'truck-loading',
			'far fa-truck-loading' => 'truck-loading',
			'fal fa-truck-loading' => 'truck-loading',
			'fas fa-truck-couch' => 'truck-couch',
			'far fa-truck-couch' => 'truck-couch',
			'fal fa-truck-couch' => 'truck-couch',
			'fas fa-truck-container' => 'truck-container',
			'far fa-truck-container' => 'truck-container',
			'fal fa-truck-container' => 'truck-container',
			'fas fa-truck' => 'truck',
			'far fa-truck' => 'truck',
			'fal fa-truck' => 'truck',
			'fas fa-trophy-alt' => 'trophy-alt',
			'far fa-trophy-alt' => 'trophy-alt',
			'fal fa-trophy-alt' => 'trophy-alt',
			'fas fa-trophy' => 'trophy',
			'far fa-trophy' => 'trophy',
			'fal fa-trophy' => 'trophy',
			'fab fa-tripadvisor' => 'trophy',
			'fas fa-triangle' => 'trophy',
			'far fa-triangle' => 'trophy',
			'fal fa-triangle' => 'trophy',
			'fab fa-trello' => 'trophy',
			'fas fa-tree-alt' => 'tree-alt',
			'far fa-tree-alt' => 'tree-alt',
			'fal fa-tree-alt' => 'tree-alt',
			'fas fa-tree' => 'tree',
			'far fa-tree' => 'tree',
			'fal fa-tree' => 'tree',
			'fas fa-trash-alt' => 'trash-alt',
			'far fa-trash-alt' => 'trash-alt',
			'fal fa-trash-alt' => 'trash-alt',
			'fas fa-trash' => 'trash',
			'far fa-trash' => 'trash',
			'fal fa-trash' => 'trash',
			'fas fa-transgender-alt' => 'transgender-alt',
			'far fa-transgender-alt' => 'transgender-alt',
			'fal fa-transgender-alt' => 'transgender-alt',
			'fas fa-transgender' => 'transgender',
			'far fa-transgender' => 'transgender',
			'fal fa-transgender' => 'transgender',
			'fas fa-train' => 'train',
			'far fa-train' => 'train',
			'fal fa-train' => 'train',
			'fas fa-trademark' => 'trademark',
			'far fa-trademark' => 'trademark',
			'fal fa-trademark' => 'trademark',
			'fab fa-trade-federation' => 'trade-federation',
			'fas fa-toggle-on' => 'toggle-on',
			'far fa-toggle-on' => 'toggle-on',
			'fal fa-toggle-on' => 'toggle-on',
			'fas fa-toggle-off' => 'toggle-off',
			'far fa-toggle-off' => 'toggle-off',
			'fal fa-toggle-off' => 'toggle-off',
			'fas fa-tint' => 'tint',
			'far fa-tint' => 'tint',
			'fal fa-tint' => 'tint',
			'fas fa-times-square' => 'times-square',
			'far fa-times-square' => 'times-square',
			'fal fa-times-square' => 'times-square',
			'fas fa-times-octagon' => 'times-octagon',
			'far fa-times-octagon' => 'times-octagon',
			'fal fa-times-octagon' => 'times-octagon',
			'fas fa-times-hexagon' => 'times-hexagon',
			'far fa-times-hexagon' => 'times-hexagon',
			'fal fa-times-hexagon' => 'times-hexagon',
			'fas fa-times-circle' => 'times-circle',
			'far fa-times-circle' => 'times-circle',
			'fal fa-times-circle' => 'times-circle',
			'fas fa-times' => 'times',
			'far fa-times' => 'times',
			'fal fa-times' => 'times',
			'fas fa-ticket-alt' => 'ticket-alt',
			'far fa-ticket-alt' => 'ticket-alt',
			'fal fa-ticket-alt' => 'ticket-alt',
			'fas fa-ticket' => 'ticket',
			'far fa-ticket' => 'ticket',
			'fal fa-ticket' => 'ticket',
			'fas fa-thumbtack' => 'thumbtack',
			'far fa-thumbtack' => 'thumbtack',
			'fal fa-thumbtack' => 'thumbtack',
			'fas fa-thumbs-up' => 'thumbs-up',
			'far fa-thumbs-up' => 'thumbs-up',
			'fal fa-thumbs-up' => 'thumbs-up',
			'fas fa-thumbs-down' => 'thumbs-down',
			'far fa-thumbs-down' => 'thumbs-down',
			'fal fa-thumbs-down' => 'thumbs-down',
			'fas fa-thermometer-three-quarters' => 'thermometer-three-quarters',
			'far fa-thermometer-three-quarters' => 'thermometer-three-quarters',
			'fal fa-thermometer-three-quarters' => 'thermometer-three-quarters',
			'fas fa-thermometer-quarter' => 'thermometer-quarter',
			'far fa-thermometer-quarter' => 'thermometer-quarter',
			'fal fa-thermometer-quarter' => 'thermometer-quarter',
			'fas fa-thermometer-half' => 'thermometer-half',
			'far fa-thermometer-half' => 'thermometer-half',
			'fal fa-thermometer-half' => 'thermometer-half',
			'fas fa-thermometer-full' => 'thermometer-full',
			'far fa-thermometer-full' => 'thermometer-full',
			'fal fa-thermometer-full' => 'thermometer-full',
			'fas fa-thermometer-empty' => 'thermometer-empty',
			'far fa-thermometer-empty' => 'thermometer-empty',
			'fal fa-thermometer-empty' => 'thermometer-empty',
			'fas fa-thermometer' => 'thermometer',
			'far fa-thermometer' => 'thermometer',
			'fal fa-thermometer' => 'thermometer',
			'fab fa-themeisle' => 'themeisle',
			'fas fa-th-list' => 'th-list',
			'far fa-th-list' => 'th-list',
			'fal fa-th-list' => 'th-list',
			'fas fa-th-large' => 'th-large',
			'far fa-th-large' => 'th-large',
			'fal fa-th-large' => 'th-large',
			'fas fa-th' => 'th',
			'far fa-th' => 'th',
			'fal fa-th' => 'th',
			'fas fa-text-width' => 'text-width',
			'far fa-text-width' => 'text-width',
			'fal fa-text-width' => 'text-width',
			'fas fa-text-height' => 'text-height',
			'far fa-text-height' => 'text-height',
			'fal fa-text-height' => 'text-height',
			'fas fa-terminal' => 'terminal',
			'far fa-terminal' => 'terminal',
			'fal fa-terminal' => 'terminal',
			'fas fa-tennis-ball' => 'tennis-ball',
			'far fa-tennis-ball' => 'tennis-ball',
			'fal fa-tennis-ball' => 'tennis-ball',
			'fab fa-tencent-weibo' => 'tencent-weibo',
			'fab fa-telegram-plane' => 'telegram-plane',
			'fab fa-telegram' => 'telegram',
			'fab fa-teamspeak' => 'teamspeak',
			'fas fa-taxi' => 'taxi',
			'far fa-taxi' => 'taxi',
			'fal fa-taxi' => 'taxi',
			'fas fa-tasks' => 'tasks',
			'far fa-tasks' => 'tasks',
			'fal fa-tasks' => 'tasks',
			'fas fa-tape' => 'tape',
			'far fa-tape' => 'tape',
			'fal fa-tape' => 'tape',
			'fas fa-tags' => 'tags',
			'far fa-tags' => 'tags',
			'fal fa-tags' => 'tags',
			'fas fa-tag' => 'tag',
			'far fa-tag' => 'tag',
			'fal fa-tag' => 'tag',
			'fas fa-tachometer-alt' => 'tachometer-alt',
			'far fa-tachometer-alt' => 'tachometer-alt',
			'fal fa-tachometer-alt' => 'tachometer-alt',
			'fas fa-tachometer' => '',
			'far fa-tachometer' => 'tachometer',
			'fal fa-tachometer' => 'tachometer',
			'fas fa-tablets' => 'tablets',
			'far fa-tablets' => 'tablets',
			'fal fa-tablets' => 'tablets',
			'fas fa-tablet-rugged' => 'tablet-rugged',
			'far fa-tablet-rugged' => 'tablet-rugged',
			'fal fa-tablet-rugged' => 'tablet-rugged',
			'fas fa-tablet-android-alt' => 'tablet-android-alt',
			'far fa-tablet-android-alt' => 'tablet-android-alt',
			'fal fa-tablet-android-alt' => 'tablet-android-alt',
			'fas fa-tablet-android' => 'tablet-android',
			'far fa-tablet-android' => 'tablet-android',
			'fal fa-tablet-android' => 'tablet-android',
			'fab fa-android' => 'fa-android',
			'fas fa-tablet-alt' => 'tablet-alt',
			'far fa-tablet-alt' => 'tablet-alt',
			'fal fa-tablet-alt' => 'tablet-alt',
			'fas fa-tablet' => 'tablet',
			'far fa-tablet' => 'tablet',
			'fal fa-tablet' => 'tablet',
			'fas fa-table-tennis' => 'table-tennis',
			'far fa-table-tennis' => 'table-tennis',
			'fal fa-table-tennis' => 'table-tennis',
			'fas fa-table' => 'table',
			'far fa-table' => 'table',
			'fal fa-table' => 'table',
			'fas fa-syringe' => 'syringe',
			'far fa-syringe' => 'syringe',
			'fal fa-syringe' => 'syringe',
			'fas fa-sync-alt' => 'sync-alt',
			'far fa-sync-alt' => 'sync-alt',
			'fal fa-sync-alt' => 'sync-alt',
			'fas fa-sync' => 'sync',
			'far fa-sync' => 'sync',
			'fal fa-sync' => 'sync',
			'fab fa-supple' => 'supple',
			'fas fa-superscript' => 'superscript',
			'far fa-superscript' => 'superscript',
			'fal fa-superscript' => 'superscript',
			'fab fa-superpowers' => 'superpowers',
			'fas fa-sun' => 'sun',
			'far fa-sun' => 'sun',
			'fal fa-sun' => 'sun',
			'fas fa-suitcase' => 'suitcase',
			'far fa-suitcase' => 'suitcase',
			'fal fa-suitcase' => 'suitcase',
			'fas fa-subway' => 'subway',
			'far fa-subway' => 'subway',
			'fal fa-subway' => 'subway',
			'fas fa-subscript' => 'subscript',
			'far fa-subscript' => 'subscript',
			'fal fa-subscript' => 'subscript',
			'fab fa-stumbleupon-circle' => 'stumbleupon-circle',
			'fab fa-stumbleupon' => 'stumbleupon',
			'fab fa-studiovinari' => 'studiovinari',
			'fab fa-stripe-s' => 'stripe-s',
			'fab fa-stripe' => 'stripe',
			'fas fa-strikethrough' => 'strikethrough',
			'far fa-strikethrough' => 'strikethrough',
			'fal fa-strikethrough' => 'strikethrough',
			'fas fa-street-view' => 'street-view',
			'far fa-street-view' => 'street-view',
			'fal fa-street-view' => 'street-view',
			'fab fa-strava' => 'strava',
			'fas fa-stopwatch' => 'stopwatch',
			'far fa-stopwatch' => 'stopwatch',
			'fal fa-stopwatch' => 'stopwatch',
			'fas fa-stop-circle' => 'stop-circle',
			'far fa-stop-circle' => 'stop-circle',
			'fal fa-stop-circle' => 'stop-circle',
			'fas fa-stop' => 'stop',
			'far fa-stop' => 'stop',
			'fal fa-stop' => 'stop',
			'fas fa-sticky-note' => 'sticky-note',
			'far fa-sticky-note' => 'sticky-note',
			'fal fa-sticky-note' => 'sticky-note',
			'fab fa-sticker-mule' => 'sticker-mule',
			'fas fa-stethoscope' => 'stethoscope',
			'far fa-stethoscope' => 'stethoscope',
			'fal fa-stethoscope' => 'stethoscope',
			'fas fa-step-forward' => 'step-forward',
			'far fa-step-forward' => 'step-forward',
			'fal fa-step-forward' => 'step-forward',
			'fas fa-step-backward' => 'step-backward',
			'far fa-step-backward' => 'step-backward',
			'fal fa-step-backward' => 'step-backward',
			'fab fa-steam-symbol' => 'steam-symbol',
			'fab fa-steam-square' => 'steam-square',
			'fab fa-steam' => 'steam',
			'fab fa-staylinked' => 'staylinked',
			'fas fa-star-half' => 'star-half',
			'far fa-star-half' => 'star-half',
			'fal fa-star-half' => 'star-half',
			'fas fa-star-exclamation' => 'star-exclamation',
			'far fa-star-exclamation' => 'star-exclamation',
			'fal fa-star-exclamation' => 'star-exclamation',
			'fas fa-star' => 'star',
			'far fa-star' => 'star',
			'fal fa-star' => 'star',
			'fab fa-stack-overflow' => 'stack-overflow',
			'fab fa-stack-exchange' => 'stack-exchange',
			'fas fa-square-full' => 'square-full',
			'far fa-square-full' => 'square-full',
			'fal fa-square-full' => 'square-full',
			'fas fa-square' => 'square',
			'far fa-square' => 'square',
			'fal fa-square' => 'square',
			'fab fa-spotify' => 'spotify',
			'fas fa-spinner-third' => 'spinner-third',
			'far fa-spinner-third' => 'spinner-third',
			'fal fa-spinner-third' => 'spinner-third',
			'fas fa-spinner' => 'spinner',
			'far fa-spinner' => 'spinner',
			'fal fa-spinner' => 'spinner',
			'fab fa-speakap' => 'speakap',
			'fas fa-spade' => 'spade',
			'far fa-spade' => 'spade',
			'fal fa-spade' => 'spade',
			'fas fa-space-shuttle' => 'space-shuttle',
			'far fa-space-shuttle' => 'space-shuttle',
			'fal fa-space-shuttle' => 'space-shuttle',
			'fab fa-soundcloud' => '',
			'fas fa-sort-up' => 'sort-up',
			'far fa-sort-up' => 'sort-up',
			'fal fa-sort-up' => 'sort-up',
			'fas fa-sort-numeric-up' => 'sort-numeric-up',
			'far fa-sort-numeric-up' => 'sort-numeric-up',
			'fal fa-sort-numeric-up' => 'sort-numeric-up',
			'fas fa-sort-numeric-down' => 'sort-numeric-down',
			'far fa-sort-numeric-down' => 'sort-numeric-down',
			'fal fa-sort-numeric-down' => 'sort-numeric-down',
			'fas fa-sort-down' => 'sort-down',
			'far fa-sort-down' => 'sort-down',
			'fal fa-sort-down' => 'sort-down',
			'fas fa-sort-amount-up' => 'sort-amount-up',
			'far fa-sort-amount-up' => 'sort-amount-up',
			'fal fa-sort-amount-up' => 'sort-amount-up',
			'fas fa-sort-amount-down' => 'sort-amount-down',
			'far fa-sort-amount-down' => 'sort-amount-down',
			'fal fa-sort-amount-down' => 'sort-amount-down',
			'fas fa-sort-alpha-up' => 'sort-alpha-up',
			'far fa-sort-alpha-up' => 'sort-alpha-up',
			'fal fa-sort-alpha-up' => 'sort-alpha-up',
			'fas fa-sort-alpha-down' => 'sort-alpha-down',
			'far fa-sort-alpha-down' => 'sort-alpha-down',
			'fal fa-sort-alpha-down' => 'sort-alpha-down',
			'fas fa-sort' => 'sort',
			'far fa-sort' => 'sort',
			'fal fa-sort' => 'sort',
			'fas fa-snowflake' => 'snowflake',
			'far fa-snowflake' => 'snowflake',
			'fal fa-snowflake' => 'snowflake',
			'fab fa-snapchat-square' => 'snapchat-square',
			'fab fa-snapchat-ghost' => 'snapchat-ghost',
			'fab fa-snapchat' => 'snapchat',
			'fas fa-smoking' => 'smoking',
			'far fa-smoking' => 'smoking',
			'fal fa-smoking' => 'smoking',
			'fas fa-smile-plus' => 'smile-plus',
			'far fa-smile-plus' => 'smile-plus',
			'fal fa-smile-plus' => 'smile-plus',
			'fas fa-smile' => 'smile',
			'far fa-smile' => 'smile',
			'fal fa-smile' => 'smile',
			'fab fa-slideshare' => 'slideshare',
			'fas fa-sliders-v-square' => 'sliders-v-square',
			'far fa-sliders-v-square' => 'sliders-v-square',
			'fal fa-sliders-v-square' => 'sliders-v-square',
			'fas fa-sliders-v' => 'sliders-v',
			'far fa-sliders-v' => 'sliders-v',
			'fal fa-sliders-v' => 'sliders-v',
			'fas fa-sliders-h-square' => 'sliders-h-square',
			'far fa-sliders-h-square' => 'sliders-h-square',
			'fal fa-sliders-h-square' => 'sliders-h-square',
			'fas fa-sliders-h' => 'sliders-h',
			'far fa-sliders-h' => 'sliders-h',
			'fal fa-sliders-h' => 'sliders-h',
			'fab fa-slack-hash' => 'slack-hash',
			'fab fa-slack' => 'slack',
			'fab fa-skype' => 'skype',
			'fab fa-skyatlas' => 'skyatlas',
			'fab fa-sith' => 'sith',
			'fas fa-sitemap' => 'sitemap',
			'far fa-sitemap' => 'sitemap',
			'fal fa-sitemap' => 'sitemap',
			'fab fa-sistrix' => 'sistrix',
			'fab fa-simplybuilt' => 'simplybuilt',
			'fas fa-signal' => 'signal',
			'far fa-signal' => 'signal',
			'fal fa-signal' => 'signal',
			'fas fa-sign-out-alt' => 'sign-out-alt',
			'far fa-sign-out-alt' => 'sign-out-alt',
			'fal fa-sign-out-alt' => 'sign-out-alt',
			'fas fa-sign-out' => 'sign-out',
			'far fa-sign-out' => 'sign-out',
			'fal fa-sign-out' => 'sign-out',
			'fas fa-sign-language' => 'sign-language',
			'far fa-sign-language' => 'sign-language',
			'fal fa-sign-language' => 'sign-language',
			'fas fa-sign-in-alt' => 'sign-in-alt',
			'far fa-sign-in-alt' => 'sign-in-alt',
			'fal fa-sign-in-alt' => 'sign-in-alt',
			'fas fa-sign-in' => 'sign-in',
			'far fa-sign-in' => 'sign-in',
			'fal fa-sign-in' => 'sign-in',
			'fas fa-sign' => 'fa-sign',
			'far fa-sign' => 'fa-sign',
			'fal fa-sign' => 'fa-sign',
			'fas fa-shuttlecock' => 'fa-shuttlecock',
			'far fa-shuttlecock' => 'fa-shuttlecock',
			'fal fa-shuttlecock' => 'fa-shuttlecock',
			'fas fa-shower' => 'fa-shower',
			'far fa-shower' => 'fa-shower',
			'fal fa-shower' => 'fa-shower',
			'fas fa-shopping-cart' => 'shopping-cart',
			'far fa-shopping-cart' => 'shopping-cart',
			'fal fa-shopping-cart' => 'shopping-cart',
			'fas fa-shopping-basket' => 'shopping-basket',
			'far fa-shopping-basket' => 'shopping-basket',
			'fal fa-shopping-basket' => 'shopping-basket',
			'fas fa-shopping-bag' => 'shopping-bag',
			'far fa-shopping-bag' => 'shopping-bag',
			'fal fa-shopping-bag' => 'shopping-bag',
			'fab fa-shirtsinbulk' => 'shirtsinbulk',
			'fas fa-shipping-timed' => 'shipping-timed',
			'far fa-shipping-timed' => 'shipping-timed',
			'fal fa-shipping-timed' => 'shipping-timed',
			'fas fa-shipping-fast' => 'shipping-fast',
			'far fa-shipping-fast' => 'shipping-fast',
			'fal fa-shipping-fast' => 'shipping-fast',
			'fas fa-ship' => 'ship',
			'far fa-ship' => 'ship',
			'fal fa-ship' => 'ship',
			'fas fa-shield-check' => 'shield-check',
			'far fa-shield-check' => 'shield-check',
			'fal fa-shield-check' => 'shield-check',
			'fas fa-shield-alt' => 'shield-alt',
			'far fa-shield-alt' => 'shield-alt',
			'fal fa-shield-alt' => 'shield-alt',
			'fas fa-shield' => 'shield',
			'far fa-shield' => 'shield',
			'fal fa-shield' => 'shield',
			'fas fa-shekel-sign' => 'shekel-sign',
			'far fa-shekel-sign' => 'shekel-sign',
			'fal fa-shekel-sign' => 'shekel-sign',
			'fas fa-share-square' => 'share-square',
			'far fa-share-square' => 'share-square',
			'fal fa-share-square' => 'share-square',
			'fas fa-share-alt-square' => 'share-alt-square',
			'far fa-share-alt-square' => 'share-alt-square',
			'fal fa-share-alt-square' => 'share-alt-square',
			'fas fa-share-alt' => 'share-alt',
			'far fa-share-alt' => 'share-alt',
			'fal fa-share-alt' => 'share-alt',
			'fas fa-share-all' => 'share-all',
			'far fa-share-all' => 'share-all',
			'fal fa-share-all' => 'share-all',
			'fas fa-share' => 'share',
			'far fa-share' => 'share',
			'fal fa-share' => 'share',
			'fab fa-servicestack' => 'servicestack',
			'fas fa-server' => 'server',
			'far fa-server' => 'server',
			'fal fa-server' => 'server',
			'fab fa-sellsy' => 'sellsy',
			'fab fa-sellcast' => 'sellcast',
			'fas fa-seedling' => 'seedling',
			'far fa-seedling' => 'seedling',
			'fal fa-seedling' => 'seedling',
			'fab fa-searchengin' => 'searchengin',
			'fas fa-search-plus' => 'search-plus',
			'far fa-search-plus' => 'search-plus',
			'fal fa-search-plus' => 'search-plus',
			'fas fa-search-minus' => 'search-minus',
			'far fa-search-minus' => 'search-minus',
			'fal fa-search-minus' => 'search-minus',
			'fas fa-search' => 'search',
			'far fa-search' => 'search',
			'fal fa-search' => 'search',
			'fas fa-scrubber' => 'scrubber',
			'far fa-scrubber' => 'scrubber',
			'fal fa-scrubber' => 'scrubber',
			'fab fa-scribd' => 'scribd',
			'fab fa-schlix' => 'schlix',
			'fas fa-scanner-touchscreen' => 'scanner-touchscreen',
			'far fa-scanner-touchscreen' => 'scanner-touchscreen',
			'fal fa-scanner-touchscreen' => 'scanner-touchscreen',
			'fas fa-scanner-keyboard' => 'scanner-keyboard',
			'far fa-scanner-keyboard' => 'scanner-keyboard',
			'fal fa-scanner-keyboard' => 'scanner-keyboard',
			'fas fa-scanner' => 'scanner',
			'far fa-scanner' => 'scanner',
			'fal fa-scanner' => 'scanner',
			'fas fa-rectangle-portrait' => 'rectangle-portrait',
			'far fa-rectangle-portrait' => 'rectangle-portrait',
			'fal fa-rectangle-portrait' => 'rectangle-portrait',
			'fas fa-rectangle-landscape' => 'rectangle-landscape',
			'far fa-rectangle-landscape' => 'rectangle-landscape',
			'fal fa-rectangle-landscape' => 'rectangle-landscape',
			'fab fa-rebel' => 'rebel',
			'fab fa-readme' => 'readme',
			'fab fa-react' => 'react',
			'fab fa-ravelry' => 'ravelry',
			'fas fa-random' => 'random',
			'far fa-random' => 'random',
			'fal fa-random' => 'random',
			'fas fa-ramp-loading' => 'ramp-loading',
			'far fa-ramp-loading' => 'ramp-loading',
			'fal fa-ramp-loading' => 'ramp-loading',
			'fas fa-racquet' => 'racquet',
			'far fa-racquet' => 'racquet',
			'fal fa-racquet' => 'racquet',
			'fab fa-r-project' => 'r-project',
			'fas fa-quote-right' => 'quote-right',
			'far fa-quote-right' => 'quote-right',
			'fal fa-quote-right' => 'quote-right',
			'fas fa-quote-left' => 'quote-left',
			'far fa-quote-left' => 'quote-left',
			'fal fa-quote-left' => 'quote-left',
			'fab fa-quora' => 'quora',
			'fab fa-quinscape' => 'quinscape',
			'fas fa-quidditch' => 'quidditch',
			'far fa-quidditch' => 'quidditch',
			'fal fa-quidditch' => 'quidditch',
			'fas fa-question-square' => 'question-square',
			'far fa-question-square' => 'question-square',
			'fal fa-question-square' => 'question-square',
			'fas fa-question-circle' => 'question-circle',
			'far fa-question-circle' => 'question-circle',
			'fal fa-question-circle' => 'question-circle',
			'fas fa-question' => 'question',
			'far fa-question' => 'question',
			'fal fa-question' => 'question',
			'fas fa-qrcode' => 'qrcode',
			'far fa-qrcode' => 'qrcode',
			'fal fa-qrcode' => 'qrcode',
			'fab fa-qq' => 'qq',
			'fab fa-python' => 'python',
			'fas fa-puzzle-piece' => 'puzzle-piece',
			'far fa-puzzle-piece' => 'puzzle-piece',
			'fal fa-puzzle-piece' => 'puzzle-piece',
			'fab fa-pushed' => 'pushed',
			'fab fa-product-hunt' => 'product-hunt',
			'fas fa-procedures' => 'procedures',
			'far fa-procedures' => 'procedures',
			'fal fa-procedures' => 'procedures',
			'fas fa-print' => 'print',
			'far fa-print' => 'print',
			'fal fa-print' => 'print',
			'fas fa-prescription-bottle-alt' => 'prescription-bottle-alt',
			'far fa-prescription-bottle-alt' => 'prescription-bottle-alt',
			'fal fa-prescription-bottle-alt' => 'prescription-bottle-alt',
			'fas fa-prescription-bottle' => 'prescription-bottle',
			'far fa-prescription-bottle' => 'prescription-bottle',
			'fal fa-prescription-bottle' => 'prescription-bottle',
			'fas fa-power-off' => 'power-off',
			'far fa-power-off' => 'power-off',
			'fal fa-power-off' => 'power-off',
			'fas fa-pound-sign' => 'pound-sign',
			'far fa-pound-sign' => 'pound-sign',
			'fal fa-pound-sign' => 'pound-sign',
			'fas fa-portrait' => 'portrait',
			'far fa-portrait' => 'portrait',
			'fal fa-portrait' => 'portrait',
			'fas fa-poo' => 'poo',
			'far fa-poo' => 'poo',
			'fal fa-poo' => 'poo',
			'fas fa-podcast' => 'podcast',
			'far fa-podcast' => 'podcast',
			'fal fa-podcast' => 'podcast',
			'fas fa-plus-square' => 'plus-square',
			'far fa-plus-square' => 'plus-square',
			'fal fa-plus-square' => 'plus-square',
			'fas fa-plus-octagon' => 'plus-octagon',
			'far fa-plus-octagon' => 'plus-octagon',
			'fal fa-plus-octagon' => 'plus-octagon',
			'fas fa-plus-hexagon' => 'plus-hexagon',
			'far fa-plus-hexagon' => 'plus-hexagon',
			'fal fa-plus-hexagon' => 'plus-hexagon',
			'fas fa-plus-circle' => 'plus-circle',
			'far fa-plus-circle' => 'plus-circle',
			'fal fa-plus-circle' => 'plus-circle',
			'fas fa-plus' => 'plus',
			'far fa-plus' => 'plus',
			'fal fa-plus' => 'plus',
			'fas fa-plug' => 'plug',
			'far fa-plug' => 'plug',
			'fal fa-plug' => 'plug',
			'fab fa-playstation' => 'playstation',
			'fas fa-play-circle' => 'play-circle',
			'far fa-play-circle' => 'play-circle',
			'fal fa-play-circle' => 'play-circle',
			'fas fa-play' => 'play',
			'far fa-play' => 'play',
			'fal fa-play' => 'play',
			'fas fa-plane-alt' => 'plane-alt',
			'far fa-plane-alt' => 'plane-alt',
			'fal fa-plane-alt' => 'plane-alt',
			'fas fa-plane' => 'plane',
			'far fa-plane' => 'plane',
			'fal fa-plane' => 'plane',
			'fas fa-rocket' => 'rocket',
			'far fa-rocket' => 'rocket',
			'fal fa-rocket' => 'rocket',
			'fas fa-space-shuttle' => 'space shuttle',
			'far fa-space-shuttle' => 'space shuttle',
			'fal fa-space-shuttle' => 'space shuttle',
			'fab fa-pinterest-square' => 'pinterest-square',
			'fab fa-pinterest-p' => 'pinterest-p',
			'fab fa-pinterest' => '',
			'fas fa-pills' => 'pills',
			'far fa-pills' => 'pills',
			'fal fa-pills' => 'pills',
			'fas fa-piggy-bank' => 'piggy-bank',
			'far fa-piggy-bank' => 'piggy-bank',
			'fal fa-piggy-bank' => 'piggy-bank',
			'fas fa-pig' => 'pig',
			'far fa-pig' => 'pig',
			'fal fa-pig' => 'pig',
			'fab fa-pied-piper-pp' => 'pied-piper-pp',
			'fab fa-pied-piper-hat' => 'pied-piper-hat',
			'fab fa-pied-piper-alt' => 'pied-piper-alt',
			'fab fa-pied-piper' => 'pied-piper',
			'fab fa-php' => 'php',
			'fas fa-phone-volume' => 'phone-volume',
			'far fa-phone-volume' => 'phone-volume',
			'fal fa-phone-volume' => 'phone-volume',
			'fas fa-phone-square' => 'phone-square',
			'far fa-phone-square' => 'phone-square',
			'fal fa-phone-square' => 'phone-square',
			'fas fa-phone-slash' => 'phone-slash',
			'far fa-phone-slash' => 'phone-slash',
			'fal fa-phone-slash' => 'phone-slash',
			'fas fa-phone-plus' => 'phone-plus',
			'far fa-phone-plus' => 'phone-plus',
			'fal fa-phone-plus' => 'phone-plus',
			'fas fa-phone' => 'phone',
			'far fa-phone' => 'phone',
			'fal fa-phone' => 'phone',
			'fab fa-phoenix-squadron' => 'phoenix-squadron',
			'fab fa-phoenix-framework' => 'phoenix-framework',
			'fab fa-phabricator' => 'phabricator',
			'fas fa-person-dolly-empty' => 'person-dolly-empty',
			'far fa-person-dolly-empty' => 'person-dolly-empty',
			'fal fa-person-dolly-empty' => 'person-dolly-empty',
			'fas fa-person-dolly' => 'person-dolly',
			'far fa-person-dolly' => 'person-dolly',
			'fal fa-person-dolly' => 'person-dolly',
			'fas fa-person-carry' => 'person-carry',
			'far fa-person-carry' => 'person-carry',
			'fal fa-person-carry' => 'person-carry',
			'fab fa-periscope' => 'periscope',
			'fas fa-percent' => 'percent',
			'far fa-percent' => 'percent',
			'fal fa-percent' => 'percent',
			'fas fa-people-carry' => 'people-carry',
			'far fa-people-carry' => 'people-carry',
			'fal fa-people-carry' => 'people-carry',
			'fas fa-pennant' => 'pennant',
			'far fa-pennant' => 'pennant',
			'fal fa-pennant' => 'pennant',
			'fas fa-pencil-alt' => 'pencil-alt',
			'far fa-pencil-alt' => 'pencil-alt',
			'fal fa-pencil-alt' => 'pencil-alt',
			'fas fa-pencil' => 'pencil',
			'far fa-pencil' => 'pencil',
			'fal fa-pencil' => 'pencil',
			'fas fa-pen-square' => 'pen-square',
			'far fa-pen-square' => 'pen-square',
			'fal fa-pen-square' => 'pen-square',
			'fas fa-pen-alt' => 'pen-alt',
			'far fa-pen-alt' => 'pen-alt',
			'fal fa-pen-alt' => 'pen-alt',
			'fas fa-pen' => 'pen',
			'far fa-pen' => 'pen',
			'fal fa-pen' => 'pen',
			'fab fa-paypal' => 'paypal',
			'fas fa-paw' => 'paw',
			'far fa-paw' => 'paw',
			'fal fa-paw' => 'paw',
			'fas fa-pause-circle' => 'pause-circle',
			'far fa-pause-circle' => 'pause-circle',
			'fal fa-pause-circle' => 'pause-circle',
			'fas fa-pause' => 'pause',
			'far fa-pause' => 'pause',
			'fal fa-pause' => 'pause',
			'fab fa-patreon' => 'patreon',
			'fas fa-paste' => 'paste',
			'far fa-paste' => 'paste',
			'fal fa-paste' => 'paste',
			'fas fa-paragraph' => 'paragraph',
			'far fa-paragraph' => 'paragraph',
			'fal fa-paragraph' => 'paragraph',
			'fas fa-parachute-box' => 'parachute-box',
			'far fa-parachute-box' => 'parachute-box',
			'fal fa-parachute-box' => 'parachute-box',
			'fas fa-paperclip' => 'paperclip',
			'far fa-paperclip' => 'paperclip',
			'fal fa-paperclip' => 'paperclip',
			'fas fa-paper-plane' => 'paper-plane',
			'far fa-paper-plane' => 'paper-plane',
			'fal fa-paper-plane' => 'paper-plane',
			'fas fa-pallet-alt' => 'pallet-alt',
			'far fa-pallet-alt' => 'pallet-alt',
			'fal fa-pallet-alt' => 'pallet-alt',
			'fas fa-pallet' => 'pallet',
			'far fa-pallet' => 'pallet',
			'fal fa-pallet' => 'pallet',
			'fas fa-tty' => 'tty',
			'far fa-tty' => 'tty',
			'fal fa-tty' => 'tty',
			'fab fa-palfed' => 'palfed',
			'fas fa-paint-brush' => 'paint-brush',
			'far fa-paint-brush' => 'paint-brush',
			'fal fa-paint-brush' => 'paint-brush',
			'fab fa-pagelines' => 'pagelines',
			'fab fa-page4' => 'page4',
			'fas fa-outdent' => 'outdent',
			'far fa-outdent' => 'outdent',
			'fal fa-outdent' => 'outdent',
			'fab fa-osi' => 'osi',
			'fab fa-optin-monster' => 'optin-monster',
			'fab fa-opera' => 'opera',
			'fab fa-openid' => 'openid',
			'fab fa-opencart' => 'opencart',
			'fab fa-old-republic' => 'old-republic',
			'fab fa-odnoklassniki-square' => 'odnoklassniki-square',
			'fab fa-odnoklassniki' => 'odnoklassniki',
			'fas fa-octagon' => 'octagon',
			'far fa-octagon' => 'octagon',
			'fal fa-octagon' => 'octagon',
			'fas fa-object-ungroup' => 'object-ungroup',
			'far fa-object-ungroup' => 'object-ungroup',
			'fal fa-object-ungroup' => 'object-ungroup',
			'fas fa-object-group' => 'object-group',
			'far fa-object-group' => 'object-group',
			'fal fa-object-group' => 'object-group',
			'fab fa-nutritionix' => 'nutritionix',
			'fab fa-ns8' => 'ns8',
			'fab fa-npm' => 'npm',
			'fas fa-notes-medical' => 'notes-medical',
			'far fa-notes-medical' => 'notes-medical',
			'fal fa-notes-medical' => 'notes-medical',
			'fab fa-node-js' => 'node-js',
			'fab fa-node' => 'node',
			'fab fa-nintendo-switch' => 'nintendo-switch',
			'fas fa-newspaper' => 'newspaper',
			'far fa-newspaper' => 'newspaper',
			'fal fa-newspaper' => 'newspaper',
			'fas fa-neuter' => 'neuter',
			'far fa-neuter' => 'neuter',
			'fal fa-neuter' => 'neuter',
			'fab fa-napster' => 'napster',
			'fas fa-music' => 'music',
			'far fa-music' => 'music',
			'fal fa-music' => 'music',
			'fas fa-mouse-pointer' => 'mouse-pointer',
			'far fa-mouse-pointer' => 'mouse-pointer',
			'fal fa-mouse-pointer' => 'mouse-pointer',
			'fas fa-motorcycle' => 'motorcycle',
			'far fa-motorcycle' => 'motorcycle',
			'fal fa-motorcycle' => 'motorcycle',
			'fas fa-moon' => 'moon',
			'far fa-moon' => 'moon',
			'fal fa-moon' => 'moon',
			'fas fa-money-bill-alt' => 'money-bill-alt',
			'far fa-money-bill-alt' => 'money-bill-alt',
			'fal fa-money-bill-alt' => 'money-bill-alt',
			'fas fa-money-bill' => 'money-bill',
			'far fa-money-bill' => 'money-bill',
			'fal fa-money-bill' => 'money-bill',
			'fab fa-monero' => 'monero',
			'fab fa-modx' => 'modx',
			'fas fa-mobile-android-alt' => 'mobile-android-alt',
			'far fa-mobile-android-alt' => 'mobile-android-alt',
			'fal fa-mobile-android-alt' => 'mobile-android-alt',
			'fas fa-mobile-android' => 'mobile-android',
			'far fa-mobile-android' => 'mobile-android',
			'fal fa-mobile-android' => 'mobile-android',
			'fas fa-mobile-alt' => 'mobile-alt',
			'far fa-mobile-alt' => 'mobile-alt',
			'fal fa-mobile-alt' => 'mobile-alt',
			'fas fa-mobile' => 'mobile',
			'far fa-mobile' => 'mobile',
			'fal fa-mobile' => 'mobile',
			'fab fa-mizuni' => 'mizuni',
			'fab fa-mixcloud' => 'mixcloud',
			'fab fa-mix' => 'mix',
			'fas fa-minus-square' => 'minus-square',
			'far fa-minus-square' => 'minus-square',
			'fal fa-minus-square' => 'minus-square',
			'fas fa-minus-octagon' => 'minus-octagon',
			'far fa-minus-octagon' => 'minus-octagon',
			'fal fa-minus-octagon' => 'minus-octagon',
			'fas fa-minus-hexagon' => 'minus-hexagon',
			'far fa-minus-hexagon' => 'minus-hexagon',
			'fal fa-minus-hexagon' => 'minus-hexagon',
			'fas fa-minus-circle' => 'minus-circle',
			'far fa-minus-circle' => 'minus-circle',
			'fal fa-minus-circle' => 'minus-circle',
			'fas fa-minus' => 'minus',
			'far fa-minus' => 'minus',
			'fal fa-minus' => 'minus',
			'fab fa-microsoft' => 'microsoft',
			'fas fa-microphone-slash' => 'microphone-slash',
			'far fa-microphone-slash' => 'microphone-slash',
			'fal fa-microphone-slash' => 'microphone-slash',
			'fas fa-microphone-alt' => 'microphone-alt',
			'far fa-microphone-alt' => 'microphone-alt',
			'fal fa-microphone-alt' => 'microphone-alt',
			'fas fa-microphone' => 'microphone',
			'far fa-microphone' => 'microphone',
			'fal fa-microphone' => 'microphone',
			'fas fa-microchip' => 'microchip',
			'far fa-microchip' => 'microchip',
			'fal fa-microchip' => 'microchip',
			'fas fa-mercury' => 'mercury',
			'far fa-mercury' => 'mercury',
			'fal fa-mercury' => 'mercury',
			'fas fa-meh' => 'meh',
			'far fa-meh' => 'meh',
			'fal fa-meh' => 'meh',
			'fab fa-meetup' => 'meetup',
			'fab fa-medrt' => 'medrt',
			'fas fa-medkit' => 'medkit',
			'far fa-medkit' => 'medkit',
			'fal fa-medkit' => 'medkit',
			'fab fa-medium-m' => 'medium-m',
			'fab fa-medium' => 'medium',
			'fab fa-medapps' => 'medapps',
			'fab fa-maxcdn' => 'maxcdn',
			'fab fa-mastodon' => 'mastodon',
			'fas fa-mars-stroke-v' => 'mars-stroke-v',
			'far fa-mars-stroke-v' => 'mars-stroke-v',
			'fal fa-mars-stroke-v' => 'mars-stroke-v',
			'fas fa-mars-stroke-h' => 'mars-stroke-h',
			'far fa-mars-stroke-h' => 'mars-stroke-h',
			'fal fa-mars-stroke-h' => 'mars-stroke-h',
			'fas fa-mars-stroke' => 'mars-stroke',
			'far fa-mars-stroke' => 'mars-stroke',
			'fal fa-mars-stroke' => 'mars-stroke',
			'fas fa-mars-double' => 'mars-double',
			'far fa-mars-double' => 'mars-double',
			'fal fa-mars-double' => 'mars-double',
			'fas fa-mars' => 'mars',
			'far fa-mars' => 'mars',
			'fal fa-mars' => 'mars',
			'fas fa-map-signs' => 'map-signs',
			'far fa-map-signs' => 'map-signs',
			'fal fa-map-signs' => 'map-signs',
			'fas fa-map-pin' => 'map-pin',
			'far fa-map-pin' => 'map-pin',
			'fal fa-map-pin' => 'map-pin',
			'fas fa-map-marker-alt' => 'map-marker-alt',
			'far fa-map-marker-alt' => 'map-marker-alt',
			'fal fa-map-marker-alt' => 'map-marker-alt',
			'fas fa-map-marker' => 'map-marker',
			'far fa-map-marker' => 'map-marker',
			'fal fa-map-marker' => 'map-marker',
			'fal fa-map-marked-alt' => 'map-marked-alt',
			'fas fa-map' => 'map',
			'far fa-map' => 'map',
			'fal fa-map' => 'map',
			'fab fa-mandalorian' => 'mandalorian',
			'fas fa-male' => 'male',
			'far fa-male' => 'male',
			'fal fa-male' => 'male',
			'fas fa-magnet' => 'magnet',
			'far fa-magnet' => 'magnet',
			'fal fa-magnet' => 'magnet',
			'fas fa-magic' => 'magic',
			'far fa-magic' => 'magic',
			'fal fa-magic' => 'magic',
			'fab fa-magento' => 'magento',
			'fab fa-lyft' => 'lyft',
			'fas fa-luchador' => 'luchador',
			'far fa-luchador' => 'luchador',
			'fal fa-luchador' => 'luchador',
			'fas fa-low-vision' => 'low-vision',
			'far fa-low-vision' => 'low-vision',
			'fal fa-low-vision' => 'low-vision',
			'fas fa-loveseat' => 'loveseat',
			'far fa-loveseat' => 'loveseat',
			'fal fa-loveseat' => 'loveseat',
			'fas fa-long-arrow-up' => 'long-arrow-up',
			'far fa-long-arrow-up' => 'long-arrow-up',
			'fal fa-long-arrow-up' => 'long-arrow-up',
			'fas fa-long-arrow-right' => 'long-arrow-right',
			'far fa-long-arrow-right' => 'long-arrow-right',
			'fal fa-long-arrow-right' => 'long-arrow-right',
			'fas fa-long-arrow-left' => 'long-arrow-left',
			'far fa-long-arrow-left' => 'long-arrow-left',
			'fal fa-long-arrow-left' => 'long-arrow-left',
			'fas fa-long-arrow-down' => 'long-arrow-down',
			'far fa-long-arrow-down' => 'long-arrow-down',
			'fal fa-long-arrow-down' => 'long-arrow-down',
			'fas fa-long-arrow-alt-up' => 'long-arrow-alt-up',
			'far fa-long-arrow-alt-up' => 'long-arrow-alt-up',
			'fal fa-long-arrow-alt-up' => 'long-arrow-alt-up',
			'fas fa-long-arrow-alt-right' => 'long-arrow-alt-right',
			'far fa-long-arrow-alt-right' => 'long-arrow-alt-right',
			'fal fa-long-arrow-alt-right' => 'long-arrow-alt-right',
			'fas fa-long-arrow-alt-left' => 'long-arrow-alt-left',
			'far fa-long-arrow-alt-left' => 'long-arrow-alt-left',
			'fal fa-long-arrow-alt-left' => 'long-arrow-alt-left',
			'fas fa-long-arrow-alt-down' => 'long-arrow-alt-down',
			'far fa-long-arrow-alt-down' => 'long-arrow-alt-down',
			'fal fa-long-arrow-alt-down' => 'long-arrow-alt-down',

			'fas fa-arrow-up' => 'arrow-up',
			'far fa-arrow-up' => 'arrow-up',
			'fal fa-arrow-up' => 'arrow-up',
			'fas fa-arrow-right' => 'arrow-right',
			'far fa-arrow-right' => 'arrow-right',
			'fal fa-arrow-right' => 'arrow-right',
			'fas fa-arrow-down' => 'arrow-down',
			'far fa-arrow-down' => 'arrow-down',
			'fal fa-arrow-down' => 'arrow-down',
			'fas fa-arrow-left' => 'arrow-left',
			'far fa-arrow-left' => 'arrow-left',
			'fal fa-arrow-left' => 'arrow-left',

			'fas fa-arrow-to-top' => 'arrow-to-top',
			'far fa-arrow-to-top' => 'arrow-to-top',
			'fal fa-arrow-to-top' => 'arrow-to-top',
			'fas fa-arrow-to-right' => 'arrow-to-right',
			'far fa-arrow-to-right' => 'arrow-to-right',
			'fal fa-arrow-to-right' => 'arrow-to-right',
			'fas fa-arrow-to-bottom' => 'arrow-to-bottom',
			'far fa-arrow-to-bottom' => 'arrow-to-bottom',
			'fal fa-arrow-to-bottom' => 'arrow-to-bottom',
			'fas fa-arrow-to-left' => 'arrow-to-left',
			'far fa-arrow-to-left' => 'arrow-to-left',
			'fal fa-arrow-to-left' => 'arrow-to-left',

			'fas fa-arrow-alt-up' => 'arrow-alt-up',
			'far fa-arrow-alt-up' => 'arrow-alt-up',
			'fal fa-arrow-alt-up' => 'arrow-alt-up',
			'fas fa-arrow-alt-right' => 'arrow-alt-right',
			'far fa-arrow-alt-right' => 'arrow-alt-right',
			'fal fa-arrow-alt-right' => 'arrow-alt-right',
			'fas fa-arrow-alt-down' => 'arrow-alt-down',
			'far fa-arrow-alt-down' => 'arrow-alt-down',
			'fal fa-arrow-alt-down' => 'arrow-alt-down',
			'fas fa-arrow-alt-left' => 'arrow-alt-left',
			'far fa-arrow-alt-left' => 'arrow-alt-left',
			'fal fa-arrow-alt-left' => 'arrow-alt-left',

			'fas fa-lock-open-alt' => 'lock-open-alt',
			'far fa-lock-open-alt' => 'lock-open-alt',
			'fal fa-lock-open-alt' => 'lock-open-alt',
			'fas fa-lock-open' => 'lock-open',
			'far fa-lock-open' => 'lock-open',
			'fal fa-lock-open' => 'lock-open',
			'fas fa-lock-alt' => 'lock-alt',
			'far fa-lock-alt' => 'lock-alt',
			'fal fa-lock-alt' => 'lock-alt',
			'fas fa-lock' => 'lock',
			'far fa-lock' => 'lock',
			'fal fa-lock' => 'lock',
			'fas fa-location-arrow' => 'location-arrow',
			'far fa-location-arrow' => 'location-arrow',
			'fal fa-location-arrow' => 'location-arrow',
			'fas fa-list-ul' => 'list-ul',
			'far fa-list-ul' => 'list-ul',
			'fal fa-list-ul' => 'list-ul',
			'fas fa-list-ol' => 'list-ol',
			'far fa-list-ol' => 'list-ol',
			'fal fa-list-ol' => 'list-ol',
			'fas fa-list-alt' => 'list-alt',
			'far fa-list-alt' => 'list-alt',
			'fal fa-list-alt' => 'list-alt',
			'fas fa-list' => 'list',
			'far fa-list' => 'list',
			'fal fa-list' => 'list',
			'fas fa-lira-sign' => 'lira-sign',
			'far fa-lira-sign' => 'lira-sign',
			'fal fa-lira-sign' => 'lira-sign',
			'fab fa-linux' => 'linux',
			'fab fa-linode' => 'linode',
			'fab fa-linkedin-in' => 'linkedin-in',
			'fab fa-linkedin' => 'linkedin',
			'fas fa-link' => 'link',
			'far fa-link' => 'link',
			'fal fa-link' => 'link',
			'fab fa-line' => 'line',
			'fas fa-lightbulb' => 'lightbulb',
			'far fa-lightbulb' => 'lightbulb',
			'fal fa-lightbulb' => 'lightbulb',
			'fas fa-life-ring' => 'life-ring',
			'far fa-life-ring' => 'life-ring',
			'fal fa-life-ring' => 'life-ring',
			'fas fa-level-up-alt' => 'level-up-alt',
			'far fa-level-up-alt' => 'level-up-alt',
			'fal fa-level-up-alt' => 'level-up-alt',
			'fas fa-level-up' => 'level-up',
			'far fa-level-up' => 'level-up',
			'fal fa-level-up' => 'level-up',
			'fas fa-level-down-alt' => 'level-down-alt',
			'far fa-level-down-alt' => 'level-down-alt',
			'fal fa-level-down-alt' => 'level-down-alt',
			'fas fa-level-down' => 'level-down',
			'far fa-level-down' => 'level-down',
			'fal fa-level-down' => 'level-down',
			'fab fa-less' => 'less',
			'fas fa-lemon' => 'lemon',
			'far fa-lemon' => 'lemon',
			'fal fa-lemon' => 'lemon',
			'fab fa-leanpub' => 'leanpub',
			'fas fa-leaf-heart' => 'leaf-heart',
			'far fa-leaf-heart' => 'leaf-heart',
			'fal fa-leaf-heart' => 'leaf-heart',
			'fas fa-leaf' => 'leaf',
			'far fa-leaf' => 'leaf',
			'fal fa-leaf' => 'leaf',
			'fab fa-lastfm-square' => 'lastfm-square',
			'fab fa-lastfm' => 'lastfm',
			'fab fa-laravel' => 'laravel',
			'fas fa-laptop' => 'laptop',
			'far fa-laptop' => 'laptop',
			'fal fa-laptop' => 'laptop',
			'fas fa-language' => 'language',
			'far fa-language' => 'language',
			'fal fa-language' => 'language',
			'fas fa-lamp' => 'lamp',
			'far fa-lamp' => 'lamp',
			'fal fa-lamp' => 'lamp',
			'fab fa-korvue' => 'korvue',
			'fab fa-kickstarter-k' => 'kickstarter-k',
			'fab fa-kickstarter' => 'kickstarter',
			'fab fa-keycdn' => 'keycdn',
			'fas fa-keyboard' => 'keyboard',
			'far fa-keyboard' => 'keyboard',
			'fal fa-keyboard' => 'keyboard',
			'fab fa-keybase' => 'keybase',
			'fas fa-key' => 'key',
			'far fa-key' => 'key',
			'fal fa-key' => 'key',
			'fab fa-jsfiddle' => 'jsfiddle',
			'fab fa-js-square' => 'js-square',
			'fab fa-js' => 'js',
			'fab fa-joomla' => 'joomla',
			'fab fa-joget' => 'joget',
			'fab fa-jenkins' => 'jenkins',
			'fab fa-jedi-orderjedi' => '',
			'fab fa-java' => 'java',
			'fas fa-jack-o-lantern' => 'jack-o-lantern',
			'far fa-jack-o-lantern' => 'jack-o-lantern',
			'fal fa-jack-o-lantern' => 'jack-o-lantern',
			'fab fa-itunes-note' => 'itunes-note',
			'fab fa-itunes' => 'itunes',
			'fas fa-italic' => 'italic',
			'far fa-italic' => 'italic',
			'fal fa-italic' => 'italic',
			'fab fa-ioxhost' => 'ioxhost',
			'fas fa-inventory' => 'inventory',
			'far fa-inventory' => 'inventory',
			'fal fa-inventory' => 'inventory',
			'fab fa-internet-explorer' => 'internet-explorer',
			'fab fa-instagram' => 'instagram',
			'fas fa-info-square' => 'info-square',
			'far fa-info-square' => 'info-square',
			'fal fa-info-square' => 'info-square',
			'fas fa-info-circle' => 'info-circle',
			'far fa-info-circle' => 'info-circle',
			'fal fa-info-circle' => 'info-circle',
			'fas fa-info' => 'info',
			'far fa-info' => 'info',
			'fal fa-info' => 'info',
			'fas fa-industry-alt' => 'industry-alt',
			'far fa-industry-alt' => 'industry-alt',
			'fal fa-industry-alt' => 'industry-alt',
			'fas fa-industry' => 'industry',
			'far fa-industry' => 'industry',
			'fal fa-industry' => 'industry',
			'fas fa-indent' => 'indent',
			'far fa-indent' => 'indent',
			'fal fa-indent' => 'indent',
			'fas fa-inbox-out' => 'inbox-out',
			'far fa-inbox-out' => 'inbox-out',
			'fal fa-inbox-out' => 'inbox-out',
			'fas fa-inbox-in' => 'inbox-in',
			'far fa-inbox-in' => 'inbox-in',
			'fal fa-inbox-in' => 'inbox-in',
			'fas fa-inbox' => 'inbox',
			'far fa-inbox' => 'inbox',
			'fal fa-inbox' => 'inbox',
			'fab fa-imdb' => 'imdb',
			'fas fa-images' => 'images',
			'far fa-images' => 'images',
			'fal fa-images' => 'images',
			'fas fa-image' => 'image',
			'far fa-image' => 'image',
			'fal fa-image' => 'image',
			'fas fa-id-card-alt' => 'id-card-alt',
			'far fa-id-card-alt' => 'id-card-alt',
			'fal fa-id-card-alt' => 'id-card-alt',
			'fas fa-id-card' => 'id-card',
			'far fa-id-card' => 'id-card',
			'fal fa-id-card' => 'id-card',
			'fas fa-id-badge' => 'id-badge',
			'far fa-id-badge' => 'id-badge',
			'fal fa-id-badge' => 'id-badge',
			'fas fa-i-cursor' => 'i-cursor',
			'far fa-i-cursor' => 'i-cursor',
			'fal fa-i-cursor' => 'i-cursor',
			'fab fa-hubspot' => 'hubspot',
			'fab fa-html5' => 'html5',
			'fab fa-houzz' => 'houzz',
			'fas fa-hourglass-start' => 'hourglass-start',
			'far fa-hourglass-start' => 'hourglass-start',
			'fal fa-hourglass-start' => 'hourglass-start',
			'fas fa-hourglass-half' => 'hourglass-half',
			'far fa-hourglass-half' => 'hourglass-half',
			'fal fa-hourglass-half' => 'hourglass-half',
			'fas fa-hourglass-end' => 'hourglass-end',
			'far fa-hourglass-end' => 'hourglass-end',
			'fal fa-hourglass-end' => 'hourglass-end',
			'fas fa-hourglass' => 'hourglass',
			'far fa-hourglass' => 'hourglass',
			'fal fa-hourglass' => 'hourglass',
			'fab fa-hotjar' => 'hotjar',
			'fas fa-hospital-symbol' => 'hospital-symbol',
			'far fa-hospital-symbol' => 'hospital-symbol',
			'fal fa-hospital-symbol' => 'hospital-symbol',
			'fas fa-hospital-alt' => 'hospital-alt',
			'far fa-hospital-alt' => 'hospital-alt',
			'fal fa-hospital-alt' => 'hospital-alt',
			'fas fa-hospital' => 'hospital',
			'far fa-hospital' => 'hospital',
			'fal fa-hospital' => 'hospital',
			'fab fa-hooli' => 'hooli',
			'fas fa-home-heart' => 'home-heart',
			'far fa-home-heart' => 'home-heart',
			'fal fa-home-heart' => 'home-heart',
			'fas fa-home' => 'home',
			'far fa-home' => 'home',
			'fal fa-home' => 'home',
			'fas fa-hockey-sticks' => 'hockey-sticks',
			'far fa-hockey-sticks' => 'hockey-sticks',
			'fal fa-hockey-sticks' => 'hockey-sticks',
			'fas fa-hockey-puck' => 'hockey-puck',
			'far fa-hockey-puck' => 'hockey-puck',
			'fal fa-hockey-puck' => 'hockey-puck',
			'fas fa-history' => 'history',
			'far fa-history' => 'history',
			'fal fa-history' => 'history',
			'fab fa-hire-a-helper' => 'hire-a-helper',
			'fab fa-hips' => 'hips',
			'fas fa-hexagon' => 'hexagon',
			'far fa-hexagon' => 'hexagon',
			'fal fa-hexagon' => 'hexagon',
			'fas fa-heartbeat' => 'heartbeat',
			'far fa-heartbeat' => 'heartbeat',
			'fal fa-heartbeat' => 'heartbeat',
			'fas fa-heart-square' => 'heart-square',
			'far fa-heart-square' => 'heart-square',
			'fal fa-heart-square' => 'heart-square',
			'fas fa-heart-circle' => 'heart-circle',
			'far fa-heart-circle' => 'heart-circle',
			'fal fa-heart-circle' => 'heart-circle',
			'fas fa-heart' => 'heart',
			'far fa-heart' => 'heart',
			'fal fa-heart' => 'heart',
			'fas fa-headphones' => 'headphones',
			'far fa-headphones' => 'headphones',
			'fal fa-headphones' => 'headphones',
			'fas fa-headset' => 'headSet',
			'fas fa-heading' => 'heading',
			'far fa-heading' => 'heading',
			'fal fa-heading' => 'heading',
			'fas fa-hdd' => 'hdd',
			'far fa-hdd' => 'hdd',
			'fal fa-hdd' => 'hdd',
			'fas fa-hashtag' => 'hashtag',
			'far fa-hashtag' => 'hashtag',
			'fal fa-hashtag' => 'hashtag',
			'fas fa-handshake-alt' => 'handshake-alt',
			'far fa-handshake-alt' => 'handshake-alt',
			'fal fa-handshake-alt' => 'handshake-alt',
			'fas fa-handshake' => 'handshake',
			'far fa-handshake' => 'handshake',
			'fal fa-handshake' => 'handshake',
			'fas fa-hands-usd' => 'hands-usd',
			'far fa-hands-usd' => 'hands-usd',
			'fal fa-hands-usd' => 'hands-usd',
			'fas fa-hands-helping' => 'hands-helping',
			'far fa-hands-helping' => 'hands-helping',
			'fal fa-hands-helping' => 'hands-helping',
			'fas fa-hands-heart' => 'hands-heart',
			'far fa-hands-heart' => 'hands-heart',
			'fal fa-hands-heart' => 'hands-heart',
			'fas fa-hands' => 'hands',
			'far fa-hands' => 'hands',
			'fal fa-hands' => 'hands',
			'fas fa-hand-spock' => 'hand-spock',
			'far fa-hand-spock' => 'hand-spock',
			'fal fa-hand-spock' => 'hand-spock',
			'fas fa-hand-scissors' => 'hand-scissors',
			'far fa-hand-scissors' => 'hand-scissors',
			'fal fa-hand-scissors' => 'hand-scissors',
			'fas fa-hand-rock' => 'hand-rock',
			'far fa-hand-rock' => 'hand-rock',
			'fal fa-hand-rock' => 'hand-rock',
			'fas fa-hand-receiving' => 'hand-receiving',
			'far fa-hand-receiving' => 'hand-receiving',
			'fal fa-hand-receiving' => 'hand-receiving',
			'fas fa-hand-pointer' => 'hand-pointer',
			'far fa-hand-pointer' => 'hand-pointer',
			'fal fa-hand-pointer' => 'hand-pointer',
			'fas fa-hand-point-up' => 'hand-point-up',
			'far fa-hand-point-up' => 'hand-point-up',
			'fal fa-hand-point-up' => 'hand-point-up',
			'fas fa-hand-point-right' => 'hand-point-right',
			'far fa-hand-point-right' => 'hand-point-right',
			'fal fa-hand-point-right' => 'hand-point-right',
			'fas fa-hand-point-left' => 'hand-point-left',
			'far fa-hand-point-left' => 'hand-point-left',
			'fal fa-hand-point-left' => 'hand-point-left',
			'fas fa-hand-point-down' => 'hand-point-down',
			'far fa-hand-point-down' => 'hand-point-down',
			'fal fa-hand-point-down' => 'hand-point-down',
			'fas fa-hand-peace' => 'hand-peace',
			'far fa-hand-peace' => 'hand-peace',
			'fal fa-hand-peace' => 'hand-peace',
			'fas fa-hand-paper' => 'hand-paper',
			'far fa-hand-paper' => 'hand-paper',
			'fal fa-hand-paper' => 'hand-paper',
			'fas fa-hand-lizard' => 'hand-lizard',
			'far fa-hand-lizard' => 'hand-lizard',
			'fal fa-hand-lizard' => 'hand-lizard',
			'fas fa-hand-holding-water' => 'hand-holding-water',
			'far fa-hand-holding-water' => 'hand-holding-water',
			'fal fa-hand-holding-water' => 'hand-holding-water',
			'fas fa-hand-holding-usd' => 'hand-holding-usd',
			'far fa-hand-holding-usd' => 'hand-holding-usd',
			'fal fa-hand-holding-usd' => 'hand-holding-usd',
			'fas fa-hand-holding-seedling' => 'hand-holding-seedling',
			'far fa-hand-holding-seedling' => 'hand-holding-seedling',
			'fal fa-hand-holding-seedling' => 'hand-holding-seedling',
			'fas fa-hand-holding-heart' => 'hand-holding-heart',
			'far fa-hand-holding-heart' => 'hand-holding-heart',
			'fal fa-hand-holding-heart' => 'hand-holding-heart',
			'fas fa-hand-holding-box' => 'hand-holding-box',
			'far fa-hand-holding-box' => 'hand-holding-box',
			'fal fa-hand-holding-box' => 'hand-holding-box',
			'fas fa-hand-holding' => 'hand-holding',
			'far fa-hand-holding' => 'hand-holding',
			'fal fa-hand-holding' => 'hand-holding',
			'fas fa-hand-heart' => 'hand-heart',
			'far fa-hand-heart' => 'hand-heart',
			'fal fa-hand-heart' => 'hand-heart',
			'fab fa-hacker-news-square' => 'hacker-news-square',
			'fab fa-hacker-news' => 'hacker-news',
			'fas fa-h3' => 'h3',
			'far fa-h3' => 'h3',
			'fal fa-h3' => 'h3',
			'fas fa-h2' => 'h2',
			'far fa-h2' => 'h2',
			'fal fa-h2' => 'h2',
			'fas fa-h1' => 'h1',
			'far fa-h1' => 'h1',
			'fal fa-h1' => 'h1',
			'fas fa-h-square' => 'h-square',
			'far fa-h-square' => 'h-square',
			'fal fa-h-square' => 'h-square',
			'fab fa-gulp' => 'gulp',
			'fab fa-grunt' => 'grunt',
			'fab fa-gripfire' => 'gripfire',
			'fab fa-grav' => 'grav',
			'fab fa-gratipay' => 'gratipay',
			'fas fa-graduation-cap' => 'graduation-cap',
			'far fa-graduation-cap' => 'graduation-cap',
			'fal fa-graduation-cap' => 'graduation-cap',
			'fab fa-google-wallet' => 'google-wallet',
			'fab fa-google-plus-square' => 'google-plus-square',
			'fab fa-google-plus-g' => 'google-plus-g',
			'fab fa-google-plus' => 'google-plus',
			'fab fa-google-play' => 'google-play',
			'fab fa-google-drive' => 'google-drive',
			'fab fa-google' => 'google',
			'fab fa-goodreads-g' => 'goodreads-g',
			'fab fa-goodreads' => 'goodreads',
			'fas fa-golf-club' => 'golf-club',
			'far fa-golf-club' => 'golf-club',
			'fal fa-golf-club' => 'golf-club',
			'fas fa-golf-ball' => 'golf-ball',
			'far fa-golf-ball' => 'golf-ball',
			'fal fa-golf-ball' => 'golf-ball',
			'fab fa-gofore' => 'gofore',
			'fas fa-globe' => 'globe',
			'far fa-globe' => 'globe',
			'fal fa-globe' => 'globe',
			'fab fa-glide-g' => 'glide-g',
			'fab fa-glide' => 'glide',
			'fas fa-glass-martini' => 'glass-martini',
			'far fa-glass-martini' => 'glass-martini',
			'fal fa-glass-martini' => 'glass-martini',
			'fab fa-gitter' => 'gitter',
			'fab fa-gitlab' => 'gitlab',
			'fab fa-gitkraken' => 'gitkraken',
			'fab fa-github-square' => 'github-square',
			'fab fa-github-alt' => 'github-alt',
			'fab fa-github' => 'github',
			'fab fa-git-square' => 'git-square',
			'fab fa-git' => 'git',
			'fas fa-gift' => 'gift',
			'far fa-gift' => 'gift',
			'fal fa-gift' => 'gift',
			'fab fa-gg-circle' => 'gg-circle',
			'fab fa-gg' => 'gg',
			'fab fa-get-pocket' => 'get-pocket',
			'fas fa-genderless' => 'genderless',
			'far fa-genderless' => 'genderless',
			'fal fa-genderless' => 'genderless',
			'fas fa-gem' => 'gem',
			'far fa-gem' => 'gem',
			'fal fa-gem' => 'gem',
			'fas fa-gavel' => 'gavel',
			'far fa-gavel' => 'gavel',
			'fal fa-gavel' => 'gavel',
			'fas fa-gamepad' => 'gamepad',
			'far fa-gamepad' => 'gamepad',
			'fal fa-gamepad' => 'gamepad',
			'fab fa-galactic-senate' => 'galactic-senate',
			'fab fa-galactic-republic' => 'galactic-republic',
			'fas fa-futbol' => 'futbol',
			'far fa-futbol' => 'futbol',
			'fal fa-futbol' => 'futbol',
			'fab fa-fulcrum' => 'fulcrum',
			'fas fa-frown' => 'frown',
			'far fa-frown' => 'frown',
			'fal fa-frown' => 'frown',
			'fab fa-freebsd' => 'freebsd',
			'fab fa-free-code-camp' => 'free-code-camp',
			'fas fa-fragile' => 'fragile',
			'far fa-fragile' => 'fragile',
			'fal fa-fragile' => 'fragile',
			'fab fa-foursquare' => 'foursquare',
			'fas fa-forward' => 'forward',
			'far fa-forward' => 'forward',
			'fal fa-forward' => 'forward',
			'fab fa-forumbee' => 'forumbee',
			'fab fa-fort-awesome-alt' => 'fort-awesome-alt',
			'fab fa-fort-awesome' => 'fort-awesome',
			'fas fa-forklift' => 'forklift',
			'far fa-forklift' => 'forklift',
			'fal fa-forklift' => 'forklift',
			'fas fa-football-helmet' => 'football-helmet',
			'far fa-football-helmet' => 'football-helmet',
			'fal fa-football-helmet' => 'football-helmet',
			'fas fa-football-ball' => 'football-ball',
			'far fa-football-ball' => 'football-ball',
			'fal fa-football-ball' => 'football-ball',
			'fab fa-fonticons-fi' => 'fonticons-fi',
			'fab fa-fonticons' => 'fonticons',
			'fas fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'far fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'fal fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'fab fa-font-awesome-logo-full' => 'font-awesome-logo-full',
			'fab fa-font-awesome-flag' => 'font-awesome-flag',
			'fab fa-font-awesome-alt' => 'font-awesome-alt',
			'fab fa-font-awesome' => 'font-awesome',
			'fas fa-font' => 'font',
			'far fa-font' => 'font',
			'fal fa-font' => 'font',
			'fas fa-folder-open' => 'folder-open',
			'far fa-folder-open' => 'folder-open',
			'fal fa-folder-open' => 'folder-open',
			'fas fa-folder' => 'folder',
			'far fa-folder' => 'folder',
			'fal fa-folder' => 'folder',
			'fab fa-fly' => 'fly',
			'fab fa-flipboard' => 'flipboard',
			'fab fa-flickr' => 'flickr',
			'fas fa-flask' => 'flask',
			'far fa-flask' => 'flask',
			'fal fa-flask' => 'flask',
			'fas fa-flag-checkered' => 'flag-checkered',
			'far fa-flag-checkered' => 'flag-checkered',
			'fal fa-flag-checkered' => 'flag-checkered',
			'fas fa-flag' => 'flag',
			'far fa-flag' => 'flag',
			'fal fa-flag' => 'flag',
			'fab fa-firstdraft' => 'firstdraft',
			'fab fa-first-order-alt' => 'first-order-alt',
			'fab fa-first-order' => 'first-order',
			'fas fa-first-aid' => 'first-aid',
			'far fa-first-aid' => 'first-aid',
			'fal fa-first-aid' => 'first-aid',
			'fab fa-firefox' => 'firefox',
			'fas fa-fire-extinguisher' => 'fire-extinguisher',
			'far fa-fire-extinguisher' => 'fire-extinguisher',
			'fal fa-fire-extinguisher' => 'fire-extinguisher',
			'fas fa-fire' => 'fire',
			'far fa-fire' => 'fire',
			'fal fa-fire' => 'fire',
			'fas fa-filter' => 'filter',
			'far fa-filter' => 'filter',
			'fal fa-filter' => 'filter',
			'fas fa-film-alt' => 'film-alt',
			'far fa-film-alt' => 'film-alt',
			'fal fa-film-alt' => 'film-alt',
			'fas fa-film' => 'film',
			'far fa-film' => 'film',
			'fal fa-film' => 'film',
			'fas fa-file-word' => 'file-word',
			'far fa-file-word' => 'file-word',
			'fal fa-file-word' => 'file-word',
			'fas fa-file-video' => 'file-video',
			'far fa-file-video' => 'file-video',
			'fal fa-file-video' => 'file-video',
			'fas fa-file-times' => 'file-times',
			'far fa-file-times' => 'file-times',
			'fal fa-file-times' => 'file-times',
			'fas fa-file-powerpoint' => 'file-powerpoint',
			'far fa-file-powerpoint' => 'file-powerpoint',
			'fal fa-file-powerpoint' => 'file-powerpoint',
			'fas fa-file-plus' => 'file-plus',
			'far fa-file-plus' => 'file-plus',
			'fal fa-file-plus' => 'file-plus',
			'fas fa-file-pdf' => 'file-pdf',
			'far fa-file-pdf' => 'file-pdf',
			'fal fa-file-pdf' => 'file-pdf',
			'fas fa-file-minus' => 'file-minus',
			'far fa-file-minus' => 'file-minus',
			'fal fa-file-minus' => 'file-minus',
			'fas fa-file-medical-alt' => 'file-medical-alt',
			'far fa-file-medical-alt' => 'file-medical-alt',
			'fal fa-file-medical-alt' => 'file-medical-alt',
			'fas fa-file-medical' => 'file-medical',
			'far fa-file-medical' => 'file-medical',
			'fal fa-file-medical' => 'file-medical',
			'fas fa-file-image' => 'file-image',
			'far fa-file-image' => 'file-image',
			'fal fa-file-image' => 'file-image',
			'fas fa-file-exclamation' => 'file-exclamation',
			'far fa-file-exclamation' => 'file-exclamation',
			'fal fa-file-exclamation' => 'file-exclamation',
			'fas fa-file-excel' => 'file-excel',
			'far fa-file-excel' => 'file-excel',
			'fal fa-file-excel' => 'file-excel',
			'fas fa-file-edit' => 'file-edit',
			'far fa-file-edit' => 'file-edit',
			'fal fa-file-edit' => 'file-edit',
			'fas fa-file-code' => 'file-code',
			'far fa-file-code' => 'file-code',
			'fal fa-file-code' => 'file-code',
			'fas fa-file-check' => 'file-check',
			'far fa-file-check' => 'file-check',
			'fal fa-file-check' => 'file-check',
			'fas fa-file-audio' => 'file-audio',
			'far fa-file-audio' => 'file-audio',
			'fal fa-file-audio' => 'file-audio',
			'fas fa-file-archive' => 'file-archive',
			'far fa-file-archive' => 'file-archive',
			'fal fa-file-archive' => 'file-archive',
			'fas fa-file-alt' => 'file-alt',
			'far fa-file-alt' => 'file-alt',
			'fal fa-file-alt' => 'file-alt',
			'fas fa-file' => 'file',
			'far fa-file' => 'file',
			'fal fa-file' => 'file',
			'fas fa-fighter-jet' => 'fighter-jet',
			'far fa-fighter-jet' => 'fighter-jet',
			'fal fa-fighter-jet' => 'fighter-jet',
			'fas fa-field-hockey' => 'field-hockey',
			'far fa-field-hockey' => 'field-hockey',
			'fal fa-field-hockey' => 'field-hockey',
			'fas fa-female' => 'female',
			'far fa-female' => 'female',
			'fal fa-female' => 'female',
			'fas fa-fax' => 'fax',
			'far fa-fax' => 'fax',
			'fal fa-fax' => 'fax',
			'fas fa-fast-forward' => 'fast-forward',
			'far fa-fast-forward' => 'fast-forward',
			'fal fa-fast-forward' => 'fast-forward',
			'fas fa-fast-backward' => 'fast-backward',
			'far fa-fast-backward' => 'fast-backward',
			'fal fa-fast-backward' => 'fast-backward',
			'fab fa-facebook-square' => 'facebook-square',
			'fab fa-facebook-messenger' => 'facebook-messenger',
			'fab fa-facebook-f' => 'facebook-f',
			'fab fa-facebook' => 'facebook',
			'fab fa-youtube' => 'youtube',
			'fab fa-youtube-square' => 'youtube-square',
			'fas fa-eye-slash' => 'eye-slash',
			'far fa-eye-slash' => 'eye-slash',
			'fal fa-eye-slash' => 'eye-slash',
			'fas fa-eye-dropper' => 'eye-dropper',
			'far fa-eye-dropper' => 'eye-dropper',
			'fal fa-eye-dropper' => 'eye-dropper',
			'fas fa-eye' => 'eye',
			'far fa-eye' => 'eye',
			'fal fa-eye' => 'eye',
			'fas fa-external-link-square-alt' => 'external-link-square-alt',
			'far fa-external-link-square-alt' => 'external-link-square-alt',
			'fal fa-external-link-square-alt' => 'external-link-square-alt',
			'fas fa-external-link-square' => 'external-link-square',
			'far fa-external-link-square' => 'external-link-square',
			'fal fa-external-link-square' => 'external-link-square',
			'fas fa-external-link-alt' => 'external-link-alt',
			'far fa-external-link-alt' => 'external-link-alt',
			'fal fa-external-link-alt' => 'external-link-alt',
			'fas fa-external-link' => 'external-link',
			'far fa-external-link' => 'external-link',
			'fal fa-external-link' => 'external-link',
			'fab fa-expeditedssl' => 'expeditedssl',
			'fas fa-expand-wide' => 'expand-wide',
			'far fa-expand-wide' => 'expand-wide',
			'fal fa-expand-wide' => 'expand-wide',
			'fas fa-expand-arrows-alt' => 'expand-arrows-alt',
			'far fa-expand-arrows-alt' => 'expand-arrows-alt',
			'fal fa-expand-arrows-alt' => 'expand-arrows-alt',
			'fas fa-expand-arrows' => 'expand-arrows',
			'far fa-expand-arrows' => 'expand-arrows',
			'fal fa-expand-arrows' => 'expand-arrows',
			'fas fa-expand-alt' => 'expand-alt',
			'far fa-expand-alt' => 'expand-alt',
			'fal fa-expand-alt' => 'expand-alt',
			'fas fa-expand' => 'expand',
			'far fa-expand' => 'expand',
			'fal fa-expand' => 'expand',
			'fas fa-exclamation-triangle' => 'exclamation-triangle',
			'far fa-exclamation-triangle' => 'exclamation-triangle',
			'fal fa-exclamation-triangle' => 'exclamation-triangle',
			'fas fa-exclamation-square' => 'exclamation-square',
			'far fa-exclamation-square' => 'exclamation-square',
			'fal fa-exclamation-square' => 'exclamation-square',
			'fas fa-exclamation-circle' => 'exclamation-circle',
			'far fa-exclamation-circle' => 'exclamation-circle',
			'fal fa-exclamation-circle' => 'exclamation-circle',
			'fas fa-exclamation' => 'exclamation',
			'far fa-exclamation' => 'exclamation',
			'fal fa-exclamation' => 'exclamation',
			'fas fa-exchange-alt' => 'exchange-alt',
			'far fa-exchange-alt' => 'exchange-alt',
			'fal fa-exchange-alt' => 'exchange-alt',
			'fas fa-exchange' => 'exchange',
			'far fa-exchange' => 'exchange',
			'fal fa-exchange' => 'exchange',
			'fas fa-euro-sign' => 'euro-sign',
			'far fa-euro-sign' => 'euro-sign',
			'fal fa-euro-sign' => 'euro-sign',
			'fab fa-etsy' => 'etsy',
			'fab fa-ethereum' => 'ethereum',
			'fab fa-erlang' => 'erlang',
			'fas fa-eraser' => 'eraser',
			'far fa-eraser' => 'eraser',
			'fal fa-eraser' => 'eraser',
			'fab fa-envira' => 'envira',
			'fas fa-envelope-square' => 'envelope-square',
			'far fa-envelope-square' => 'envelope-square',
			'fal fa-envelope-square' => 'envelope-square',
			'fas fa-envelope-open' => 'envelope-open',
			'far fa-envelope-open' => 'envelope-open',
			'fal fa-envelope-open' => 'envelope-open',
			'fas fa-envelope' => 'envelope',
			'far fa-envelope' => 'envelope',
			'fal fa-envelope' => 'envelope',
			'fab fa-empire' => 'empire',
			'fab fa-ember' => 'ember',
			'fas fa-ellipsis-v-alt' => 'ellipsis-v-alt',
			'far fa-ellipsis-v-alt' => 'ellipsis-v-alt',
			'fal fa-ellipsis-v-alt' => 'ellipsis-v-alt',
			'fas fa-ellipsis-v' => 'ellipsis-v',
			'far fa-ellipsis-v' => 'ellipsis-v',
			'fal fa-ellipsis-v' => 'ellipsis-v',
			'fas fa-ellipsis-h-alt' => 'ellipsis-h-alt',
			'far fa-ellipsis-h-alt' => 'ellipsis-h-alt',
			'fal fa-ellipsis-h-alt' => 'ellipsis-h-alt',
			'fas fa-ellipsis-h' => 'ellipsis-h',
			'far fa-ellipsis-h' => 'ellipsis-h',
			'fal fa-ellipsis-h' => 'ellipsis-h',
			'fab fa-elementor' => 'elementor',
			'fas fa-eject' => 'eject',
			'far fa-eject' => 'eject',
			'fal fa-eject' => 'eject',
			'fas fa-edit' => 'edit',
			'far fa-edit' => 'edit',
			'fal fa-edit' => 'edit',
			'fab fa-edge' => 'edge',
			'fab fa-ebay' => 'ebay',
			'fab fa-earlybirds' => 'earlybirds',
			'fab fa-dyalog' => 'dyalog',
			'fas fa-dumbbell' => 'dumbbell',
			'far fa-dumbbell' => 'dumbbell',
			'fal fa-dumbbell' => 'dumbbell',
			'fab fa-drupal' => 'drupal',
			'fab fa-dropbox' => 'dropbox',
			'fab fa-dribbble-square' => 'dribbble-square',
			'fab fa-dribbble' => 'dribbble',
			'fab fa-draft2digital' => 'draft2digital',
			'fas fa-download' => 'download',
			'far fa-download' => 'download',
			'fal fa-download' => 'download',
			'fas fa-dove' => 'dove',
			'far fa-dove' => 'dove',
			'fal fa-dove' => 'dove',
			'fas fa-dot-circle' => 'dot-circle',
			'far fa-dot-circle' => 'dot-circle',
			'fal fa-dot-circle' => 'dot-circle',
			'fas fa-donate' => 'donate',
			'far fa-donate' => 'donate',
			'fal fa-donate' => 'donate',
			'fas fa-dolly-flatbed-empty' => 'dolly-flatbed-empty',
			'far fa-dolly-flatbed-empty' => 'dolly-flatbed-empty',
			'fal fa-dolly-flatbed-empty' => 'dolly-flatbed-empty',
			'fas fa-dolly-flatbed-alt' => 'dolly-flatbed-alt',
			'far fa-dolly-flatbed-alt' => 'dolly-flatbed-alt',
			'fal fa-dolly-flatbed-alt' => 'dolly-flatbed-alt',
			'fas fa-dolly-flatbed' => 'dolly-flatbed',
			'far fa-dolly-flatbed' => 'dolly-flatbed',
			'fal fa-dolly-flatbed' => 'dolly-flatbed',
			'fas fa-dolly-empty' => 'dolly-empty',
			'far fa-dolly-empty' => 'dolly-empty',
			'fal fa-dolly-empty' => 'dolly-empty',
			'fas fa-dolly' => 'dolly',
			'far fa-dolly' => 'dolly',
			'fal fa-dolly' => 'dolly',
			'fas fa-dollar-sign' => 'dollar-sign',
			'far fa-dollar-sign' => 'dollar-sign',
			'fal fa-dollar-sign' => 'dollar-sign',
			'fab fa-docker' => 'docker',
			'fab fa-dochub' => 'dochub',
			'fas fa-dna' => 'dna',
			'far fa-dna' => 'dna',
			'fal fa-dna' => 'dna',
			'fab fa-discourse' => 'discourse',
			'fab fa-discord' => 'discord',
			'fab fa-digital-ocean' => 'digital-ocean',
			'fab fa-digg' => 'digg',
			'fas fa-diamond' => 'diamond',
			'far fa-diamond' => 'diamond',
			'fal fa-diamond' => 'diamond',
			'fas fa-diagnoses' => 'diagnoses',
			'far fa-diagnoses' => 'diagnoses',
			'fal fa-diagnoses' => 'diagnoses',
			'fab fa-deviantart' => 'deviantart',
			'fas fa-desktop-alt' => 'desktop-alt',
			'far fa-desktop-alt' => 'desktop-alt',
			'fal fa-desktop-alt' => 'desktop-alt',
			'fas fa-desktop' => 'desktop',
			'far fa-desktop' => 'desktop',
			'fal fa-desktop' => 'desktop',
			'fab fa-deskpro' => 'deskpro',
			'fab fa-deploydog' => 'deploydog',
			'fab fa-delicious' => 'delicious',
			'fas fa-deaf' => 'deaf',
			'far fa-deaf' => 'deaf',
			'fal fa-deaf' => 'deaf',
			'fas fa-database' => 'database',
			'far fa-database' => 'database',
			'fal fa-database' => 'database',
			'fab fa-dashcube' => 'dashcube',
			'fab fa-d-and-d' => 'd-and-d',
			'fab fa-cuttlefish' => 'cuttlefish',
			'fas fa-cut' => 'cut',
			'far fa-cut' => 'cut',
			'fal fa-cut' => 'cut',
			'fas fa-curling' => 'curling',
			'far fa-curling' => 'curling',
			'fal fa-curling' => 'curling',
			'fas fa-cubes' => 'cubes',
			'far fa-cubes' => 'cubes',
			'fal fa-cubes' => 'cubes',
			'fas fa-cube' => 'cube',
			'far fa-cube' => 'cube',
			'fal fa-cube' => 'cube',
			'fab fa-css3-alt' => 'css3-alt',
			'fab fa-css3' => 'css3',
			'fas fa-crosshairs' => 'crosshairs',
			'far fa-crosshairs' => 'crosshairs',
			'fal fa-crosshairs' => 'crosshairs',
			'fas fa-crop' => 'crop',
			'far fa-crop' => 'crop',
			'fal fa-crop' => 'crop',
			'fas fa-cricket' => 'cricket',
			'far fa-cricket' => 'cricket',
			'fal fa-cricket' => 'cricket',
			'fas fa-credit-card-front' => 'credit-card-front',
			'far fa-credit-card-front' => 'credit-card-front',
			'fal fa-credit-card-front' => 'credit-card-front',
			'fas fa-credit-card-blank' => 'credit-card-blank',
			'far fa-credit-card-blank' => 'credit-card-blank',
			'fal fa-credit-card-blank' => 'credit-card-blank',
			'fas fa-credit-card' => 'credit-card',
			'far fa-credit-card' => 'credit-card',
			'fal fa-credit-card' => 'credit-card',
			'fab fa-creative-commons-zero' => 'creative-commons-zero',
			'fab fa-creative-commons-share' => 'creative-commons-share',
			'fab fa-creative-commons-sampling-plus' => 'creative-commons-sampling-plus',
			'fab fa-creative-commons-sampling' => 'creative-commons-sampling',
			'fab fa-creative-commons-sa' => 'creative-commons-sa',
			'fab fa-creative-commons-remix' => 'creative-commons-remix',
			'fab fa-creative-commons-pd-alt' => 'creative-commons-pd-alt',
			'fab fa-creative-commons-pd' => 'creative-commons-pd',
			'fab fa-creative-commons-nd' => 'creative-commons-nd',
			'fab fa-creative-commons-nc-jp' => 'creative-commons-nc-jp',
			'fab fa-creative-commons-nc-eu' => 'creative-commons-nc-eu',
			'fab fa-creative-commons-nc' => 'creative-commons-nc',
			'fab fa-creative-commons-by' => 'creative-commons-by',
			'fab fa-creative-commons' => 'creative-commons',
			'fab fa-cpanel' => 'cpanel',
			'fas fa-couch' => 'couch',
			'far fa-couch' => 'couch',
			'fal fa-couch' => 'couch',
			'fas fa-copyright' => 'copyright',
			'far fa-copyright' => 'copyright',
			'fal fa-copyright' => 'copyright',
			'fas fa-copy' => 'copy',
			'far fa-copy' => 'copy',
			'fal fa-copy' => 'copy',
			'fas fa-conveyor-belt-alt' => 'conveyor-belt-alt',
			'far fa-conveyor-belt-alt' => 'conveyor-belt-alt',
			'fal fa-conveyor-belt-alt' => 'conveyor-belt-alt',
			'fas fa-conveyor-belt' => 'conveyor-belt',
			'far fa-conveyor-belt' => 'conveyor-belt',
			'fal fa-conveyor-belt' => 'conveyor-belt',
			'fab fa-contao' => 'contao',
			'fas fa-container-storage' => 'container-storage',
			'far fa-container-storage' => 'container-storage',
			'fal fa-container-storage' => 'container-storage',
			'fab fa-connectdevelop' => 'connectdevelop',
			'fas fa-compress-wide' => 'compress-wide',
			'far fa-compress-wide' => 'compress-wide',
			'fal fa-compress-wide' => 'compress-wide',
			'fas fa-compress-alt' => 'compress-alt',
			'far fa-compress-alt' => 'compress-alt',
			'fal fa-compress-alt' => 'compress-alt',
			'fas fa-compress' => 'compress',
			'far fa-compress' => 'compress',
			'fal fa-compress' => 'compress',
			'fas fa-compass' => 'compass',
			'far fa-compass' => 'compass',
			'fal fa-compass' => 'compass',
			'fas fa-comments-alt' => 'comments-alt',
			'far fa-comments-alt' => 'comments-alt',
			'fal fa-comments-alt' => 'comments-alt',
			'fas fa-comments' => 'comments',
			'far fa-comments' => 'comments',
			'fal fa-comments' => 'comments',
			'fas fa-comment-times' => 'comment-times',
			'far fa-comment-times' => 'comment-times',
			'fal fa-comment-times' => 'comment-times',
			'fas fa-comment-smile' => 'comment-smile',
			'far fa-comment-smile' => 'comment-smile',
			'fal fa-comment-smile' => 'comment-smile',
			'fas fa-comment-slash' => 'comment-slash',
			'far fa-comment-slash' => 'comment-slash',
			'fal fa-comment-slash' => 'comment-slash',
			'fas fa-comment-plus' => 'comment-plus',
			'far fa-comment-plus' => 'comment-plus',
			'fal fa-comment-plus' => 'comment-plus',
			'fas fa-comment-minus' => 'comment-minus',
			'far fa-comment-minus' => 'comment-minus',
			'fal fa-comment-minus' => 'comment-minus',
			'fas fa-comment-lines' => 'comment-lines',
			'far fa-comment-lines' => 'comment-lines',
			'fal fa-comment-lines' => 'comment-lines',
			'fas fa-comment-exclamation' => 'comment-exclamation',
			'far fa-comment-exclamation' => 'comment-exclamation',
			'fal fa-comment-exclamation' => 'comment-exclamation',
			'fas fa-comment-edit' => 'comment-edit',
			'far fa-comment-edit' => 'comment-edit',
			'fal fa-comment-edit' => 'comment-edit',
			'fas fa-comment-dots' => 'comment-dots',
			'far fa-comment-dots' => 'comment-dots',
			'fal fa-comment-dots' => 'comment-dots',
			'fas fa-comment-check' => 'comment-check',
			'far fa-comment-check' => 'comment-check',
			'fal fa-comment-check' => 'comment-check',
			'fas fa-comment-alt-times' => 'comment-alt-times',
			'far fa-comment-alt-times' => 'comment-alt-times',
			'fal fa-comment-alt-times' => 'comment-alt-times',
			'fas fa-comment-alt-smile' => 'comment-alt-smile',
			'far fa-comment-alt-smile' => 'comment-alt-smile',
			'fal fa-comment-alt-smile' => 'comment-alt-smile',
			'fas fa-comment-alt-slash' => 'comment-alt-slash',
			'far fa-comment-alt-slash' => 'comment-alt-slash',
			'fal fa-comment-alt-slash' => 'comment-alt-slash',
			'fas fa-comment-alt-plus' => 'comment-alt-plus',
			'far fa-comment-alt-plus' => 'comment-alt-plus',
			'fal fa-comment-alt-plus' => 'comment-alt-plus',
			'fas fa-comment-alt-minus' => 'comment-alt-minus',
			'far fa-comment-alt-minus' => 'comment-alt-minus',
			'fal fa-comment-alt-minus' => 'comment-alt-minus',
			'fas fa-comment-alt-lines' => 'comment-alt-lines',
			'far fa-comment-alt-lines' => 'comment-alt-lines',
			'fal fa-comment-alt-lines' => 'comment-alt-lines',
			'fas fa-comment-alt-exclamation' => 'comment-alt-exclamation',
			'far fa-comment-alt-exclamation' => 'comment-alt-exclamation',
			'fal fa-comment-alt-exclamation' => 'comment-alt-exclamation',
			'fas fa-comment-alt-edit' => 'comment-alt-edit',
			'far fa-comment-alt-edit' => 'comment-alt-edit',
			'fal fa-comment-alt-edit' => 'comment-alt-edit',
			'fas fa-comment-alt-dots' => 'comment-alt-dots',
			'far fa-comment-alt-dots' => 'comment-alt-dots',
			'fal fa-comment-alt-dots' => 'comment-alt-dots',
			'fas fa-comment-alt-check' => 'comment-alt-check',
			'far fa-comment-alt-check' => 'comment-alt-check',
			'fal fa-comment-alt-check' => 'comment-alt-check',
			'fas fa-comment-alt' => 'comment-alt',
			'far fa-comment-alt' => 'comment-alt',
			'fal fa-comment-alt' => 'comment-alt',
			'fas fa-comment' => 'comment',
			'far fa-comment' => 'comment',
			'fal fa-comment' => 'comment',
			'fas fa-columns' => 'columns',
			'far fa-columns' => 'columns',
			'fal fa-columns' => 'columns',
			'fas fa-cogs' => 'cogs',
			'far fa-cogs' => 'cogs',
			'fal fa-cogs' => 'cogs',
			'fas fa-cog' => 'cog',
			'far fa-cog' => 'cog',
			'fal fa-cog' => 'cog',
			'fas fa-coffee' => 'coffee',
			'far fa-coffee' => 'coffee',
			'fal fa-coffee' => 'coffee',
			'fab fa-codiepie' => 'codiepie',
			'fab fa-codepen' => 'codepen',
			'fas fa-code-merge' => 'code-merge',
			'far fa-code-merge' => 'code-merge',
			'fal fa-code-merge' => 'code-merge',
			'fas fa-code-commit' => 'code-commit',
			'far fa-code-commit' => 'code-commit',
			'fal fa-code-commit' => 'code-commit',
			'fas fa-code-branch' => 'code-branch',
			'far fa-code-branch' => 'code-branch',
			'fal fa-code-branch' => 'code-branch',
			'fas fa-code' => 'code',
			'far fa-code' => 'code',
			'fal fa-code' => 'code',
			'fas fa-club' => 'club',
			'far fa-club' => 'club',
			'fal fa-club' => 'club',
			'fab fa-cloudversify' => 'cloudversify',
			'fab fa-cloudsmith' => 'cloudsmith',
			'fab fa-cloudscale' => 'cloudscale',
			'fas fa-cloud-upload-alt' => 'cloud-upload-alt',
			'far fa-cloud-upload-alt' => 'cloud-upload-alt',
			'fal fa-cloud-upload-alt' => 'cloud-upload-alt',
			'fas fa-cloud-upload' => 'cloud-upload',
			'far fa-cloud-upload' => 'cloud-upload',
			'fal fa-cloud-upload' => 'cloud-upload',
			'fas fa-cloud-download-alt' => 'cloud-download-alt',
			'far fa-cloud-download-alt' => 'cloud-download-alt',
			'fal fa-cloud-download-alt' => 'cloud-download-alt',
			'fas fa-cloud-download' => 'cloud-download',
			'far fa-cloud-download' => 'cloud-download',
			'fal fa-cloud-download' => 'cloud-download',
			'fas fa-cloud' => 'cloud',
			'far fa-cloud' => 'cloud',
			'fal fa-cloud' => 'cloud',
			'fas fa-closed-captioning' => 'closed-captioning',
			'far fa-closed-captioning' => 'closed-captioning',
			'fal fa-closed-captioning' => 'closed-captioning',
			'fas fa-clone' => 'clone',
			'far fa-clone' => 'clone',
			'fal fa-clone' => 'clone',
			'fas fa-clock' => 'clock',
			'far fa-clock' => 'clock',
			'fal fa-clock' => 'clock',
			'fas fa-clipboard-list' => 'clipboard-list',
			'far fa-clipboard-list' => 'clipboard-list',
			'fal fa-clipboard-list' => 'clipboard-list',
			'fas fa-clipboard-check' => 'clipboard-check',
			'far fa-clipboard-check' => 'clipboard-check',
			'fal fa-clipboard-check' => 'clipboard-check',
			'fas fa-clipboard' => 'clipboard',
			'far fa-clipboard' => 'clipboard',
			'fal fa-clipboard' => 'clipboard',
			'fas fa-circle-notch' => 'circle-notch',
			'far fa-circle-notch' => 'circle-notch',
			'fal fa-circle-notch' => 'circle-notch',
			'fas fa-circle' => 'circle',
			'far fa-circle' => 'circle',
			'fal fa-circle' => 'circle',
			'fab fa-chrome' => 'chrome',
			'fas fa-child' => 'child',
			'far fa-child' => 'child',
			'fal fa-child' => 'child',
			
			'fas fa-angle-right' => 'angle-right',
			'far fa-angle-right' => 'angle-right',
			'fal fa-angle-right' => 'angle-right',
			'fas fa-angle-left' => 'angle-left',
			'far fa-angle-left' => 'angle-left',
			'fal fa-angle-left' => 'angle-left',
			'fas fa-angle-up' => 'angle-up',
			'far fa-angle-up' => 'angle-up',
			'fal fa-angle-up' => 'angle-up',
			'fas fa-angle-down' => 'angle-down',
			'far fa-angle-down' => 'angle-down',
			'fal fa-angle-down' => 'angle-down',

			'fas fa-chevron-up' => 'chevron-up',
			'far fa-chevron-up' => 'chevron-up',
			'fal fa-chevron-up' => 'chevron-up',
			'fas fa-chevron-square-up' => 'chevron-square-up',
			'far fa-chevron-square-up' => 'chevron-square-up',
			'fal fa-chevron-square-up' => 'chevron-square-up',
			'fas fa-chevron-square-right' => 'chevron-square-right',
			'far fa-chevron-square-right' => 'chevron-square-right',
			'fal fa-chevron-square-right' => 'chevron-square-right',
			'fas fa-chevron-square-left' => 'chevron-square-left',
			'far fa-chevron-square-left' => 'chevron-square-left',
			'fal fa-chevron-square-left' => 'chevron-square-left',
			'fas fa-chevron-square-down' => 'chevron-square-down',
			'far fa-chevron-square-down' => 'chevron-square-down',
			'fal fa-chevron-square-down' => 'chevron-square-down',
			'fas fa-chevron-right' => 'chevron-right',
			'far fa-chevron-right' => 'chevron-right',
			'fal fa-chevron-right' => 'chevron-right',
			'fas fa-chevron-left' => 'chevron-left',
			'far fa-chevron-left' => 'chevron-left',
			'fal fa-chevron-left' => 'chevron-left',
			'fas fa-chevron-down' => 'chevron-down',
			'far fa-chevron-down' => 'chevron-down',
			'fal fa-chevron-down' => 'chevron-down',
			'fas fa-chevron-double-up' => 'chevron-double-up',
			'far fa-chevron-double-up' => 'chevron-double-up',
			'fal fa-chevron-double-up' => 'chevron-double-up',
			'fas fa-chevron-double-right' => 'chevron-double-right',
			'far fa-chevron-double-right' => 'chevron-double-right',
			'fal fa-chevron-double-right' => 'chevron-double-right',
			'fas fa-chevron-double-left' => 'chevron-double-left',
			'far fa-chevron-double-left' => 'chevron-double-left',
			'fal fa-chevron-double-left' => 'chevron-double-left',
			'fas fa-chevron-double-down' => 'chevron-double-down',
			'far fa-chevron-double-down' => 'chevron-double-down',
			'fal fa-chevron-double-down' => 'chevron-double-down',
			'fas fa-chevron-circle-up' => 'chevron-circle-up',
			'far fa-chevron-circle-up' => 'chevron-circle-up',
			'fal fa-chevron-circle-up' => 'chevron-circle-up',
			'fas fa-chevron-circle-right' => 'chevron-circle-right',
			'far fa-chevron-circle-right' => 'chevron-circle-right',
			'fal fa-chevron-circle-right' => 'chevron-circle-right',
			'fas fa-chevron-circle-left' => 'chevron-circle-left',
			'far fa-chevron-circle-left' => 'chevron-circle-left',
			'fal fa-chevron-circle-left' => 'chevron-circle-left',
			'fas fa-chevron-circle-down' => 'chevron-circle-down',
			'far fa-chevron-circle-down' => 'chevron-circle-down',
			'fal fa-chevron-circle-down' => 'chevron-circle-down',
			'fas fa-chess-rook-alt' => 'chess-rook-alt',
			'far fa-chess-rook-alt' => 'chess-rook-alt',
			'fal fa-chess-rook-alt' => 'chess-rook-alt',
			'fas fa-chess-rook' => 'chess-rook',
			'far fa-chess-rook' => 'chess-rook',
			'fal fa-chess-rook' => 'chess-rook',
			'fas fa-chess-queen-alt' => 'chess-queen-alt',
			'far fa-chess-queen-alt' => 'chess-queen-alt',
			'fal fa-chess-queen-alt' => 'chess-queen-alt',
			'fas fa-chess-queen' => 'chess-queen',
			'far fa-chess-queen' => 'chess-queen',
			'fal fa-chess-queen' => 'chess-queen',
			'fas fa-chess-pawn-alt' => 'chess-pawn-alt',
			'far fa-chess-pawn-alt' => 'chess-pawn-alt',
			'fal fa-chess-pawn-alt' => 'chess-pawn-alt',
			'fas fa-chess-pawn' => 'chess-pawn',
			'far fa-chess-pawn' => 'chess-pawn',
			'fal fa-chess-pawn' => 'chess-pawn',
			'fas fa-chess-knight-alt' => 'chess-knight-alt',
			'far fa-chess-knight-alt' => 'chess-knight-alt',
			'fal fa-chess-knight-alt' => 'chess-knight-alt',
			'fas fa-chess-knight' => 'chess-knight',
			'far fa-chess-knight' => 'chess-knight',
			'fal fa-chess-knight' => 'chess-knight',
			'fas fa-chess-king-alt' => 'chess-king-alt',
			'far fa-chess-king-alt' => 'chess-king-alt',
			'fal fa-chess-king-alt' => 'chess-king-alt',
			'fas fa-chess-king' => 'chess-king',
			'far fa-chess-king' => 'chess-king',
			'fal fa-chess-king' => 'chess-king',
			'fas fa-chess-clock-alt' => 'chess-clock-alt',
			'far fa-chess-clock-alt' => 'chess-clock-alt',
			'fal fa-chess-clock-alt' => 'chess-clock-alt',
			'fas fa-chess-clock' => 'chess-clock',
			'far fa-chess-clock' => 'chess-clock',
			'fal fa-chess-clock' => 'chess-clock',
			'fas fa-chess-board' => 'chess-board',
			'far fa-chess-board' => 'chess-board',
			'fal fa-chess-board' => 'chess-board',
			'fas fa-chess-bishop-alt' => 'chess-bishop-alt',
			'far fa-chess-bishop-alt' => 'chess-bishop-alt',
			'fal fa-chess-bishop-alt' => 'chess-bishop-alt',
			'fas fa-chess-bishop' => 'chess-bishop',
			'far fa-chess-bishop' => 'chess-bishop',
			'fal fa-chess-bishop' => 'chess-bishop',
			'fas fa-chess' => 'chess',
			'far fa-chess' => 'chess',
			'fal fa-chess' => 'chess',
			'fas fa-check-square' => 'check-square',
			'far fa-check-square' => 'check-square',
			'fal fa-check-square' => 'check-square',
			'fas fa-check-circle' => 'check-circle',
			'far fa-check-circle' => 'check-circle',
			'fal fa-check-circle' => 'check-circle',
			'fas fa-check' => 'check',
			'far fa-check' => 'check',
			'fal fa-check' => 'check',
			'fas fa-chart-pie' => 'chart-pie',
			'far fa-chart-pie' => 'chart-pie',
			'fal fa-chart-pie' => 'chart-pie',
			'fas fa-chart-line' => 'chart-line',
			'far fa-chart-line' => 'chart-line',
			'fal fa-chart-line' => 'chart-line',
			'fas fa-chart-bar' => 'chart-bar',
			'far fa-chart-bar' => 'chart-bar',
			'fal fa-chart-bar' => 'chart-bar',
			'fas fa-chart-area' => 'chart-area',
			'far fa-chart-area' => 'chart-area',
			'fal fa-chart-area' => 'chart-area',
			'fas fa-certificate' => 'certificate',
			'far fa-certificate' => 'certificate',
			'fal fa-certificate' => 'certificate',
			'fab fa-centercode' => 'centercode',
			'fab fa-cc-visa' => 'cc-visa',
			'fab fa-cc-stripe' => 'cc-stripe',
			'fab fa-cc-paypal' => 'cc-paypal',
			'fab fa-cc-mastercard' => 'cc-mastercard',
			'fab fa-cc-jcb' => 'cc-jcb',
			'fab fa-cc-discover' => 'cc-discover',
			'fab fa-cc-diners-club' => 'cc-diners-club',
			'fab fa-cc-apple-pay' => 'cc-apple-pay',
			'fab fa-apple' => 'fa-apple',
			'fab fa-cc-amex' => 'cc-amex',
			'fab fa-cc-amazon-pay' => 'cc-amazon-pay',
			'fas fa-cart-plus' => 'cart-plus',
			'far fa-cart-plus' => 'cart-plus',
			'fal fa-cart-plus' => 'cart-plus',
			'fas fa-cart-arrow-down' => 'cart-arrow-down',
			'far fa-cart-arrow-down' => 'cart-arrow-down',
			'fal fa-cart-arrow-down' => 'cart-arrow-down',
			'fas fa-caret-up' => 'caret-up',
			'far fa-caret-up' => 'caret-up',
			'fal fa-caret-up' => 'caret-up',
			'fas fa-caret-square-up' => 'caret-square-up',
			'far fa-caret-square-up' => 'caret-square-up',
			'fal fa-caret-square-up' => 'caret-square-up',
			'fas fa-caret-square-right' => 'caret-square-right',
			'far fa-caret-square-right' => 'caret-square-right',
			'fal fa-caret-square-right' => 'caret-square-right',
			'fas fa-caret-square-left' => 'caret-square-left',
			'far fa-caret-square-left' => 'caret-square-left',
			'fal fa-caret-square-left' => 'caret-square-left',
			'fas fa-caret-square-down' => 'caret-square-down',
			'far fa-caret-square-down' => 'caret-square-down',
			'fal fa-caret-square-down' => 'caret-square-down',
			'fas fa-caret-right' => 'caret-right',
			'far fa-caret-right' => 'caret-right',
			'fal fa-caret-right' => 'caret-right',
			'fas fa-caret-left' => 'caret-left',
			'far fa-caret-left' => 'caret-left',
			'fal fa-caret-left' => 'caret-left',
			'fas fa-caret-down' => 'caret-down',
			'far fa-caret-down' => 'caret-down',
			'fal fa-caret-down' => 'caret-down',
			'fas fa-caret-circle-up' => 'caret-circle-up',
			'far fa-caret-circle-up' => 'caret-circle-up',
			'fal fa-caret-circle-up' => 'caret-circle-up',
			'fas fa-caret-circle-right' => 'caret-circle-right',
			'far fa-caret-circle-right' => 'caret-circle-right',
			'fal fa-caret-circle-right' => 'caret-circle-right',
			'fas fa-caret-circle-left' => 'caret-circle-left',
			'far fa-caret-circle-left' => 'caret-circle-left',
			'fal fa-caret-circle-left' => 'caret-circle-left',
			'fas fa-caret-circle-down' => 'caret-circle-down',
			'far fa-caret-circle-down' => 'caret-circle-down',
			'fal fa-caret-circle-down' => 'caret-circle-down',
			'fas fa-car' => 'car',
			'far fa-car' => 'car',
			'fal fa-car' => 'car',
			'fas fa-capsules' => 'capsules',
			'far fa-capsules' => 'capsules',
			'fal fa-capsules' => 'capsules',
			'fas fa-camera-retro' => 'camera-retro',
			'far fa-camera-retro' => 'camera-retro',
			'fal fa-camera-retro' => 'camera-retro',
			'fas fa-camera-alt' => 'camera-alt',
			'far fa-camera-alt' => 'camera-alt',
			'fal fa-camera-alt' => 'camera-alt',
			'fas fa-camera' => 'camera',
			'far fa-camera' => 'camera',
			'fal fa-camera' => 'camera',
			'fas fa-calendar-times' => 'calendar-times',
			'far fa-calendar-times' => 'calendar-times',
			'fal fa-calendar-times' => 'calendar-times',
			'fas fa-calendar-plus' => 'calendar-plus',
			'far fa-calendar-plus' => 'calendar-plus',
			'fal fa-calendar-plus' => 'calendar-plus',
			'fas fa-calendar-minus' => 'calendar-minus',
			'far fa-calendar-minus' => 'calendar-minus',
			'fal fa-calendar-minus' => 'calendar-minus',
			'fas fa-calendar-exclamation' => 'calendar-exclamation',
			'far fa-calendar-exclamation' => 'calendar-exclamation',
			'fal fa-calendar-exclamation' => 'calendar-exclamation',
			'fas fa-calendar-edit' => 'calendar-edit',
			'far fa-calendar-edit' => 'calendar-edit',
			'fal fa-calendar-edit' => 'calendar-edit',
			'fas fa-calendar-check' => 'calendar-check',
			'far fa-calendar-check' => 'calendar-check',
			'fal fa-calendar-check' => 'calendar-check',
			'fas fa-calendar-alt' => 'calendar-alt',
			'far fa-calendar-alt' => 'calendar-alt',
			'fal fa-calendar-alt' => 'calendar-alt',
			'fas fa-calendar' => 'calendar',
			'far fa-calendar' => 'calendar',
			'fal fa-calendar' => 'calendar',
			'fas fa-calculator' => 'calculator',
			'far fa-calculator' => 'calculator',
			'fal fa-calculator' => 'calculator',
			'fab fa-buysellads' => 'buysellads',
			'fas fa-bus' => 'bus',
			'far fa-bus' => 'bus',
			'fal fa-bus' => 'bus',
			'fal fa-medal' => 'medal',
			'fal fa-meteor' => 'meteor'
		);
		return $icons;
	}

	/**
	 * Retrieve icons control default settings.
	 *
	 * Get the default settings of the icons control. Used to return the default
	 * settings while initializing the icons control.
	 *
	 * @since 1.0.0
	 * @access protected
	 *
	 * @return array Control default settings.
	 */

	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}

	/**
	 * Render icons control output in the editor.
	 *
	 * Used to generate the control HTML in the editor using Underscore JS
	 * template. The variables for the class are available using `data` JS
	 * object.
	 *
	 * @since 1.0.0
	 * @access public
	 */

	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">
				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'eduvalt' ); ?>">
					<option value=""><?php esc_html_e( 'Select Icon', 'eduvalt' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}
}