(function ($) {
"use strict";

    $(window).on('load', function () {
        preloader();
    });

    // website preloader
    function preloader() {
        $('#preloader').delay(0).fadeOut();
    };

    // Choose Items
    $(".choose-item-two").hover(function(){
        var cur = $(this);
        $(".choose-item-two").removeClass("active");
        cur.addClass("active");
        return true;
    });

    // Counter
    // $('.counter').counterUp({
    //     delay: 10,
    //     time: 3000
    // });

    /*-------------------------------------
    Intersection Observer
    -------------------------------------*/
    if (!!window.IntersectionObserver) {
    let observer = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.classList.add("active-animation");
            //entry.target.src = entry.target.dataset.src;
            observer.unobserve(entry.target);
        }
        });
    }, {
        rootMargin: "0px 0px -100px 0px"
    });
    document.querySelectorAll('.has-animation').forEach(block => {
        observer.observe(block)
    });
    }else {
    document.querySelectorAll('.has-animation').forEach(block => {
        block.classList.remove('has-animation')
    });
    }


    /*=============================================
        =            Scroll Up               =
    =============================================*/
    if ($('.scroll-to-target').length) {
      $(".scroll-to-target").on('click', function () {
        var target = $(this).attr('data-target');
        // animate
        $('html, body').animate({
          scrollTop: $(target).offset().top
        }, 1000);

      });
    }

    // offcanvas menu
    $(".menu-tigger").on("click", function () {
        $(".extra-info, .offcanvas-overly").addClass("active");
        return false;
    });
    $(".menu-close,.offcanvas-overly").on("click", function () {
        $(".extra-info,.offcanvas-overly").removeClass("active");
    });

    $(".menu-tigger").on("click", function () {
        $(".off-canvas-menu,.offcanvas-overly").addClass("active");
        return false;
    });
    $(".menu-close,.offcanvas-overly").on("click", function () {
        $(".off-canvas-menu,.offcanvas-overly").removeClass("active");
    });

    jQuery('.elementor-accordion-icon-opened i').removeClass('fas fa-arrow-up');
    jQuery('.elementor-accordion-icon-opened i').addClass('fal fa-arrow-up');

    jQuery('.elementor-accordion-icon-closed i').removeClass('fas fa-arrow-down');
    jQuery('.elementor-accordion-icon-closed i').addClass('fal fa-arrow-down');

})(jQuery);