<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Register Sidebar widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 *
 *
**/

/*------------------------------------------------------------------------------------------*/
/* - Recent Post Widget Widget
/*------------------------------------------------------------------------------------------*/
if( ! class_exists( 'eduvalt_recent_post_Widget' ) ) {
  class eduvalt_recent_post_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'eduvalt_rp_widget', // Widget ID
            'A::1 - Recent Posts Widget', // Widget Name
            array( 'description' => 'Eduvalt Recent Post' ) // Widget Description
        );
    }

    // Front-end display of the widget
    public function widget( $args, $instance ) {
        $title = apply_filters( 'widget_title', $instance['title'] );
        $number_of_posts = isset( $instance['number_of_posts'] ) ? absint( $instance['number_of_posts'] ) : 5;
        $order = isset( $instance['order'] ) ? $instance['order'] : 'DESC';
        $title_limit = isset($instance['title_limit']) ? absint($instance['title_limit']) : 35;

        echo $args['before_widget'];

        if ( $title ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        $recent_posts = new WP_Query(
            array(
                'post_type'      => 'post',
                'posts_per_page' => $number_of_posts,
                'orderby'        => 'date',
                'order'          => $order, // Use the chosen order (DESC or ASC)
            )
        );

        if ( $recent_posts->have_posts() ) {
            echo '<div class="sidebar-rc-post">';
            while ( $recent_posts->have_posts() ) {
                $recent_posts->the_post();

                $post_title = get_the_title();
                $shortened_title = (mb_strlen($post_title) > $title_limit) ? mb_substr($post_title, 0, $title_limit) . '..' : $post_title;
                ?>
                <div class="rc-post-item">
                  <?php
                  // Display post thumbnail if available
                  if ( has_post_thumbnail() ) { ?>
                      <div class="rc-post-thumb">
                        <a href="<?php the_permalink(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); ?></a>
                      </div>
                    <?php
                  }
                  ?>
                  <div class="rc-post-content">
                    <h4 class="title"><a href="<?php the_permalink(); ?>"><?php echo $shortened_title; ?></a></h4>
                    <span class="date"><i class="flaticon-calendar-date"></i><?php the_time(get_option('date_format')); ?></span>
                  </div>

                </div>
                <?php
            }
            echo '</div>';
            wp_reset_postdata();
        } else {
            echo '<p>No recent posts found.</p>';
        }

        echo $args['after_widget'];
    }

    // Widget settings form in the admin
    public function form( $instance ) {
        $title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $number_of_posts = isset( $instance['number_of_posts'] ) ? absint( $instance['number_of_posts'] ) : 5;
        $order = isset( $instance['order'] ) ? $instance['order'] : 'DESC'; // Default to DESC order
        $title_limit = isset($instance['title_limit']) ? absint($instance['title_limit']) : 35;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'number_of_posts' ); ?>">Number of Posts to Display:</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'number_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'number_of_posts' ); ?>" type="number" min="1" max="10" value="<?php echo $number_of_posts; ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'order' ); ?>">Post Order:</label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'order' ); ?>" name="<?php echo $this->get_field_name( 'order' ); ?>">
                <option value="DESC" <?php selected( $order, 'DESC' ); ?>>Descending</option>
                <option value="ASC" <?php selected( $order, 'ASC' ); ?>>Ascending</option>
            </select>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('title_limit'); ?>"><?php _e('Title character limit:'); ?></label>
            <input class="tiny-text" id="<?php echo $this->get_field_id('title_limit'); ?>" name="<?php echo $this->get_field_name('title_limit'); ?>" type="number" step="1" min="1" value="<?php echo $title_limit; ?>" size="3" />
        </p>
        <?php
    }

    // Save widget settings
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['number_of_posts'] = ( ! empty( $new_instance['number_of_posts'] ) ) ? absint( $new_instance['number_of_posts'] ) : 5;
        $instance['title_limit'] = ( ! empty( $new_instance['title_limit'] ) ) ? absint( $new_instance['title_limit'] ) : 35;
        $instance['order'] = ( ! empty( $new_instance['order'] ) && in_array( $new_instance['order'], array( 'DESC', 'ASC' ) ) ) ? $new_instance['order'] : 'DESC';
        return $instance;
    }
  }
}

if ( ! function_exists( 'eduvalt_recent_post_widget_init' ) ) {
  function eduvalt_recent_post_widget_init() {
    register_widget( 'eduvalt_recent_post_Widget' );
  }
  add_action( 'widgets_init', 'eduvalt_recent_post_widget_init', 2 );
}

/**
 * Eduvalt Footer Info Widget
 *
 *
 * @author      Eduvalt
 * @category    Widgets
 * @package     Eduvalt/Widgets
 * @version     1.0.0
 * @extends     WP_Widget
 */
add_action('widgets_init', 'Eduvalt_info_Widget');
function Eduvalt_info_Widget() {
    register_widget('Eduvalt_info_Widget');
}

class Eduvalt_info_Widget  extends WP_Widget{

    public function __construct(){
        parent::__construct('Eduvalt_info_Widget',esc_html__('A::2 - Eduvalt Info Widget','eduvalt'),array(
            'description' => esc_html__('Eduvalt Info Widget','eduvalt'),
        ));
    }

    public function widget($args, $instance){
        extract($args);
        extract($instance);

        print $before_widget;

        if ( ! empty( $title ) ) {
            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;
        }
        ?>

        <div class="footer__about">
            <?php if( !empty($image_box_image) ): ?>
                <div class="footer__logo logo">
                    <a href="<?php print home_url(); ?>">
                        <img src="<?php print $image_box_image; ?>" alt="<?php echo esc_attr__('Eduvalt','eduvalt') ?>">
                    </a>
                </div>
            <?php endif; ?>

            <?php if( !empty($description) ): ?>
                <div class="footer-text">
                    <p><?php print $description; ?></p>
                </div>
            <?php endif; ?>


        <ul class="list-wrap m-0 p-0">

            <?php if( !empty($address) ): ?>
                <li class="address"><?php print $address; ?></li>
            <?php endif; ?>

            <?php if( !empty($number) ): ?>
                <li class="number"><?php print $number; ?></li>
            <?php endif; ?>

            <li class="socials">
            <?php if( !empty($facebook) ): ?>
                <a href="<?php print esc_url($facebook); ?>"><i class="fab fa-facebook-f"></i></a>
            <?php endif; ?>

            <?php if( !empty($twitter) ): ?>
                <a href="<?php print esc_url($twitter); ?>"><i class="fab fa-twitter"></i></a>
            <?php endif; ?>

            <?php if( !empty($whatsapp) ): ?>
                <a href="<?php print esc_url($whatsapp); ?>"><i class="fab fa-whatsapp"></i></a>
            <?php endif; ?>

            <?php if( !empty($instagram) ): ?>
                <a href="<?php print esc_url($instagram); ?>"><i class="fab fa-instagram"></i></a>
            <?php endif; ?>

            <?php if( !empty($linkedin) ): ?>
                <a href="<?php print esc_url($linkedin); ?>"><i class="fab fa-linkedin-in"></i></a>
            <?php endif; ?>

            <?php if( !empty($youtube) ): ?>
                <a href="<?php print esc_url($youtube); ?>"><i class="fab fa-youtube"></i></a>
            <?php endif; ?>
            </li>
        </ul>

        </div>
        <?php print $after_widget; ?>

    <?php
    }


    /**
     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */
    public function form($instance){

        $title       = isset($instance['title'])? $instance['title']:'';
        $description = isset($instance['description'])? $instance['description']:'';
        $author_img  = isset($instance['image_box_image'])? $instance['image_box_image']:'';
        
        $address     = isset($instance['address'])? $instance['address']:'';
        $number      = isset($instance['number'])? $instance['number']:'';
        $facebook    = isset($instance['facebook'])? $instance['facebook']:'';
        $twitter     = isset($instance['twitter'])? $instance['twitter']:'';
        $whatsapp    = isset($instance['whatsapp'])? $instance['whatsapp']:'';
        $instagram   = isset($instance['instagram'])? $instance['instagram']:'';
        $linkedin    = isset($instance['linkedin'])? $instance['linkedin']:'';
        $youtube     = isset($instance['youtube'])? $instance['youtube']:'';

        ?>
        <p>
            <label for="title"><?php esc_html_e('Title:','eduvalt'); ?></label>
        </p>
        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

        <p>
            <input type="button" class="button button-secondary js_custom_upload_media" id="<?= $this->id ?>" value="Upload Media"></input>
            <input type="hidden" class="img <?= $this->id ?>_url" name="<?php print esc_attr($this->get_field_name('image_box_image')); ?>" class="image_er_link" value="<?php print $author_img ; ?>">
            <div class="author-image-show">
                <img class="<?= $this->id ?>_img" src="<?php print $author_img ; ?>" alt="" width="150" height="auto">
            </div>
            <script>
                jQuery(document).ready(function ($) {
                    function media_upload(button_selector) {
                        var _custom_media = true,
                            _orig_send_attachment = wp.media.editor.send.attachment;
                        $('body').on('click', button_selector, function () {
                            var button_id = $(this).attr('id');
                            wp.media.editor.send.attachment = function (props, attachment) {
                                if (_custom_media) {
                                    $('.' + button_id + '_img').attr('src', attachment.url);
                                    $('.' + button_id + '_url').val(attachment.url);
                                } else {
                                    return _orig_send_attachment.apply($('#' + button_id), [props, attachment]);
                                }
                            }
                            wp.media.editor.open($('#' + button_id));

                            $($(this).parents()[4]).addClass('widget-dirty');
                            $('#widget-<?= $this->id ?>-savewidget').removeAttr('disabled');
                            return false;
                        });
                    }
                    media_upload('.js_custom_upload_media');
                });
            </script>
        </p>

        <p>
            <label for="title"><?php esc_html_e('Short Description:','eduvalt'); ?></label>
        </p>

        <textarea class="widefat" rows="7" cols="15" id="<?php print esc_attr($this->get_field_id('description')); ?>" value="<?php print esc_attr($description); ?>" name="<?php print esc_attr($this->get_field_name('description')); ?>"><?php print esc_attr($description); ?></textarea>

        <p>
            <label for="title"><?php esc_html_e('Address:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('address')); ?>"  name="<?php print esc_attr($this->get_field_name('address')); ?>" value="<?php print esc_attr($address); ?>">

        <p>
            <label for="title"><?php esc_html_e('Number:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('number')); ?>"  name="<?php print esc_attr($this->get_field_name('number')); ?>" value="<?php print esc_attr($number); ?>">

        <p>
            <label for="title"><?php esc_html_e('Facebook:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('facebook')); ?>"  name="<?php print esc_attr($this->get_field_name('facebook')); ?>" value="<?php print esc_attr($facebook); ?>">

        <p>
            <label for="title"><?php esc_html_e('Twitter:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('twitter')); ?>"  name="<?php print esc_attr($this->get_field_name('twitter')); ?>" value="<?php print esc_attr($twitter); ?>">

        <p>
            <label for="title"><?php esc_html_e('WhatsApp:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('whatsapp')); ?>"  name="<?php print esc_attr($this->get_field_name('whatsapp')); ?>" value="<?php print esc_attr($whatsapp); ?>">

        <p>
            <label for="title"><?php esc_html_e('Instagram:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('instagram')); ?>"  name="<?php print esc_attr($this->get_field_name('instagram')); ?>" value="<?php print esc_attr($instagram); ?>">

        <p>
            <label for="title"><?php esc_html_e('Linkedin:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('linkedin')); ?>"  name="<?php print esc_attr($this->get_field_name('linkedin')); ?>" value="<?php print esc_attr($linkedin); ?>">

        <p>
            <label for="title"><?php esc_html_e('Youtube:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('youtube')); ?>"  name="<?php print esc_attr($this->get_field_name('youtube')); ?>" value="<?php print esc_attr($youtube); ?>">
        <p></p>

        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['description'] = ( ! empty( $new_instance['description'] ) ) ? strip_tags( $new_instance['description'] ) : '';
        $instance['address'] = ( ! empty( $new_instance['address'] ) ) ? strip_tags( $new_instance['address'] ) : '';
        $instance['number'] = ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : '';
        $instance['facebook'] = ( ! empty( $new_instance['facebook'] ) ) ? strip_tags( $new_instance['facebook'] ) : '';
        $instance['twitter'] = ( ! empty( $new_instance['twitter'] ) ) ? strip_tags( $new_instance['twitter'] ) : '';
        $instance['whatsapp'] = ( ! empty( $new_instance['whatsapp'] ) ) ? strip_tags( $new_instance['whatsapp'] ) : '';
        $instance['instagram'] = ( ! empty( $new_instance['instagram'] ) ) ? strip_tags( $new_instance['instagram'] ) : '';
        $instance['linkedin'] = ( ! empty( $new_instance['linkedin'] ) ) ? strip_tags( $new_instance['linkedin'] ) : '';
        $instance['youtube'] = ( ! empty( $new_instance['youtube'] ) ) ? strip_tags( $new_instance['youtube'] ) : '';
        $instance['image_box_image'] = ( ! empty( $new_instance['image_box_image'] ) ) ? strip_tags( $new_instance['image_box_image'] ) : '';
        return $instance;
    }
}





/**
 * Eduvalt Footer Work Info Widget
 *
 *
 * @author      Eduvalt
 * @category    Widgets
 * @package     Eduvalt/Widgets
 * @version     1.0.0
 * @extends     WP_Widget
 */
add_action('widgets_init', 'Eduvalt_Work_info_Widget');
function Eduvalt_Work_info_Widget() {
    register_widget('Eduvalt_Work_info_Widget');
}


class Eduvalt_Work_info_Widget  extends WP_Widget{

    public function __construct(){
        parent::__construct('Eduvalt_Work_info_Widget',esc_html__('A::3 - Eduvalt Work Info Widget','eduvalt'),array(
            'description' => esc_html__('Eduvalt Work Info Widget','eduvalt'),
        ));
    }

    public function widget($args, $instance){
        extract($args);
        extract($instance);

        print $before_widget;

        if ( ! empty( $title ) ) {
            print $before_title . apply_filters( 'widget_title', $title ) . $after_title;
        }
        ?>

        <div class="footer__working-list">
            <?php if( !empty($daysone) || !empty($timesone) ): ?>
            <div class="footer__working-item">
                <?php if( !empty($daysone) ): ?>
                    <span class="day"><?php print $daysone; ?></span>
                <?php endif; ?>
                <?php if( !empty($timesone) ): ?>
                <span class="time"><?php print $timesone; ?></span>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if( !empty($daystwo) || !empty($timestwo) ): ?>
            <div class="footer__working-item">
                <?php if( !empty($daystwo) ): ?>
                    <span class="day"><?php print $daystwo; ?></span>
                <?php endif; ?>
                <?php if( !empty($timestwo) ): ?>
                <span class="time"><?php print $timestwo; ?></span>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if( !empty($daysthree) || !empty($timesthree) ): ?>
            <div class="footer__working-item">
                <?php if( !empty($daysthree) ): ?>
                    <span class="day"><?php print $daysthree; ?></span>
                <?php endif; ?>
                <?php if( !empty($timesthree) ): ?>
                <span class="time"><?php print $timesthree; ?></span>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <?php if( !empty($daysfour) || !empty($timesfour) ): ?>
                <div class="footer__working-item">
                    <?php if( !empty($daysfour) ): ?>
                        <span class="day"><?php print $daysfour; ?></span>
                    <?php endif; ?>
                    <?php if( !empty($timesfour) ): ?>
                    <span class="time"><?php print $timesfour; ?></span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

        </div>
        <?php print $after_widget; ?>

    <?php
    }


    /**
     * widget function.
     *
     * @see WP_Widget
     * @access public
     * @param array $instance
     * @return void
     */
    public function form($instance){

        $title      = isset($instance['title'])? $instance['title']:'';
        $daysone    = isset($instance['daysone'])? $instance['daysone']:'';
        $timesone   = isset($instance['timesone'])? $instance['timesone']:'';
        $daystwo    = isset($instance['daystwo'])? $instance['daystwo']:'';
        $timestwo   = isset($instance['timestwo'])? $instance['timestwo']:'';
        $daysthree  = isset($instance['daysthree'])? $instance['daysthree']:'';
        $timesthree = isset($instance['timesthree'])? $instance['timesthree']:'';
        $daysfour  = isset($instance['daysfour'])? $instance['daysfour']:'';
        $timesfour = isset($instance['timesfour'])? $instance['timesfour']:'';

        ?>
        <p>
            <label for="title"><?php esc_html_e('Title:','eduvalt'); ?></label>
        </p>
        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('title')); ?>"  name="<?php print esc_attr($this->get_field_name('title')); ?>" value="<?php print esc_attr($title); ?>">

        <p>
            <label for="title"><?php esc_html_e('Days 1:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('daysone')); ?>"  name="<?php print esc_attr($this->get_field_name('daysone')); ?>" value="<?php print esc_attr($daysone); ?>">

        <p>
            <label for="title"><?php esc_html_e('Times 1:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('timesone')); ?>"  name="<?php print esc_attr($this->get_field_name('timesone')); ?>" value="<?php print esc_attr($timesone); ?>">

        <p>
            <label for="title"><?php esc_html_e('Days 2:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('daystwo')); ?>"  name="<?php print esc_attr($this->get_field_name('daystwo')); ?>" value="<?php print esc_attr($daystwo); ?>">

        <p>
            <label for="title"><?php esc_html_e('Times 2:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('timestwo')); ?>"  name="<?php print esc_attr($this->get_field_name('timestwo')); ?>" value="<?php print esc_attr($timestwo); ?>">

        <p>
            <label for="title"><?php esc_html_e('Days 3:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('daysthree')); ?>"  name="<?php print esc_attr($this->get_field_name('daysthree')); ?>" value="<?php print esc_attr($daysthree); ?>">

        <p>
            <label for="title"><?php esc_html_e('Times 3:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('timesthree')); ?>"  name="<?php print esc_attr($this->get_field_name('timesthree')); ?>" value="<?php print esc_attr($timesthree); ?>">


        <p>
            <label for="title"><?php esc_html_e('Days 4:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('daysfour')); ?>"  name="<?php print esc_attr($this->get_field_name('daysfour')); ?>" value="<?php print esc_attr($daysfour); ?>">

        <p>
            <label for="title"><?php esc_html_e('Times 4:','eduvalt'); ?></label>
        </p>

        <input class="widefat" type="text" id="<?php print esc_attr($this->get_field_id('timesfour')); ?>"  name="<?php print esc_attr($this->get_field_name('timesfour')); ?>" value="<?php print esc_attr($timesfour); ?>">

        <p></p>

        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['daysone'] = ( ! empty( $new_instance['daysone'] ) ) ? strip_tags( $new_instance['daysone'] ) : '';
        $instance['timesone'] = ( ! empty( $new_instance['timesone'] ) ) ? strip_tags( $new_instance['timesone'] ) : '';
        $instance['daystwo'] = ( ! empty( $new_instance['daystwo'] ) ) ? strip_tags( $new_instance['daystwo'] ) : '';
        $instance['timestwo'] = ( ! empty( $new_instance['timestwo'] ) ) ? strip_tags( $new_instance['timestwo'] ) : '';
        $instance['daysthree'] = ( ! empty( $new_instance['daysthree'] ) ) ? strip_tags( $new_instance['daysthree'] ) : '';
        $instance['timesthree'] = ( ! empty( $new_instance['timesthree'] ) ) ? strip_tags( $new_instance['timesthree'] ) : '';
        $instance['daysfour'] = ( ! empty( $new_instance['daysfour'] ) ) ? strip_tags( $new_instance['daysfour'] ) : '';
        $instance['timesfour'] = ( ! empty( $new_instance['timesfour'] ) ) ? strip_tags( $new_instance['timesfour'] ) : '';

        return $instance;
    }
}