<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Working_Steps extends Widget_Base {
	// widgets unique ID
	public function get_name() {
		return 'working-steps';
	}

	// widgets title
	public function get_title() {
		return 'Tutor Categories Item';
	}

	// widgets Icon
	public function get_icon() {
		return 'eicon-info-box';
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Tutor Categories Item', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'select_styles',
			[
				'label' => __( 'Select Style', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' 	=> __( 'Style One', 'eduvalt' ),
					'style2' 	=> __( 'Style Two', 'eduvalt' ),
					'style3' 	=> __( 'Style Three', 'eduvalt' ),
				]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'course_cat_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Graphic Design', 'eduvalt' ),
			]
		);

		$repeater->add_control(
			'course_cat_numer',
			[
				'label' => esc_html__( 'Course Number', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( '07 Courses', 'eduvalt' ),
			]
		);

        $repeater->add_control(
            'courses_icons_type', [
                'label' => __( 'Icon Type', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
			    'default' => '1',
			    'options' => [
			     	'1'   => __( 'Icon', 'eduvalt' ),
			     	'2'   => __( 'SVG', 'eduvalt' ),
			    ],
            ]
        );

        $repeater->add_control(
            'course_cat_font_icons', [
                'label' => __( 'Upload Icon', 'eduvalt' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
				'condition' => [
					'courses_icons_type' => '1',
				],
            ]
        );

        $repeater->add_control(
            'course_cat_svg_icons', [
                'label' => __( 'Select Icon', 'eduvalt' ),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
				'condition' => [
					'courses_icons_type' => '2',
				],
            ]
        );

		$repeater->add_control(
			'course_bg_thumb',
			[
				'label' => esc_html__( 'Background Image', 'eduvalt' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'course_cat_link',
			[
				'label' => __( 'Button Link', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'course_categories_list',
			[
				'label' => __( 'Repeater List', 'eduvalt' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'course_cat_numer'  => __( '06 Courses', 'eduvalt' ),
						'course_cat_title'  => __( 'Graphic Design', 'eduvalt' ),
						'course_cat_link'   => __( 'example.com' ),
					],
					[
						'course_cat_numer'  => __( '09 Courses', 'eduvalt' ),
						'course_cat_title'  => __( 'Marketing', 'eduvalt' ),
						'course_cat_link'   => __( 'example.com' ),
					]
				],
				'title_field' => '{{{ course_cat_title }}}',
			]
		);
 
        $this->add_control(
            'work_bg_shape',
            [
                'label' => esc_html__( 'Work Shape', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


		$this->end_controls_section();
		//End  of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'step_items_bg_color',
			[
				'label' => __( 'Item Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_items_shape_bg_color',
			[
				'label' => __( 'Item Top Shape Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item::after' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_items_hover_shape_bg_color',
			[
				'label' => __( 'Item Hover Top Shape Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item::before' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->end_controls_section();


        // Content Style
        $this->start_controls_section(
            'work_sptes_icons_style',
            [
                'label' => esc_html__( 'Icon Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
			'step_icons_bg_color',
			[
				'label' => __( 'Item Icon Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .choose-icon' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_icons_text_color',
			[
				'label' => __( 'Item Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .choose-icon svg' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_icons_hover_bg_color',
			[
				'label' => __( 'Item Icon Hover Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item:hover .choose-icon' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_icons_hover_text_color',
			[
				'label' => __( 'Item Hover Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item:hover .choose-icon svg' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);


		// style two
		$this->add_responsive_control(
			'step2_icons_bg_color',
			[
				'label' => __( 'Item Icon Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item-wrap .work-item .work-icon' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);

		$this->add_responsive_control(
			'step2_icons_text_color',
			[
				'label' => __( 'Item Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item-wrap .work-item .work-icon' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);

		$this->add_responsive_control(
			'step2_icons_hover_bg_color',
			[
				'label' => __( 'Item Icon Hover Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item .work-icon::before' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);

		$this->add_responsive_control(
			'step2_icons_hover_text_color',
			[
				'label' => __( 'Item Hover Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item:hover .work-icon' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);

		$this->add_responsive_control(
			'step2_number_bg_color',
			[
				'label' => __( 'Item Number Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item .work-icon .number' => 'background: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);
		$this->add_responsive_control(
			'step2_number_text_color',
			[
				'label' => __( 'Item Number Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item .work-icon .number' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);
		$this->add_responsive_control(
			'step2_number_hover_text_color',
			[
				'label' => __( 'Item Number Hover Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item:hover .work-icon .number' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);

		// style Five
		$this->add_responsive_control(
			'step5_icons_bg_color',
			[
				'label' => __( 'Item Icon Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-list-wrap .list-wrap .work-list-item i' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style5',
				],
			]
		);


		$this->end_controls_section();

        // Content Style
        $this->start_controls_section(
            'work_sptes_content_style',
            [
                'label' => esc_html__( 'Content Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
			'step_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .working-steps-items .choose-content .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_title_hover_color',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .working-steps-items .choose-content .title a:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_content_color',
			[
				'label' => __( 'Content Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .working-steps-items .choose-content p' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .choose-item .working-steps-items .choose-content .title',
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		// style two
		$this->add_responsive_control(
			'step2_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item-wrap .work-content .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);
		$this->add_responsive_control(
			'step2_content_color',
			[
				'label' => __( 'Content Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-item-wrap .work-content p' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style2',
				],
			]
		);


		// style Five
		$this->add_responsive_control(
			'step5_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .work-list-wrap .list-wrap .work-list-item span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style5',
				],
			]
		);

		$this->end_controls_section();


        // Button
        $this->start_controls_section(
            'work_sptes_button_style',
            [
                'label' => esc_html__( 'Button Style', 'eduvalt' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_responsive_control(
			'step_readmore_color',
			[
				'label' => __( 'Read More Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .working-steps-items .choose-content a.read-more' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->add_responsive_control(
			'step_readmore_hover_color',
			[
				'label' => __( 'Read More Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .choose-item .working-steps-items .choose-content a.read-more:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'select_styles' => 'style1',
				],
			]
		);

		$this->end_controls_section();

	}
	//end of control box 

	//to show on the fontend 
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
			<?php if ( $settings['select_styles'] == 'style3') { ?>
				<?php if ( $settings['course_categories_list'] ) { ?>
			        <div class="row justify-content-center row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xl-4">
			        	<?php foreach ( $settings['course_categories_list'] as $value ) { ?>
			                <div class="col">
			                    <div class="categories__item-three">
			                    	<a href="<?php echo $value['course_cat_link']['url']; ?>">
			                    		<?php if (!empty($value['course_bg_thumb']['url'])): ?>
						                    <div class="thumb">
						                        <img src="<?php echo esc_url( $value['course_bg_thumb']['url'] ); ?>" alt="<?php echo esc_attr( !empty($value['course_cat_title']) ? $value['course_cat_title'] : 'Course category thumbnail' ); ?>">
						                    </div>
				                    	<?php endif; ?>
		                                <div class="info">
		                                    <div class="list"><span class="courses"><?php echo $value['course_cat_numer']; ?></span></div>
		                                    <?php if( !empty( $value['course_cat_title'] )){ ?>
		                                    	<div class="list"><span class="name"><?php echo $value['course_cat_title']; ?></span></div>
		                                	<?php } ?>
		                                </div>
				                    </a>
			                    </div>
			                </div>
			            <?php } ?>
			        </div>
		        <?php } ?>
	        <?php }elseif ( $settings['select_styles'] == 'style2') { ?>
				<?php if ( $settings['course_categories_list'] ) { ?>
			        <div class="row justify-content-center row-cols-1 row-cols-sm-2 row-cols-md-3">
			        	<?php foreach ( $settings['course_categories_list'] as $index=> $value ) { ?>
			                <div class="col">
			                    <div class="categories__item-two tg-svg">
			                    	<a href="<?php echo $value['course_cat_link']['url']; ?>">
				                    	<?php if( !empty( $value['courses_icons_type'] == 1 ) ){ ?>
					                    	<?php if( !empty( $value['course_cat_font_icons'] ) ){ ?>
					                    		<div class="icon">
													<span class="svg-icon" id="cat_svg-<?php echo $index; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/categories_icon.svg"><svg width="100%" height="100%" viewBox="0 0 81 36" fill="none" xmlns="http://www.w3.org/2000/svg">
													<path fill-rule="evenodd" clip-rule="evenodd" d="M73.2539 26.0108L77.7925 25.0797L74.4188 28.2552L75.3921 32.7719L72.1744 29.42L67.6357 30.3511L71.0095 27.1757L70.1207 22.6151L73.2539 26.0108Z" fill="currentColor" style="stroke-dasharray: 38, 40; stroke-dashoffset: 0;"></path>
													<path d="M9.54386 14.0915L8.86485 12.1998L6.10032 13.2003L5.09 10.457L3.18846 11.1574L4.19878 13.9006L1.44572 14.9322L2.1559 16.8124L4.89911 15.8021L5.93075 18.5552L7.80112 17.8663L6.80065 15.1018L9.54386 14.0915Z" fill="currentColor" style="stroke-dasharray: 32, 34; stroke-dashoffset: 0;"></path>
													<path d="M52 4.00122L48.992 1.00122L45.952 4.00122L43.008 1.00122L39.968 4.00122L37.056 1.00122L34 4.00122" stroke="currentColor" stroke-width="1.1" stroke-miterlimit="10" style="stroke-dasharray: 26, 28; stroke-dashoffset: 0;"></path>
													</svg></span>
					                    			<i class="<?php echo $value['course_cat_font_icons']; ?>"></i>
					                    		</div>
					                    	<?php } ?>
				                    	<?php }else{ ?>
					                    	<div class="icon">
					                    		<?php \Elementor\Icons_Manager::render_icon( $value['course_cat_svg_icons'], [ 'aria-hidden' => 'true' ] ); ?>
					                    	</div>
				                    	<?php } ?>
				                    	<div class="info">
				                            <span class="name">
				                            	<?php if( !empty( $value['course_cat_title'] )){ ?>
				                            		<?php echo $value['course_cat_title']; ?>
				                            	<?php } ?>
				                            </span>
				                            <span class="courses"><?php echo $value['course_cat_numer']; ?></span>
			                        	</div>
				                    </a>
			                    </div>
			                </div>
			            <?php } ?>
			        </div>
		        <?php } ?>
	        <?php }else{ ?> 
				<?php if ( $settings['course_categories_list'] ) { ?>
			        <div class="row justify-content-center row-cols-2 row-cols-md-3">
			        	<?php foreach ( $settings['course_categories_list'] as $value ) { ?>
			                <div class="col">
			                    <div class="categories__item">
			                    	<a href="<?php echo $value['course_cat_link']['url']; ?>">
				                    	<?php if( !empty( $value['courses_icons_type'] == 1 ) ){ ?>
					                    	<?php if( !empty( $value['course_cat_font_icons'] ) ){ ?>
					                    		<div class="choose-icon">
					                    			<i class="<?php echo $value['course_cat_font_icons']; ?>"></i>
					                    		</div>
					                    	<?php } ?>
				                    	<?php }else{ ?>
					                    	<div class="choose-icon">
					                    		<?php \Elementor\Icons_Manager::render_icon( $value['course_cat_svg_icons'], [ 'aria-hidden' => 'true' ] ); ?>
					                    	</div>
				                    	<?php } ?>
			                            <span class="name">
			                            	<?php if( !empty( $value['course_cat_title'] )){ ?>
			                            		<?php echo $value['course_cat_title']; ?>
			                            	<?php } ?>
			                            </span>
			                            <span class="courses"><?php echo $value['course_cat_numer']; ?></span>
				                    </a>
			                    </div>
			                </div>
			            <?php } ?>
			        </div>
		        <?php } ?>
	        <?php } ?>
		<?php
	}
}