<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Tutor_Course_Grid extends Widget_Base {   //this name is added to plugin.php of the root folder

	public function get_name() {
		return 'section-tutor-course-grid';
	}

	public function get_title() {
		return 'Tutor Couser Grid';   // title to show on elementor
	}

	public function get_icon() {
		return 'fal fa-quote-left';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}
   
   public function get_script_depends() {
		return [ 'eduvalt-elementor-editor' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/
	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Tutor Course Grid', 'eduvalt' ),   //section name for controler view
			]
		);
        $this->add_control(
            'section_about_title',
            [
                'label' => esc_html__( 'Section Title First', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Our', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_middle',
            [
                'label' => esc_html__( 'Section Title Middle', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Featured', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_last',
            [
                'label' => esc_html__( 'Section Title Last', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Courses', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_sub_title',
            [
                'label' => esc_html__( '10,000+ Unique Online Courses', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Welcome our Property.', 'eduvalt'),
                'label_block' => true,
            ]
        );

		$this->add_control(
			  'case_grid_styles',
			  [
			     'label'   => __( 'Course Grid Style', 'eduvalt' ),
			     'type'    => Controls_Manager::SELECT,
			     'default' => 'style1',
			     'options' => [
					'style1' => __( 'Grid Style 1', 'eduvalt' ),
					'style2' => __( 'Grid Style 2', 'eduvalt' ),
					'style3' => __( 'Grid Style 3', 'eduvalt' ),
			     ],
			  ]
		);

		$this->add_control(
			'categories_portfolio',
			[
				'label' => __( 'Select Categories', 'eduvalt' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => eduvalt_get_terms_dropdown_array([
					'taxonomy' => 'course-category',
					'hide_empty' => true
				]),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_number',
			[
				'label' => esc_html__( 'Number of Case', 'eduvalt' ),
				'description' => esc_html__( 'Give -1 for all post', 'eduvalt' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 12,
			]
		);

		$this->add_control(
			'grid_columns',
			[
			    'label'       => __( 'Case Grid columns', 'eduvalt' ),
			    'type' => Controls_Manager::SELECT,
			    'default' => '4',
			    'options' => [
			     	'6'   => __( '2', 'eduvalt' ),
			     	'4'   => __( '3', 'eduvalt' ),
			     	'3'   => __( '4', 'eduvalt' ),
			    ],
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => __( 'Order by', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' =>ifinger_post_orderby_options(),
			]
		);

		$this->add_control(
			'order',
			[
				'label' => __( 'Order', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'ASC' => __( 'Ascending Order', 'eduvalt' ),
					'DESC' => __( 'Descending', 'eduvalt' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_style',
			[
				'label' => esc_html__( 'Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'casegrid_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .projects-area-three .project-content-three .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);

		$this->add_control(
			'casegrid_title_hover_color',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .projects-area-three .project-content-three .title a:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .projects-area-three .project-content-three .title',
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);

		$this->add_control(
			'casegrid_items2_color',
			[
				'label' => __( 'Item Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two::before' => 'background: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->add_control(
			'casegrid_title2_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two .project-content-two .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->add_control(
			'casegrid_title2_hover_color',
			[
				'label' => __( 'Title Hover Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two .project-content-two .title a:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title2_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .project-item-two .project-content-two .title',
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'casegrid_sub_title_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'casegrid_sub_title_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .projects-area-three .project-content-three span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .projects-area-three .project-content-three span',
				'condition' => [
					'case_grid_styles' => 'style1',
				],
			]
		);

		$this->add_control(
			'casegrid_sub_title2_color',
			[
				'label' => __( 'Sub Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project-item-two .project-content-two span' => 'color: {{VALUE}};',
				],
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title2_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .project-item-two .project-content-two span',
				'condition' => [
					'case_grid_styles' => 'style2',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {				//to show on the fontend 
		$settings = $this->get_settings_for_display();
		$eduvalt_rtl_check = is_rtl() ?  'true' : 'false';
		if ( function_exists('tutor')) {

		if( !empty( $settings['categories_portfolio'] ) ){
			$category = !empty( $settings['categories_portfolio'] ) ? $settings['categories_portfolio'] : 'All';
	    	$args = array(
				'post_type'      => 'courses',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['orderby'],
	            'tax_query'     => array(
	                array(
	                    'taxonomy'  => 'course-category',
	                    'field'     => 'id', 
	                    'terms'     => $category
	                )
	            )
	    	);
		}else{
	    	$args = array(
				'post_type'      => 'courses',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['post_number'],
				'orderby'        => $settings['orderby'],
	    	);
		}

		$e_uniqid     = uniqid();

		$grid_query= null;		 
		$grid_query = new \WP_Query( $args );

		if ( $grid_query->have_posts() ) : ?>
			<?php if( 'style3' == $settings['case_grid_styles'] ){ ?>

				<script type="text/javascript">
				    jQuery(document).ready(function(){
						jQuery('.courses-slider-active').slick({
							dots: false,
							infinite: true,
							speed: 600,
							autoplay: false,
							arrows: true,
							rtl: <?php echo $eduvalt_rtl_check; ?>,
							slidesToShow: 4,
							slidesToScroll: 1,
						    prevArrow: '<button type="button" class="slick-prev"><i class="fas fa-arrow-left"></i></button>',
							nextArrow: '<button type="button" class="slick-next"><i class="fas fa-arrow-right"></i></button>',
							responsive: [
								{
									breakpoint: 1200,
									settings: {
										slidesToShow: 3,
										slidesToScroll: 1,
										infinite: true,
									}
								},
								{
									breakpoint: 992,
									settings: {
										slidesToShow: 2,
										slidesToScroll: 1
									}
								},
								{
									breakpoint: 767,
									settings: {
										slidesToShow: 1,
										slidesToScroll: 1,
						                centerMode: true,
						                centerPadding: '110px',
										arrows: false,
									}
								},
								{
									breakpoint: 575,
									settings: {
										slidesToShow: 1,
										slidesToScroll: 1,
										arrows: false,
						                centerMode: false,
						                centerPadding: '0',
									}
								},
							]
						});
				    });
				</script>

				<div class="row courses-slider-active">
                	<?php while ( $grid_query->have_posts() ) : $grid_query->the_post();
                		$course_id       = get_the_ID();

                        $course_duration = get_tutor_course_duration_context();
                        $course_students = tutor_utils()->count_enrolled_users_by_course();
                        $course_students = !empty($course_students) ? $course_students : 0;

				        $tutor_lesson_count = tutor_utils()->get_lesson_count_by_course($course_id);
				        // $course_rating = tutor_utils()->get_course_rating();
				        // $total_reviews = apply_filters('tutor_course_rating_count', $course_rating->rating_count);

				        $course_categories     = get_tutor_course_categories($course_id);


					    $terms = get_the_terms(get_the_ID(), 'course-category' );
				        if ( $terms && ! is_wp_error( $terms ) ) {
				            $draught_links = array();
				            foreach ( $terms as $term ) {
				                $draught_links[] = $term->slug;
				                $term_link = get_term_link( $term );
				            }        
				        	$cat_slug = join( " ", $draught_links );
				        }

                		?>
	                	<div class="col">
	                        <div class="courses__item-two shine__animate-item">
	                            <div class="courses__item-two-thumb">
	                                <a href="<?php the_permalink(); ?>" class="shine__animate-link">
	                                    <?php the_post_thumbnail('full', ['alt' => get_the_title()]); ?>
	                                </a>
                                    <div class="author">
										<?php
									        global $post, $authordata;
									        $profile_url = tutor_utils()->profile_url($authordata->ID, true);
									        $disable_course_author = get_tutor_option('disable_course_author');
								        ?>

										<?php if ( !$disable_course_author ) { ?>
										    <a href="<?php echo esc_url( $profile_url ); ?>" class="instructor-profile-link">
										        <?php
										            echo get_avatar(
										                get_the_author_meta( 'ID' ),
										                32,
										                '',
										                '', // empty alt text
										                [
										                    'alt' => '',
										                    'aria-hidden' => 'true',
										                    'role' => 'presentation'
										                ]
										            );
										        ?>
										        <span class="s-classs"><?php echo esc_html( get_the_author() ); ?></span>
										    </a>
										<?php } ?>

                                    </div>
	                            </div>
	                            <div class="courses__item-two-content">
					                <?php  
					                        $postID = get_post()->ID;
					                        $tax_html = '';
					                        $terms = get_the_terms($postID, 'course-category');
					                        if (!empty($terms) && !is_wp_error($terms)) {
					                            foreach ($terms as $cat) {
					                                $tax_html .= '<a href="' . get_term_link($cat, $cat->taxonomy) . '" rel="tag">' . $cat->name . '</a>';
					                            }
					                        }

					                        if (!$tax_html) {
					                            //* Bailout, if nothing to render
					                            return;
					                        }

					                        printf('<div class="courses__item-categories ">%s</div>', $tax_html); 
					                ?>
	                                <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
	                                <ul class="courses__item-meta list-wrap">
	                                	<?php if($tutor_lesson_count) { ?>
	                                    	<li><i class="flaticon-file"></i> <?php echo $tutor_lesson_count; ?></li>
	                                	<?php } ?>
										<?php
											$duration        = get_post_meta( get_the_ID(), '_course_duration', true );
								            $durationHours   = intval( tutor_utils()->avalue_dot( 'hours', $duration ) );
								            $durationMinutes = intval( tutor_utils()->avalue_dot( 'minutes', $duration ) );
								            $durationSeconds = intval( tutor_utils()->avalue_dot( 'seconds', $duration ) );
							            ?>
	                                    <li>
	                                    	<i class="flaticon-timer"></i>
                                    		<?php echo $durationHours; ?><?php echo esc_html( 'h' ); ?>
                                    		<?php echo $durationMinutes; ?><?php echo esc_html( 'm' ); ?>
	                                    </li>
	                                    <li><i class="flaticon-user-1"></i> <?php echo $course_students; ?></li>
	                                </ul>
	                                <div class="courses__item-bottom">
	                                    <div class="course__price">
	                                        <h3 class="price">
												<?php 
												    //tutor_course_price();

											        $is_purchasable = tutor_utils()->is_course_purchasable();
											        $price          = apply_filters( 'get_tutor_course_price', null, get_the_ID() );
											        if ( $is_purchasable && $price ) :
											            $price = $price;
											        else :
											            $price = __( 'Free', 'eduvalt' );
											        endif;

											        echo wp_kses_post($price);
												?>
	                                        </h3>
	                                    </div>
	                                    <div class="courses__item-rating">
					                        <?php
										        $course_rating = tutor_utils()->get_course_rating();
										        $total_reviews = apply_filters('tutor_course_rating_count', $course_rating->rating_avg);
										        if ($course_rating->rating_avg > 0) { ?>
										            <i class="fas fa-star"></i>
										            <span class="rating-count">
										                <?php echo '('.esc_attr( $total_reviews ).')'; ?>
										            </span>
										    <?php } ?>
	                                    </div>
	                                </div>
	                            </div>
	                        </div>

	                    </div>

                    <?php endwhile; wp_reset_postdata(); ?>
		        </div>

			<?php }elseif( 'style2' == $settings['case_grid_styles'] ){ ?>
				<div class="projects-area-two">
	                <div class="section__title-wrap mb-40">
	                    <div class="row align-items-end">
	                        <div class="col-lg-5">
	                            <div class="section__title text-center text-lg-start">
	                                <span class="sub-title"><?php echo esc_html( $settings['section_sub_title'] ); ?></span>
	                                <h2 class="title tg-svg"><?php echo esc_html( $settings['section_about_title'] ); ?> <span class="position-relative"><span class="svg-icon" id="svg-4" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo esc_html( $settings['section_about_title_middle'] ); ?></span> <?php echo esc_html( $settings['section_about_title_last'] ); ?></h2>
	                            </div>
	                        </div>
	                        <?php if( !empty( $settings['categories_portfolio'] ) ){ ?>
		                        <div class="col-lg-7">
		                            <div class="courses__nav-active">
										<?php
											$filters = get_terms( array(
											    'taxonomy'   => 'course-category',
											    'include'    => $settings['categories_portfolio'],
											    'hide_empty' => false,
											    'orderby'    => 'include',
											) );

											if ( ! empty( $filters ) && ! is_wp_error( $filters ) ) { ?>
											    <button class="active" data-filter="*">
											        <?php echo esc_html__( 'All Courses', 'eduvalt' ); ?> 
											        <span><?php echo esc_html__( 'New', 'eduvalt' ); ?></span>
											    </button>
											    <?php
											    foreach ( $filters as $filter ) {
											        echo '<button class="button" data-filter=".' . esc_attr( $filter->slug ) . '">' . esc_html( $filter->name ) . '</button>';
											    }
											}
										?>
		                            </div>
		                        </div>
					        <?php } ?>
	                    </div>
	                </div>
					<div class="row courses-active">
	                	<?php while ( $grid_query->have_posts() ) : $grid_query->the_post();
	                		$course_id       = get_the_ID();

                            $course_duration = get_tutor_course_duration_context();
                            $course_students = tutor_utils()->count_enrolled_users_by_course();
                            $course_students = !empty($course_students) ? $course_students : 0;

					        $tutor_lesson_count = tutor_utils()->get_lesson_count_by_course($course_id);
					        // $course_rating = tutor_utils()->get_course_rating();
					        // $total_reviews = apply_filters('tutor_course_rating_count', $course_rating->rating_count);

					        $course_categories     = get_tutor_course_categories($course_id);

							$terms = get_the_terms( get_the_ID(), 'course-category' );
							if ( $terms && ! is_wp_error( $terms ) ) {
							    $term_slugs = array();
							    foreach ( $terms as $term ) {
							        $term_slugs[] = $term->slug;
							        $term_link = get_term_link( $term );
							    }        
							    $cat_slug = join( " ", $term_slugs );
							}
	                		?>
		                	<div class="col-lg-<?php echo esc_attr( $settings['grid_columns'] ); ?> grid-item <?php echo esc_attr( $cat_slug ); ?>">
		                        <div class="courses__item-two shine__animate-item">
		                            <div class="courses__item-two-thumb">
		                                <a href="<?php the_permalink(); ?>" class="shine__animate-link">
		                                    <?php the_post_thumbnail('full', ['alt' => get_the_title()]); ?>
		                                </a>
		                                <div class="course__price">
		                                    <svg viewBox="0 0 104 34" fill="none" x="0px" y="0px" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
		                                        <path d="M17.5689 2.56089L0 34H99C101.761 34 104 31.7614 104 29V0H21.9336C20.1223 0 18.4525 0.979667 17.5689 2.56089Z" fill="currentColor"/>
		                                    </svg>
		                                    <h3 class="price">
												<?php 
												    //tutor_course_price();

											        $is_purchasable = tutor_utils()->is_course_purchasable();
											        $price          = apply_filters( 'get_tutor_course_price', null, get_the_ID() );
											        if ( $is_purchasable && $price ) :
											            $price = $price;
											        else :
											            $price = __( 'Free', 'eduvalt' );
											        endif;

											        echo wp_kses_post($price);
												?>
		                                    </h3>
		                                </div>
		                            </div>
		                            <div class="courses__item-two-content">
						                <?php  
						                        $postID = get_post()->ID;
						                        $tax_html = '';
						                        $terms = get_the_terms($postID, 'course-category');
						                        if (!empty($terms) && !is_wp_error($terms)) {
						                            foreach ($terms as $cat) {
						                                $tax_html .= '<a href="' . get_term_link($cat, $cat->taxonomy) . '" rel="tag">' . $cat->name . '</a>';
						                            }
						                        }

						                        if (!$tax_html) {
						                            //* Bailout, if nothing to render
						                            return;
						                        }

						                        printf('<div class="courses__item-categories ">%s</div>', $tax_html); 
						                ?>
		                                <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
		                                <ul class="courses__item-meta list-wrap">
		                                	<?php if($tutor_lesson_count) { ?>
		                                    	<li><i class="flaticon-file"></i> <?php echo $tutor_lesson_count; ?></li>
		                                	<?php } ?>
											<?php
												$duration        = get_post_meta( get_the_ID(), '_course_duration', true );
									            $durationHours   = intval( tutor_utils()->avalue_dot( 'hours', $duration ) );
									            $durationMinutes = intval( tutor_utils()->avalue_dot( 'minutes', $duration ) );
									            $durationSeconds = intval( tutor_utils()->avalue_dot( 'seconds', $duration ) );
								            ?>
		                                    <li>
		                                    	<i class="flaticon-timer"></i>
	                                    		<?php echo $durationHours; ?><?php echo esc_html( 'h' ); ?>
	                                    		<?php echo $durationMinutes; ?><?php echo esc_html( 'm' ); ?>
		                                    </li>
		                                    <li><i class="flaticon-user-1"></i> <?php echo $course_students; ?></li>
		                                </ul>
		                                <div class="courses__item-bottom">
		                                    <div class="author">
												<?php
											        global $post, $authordata;
											        $profile_url = tutor_utils()->profile_url($authordata->ID, true);
											        $disable_course_author = get_tutor_option('disable_course_author');
										        ?>

										        <?php if ( !$disable_course_author){ ?>
													<a href="<?php echo esc_url( $profile_url ); ?>" class="instructor-profile-link">
													  <?php
													  	echo get_avatar(
													    get_the_author_meta( 'ID' ),
													    32,
													    '',
													    '', // empty alt text
													    [ 'aria-hidden' => 'true' ] // hide from screen readers
													  );
													  ?>
													  <span class="instructor-name"><?php echo esc_html( get_the_author() ); ?></span>
													</a>
										        <?php } ?>
		                                    </div>
		                                    <div class="courses__item-rating">
						                        <?php
											        $course_rating = tutor_utils()->get_course_rating();
											        $total_reviews = apply_filters('tutor_course_rating_count', $course_rating->rating_avg);

											        if ($course_rating->rating_avg > 0) { ?>
											            <i class="fas fa-star"></i>
											            <span class="rating-count">
											                <?php echo '('.esc_attr( $total_reviews ).')'; ?>
											            </span>
											    <?php } ?>
		                                    </div>
		                                </div>
		                            </div>
		                        </div>
		                    </div>

	                    <?php endwhile; wp_reset_postdata(); ?>
			        </div>
		        </div>
			<?php } else{ ?>
				<div class="projects-area-three">
	                <div class="section__title-wrap mb-40">
	                    <div class="row align-items-end">
	                        <div class="col-lg-5">
	                            <div class="section__title text-center text-lg-start">
	                                <span class="sub-title"><?php echo esc_html( $settings['section_sub_title'] ); ?></span>
	                                <h2 class="title tg-svg"><?php echo esc_html( $settings['section_about_title'] ); ?> <span class="position-relative"><span class="svg-icon" id="svg-4" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo esc_html( $settings['section_about_title_middle'] ); ?></span> <?php echo esc_html( $settings['section_about_title_last'] ); ?></h2>
	                            </div>
	                        </div>
	                        <?php if( !empty( $settings['categories_portfolio'] ) ){ ?>
		                        <div class="col-lg-7">
		                            <div class="courses__nav-active">
										<?php
											$filters = get_terms( array(
											    'taxonomy'   => 'course-category',
											    'include'    => $settings['categories_portfolio'],
											    'hide_empty' => false,
											    'orderby'    => 'include',
											) );

											if ( ! empty( $filters ) && ! is_wp_error( $filters ) ) { ?>
											    <button class="active" data-filter="*">
											        <?php echo esc_html__( 'All Courses', 'eduvalt' ); ?> 
											        <span><?php echo esc_html__( 'New', 'eduvalt' ); ?></span>
											    </button>
											    <?php
											    foreach ( $filters as $filter ) {
											        echo '<button class="button" data-filter=".' . esc_attr( $filter->slug ) . '">' . esc_html( $filter->name ) . '</button>';
											    }
											}
										?>
		                            </div>
		                        </div>
					        <?php } ?>
	                    </div>
	                </div>
					<div class="row courses-active">
	                	<?php while ( $grid_query->have_posts() ) : $grid_query->the_post();
	                		$course_id       = get_the_ID();

                            $course_duration = get_tutor_course_duration_context();
                            $course_students = tutor_utils()->count_enrolled_users_by_course();
                            $course_students = !empty($course_students) ? $course_students : 0;

					        $tutor_lesson_count = tutor_utils()->get_lesson_count_by_course($course_id);
					        $course_rating = tutor_utils()->get_course_rating();
					        $total_reviews = apply_filters('tutor_course_rating_count', $course_rating->rating_count);

					        $course_categories     = get_tutor_course_categories($course_id);

							$terms = get_the_terms( get_the_ID(), 'course-category' );
							if ( $terms && ! is_wp_error( $terms ) ) {
							    $term_slugs = array();
							    foreach ( $terms as $term ) {
							        $term_slugs[] = $term->slug;
							        $term_link = get_term_link( $term );
							    }        
							    $cat_slug = join( " ", $term_slugs );
							}

	                		?>
		                	<div class="col-lg-<?php echo esc_attr( $settings['grid_columns'] ); ?> grid-item <?php echo esc_attr( $cat_slug ); ?>">
		                        <div class="courses__item shine__animate-item">
		                            <div class="courses__item-thumb">
						                <?php  
					                        $postID = get_post()->ID;
					                        $tax_html = '';
					                        $terms = get_the_terms($postID, 'course-category');
					                        if (!empty($terms) && !is_wp_error($terms)) {
					                            foreach ($terms as $cat) {
					                                $tax_html .= '<a href="' . get_term_link($cat, $cat->taxonomy) . '" rel="tag">' . $cat->name . '</a>';
					                            }
					                        }

					                        if (!$tax_html) {
					                            //* Bailout, if nothing to render
					                            return;
					                        }

					                        printf('<div class="courses__item-categories ">%s</div>', $tax_html); 
						                ?>
                                        <a class="shine__animate-link" href="<?php the_permalink(); ?>">
                                          <?php the_post_thumbnail('full', ['alt' => get_the_title()]); ?>
                                        </a>
		                            </div>
		                            <div class="courses__item-content">
		                                <ul class="courses__item-meta list-wrap">
		                                	<?php if($tutor_lesson_count) { ?>
		                                    	<li><i class="flaticon-file"></i> <?php echo $tutor_lesson_count; ?> <?php echo __('Lessons', 'eduvalt'); ?></li>
		                                	<?php } ?>
											<?php
												$duration        = get_post_meta( get_the_ID(), '_course_duration', true );
									            $durationHours   = intval( tutor_utils()->avalue_dot( 'hours', $duration ) );
									            $durationMinutes = intval( tutor_utils()->avalue_dot( 'minutes', $duration ) );
									            $durationSeconds = intval( tutor_utils()->avalue_dot( 'seconds', $duration ) );
								            ?>
		                                    <li>
		                                    	<i class="flaticon-timer"></i>
	                                    		<?php echo $durationHours; ?><?php echo esc_html( 'h' ); ?>
	                                    		<?php echo $durationMinutes; ?><?php echo esc_html( 'm' ); ?>
		                                    </li>
		                                    <li><i class="flaticon-user-1"></i> <?php echo $course_students; ?> <?php echo __('Students', 'eduvalt'); ?></li>
		                                </ul>
		                                 <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
										<?php
										if ($course_rating->rating_avg < 0) { ?>
			                                <div class="courses__item-rating">
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <span class="rating-count">(<?php echo esc_html( $total_reviews ); ?>)</span>
			                                </div>
			                            <?php }else{ ?>
			                                <div class="courses__item-rating">
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <i class="fas fa-star"></i>
			                                    <span class="rating-count">(<?php echo esc_html( $total_reviews ); ?>)</span>
			                                </div>
			                            <?php } ?>
		                                <div class="courses__item-bottom">
		                                    <div class="author">
												<?php
											        global $post, $authordata;
											        $profile_url = tutor_utils()->profile_url($authordata->ID, true);
											        $disable_course_author = get_tutor_option('disable_course_author');
										        ?>
										        <?php if ( !$disable_course_author){ ?>
													<a href="<?php echo esc_url( $profile_url ); ?>" class="instructor-profile-link">
													  <?php
													  	echo get_avatar(
													    get_the_author_meta( 'ID' ),
													    32,
													    '',
													    '', // empty alt text
													    [ 'aria-hidden' => 'true' ] // hide from screen readers
													  );
													  ?>
													  <span class="instructor-name"><?php echo esc_html( get_the_author() ); ?></span>
													</a>
										        <?php } ?>

		                                    </div>
		                                    <h5 class="price">
												<?php 
												    //tutor_course_price();

											        $is_purchasable = tutor_utils()->is_course_purchasable();
											        $price          = apply_filters( 'get_tutor_course_price', null, get_the_ID() );
											        if ( $is_purchasable && $price ) :
											            $price = $price;
											        else :
											            $price = __( 'Free', 'eduvalt' );
											        endif;

											        echo wp_kses_post($price);
												?>
											</h5>
		                                </div>
		                            </div>
		                        </div>
		                    </div>

	                    <?php endwhile; wp_reset_postdata(); ?>
			        </div>
		        </div>
			<?php } ?>
		<?php endif;

		}
	}
}