<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Quote extends Widget_Base {

	public function get_name() {
		return 'section-quote';
	}

	// title to show on eduvalt
	public function get_title() {
		return 'Quote Content';
	}

	public function get_icon() {
		return 'fal fa-quote-left';
	}

	 // category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Quote Content', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'section_quote_img',
			[
				'label' => esc_html__( 'Quote Image', 'eduvalt' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
			]
		);

		// Title 
		$this->add_control(
			'section_quote_title',
			[
				'label' => esc_html__( 'Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Quote Title Here', 'eduvalt' ),
			]
		);

		// Description
		$this->add_control(
			'section_quote_description',
			[
				'label' => esc_html__( 'Description Text', 'eduvalt' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __( 'Quote Description Text', 'eduvalt' ),
			]
		);

		$this->add_control(
			'section_quote_btn_title',
			[
				'label' => esc_html__( 'Button Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Make A Request', 'eduvalt' ),
			]
		);

		$this->add_control(
			'section_quote_btn_link',
			[
				'label' => __( 'Link', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left'    => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-left',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/
		$this->start_controls_section(
			'title_quote_style',
			[
				'label' => esc_html__( 'Title Style', 'eduvalt' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title 1 Styling
		========================================*/
		$this->add_control(
			'title_quote_color',
			[
				'label' 	=> __( 'Text Color', 'eduvalt' ),
				'type' 		=> Controls_Manager::COLOR,
				'default' 	=> '#d53863',
				'selectors' => [
					'{{WRAPPER}} .section-quote-style h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_quote_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .section-quote-style h4',
			]
		);

		$this->end_controls_section();

		/* = Description Styling
		========================================*/
		$this->start_controls_section(
			'quote_description_style',
			[
				'label' => esc_html__( 'Quote Description Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'quote_description_text_color',
			[
				'label' => __( 'Quote Description Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#0a174c',
				'selectors' => [
					'{{WRAPPER}} .section-quote-style > p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'quote_description_typography',
				'label' => __( 'Description Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .section-quote-style > p',
			]
		);

		$this->add_control(
			'quote_line_color',
			[
				'label' => __( 'Quote Line Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#ededed',
				'selectors' => [
					'{{WRAPPER}} .section-quote-style.text-left' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_inline_editing_attributes( 'section_quote_title', 'none' );
		$this->add_inline_editing_attributes( 'section_quote_description', 'none' );
	?>
		<div class="cta-area">
            <div class="container">
                <div class="cta-bg" style="background-image: url(<?php echo $settings['section_quote_img']['url']?>);">
                    <div class="cta-content">
                        <h5><?php echo $settings['section_quote_title'];?> <span><?php echo $settings['section_quote_description'];?> </span></h5>
                    </div>
                    <?php if( ! empty( $settings['section_quote_btn_link']['url'] ) && ! empty( $settings['section_quote_btn_title'] ) ) { ?>
                        <div class="cta-link">
                            <a href="<?php echo esc_url( $settings['section_quote_btn_link']['url'] ); ?>"><?php echo esc_html( $settings['section_quote_btn_title'] ); ?></a>
                        </div>
                	<?php } ?>
                </div>
            </div>
        </div>
	<?php
	}
}