<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Newsletter extends Widget_Base {

	public function get_name() {
		return 'section-newsletter';
	}

	public function get_title() {
		return 'Newsletter Shortcode';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-heading';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Quote', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'select_styles',
			[
				'label' => __( 'Select Style', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' 	=> __( 'Style One', 'eduvalt' ),
					'style2' 	=> __( 'Style Two', 'eduvalt' ),
				]
			]
		);

        $this->add_control(
            'quote_bg_shape',
            [
                'label' => esc_html__( 'Quote Bg Shape', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'quote_bg_shape_icon',
            [
                'label' => esc_html__( 'Quote Icon One Shape', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
				'condition' => [
					'select_styles' => 'style2',
				],
            ]
        );

        $this->add_control(
            'quote_bg_shape_icon_two',
            [
                'label' => esc_html__( 'Quote Icon Two Shape', 'eduvalt' ),
                'type'  => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
				'condition' => [
					'select_styles' => 'style2',
				],
            ]
        );

		// Title 
		$this->add_control(
			'style3_section_title1',
			[
				'label' => esc_html__( 'Title First', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Join us &', 'eduvalt' ),
			]
		);
		// Title 
		$this->add_control(
			'style3_section_title2',
			[
				'label' => esc_html__( 'Title Middle', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Spread', 'eduvalt' ),
			]
		);
		// Title 
		$this->add_control(
			'style3_section_title3',
			[
				'label' => esc_html__( 'Title Last', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Experiences', 'eduvalt' ),
			]
		);
		
		// Sub Title
		$this->add_control(
			'style3_sec_sub_title',
			[
				'label' => esc_html__( 'Description', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Borem ipsum dolor sit amet, consectetur adipiscing eliawe awUt elit ellus, luctus nec ullamcorper mattisBorem', 'eduvalt' ),
			]
		);
		// Sub Title
		$this->add_control(
			'button_title',
			[
				'label' => esc_html__( 'Button Text', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Become an Instructor', 'eduvalt' ),
			]
		);
		$this->add_control(
			'button_link',
			[
				'label' => __( 'Link', 'eduvalt' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
		);

		$this->add_control(
			'icon_font',
			[
				'label' => esc_html__( 'Font Icon', 'eduvalt' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'flaticon-message',
			]
		);

		$this->add_control(
			'newsletter_shortcode',
			[
				'label' => esc_html__( 'Newsletter Shortcode', 'eduvalt' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default' => __( '[contact-form-7 id="1661" title="Newsletter"]', 'eduvalt' ),
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left'    => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-left',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'title_line1_style',
			[
				'label' => esc_html__( 'Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title 1 Styling
		========================================*/
		$this->add_control(
			'title1_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .newsletter-content-two .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title1_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .newsletter-content-two .title',
			]
		);
		$this->end_controls_section();

		/* = Sub Title Styling
		========================================*/
		$this->start_controls_section(
			'subtitle_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'sub_title_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .newsletter-content-two span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .newsletter-content-two span',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button_quote_style',
			[
				'label' => esc_html__( 'Button Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'quote_font_color',
			[
				'label' => __( 'Font color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .newsletter-area-two.newsletter-bg-two .contact-btn a.btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'quote_line_color',
			[
				'label' => __( 'Line color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .newsletter-area-two.newsletter-bg-two .contact-btn a span::before' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'quote_bg_color',
			[
				'label' => __( 'Background color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .newsletter-area-two.newsletter-bg-two .contact-btn .btn' => 'background-color: {{VALUE}};',
				],
			]
		);
		// Hover Settings
		$this->add_responsive_control(
			'quote_h_font_color',
			[
				'label' => __( 'Hover Font color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .newsletter-area-two.newsletter-bg-two .contact-btn a.btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'quote_h_line_color',
			[
				'label' => __( 'Hover Line color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .newsletter-area-two.newsletter-bg-two .contact-btn a:hover span::after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'quote_h_bg_color',
			[
				'label' => __( 'Hover Background color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .newsletter-area-two.newsletter-bg-two .contact-btn .btn:after' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	protected function render() {
		$settings = $this->get_settings_for_display();
		$newsletter_shortcode = $settings['newsletter_shortcode'];
		$target               = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow             = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : '';
		$randID = wp_rand();

		?>

		<?php if( $settings['select_styles'] == 'style2' ){ ?> 
	        <section class="cta-area">
                <div class="row">
                    <div class="col-12">
                        <div class="cta__wrapper" style="background-image:url(<?php echo $settings['quote_bg_shape']['url']; ?>)">
                            <div class="section__title white-title">
                                <h2 class="title tg-svg"><?php echo $settings['style3_section_title1']; ?> <span class="position-relative"><span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo $settings['style3_section_title2']; ?></span> <?php echo $settings['style3_section_title3']; ?></h2>
                            </div>
                            <div class="cta__desc">
                                <p><?php echo $settings['style3_sec_sub_title']; ?></p>
                            </div>
                            <div class="tg-button-wrap justify-content-center justify-content-md-end">
                                <a href="<?php echo $settings['button_link']['url']; ?>" <?php echo $target; ?> <?php echo $nofollow; ?> class="btn white-btn tg-svg"><span class="text"><?php echo $settings['button_title']; ?></span> <span class="svg-icon" id="cta-btn" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/btn-arrow.svg"></span></a>
                            </div>
                            <?php if (!empty($settings['quote_bg_shape_icon']['url'])): ?>
                            	<img class="object" src="<?php echo $settings['quote_bg_shape_icon']['url']; ?>" style="left: 25px; top: -35px;" alt="Object" data-aos="fade-down" data-aos-delay="400">
                            <?php endif; ?>
                            <?php if (!empty($settings['quote_bg_shape_icon_two']['url'])): ?>
                            	<img class="object" src="<?php echo $settings['quote_bg_shape_icon_two']['url']; ?>" style="right: -20px; bottom: -80px;" alt="Object" data-aos="fade-up" data-aos-delay="400">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
	        </section>
		<?php }else{ ?>
	        <section class="newsletter-area section-py-55">
                <div class="row align-items-center justify-content-center">
                    <div class="col-xl-6 col-lg-4">
                        <div class="newsletter__img-wrap">
                        	<?php if (!empty($settings['quote_bg_shape']['url'])): ?>
	                            <div class="newsletter__img" data-aos="fade-right">
	                                <img src="<?php echo $settings['quote_bg_shape']['url']; ?>" alt="img">
	                            </div>
                            <?php endif; ?>
                            <div class="newsletter__content">
                                <h4 class="title"><?php echo $settings['style3_section_title1']; ?><br> <?php echo $settings['style3_section_title2']; ?></h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-7">
                        <?php echo do_shortcode( $newsletter_shortcode ); ?>
                    </div>
                </div>
	        </section>
		<?php } ?>
	<?php
	}
}