<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Head_Two extends Widget_Base {

	public function get_name() {
		return 'section-head-two';
	}

	public function get_title() {
		return 'Section Heading';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-heading';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Section Heading', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'heading_styles',
			[
				'label' => __( 'Heading Style', 'eduvalt' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => [
					'style1' 	=> __( 'Style One', 'eduvalt' ),
					'style2' 	=> __( 'Style Two', 'eduvalt' ),
					'style3' 	=> __( 'Style Three', 'eduvalt' ),
				]
			]
		);

		// Title 
		$this->add_control(
			'style3_section_title1',
			[
				'label' => esc_html__( 'Title First', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Add Title', 'eduvalt' ),
			]
		);
		// Title 
		$this->add_control(
			'style3_section_title2',
			[
				'label' => esc_html__( 'Title Middle', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Add Title', 'eduvalt' ),
			]
		);
		// Title 
		$this->add_control(
			'style3_section_title3',
			[
				'label' => esc_html__( 'Title Last', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Add Title', 'eduvalt' ),
			]
		);
		
		// Sub Title
		$this->add_control(
			'style3_sec_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Add Sub Title', 'eduvalt' ),
			]
		);
		
		// Sub Title
		$this->add_control(
			'style3_sec_description',
			[
				'label' => esc_html__( 'Description', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => __( 'Add Description', 'eduvalt' ),
			]
		);
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left'    => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'text-left',
				'toggle' => true,
			]
		);
		
		$this->end_controls_section();

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'title_line1_style',
			[
				'label' => esc_html__( 'Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		/* = Title 1 Styling
		========================================*/

		$this->add_control(
			'title1_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#111111',
				'selectors' => [
					'{{WRAPPER}} .section-title .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title1_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .section-title .title, .section-title-two .title, .section-title-three .title',
			]
		);

		$this->add_responsive_control(
            'style1title_margin',
            [
                'label' => esc_html__('Margin', 'eduvalt'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', 'rem'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .section-title .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();


		/* = Sub Title Styling
		========================================*/
		$this->start_controls_section(
			'subtitle_style',
			[
				'label' => esc_html__( 'Sub Title Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'sub_title_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#074DF3',
				'selectors' => [
					'{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .section-title.title-style-three .sub-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .section-title.three .sub-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'sub_title_line_color',
			[
				'label' => __( 'Line Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title .sub-title::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'sub_title_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#eef0ff',
				'selectors' => [
					'{{WRAPPER}} .section-title.title-style-three .sub-title' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .section-title span.sub-title',
			]
		);

		$this->end_controls_section();


	}
	//end of control box 

	protected function render() {
		$settings = $this->get_settings_for_display();

		$randID = wp_rand();
		?>

		<?php if( $settings['heading_styles'] == 'style3' ){ ?>
			<div class="<?php echo esc_attr( $settings['text_align'] ); ?> section-title title-style-four tg-heading-subheading animation-style2">
				<?php if ( !empty( $settings['style3_sec_sub_title'] ) ) { ?>
		            <h6 class="sub-title tg-element-title">
		            	<?php echo $settings['style3_sec_sub_title']; ?>
		            </h6>
	            <?php } ?>
	            <?php if ( !empty( $settings['style3_section_title1'] ) ) { ?>
		            <h2 class="title tg-element-title"> <?php echo $settings['style3_section_title1']; ?> </h2>
	            <?php } ?>
	        </div>
		<?php } elseif( $settings['heading_styles'] == 'style2' ){ ?>
			<div class="<?php echo esc_attr( $settings['text_align'] ); ?> section-title title-style-three tg-heading-subheading animation-style2">
				<?php if ( !empty( $settings['style3_sec_sub_title'] ) ) { ?>
		            <h6 class="sub-title tg-element-title">
		            	<?php echo $settings['style3_sec_sub_title']; ?>
		            </h6>
	            <?php } ?>
	            <?php if ( !empty( $settings['style3_section_title1'] ) ) { ?>
		            <h2 class="title tg-element-title"> <?php echo $settings['style3_section_title1']; ?> </h2>
	            <?php } ?>
	        </div>
		<?php }else{ ?>
            <div class="section__title <?php echo esc_attr( $settings['text_align'] ); ?>">
            	<?php if ( !empty( $settings['style3_sec_sub_title'] ) ) { ?>
                	<span class="sub-title"><?php echo $settings['style3_sec_sub_title']; ?></span>
            	<?php } ?>
	            <?php if ( !empty( $settings['style3_section_title1'] ) || !empty( $settings['style3_section_title2'] ) || !empty( $settings['style3_section_title3'] ) ) { ?>
                	<h2 class="title tg-svg"><?php echo $settings['style3_section_title1']; ?> <span class="position-relative"><span class="svg-icon" id="svg-<?php echo $randID; ?>" data-svg-icon="<?php echo get_template_directory_uri(); ?>/assets/img/icons/title_shape.svg"></span><?php echo $settings['style3_section_title2']; ?></span> <?php echo $settings['style3_section_title3']; ?></h2>
	            <?php } ?>
	            <?php if ( !empty( $settings['style3_sec_description'] ) ) { ?>
	            	<p class="desc"><?php echo $settings['style3_sec_description']; ?></p>
	            <?php } ?>
            </div>

		<?php } ?>
		<?php
	}
}