<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Contact_Cf7 extends Widget_Base {

	public function get_name() {
		return 'eduvalt-cf7';
	}

	public function get_title() {
		return 'Contact Form 7';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-link';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Contact Form 7', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'contact_section_title',
			[
				'label' => esc_html__( 'Section Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$this->add_control(
			'contact_section_sub_title',
			[
				'label' => esc_html__( 'Section Sub Title', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

        $this->add_control(
            'selected_form_id',
            [
                'label' => esc_html__( 'Chosse Your Form', 'eduvalt' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => ['' => esc_html__( '', 'eduvalt' ) ] + \eduvalt_get_cf7_forms(),
            ]
        );
		
		$this->end_controls_section();

		//End  of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Contact Form 7 Style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'main_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 .contact-form-wrap' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'main_title_color',
			[
				'label' => __( 'Title Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 .contact-form-wrap .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title Typography', 'eduvalt' ),
				'selector' => '{{WRAPPER}} .form_btn_cf7 .contact-form-wrap .title',
			]
		);

		$this->add_responsive_control(
			'main_subtitle_color',
			[
				'label' => __( 'Title Line Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 .contact-form-wrap .title::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'main_border_color',
			[
				'label' => __( 'Border Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 .contact-form-wrap' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'main_border_radious',
			[
				'label' => __( 'Border radius', 'eduvalt' ),
				'type' => Controls_Manager::SLIDER,
				'deafult' => '',
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 .contact-form-wrap' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'sections_padding',
            [
                'label' => esc_html__( 'Padding', 'eduvalt' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .form_btn_cf7 .contact-form-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'eduvalt' ),
			]
		);

		$this->add_responsive_control(
			'btn_bg_color',
			[
				'label' => __( 'Background color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .wpcf7-form-control.has-spinner.wpcf7-submit' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_text_color',
			[
				'label' => __( 'Font color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn' => 'color: {{VALUE}};',
					'{{WRAPPER}} .wpcf7-form-control.has-spinner.wpcf7-submit' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		/* = Button Hover Styling
		========================================*/
		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'eduvalt' ),
			]
		);

		$this->add_responsive_control(
			'btn_h_bg_color',
			[
				'label' => __( 'Background color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn:hover' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .wpcf7-form-control.has-spinner.wpcf7-submit::after' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'btn_h_font_color',
			[
				'label' => __( 'Font color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .form_btn_cf7 button.btn:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .wpcf7-form-control.has-spinner.wpcf7-submit:hover' => 'color: {{VALUE}};',
				],
			]
		);		

	}
	//end of control box 

	//to show on the fontend
	protected function render() {  
        if ( ! class_exists('WPCF7') ) {
            return;
        }

        $settings = $this->get_settings_for_display();        

        if ( ! empty( $settings['selected_form_id'] ) ) { ?>
            <div class="form_btn_cf7">
				<div class="contact-form-wrap">
					<?php if ( !empty( $settings['contact_section_title'] ) ) { ?>
					    <h2 class="title"> <?php echo $settings['contact_section_title']; ?> </h2>
					<?php } ?>
					<?php if ( !empty( $settings['contact_section_sub_title'] ) ) { ?>
					    <p>
					    	<?php echo $settings['contact_section_sub_title']; ?>
					    </p>
					<?php } ?>
            		<?php echo  do_shortcode( '[contact-form-7 id="'.$settings['selected_form_id'].'"]'); ?>
				</div>
            </div>
        <?php
        }
	}
}