<?php

namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Brand_Slider extends Widget_Base
{   //this name is added to plugin.php of the root folder

    public function get_name()
    {
        return 'brand-slider';
    }

    public function get_title()
    {
        return 'Brand Slider';   // title to show on elementor
    }

    public function get_icon()
    {
        return 'eicon-slider-push';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
    }

    public function get_categories()
    {
        return ['eduvalt-elements'];    // category of the widget
    }

    public function get_script_depends()
    {
        return ['eduvalt-elementor-editor'];
    }

    /**
     * A list of scripts that the widgets is depended in
     * @since 1.3.0
     **/
    protected function register_controls()
    {

        //start of a control box
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Brand Settings', 'eduvalt'),   //section name for controler view
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'brand_image',
            [
                'label' => __('Brand Image', 'eduvalt'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'brand_link',
            [
                'label' => __('Brand Item Link', 'eduvalt'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('Brand Item URL', 'eduvalt'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'brand_items',
            [
                'label' => __('Add Images', 'eduvalt'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'brand_links',
            [
                'label'       => __('Enable Links', 'eduvalt'),
                'type' => Controls_Manager::SELECT,
                'default' => 'yes',
                'options' => [
                    'yes'   => __('Yes', 'eduvalt'),
                    'no'  => __('No', 'eduvalt'),
                ],
            ]
        );

        $this->add_control(
            'slider_autoplay',
            [
                'label'   => __('Slider Autoplay', 'eduvalt'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'false'   => __('No', 'eduvalt'),
                    'true'    => __('Yes', 'eduvalt'),
                ],
            ]
        );

        $this->add_control(
            'slider_autoplay_speed',
            [
                'label' => esc_html__('Slider Speed', 'eduvalt'),
                'description' => esc_html__('Autoplay duration in millisecond', 'eduvalt'),
                'type' => Controls_Manager::NUMBER,
                'default' => 1000,
            ]
        );

        $this->add_control(
            'item_to_show',
            [
                'label' => esc_html__('Number of items to show', 'eduvalt'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'slider_infinite_item',
            [
                'label'   => __('infinite Slider?', 'eduvalt'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'false'   => __('No', 'eduvalt'),
                    'true'    => __('Yes', 'eduvalt'),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'brand_item_style',
            [
                'label' => esc_html__('Brand Style', 'eduvalt'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'item_marign_bottom',
            [
                'label' => esc_html__('Item Margin Bottom', 'eduvalt'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => '50px',
                'selectors' => [
                    '{{WRAPPER}} .brand-item-two' => 'margin-bottom: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    //to show on the fontend
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $eduvalt_rtl_check = is_rtl() ?  'true' : 'false';
        $e_uniqid     = uniqid();
?>
        <script type="text/javascript">
            jQuery(document).ready(function() {
                jQuery('.brand-area-<?php echo esc_attr($e_uniqid); ?>').slick({
                    dots: false,
                    infinite: <?php echo $settings['slider_infinite_item']; ?>,
                    speed: <?php echo $settings['slider_autoplay_speed']; ?>,
                    autoplay: <?php echo $settings['slider_autoplay']; ?>,
                    arrows: false,
                    rtl: <?php echo $eduvalt_rtl_check; ?>,
                    slidesToShow: <?php echo $settings['item_to_show']; ?>,
                    slidesToScroll: 2,
                    responsive: [{
                            breakpoint: 1200,
                            settings: {
                                slidesToShow: 6,
                                slidesToScroll: 1,
                                infinite: true,
                            }
                        },
                        {
                            breakpoint: 992,
                            settings: {
                                slidesToShow: 4,
                                slidesToScroll: 1
                            }
                        },
                        {
                            breakpoint: 767,
                            settings: {
                                slidesToShow: 3,
                                slidesToScroll: 1,
                                arrows: false,
                            }
                        },
                        {
                            breakpoint: 575,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 1,
                                arrows: false,
                            }
                        },
                    ]
                });
            });
        </script>

        <?php if (!empty($settings['brand_items'])): ?>
            <div class="row brand-area-<?php echo esc_attr($e_uniqid); ?>">
                <?php foreach ($settings['brand_items'] as $key => $value): ?>
                    <?php
                        // Determine link and image attributes
                        $url = $value['brand_link']['url'] ?? '';
                        $target = !empty($value['brand_link']['is_external']) ? ' target="_blank"' : '';
                        $nofollow = !empty($value['brand_link']['nofollow']) ? ' rel="nofollow"' : '';
                        $image_url = $value['brand_image']['url'] ?? '';
                    ?>
                    <?php if (!empty($image_url)): // Ensure the image URL is not empty ?>
                        <div class="col-12">
                            <div class="brand__item">
                                <?php if (!empty($settings['brand_links']) && $settings['brand_links'] === 'yes' && $url): ?>
                                    <a href="<?php echo esc_url($url); ?>" <?php echo $target . $nofollow; ?>>
                                        <img src="<?php echo esc_url($image_url); ?>" alt="<?php esc_attr_e('Brand Image', 'eduvalt'); ?>">
                                    </a>
                                <?php else: ?>
                                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php esc_attr_e('Brand Image', 'eduvalt'); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

<?php
    }
}
