<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Animated_Home_Image extends Widget_Base {

	public function get_name() {
		return 'animated_home_image';
	}

	public function get_title() {
		return 'Animate One';   // title to show on eduvalt
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'eduvalt-elements' ];    // category of the widget
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//section name for controler view
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Animate One', 'eduvalt' ),
			]
		);

        $this->add_control(
            'section_about_title',
            [
                'label' => esc_html__( 'Experience Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Year Of Experiences', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_middle',
            [
                'label' => esc_html__( 'Experience Number', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( '12', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_title_last',
            [
                'label' => esc_html__( 'Section Title Last', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Around The World', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_sub_title',
            [
                'label' => esc_html__( 'Section Sub Title', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Get To Know About Us', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_sub_title2',
            [
                'label' => esc_html__( 'Banner Description', 'eduvalt' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'Borem ipsum dolor sit amet, consectetur adipiscing eliawe awUt elit ellus, luctus nec ullamcorper mattisBorem ipsum dolor awes atnse awctetur adipis we followelit. Borem.', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_btn1_text',
            [
                'label' => esc_html__( 'Button One Text', 'eduvalt' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Discover More', 'eduvalt'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'section_about_btn1_link',
            [
                'label' => __( 'Link', 'eduvalt' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'eduvalt' ),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

		$this->add_control(
			'anim_one_img',
			[
				'label' => esc_html__( 'Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_two_img',
			[
				'label' => esc_html__( 'Image Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_three_img',
			[
				'label' => esc_html__( 'Image Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img',
			[
				'label' => esc_html__( 'Image Shape', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img_two',
			[
				'label' => esc_html__( 'Image Shape Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'anim_shape_img_three',
			[
				'label' => esc_html__( 'Image Shape Three', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'full_imgstyle',
			[
				'label' => esc_html__( 'Counter style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'delay',
			[
				'label' => __( 'Counter Delay (milliseconds)', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '10', 'eduvalt' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'time',
			[
				'label' => __( 'Counter Animation Time', 'eduvalt' ),
				'type' => Controls_Manager::TEXT,
				'default' =>  __( '2000', 'eduvalt' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'img_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .expertise-img-wrap .exp-content' => 'background: {{VALUE}};',
					'{{WRAPPER}} .expertise-img-wrap .exp-box' => 'border:10px solid {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'img_text_color',
			[
				'label' => __( 'Test Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .expertise-img-wrap .exp-content h2, .expertise-img-wrap .exp-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .expertise-img-wrap .exp-content .icon i:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 
		$settings = $this->get_settings_for_display();
		$randID = wp_rand();
		?>
        <section class="about-area tg-motion-effects">
            <div class="about__images">
            	<?php if (!empty($settings['anim_two_img']['url'])): ?>
                	<img class="small-img tg-motion-effects3" src="<?php echo esc_url( $settings['anim_two_img']['url'] );?>" alt="img">
                <?php endif; ?>
                <?php if (!empty($settings['anim_one_img']['url'])): ?>
                	<img class="big-img" src="<?php echo esc_url( $settings['anim_one_img']['url'] );?>" alt="img">
                <?php endif; ?>
                <div class="about__exp">
                    <svg width="126" height="108" viewBox="0 0 126 108" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0 10C0 4.47715 4.47715 0 10 0H110.996C116.321 0 120.713 4.17312 120.983 9.4914L125.429 96.7793C125.733 102.754 120.758 107.657 114.789 107.267L9.34719 100.369C4.08901 100.025 0 95.6593 0 90.3899V10Z" fill="currentcolor" />
                    </svg>
                    <h4 class="year"><?php echo $settings['section_about_title_middle']; ?> +</h4>
                    <p><?php echo $settings['section_about_title']; ?></p>
                </div>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/others/about_dots.svg" alt="svg" class="dots tg-motion-effects2">
                <svg class="circle tg-motion-effects1" width="344" height="344" viewBox="0 0 344 344" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect x="20" y="20" width="304" height="304" rx="152" stroke="currentcolor" stroke-width="40" />
                </svg>
            </div>
        </section>
	<?php
	}
}