<?php
namespace Eduvalt\Widgets;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Animated_Image extends Widget_Base {

	public function get_name() {
		return 'animated_image';
	}

	// title to show on eduvalt
	public function get_title() {
		return 'Animated Image';
	}

	public function get_icon() {
		return 'fal fa-file-image';    // eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	// category of the widget
	public function get_categories() {
		return [ 'eduvalt-elements' ];
	}

	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
		//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Animated Image', 'eduvalt' ),   //section name for controler view
			]
		);

		$this->add_control(
			'anim_top_img',
			[
				'label' => esc_html__( 'Image One', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'img_top_animation',
			[
				'label' => __( 'Image One Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'img_top_animation_delay',
			[
				'label' => __( 'Image One Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'anim_bottom_img',
			[
				'label' => esc_html__( 'Image Two', 'eduvalt' ),
				'type'  => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'img_bottom_animation',
			[
				'label' => __( 'Image Two Animation', 'eduvalt' ),
				'type' => Controls_Manager::ANIMATION,
				'label_block' => true,
			]
		);

		$this->add_control(
			'img_bottom_animation_delay',
			[
				'label' => __( 'Image Two Animation Delay', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '0.2s',
				'options' => ifinger_anim_delay(),
				'label_block' => true,
			]
		);

		$this->add_control(
			'counter_animate_title',
			[
				'label' => esc_html__( 'Counter Number', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => '32',
			]
		);
		$this->add_control(
			'counter_animate_sub_title',
			[
				'label' => esc_html__( 'Counter Title', 'eduvalt' ),
				'type'  => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'years Of Experience',
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'eduvalt' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'eduvalt' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'eduvalt' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'eduvalt' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'selectors' => [
					'{{WRAPPER}} .anim-image' => 'text-align: {{VALUE}};',
				],
			]
		);		
		
		$this->end_controls_section();

		//End of a control box

		/* = Add Item Styling
		========================================*/

		$this->start_controls_section(
			'full_imgstyle',
			[
				'label' => esc_html__( 'Image style', 'eduvalt' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'img_bg_color',
			[
				'label' => __( 'Background Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-img-wrap .year-experience svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'img_bg_text_color',
			[
				'label' => __( 'Text Color', 'eduvalt' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .about-img-wrap .year-experience .content .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}
	//end of control box 

	//to show on the fontend
	protected function render() { 

		$settings = $this->get_settings_for_display();

		// top image animation
		if ( ! empty( $settings['img_top_animation'] ) ) {
			$img_top_anim = 'data-wow-delay="'.esc_attr( $settings['img_top_animation_delay'] ).'"';
		} else {
			$img_top_anim = '';	
		}

		if ( ! empty( $settings['img_top_animation'] ) ) {
			$this->add_render_attribute( 'topmainimage', 'class', 'wow ' . $settings['img_top_animation'] );
		}

		// main image animation
		if ( ! empty( $settings['img_entrance_animation'] ) ) {
			$img_anim = 'data-wow-delay="'.esc_attr( $settings['img_entrance_animation_delay'] ).'"';
		} else {
			$img_anim = '';	
		}

		if ( ! empty( $settings['img_entrance_animation'] ) ) {
			$this->add_render_attribute( 'mainimage', 'class', 'wow ' . $settings['img_entrance_animation'] );
		}

		// bottom image animation
		if ( ! empty( $settings['img_bottom_animation'] ) ) {
			$img_bottom_anim = 'data-wow-delay="'.esc_attr( $settings['img_bottom_animation_delay'] ).'"';
		} else {
			$img_bottom_anim = '';	
		}

		if ( ! empty( $settings['img_bottom_animation'] ) ) {
			$this->add_render_attribute( 'bottommainimage', 'class', 'wow ' . $settings['img_bottom_animation'] );
		}
		?>
		<div class="eduvalt-animate-image-wrapper features-area-five">
            <div class="about-img-wrap wow fadeInLeft" data-wow-delay=".2s">
            	<?php if( !empty ( $settings['anim_top_img']['url'] ) ) : ?>
	                <div class="about-img">
	                    <img src="<?php echo esc_attr( $settings['anim_top_img']['url'] );?>" alt="">
	                </div>
                <?php endif; ?>
                <div class="year-experience">
                    <svg xmlns="http://www.w3.org/2000/svg" width="213.875" height="237.31" viewBox="0 0 213.875 237.31">
                        <path d="M927.407,1398.64l-78.017-44.91a28.989,28.989,0,0,0-28.915,0l-78.017,44.91A28.818,28.818,0,0,0,728,1423.61v89.83a28.8,28.8,0,0,0,14.458,24.96l78.017,44.92a28.989,28.989,0,0,0,28.915,0l78.017-44.92a28.8,28.8,0,0,0,14.457-24.96v-89.83A28.819,28.819,0,0,0,927.407,1398.64Z"
                            transform="translate(-728 -1349.88)" />
                    </svg>
                    <div class="content">
                        <h2 class="title"><?php echo esc_attr( $settings['counter_animate_title'] ); ?> <span><?php echo esc_html( $settings['counter_animate_sub_title'] ); ?></span></h2>
                    </div>
                </div>
            </div>
		</div>
	<?php 
	}
}